/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.cimxml;

import com.sun.xml.parser.Parser;
import com.sun.xml.tree.ElementNode;
import com.sun.xml.tree.TreeWalker;
import com.sun.xml.tree.XmlDocument;
import com.sun.xml.tree.XmlDocumentBuilder;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMDateTime;
import javax.wbem.cim.CIMElement;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMFlavor;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMMethod;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMParameter;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMQualifier;
import javax.wbem.cim.CIMQualifierType;
import javax.wbem.cim.CIMScope;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt32;
import javax.wbem.cim.UnsignedInt64;
import javax.wbem.cim.UnsignedInt8;
import javax.wbem.client.Debug;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.InputSource;

class XMLParser {
    XMLParser() {
    }

    static CIMClass getCIMClass(Node node) {
        CIMClass cIMClass = new CIMClass();
        Vector<Object> vector = new Vector<Object>();
        Vector<Object> vector2 = new Vector<Object>();
        Vector<CIMMethod> vector3 = new Vector<CIMMethod>();
        TreeWalker treeWalker = new TreeWalker(node);
        node = treeWalker.getCurrent();
        while (node != null) {
            Object object;
            String string = node.getNodeName();
            if (string.equals("CLASS")) {
                object = node.getAttributes();
                int n = 0;
                while (n < object.getLength()) {
                    Node node2 = object.item(n);
                    String string2 = node2.getNodeName();
                    if (string2.equals("NAME")) {
                        cIMClass.setName(node2.getNodeValue());
                    } else if (string2.equals("SUPERCLASS")) {
                        cIMClass.setSuperClass(node2.getNodeValue());
                    }
                    ++n;
                }
                node = treeWalker.getNextElement(null);
                continue;
            }
            if (string.equals("QUALIFIER")) {
                if (node.getParentNode().getNodeName().equals("CLASS")) {
                    object = XMLParser.getCIMQualifier(node);
                    vector.addElement(object);
                }
                node = node.getNextSibling();
                continue;
            }
            if (string.startsWith("PROPERTY")) {
                object = XMLParser.getCIMProperty(node);
                vector2.addElement(object);
                if (((CIMProperty)object).isKey()) {
                    cIMClass.setIsKeyed(true);
                }
                node = node.getNextSibling();
                continue;
            }
            if (string.equals("METHOD")) {
                vector3.addElement(XMLParser.getCIMMethod(node));
                node = node.getNextSibling();
                continue;
            }
            node = node.getNextSibling();
        }
        if (vector3.size() > 0) {
            cIMClass.setMethods(vector3);
        }
        if (vector.size() > 0) {
            cIMClass.setQualifiers(vector);
        }
        if (vector2.size() > 0) {
            cIMClass.setProperties(vector2);
        }
        return cIMClass;
    }

    static CIMInstance getCIMInstance(Node node) {
        CIMInstance cIMInstance = new CIMInstance();
        Vector<CIMQualifier> vector = new Vector<CIMQualifier>();
        Vector<CIMProperty> vector2 = new Vector<CIMProperty>();
        TreeWalker treeWalker = new TreeWalker(node);
        node = treeWalker.getCurrent();
        while (node != null && !node.getNodeName().equals("INSTANCE")) {
            node = treeWalker.getNextElement(null);
        }
        node = treeWalker.getCurrent();
        while (node != null) {
            String string = node.getNodeName();
            if (string.equals("INSTANCE")) {
                ((ElementNode)node).normalize();
                cIMInstance.setClassName(((ElementNode)node).getAttribute("CLASSNAME"));
                node = node.getFirstChild();
                continue;
            }
            if (string.equals("QUALIFIER")) {
                vector.addElement(XMLParser.getCIMQualifier(node));
                node = node.getNextSibling();
                continue;
            }
            if (string.startsWith("PROPERTY")) {
                vector2.addElement(XMLParser.getCIMProperty(node));
                node = node.getNextSibling();
                continue;
            }
            node = node.getNextSibling();
        }
        if (vector.size() > 0) {
            cIMInstance.setQualifiers(vector);
        }
        if (vector2.size() > 0) {
            cIMInstance.setProperties(vector2);
        }
        return cIMInstance;
    }

    static CIMMethod getCIMMethod(Node node) {
        CIMMethod cIMMethod = new CIMMethod();
        Vector<CIMQualifier> vector = new Vector<CIMQualifier>();
        Vector<CIMParameter> vector2 = new Vector<CIMParameter>();
        TreeWalker treeWalker = new TreeWalker(node);
        node = treeWalker.getCurrent();
        while (node != null) {
            String string = node.getNodeName();
            if (string.equals("METHOD")) {
                NamedNodeMap namedNodeMap = node.getAttributes();
                int n = 0;
                while (n < namedNodeMap.getLength()) {
                    Node node2 = namedNodeMap.item(n);
                    String string2 = node2.getNodeName();
                    if (string2.equals("NAME")) {
                        cIMMethod.setName(node2.getNodeValue());
                    } else if (string2.equals("TYPE")) {
                        String string3 = node2.getNodeValue();
                        try {
                            CIMDataType cIMDataType = CIMDataType.getDataType(string3);
                            cIMMethod.setType(cIMDataType);
                        }
                        catch (CIMException cIMException) {
                            Debug.trace1("Got exception", cIMException);
                        }
                    } else if (!string2.equals("PROPAGATED") && string2.equals("CLASSORIGIN")) {
                        cIMMethod.setOriginClass(node2.getNodeValue());
                    }
                    ++n;
                }
            } else if (string.equals("QUALIFIER")) {
                vector.addElement(XMLParser.getCIMQualifier(node));
            } else if (string.startsWith("PARAMETER")) {
                vector2.addElement(XMLParser.getCIMParameter(node));
            }
            node = treeWalker.getNext();
        }
        if (vector.size() > 0) {
            cIMMethod.setQualifiers(vector);
        }
        if (vector2.size() > 0) {
            cIMMethod.setParameters(vector2);
        }
        return cIMMethod;
    }

    static CIMObjectPath getCIMObjectPath(Node node) {
        String string = "";
        String string2 = "";
        CIMObjectPath cIMObjectPath = new CIMObjectPath();
        TreeWalker treeWalker = new TreeWalker(node);
        node = treeWalker.getCurrent();
        while (node != null) {
            String string3 = node.getNodeName();
            if (!(string3.equals("NAMESPACEPATH") || string3.equals("LOCALNAMESPACEPATH") || string3.equals("CLASSPATH") || string3.equals("LOCALCLASSPATH") || string3.equals("INSTANCEPATH") || string3.equals("LOCALINSTANCEPATH") || string3.equals("OBJECTPATH"))) {
                Object object;
                if (string3.equals("VALUE.REFERENCE")) {
                    node = treeWalker.removeCurrent();
                    continue;
                }
                if (string3.equals("HOST")) {
                    object = XMLParser.getTextNode(node);
                    if (object == null || ((String)object).length() == 0) continue;
                    cIMObjectPath.setHost((String)object);
                } else if (string3.equals("NAMESPACE")) {
                    object = cIMObjectPath.getNameSpace();
                    object = (String)object + "/" + ((ElementNode)node).getAttribute("NAME");
                    cIMObjectPath.setNameSpace((String)object);
                    node = node.getNextSibling();
                } else if (string3.equals("CLASSNAME")) {
                    cIMObjectPath.setObjectName(((ElementNode)node).getAttribute("NAME"));
                } else if (string3.equals("INSTANCENAME")) {
                    string = ((ElementNode)node).getAttribute("CLASSNAME");
                    cIMObjectPath.setObjectName(string);
                } else if (node.getNodeName() == "KEYBINDING") {
                    object = XMLParser.getCIMProperty(node);
                    cIMObjectPath.addKey(((CIMElement)object).getName(), ((CIMProperty)object).getValue());
                    if ("NameSpace".equals(((CIMElement)object).getName())) {
                        string2 = ((CIMProperty)object).getValue().getValue().toString();
                    }
                    node = treeWalker.removeCurrent();
                    continue;
                }
            }
            node = treeWalker.getNext();
        }
        if (string.equals("__Namespace")) {
            return new CIMObjectPath("", string2);
        }
        return cIMObjectPath;
    }

    static CIMParameter getCIMParameter(Node node) {
        CIMParameter cIMParameter = new CIMParameter();
        Vector<CIMQualifier> vector = new Vector<CIMQualifier>();
        TreeWalker treeWalker = new TreeWalker(node);
        String string = null;
        node = treeWalker.getCurrent();
        while (node != null) {
            String string2 = node.getNodeName();
            if (string2.startsWith("PARAMETER")) {
                NamedNodeMap namedNodeMap = node.getAttributes();
                int n = 0;
                while (n < namedNodeMap.getLength()) {
                    Node node2 = namedNodeMap.item(n);
                    String string3 = node2.getNodeName();
                    if (string3.equals("NAME")) {
                        cIMParameter.setName(node2.getNodeValue());
                    } else if (string3.equals("TYPE")) {
                        String string4 = node2.getNodeValue();
                        try {
                            cIMParameter.setType(CIMDataType.getDataType(string4, string2.endsWith(".ARRAY")));
                        }
                        catch (CIMException cIMException) {
                            Debug.trace1("Got exception", cIMException);
                        }
                    } else if (string3.equals("ARRAYSIZE")) {
                        cIMParameter.setSize(Integer.parseInt(node2.getNodeValue()));
                    } else if (string3.equals("REFERENCECLASS")) {
                        string = node2.getNodeValue();
                    }
                    ++n;
                }
                if (string2.endsWith(".REFERENCE")) {
                    cIMParameter.setType(new CIMDataType(string != null ? string : ""));
                }
            } else if (string2.equals("QUALIFIER")) {
                node = treeWalker.getCurrent();
                while (node != null) {
                    vector.addElement(XMLParser.getCIMQualifier(node));
                    node = treeWalker.getNextElement(string2);
                }
            }
            node = treeWalker.getNext();
        }
        if (vector.size() > 0) {
            cIMParameter.setQualifiers(vector);
        }
        return cIMParameter;
    }

    static CIMProperty getCIMProperty(Node node) {
        CIMProperty cIMProperty = new CIMProperty();
        String string = null;
        boolean bl = false;
        boolean bl2 = false;
        Object object = null;
        TreeWalker treeWalker = new TreeWalker(node);
        node = treeWalker.getCurrent();
        while (node != null) {
            Object object2;
            String string2 = node.getNodeName();
            if (string2.startsWith("PROPERTY")) {
                object2 = node.getAttributes();
                String string3 = null;
                String string4 = null;
                String string5 = null;
                String string6 = "false";
                String string7 = null;
                int n = 0;
                while (n < object2.getLength()) {
                    Node node2 = object2.item(n);
                    String string8 = node2.getNodeName();
                    if (string8.equals("NAME")) {
                        string3 = node2.getNodeValue();
                    } else if (string8.equals("TYPE")) {
                        string = node2.getNodeValue();
                        try {
                            cIMProperty.setType(CIMDataType.getDataType(string, string2.endsWith(".ARRAY")));
                        }
                        catch (CIMException cIMException) {
                            Debug.trace1("Got exception", cIMException);
                        }
                    } else if (string8.equals("CLASSORIGIN")) {
                        string4 = node2.getNodeValue();
                    } else if (string8.equals("ARRAYSIZE")) {
                        string5 = node2.getNodeValue();
                    } else if (string8.equals("PROPAGATED")) {
                        string6 = node2.getNodeValue();
                    } else if (string8.equals("REFERENCECLASS")) {
                        string7 = node2.getNodeValue();
                    }
                    ++n;
                }
                if (!string6.equalsIgnoreCase("true") || string4 == null) {
                    // empty if block
                }
                if (string3 != null) {
                    cIMProperty.setName(string3);
                }
                if (string4 != null) {
                    cIMProperty.setOriginClass(string4);
                }
                if (string5 != null) {
                    cIMProperty.setSize(Integer.parseInt(string5));
                }
                node = treeWalker.getNextElement(null);
                continue;
            }
            if (string2.equals("QUALIFIER")) {
                try {
                    object2 = ((ElementNode)node).getAttribute("NAME");
                    if (((String)object2).equals("EmbeddedObject")) {
                        bl = true;
                    }
                    cIMProperty.addQualifier(XMLParser.getCIMQualifier(node));
                }
                catch (CIMException cIMException) {
                    Debug.trace1("Got exception", cIMException);
                }
                node = node.getNextSibling();
                continue;
            }
            if (string2.equals("KEYBINDING")) {
                if (cIMProperty.getName().length() == 0) {
                    cIMProperty.setName(((ElementNode)node).getAttribute("NAME"));
                }
                node = treeWalker.getNextElement(null);
                continue;
            }
            if (string2.equals("KEYVALUE")) {
                string = ((ElementNode)node).getAttribute("VALUETYPE");
                object2 = XMLParser.getStringValue(node);
                if (object2 == null) {
                    // empty if block
                }
                cIMProperty.setValue(new CIMValue(object2));
                break;
            }
            if (string2.equals("VALUE.REFERENCE")) {
                cIMProperty.setValue(XMLParser.getCIMValue(node, ""));
                cIMProperty.setType(new CIMDataType(((CIMObjectPath)cIMProperty.getValue().getValue()).getObjectName()));
                break;
            }
            if (string2.equals("VALUE.ARRAY")) {
                cIMProperty.setValue(XMLParser.getCIMValue(node, string));
                break;
            }
            if (string2.equals("VALUE")) {
                bl2 = true;
                object = XMLParser.valueObject(node, string);
                break;
            }
            node = node.getNextSibling();
        }
        if (bl2) {
            if (bl) {
                try {
                    object = XMLParser.getEmbeddedObject((String)object);
                }
                catch (CIMException cIMException) {
                    Debug.trace1("Got exception", cIMException);
                }
            }
            cIMProperty.setValue(new CIMValue(object));
        }
        return cIMProperty;
    }

    static Object getEmbeddedObject(String string) throws CIMException {
        Object object;
        CIMElement cIMElement = null;
        XmlDocument xmlDocument = null;
        Parser parser = new Parser();
        XmlDocumentBuilder xmlDocumentBuilder = new XmlDocumentBuilder();
        InputSource inputSource = new InputSource();
        try {
            object = XMLParser.stripQuote(string).getBytes();
            inputSource.setByteStream(new ByteArrayInputStream((byte[])object));
            parser.setFastStandalone(true);
            parser.setDocumentHandler((DocumentHandler)xmlDocumentBuilder);
            parser.parse(inputSource);
            xmlDocument = xmlDocumentBuilder.getDocument();
        }
        catch (Exception exception) {
            throw new CIMException("XMLERROR", (Object)exception);
        }
        object = new TreeWalker((Node)xmlDocument);
        Node node = object.getCurrent();
        while (node != null) {
            String string2 = node.getNodeName();
            if (string2.equals("CLASS")) {
                cIMElement = XMLParser.getCIMClass(node);
                node = node.getNextSibling();
                continue;
            }
            if (string2.equals("INSTANCE")) {
                cIMElement = XMLParser.getCIMInstance(node);
                node = node.getNextSibling();
                continue;
            }
            node = object.getNextElement(null);
        }
        return cIMElement;
    }

    static String stripQuote(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) == '\\' && (string.charAt(n + 1) == '\\' || string.charAt(n + 1) == '\"')) {
                stringBuffer.append(string.charAt(++n));
            } else {
                stringBuffer.append(string.charAt(n));
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    static CIMQualifier getCIMQualifier(Node node) {
        CIMQualifier cIMQualifier = new CIMQualifier();
        String string = null;
        TreeWalker treeWalker = new TreeWalker(node);
        node = treeWalker.getCurrent();
        while (node != null) {
            String string2 = node.getNodeName();
            if (string2.equals("QUALIFIER")) {
                NamedNodeMap namedNodeMap = node.getAttributes();
                int n = 0;
                while (n < namedNodeMap.getLength()) {
                    Node node2 = namedNodeMap.item(n);
                    if (node2.getNodeName().equals("NAME")) {
                        cIMQualifier.setName(node2.getNodeValue());
                    } else if (node2.getNodeName().equals("TYPE")) {
                        string = node2.getNodeValue();
                    } else if (node2.getNodeName().equals("OVERRIDABLE")) {
                        if (node2.getNodeValue().equalsIgnoreCase("true")) {
                            cIMQualifier.addFlavor(new CIMFlavor(0));
                        } else {
                            cIMQualifier.addFlavor(new CIMFlavor(1));
                        }
                    } else if (node2.getNodeName().equals("TOSUBCLASS")) {
                        if (node2.getNodeValue().equalsIgnoreCase("true")) {
                            cIMQualifier.addFlavor(new CIMFlavor(3));
                        } else {
                            cIMQualifier.addFlavor(new CIMFlavor(2));
                        }
                    } else if (node2.getNodeName().equals("TRANSLATABLE") && node2.getNodeValue().equalsIgnoreCase("true")) {
                        cIMQualifier.addFlavor(new CIMFlavor(4));
                    }
                    ++n;
                }
                node = treeWalker.getNextElement(null);
                continue;
            }
            if (string2.startsWith("VALUE")) {
                cIMQualifier.setValue(XMLParser.getCIMValue(node, string));
                break;
            }
            node = treeWalker.getNextElement(null);
        }
        return cIMQualifier;
    }

    static CIMQualifierType getCIMQualifierType(Node node) {
        CIMQualifierType cIMQualifierType = new CIMQualifierType();
        String string = null;
        boolean bl = false;
        int n = -2;
        TreeWalker treeWalker = new TreeWalker(node);
        node = treeWalker.getCurrent();
        while (node != null) {
            Object object;
            int n2;
            NamedNodeMap namedNodeMap;
            String string2 = node.getNodeName();
            if (string2.equals("QUALIFIER.DECLARATION")) {
                namedNodeMap = node.getAttributes();
                n2 = 0;
                while (n2 < namedNodeMap.getLength()) {
                    object = namedNodeMap.item(n2);
                    if (object.getNodeName().equals("NAME")) {
                        cIMQualifierType.setName(object.getNodeValue());
                    } else if (object.getNodeName().equals("TYPE")) {
                        string = object.getNodeValue();
                    } else if (object.getNodeName().equals("ISARRAY")) {
                        bl = object.getNodeValue().equalsIgnoreCase("true");
                    } else if (object.getNodeName().equals("ARRAYSIZE")) {
                        bl = true;
                        n = Integer.parseInt(object.getNodeValue());
                    } else if (object.getNodeName().equals("OVERRIDABLE")) {
                        if (object.getNodeValue().equalsIgnoreCase("true")) {
                            cIMQualifierType.addFlavor(new CIMFlavor(0));
                        } else {
                            cIMQualifierType.addFlavor(new CIMFlavor(1));
                        }
                    } else if (object.getNodeName().equals("TOSUBCLASS")) {
                        if (object.getNodeValue().equalsIgnoreCase("true")) {
                            cIMQualifierType.addFlavor(new CIMFlavor(3));
                        } else {
                            cIMQualifierType.addFlavor(new CIMFlavor(2));
                        }
                    } else if (object.getNodeName().equals("TRANSLATABLE") && object.getNodeValue().equalsIgnoreCase("true")) {
                        cIMQualifierType.addFlavor(new CIMFlavor(4));
                    }
                    ++n2;
                }
                try {
                    object = CIMDataType.getDataType(string, bl);
                    if (bl) {
                        object = new CIMDataType(((CIMDataType)object).getType(), n);
                    }
                    cIMQualifierType.setType((CIMDataType)object);
                }
                catch (CIMException cIMException) {
                    Debug.trace1("Got exception", cIMException);
                }
                node = treeWalker.getNextElement(null);
                continue;
            }
            if (string2.startsWith("SCOPE")) {
                namedNodeMap = node.getAttributes();
                n2 = 0;
                while (n2 < namedNodeMap.getLength()) {
                    object = namedNodeMap.item(n2);
                    if (object.getNodeName().equals("CLASS") && object.getNodeValue().equalsIgnoreCase("true")) {
                        cIMQualifierType.addScope(new CIMScope(1));
                    } else if (object.getNodeName().equals("ASSOCIATION") && object.getNodeValue().equalsIgnoreCase("true")) {
                        cIMQualifierType.addScope(new CIMScope(2));
                    } else if (object.getNodeName().equals("REFERENCE") && object.getNodeValue().equalsIgnoreCase("true")) {
                        cIMQualifierType.addScope(new CIMScope(5));
                    } else if (object.getNodeName().equals("PROPERTY") && object.getNodeValue().equalsIgnoreCase("true")) {
                        cIMQualifierType.addScope(new CIMScope(4));
                    } else if (object.getNodeName().equals("METHOD") && object.getNodeValue().equalsIgnoreCase("true")) {
                        cIMQualifierType.addScope(new CIMScope(6));
                    } else if (object.getNodeName().equals("PARAMETER") && object.getNodeValue().equalsIgnoreCase("true")) {
                        cIMQualifierType.addScope(new CIMScope(7));
                    } else if (object.getNodeName().equals("INDICATION") && object.getNodeValue().equalsIgnoreCase("true")) {
                        cIMQualifierType.addScope(new CIMScope(3));
                    }
                    ++n2;
                }
                node = treeWalker.getNextElement(null);
                continue;
            }
            if (string2.startsWith("VALUE")) {
                cIMQualifierType.setDefaultValue(XMLParser.getCIMValue(node, string));
                break;
            }
            node = treeWalker.getNextElement(null);
        }
        return cIMQualifierType;
    }

    static CIMValue getCIMValue(Node node, String string) {
        Vector<Object> vector = null;
        TreeWalker treeWalker = new TreeWalker(node);
        node = treeWalker.getCurrent();
        while (node != null) {
            String string2 = node.getNodeName();
            if (string2.equals("KEYVALUE")) {
                vector = XMLParser.valueObject(node, ((ElementNode)node).getAttribute("VALUETYPE"));
                break;
            }
            if (string2.equals("VALUE")) {
                vector = XMLParser.valueObject(node, string);
                break;
            }
            if (string2.equals("VALUE.ARRAY")) {
                Vector<Object> vector2 = new Vector<Object>();
                node = treeWalker.getNextElement("VALUE");
                while (node != null) {
                    vector2.addElement(XMLParser.valueObject(node, string));
                    node = treeWalker.getNextElement("VALUE");
                }
                vector = vector2;
                break;
            }
            if (string2.equals("VALUE.REFERENCE")) {
                vector = XMLParser.getCIMObjectPath(XMLParser.getFirstChildElement(node));
                break;
            }
            node = treeWalker.getNext();
        }
        return new CIMValue(vector);
    }

    private static Object valueObject(Node node, String string) {
        Object object = null;
        String string2 = XMLParser.getStringValue(node);
        if (string2 == null || string == null) {
            return string2;
        }
        string = string.length() > 0 ? string : "string";
        int n = 10;
        if (string.startsWith("sint") && (string2.startsWith("0x") || string2.startsWith("+0x") || string2.startsWith("-0x") || string2.startsWith("0X") || string2.startsWith("+0X") || string2.startsWith("-0X")) || string.startsWith("uint") && (string2.startsWith("0x") || string2.startsWith("0X"))) {
            n = 16;
            int n2 = (string2.indexOf("x") > 0 ? string2.indexOf("x") : string2.indexOf("X")) + 1;
            String string3 = string2 = string2.startsWith("-") ? "-" + string2.substring(n2) : string2.substring(n2);
        }
        if (string.equals("boolean")) {
            object = Boolean.valueOf(string2);
        } else if (string.equals("char16")) {
            object = new Character(string2.charAt(0));
        } else if (string.equals("datetime")) {
            String string4 = string2;
            int n3 = string4.length();
            if (n3 != 25) {
                Debug.trace1("Datetime string is not valid: " + string4);
                if (n3 > 20) {
                    String string5 = string4.substring(0, 21);
                    string4 = string5 = string5 + "-000";
                    Debug.trace3("Attempting to fix datetime, changed to: " + string4);
                } else {
                    Debug.trace3("Datetime is 'unfixable'");
                }
            }
            object = new CIMDateTime(string4);
        } else if (string.equals("real32")) {
            object = new Float(string2);
        } else if (string.equals("real64")) {
            object = new Double(string2);
        } else if (string.equals("sint16")) {
            object = Short.valueOf(string2, n);
        } else if (string.equals("sint32")) {
            object = Integer.valueOf(string2, n);
        } else if (string.equals("sint64")) {
            object = Long.valueOf(string2, n);
        } else if (string.equals("sint8")) {
            object = Byte.valueOf(string2, n);
        } else if (string.equals("string")) {
            object = string2 == null ? (String)object : new String(string2);
        } else if (string.equals("uint16")) {
            object = new UnsignedInt16(Integer.valueOf(string2, n));
        } else if (string.equals("uint32")) {
            object = new UnsignedInt32(Long.valueOf(string2, n));
        } else if (string.equals("uint64")) {
            object = new UnsignedInt64(new BigInteger(string2, n));
        } else if (string.equals("uint8")) {
            object = new UnsignedInt8(Short.valueOf(string2, n));
        } else if (string2.indexOf("e") > 0 || string2.indexOf("E") > 0) {
            object = new Double(string2);
        } else if (string2.startsWith("+") || string2.startsWith("-")) {
            object = new Long(string2);
        }
        return object;
    }

    static boolean getBooleanValue(Node node) {
        TreeWalker treeWalker = new TreeWalker(node);
        boolean bl = false;
        node = treeWalker.getNextElement("VALUE");
        return XMLParser.getTextNode(node).equalsIgnoreCase("true");
    }

    private static Node getFirstChildElement(Node node) {
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node2 = nodeList.item(n);
                if (node2.getNodeType() == 1) {
                    return node2;
                }
                ++n;
            }
        }
        return null;
    }

    static String getStringValue(Node node) {
        String string = node.getNodeName();
        if (string.endsWith("PARAMVALUE")) {
            node = XMLParser.getFirstChildElement(node);
        }
        return XMLParser.getTextNode(node);
    }

    private static String getTextNode(Node node) {
        TreeWalker treeWalker = new TreeWalker(node);
        node = treeWalker.getCurrent();
        while (node != null) {
            if (node.getNodeType() == 3 && node != null) {
                return node.getNodeValue();
            }
            node = treeWalker.getNext();
        }
        return null;
    }
}

