/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.client.adapter.http.transport;

import java.lang.ref.SoftReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;

public final class HttpSettings {
    private static Object lastNonProxyLock = new Object();
    private static String lastNonProxyHosts = null;
    private static SoftReference lastNonProxyPool = null;
    private Properties props;

    public static HttpSettings getHttpSettings() {
        return (HttpSettings)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new HttpSettings(System.getProperties());
            }
        });
    }

    private HttpSettings(Properties properties) {
        this.props = properties;
    }

    public String getHttpProxyHost(String string) {
        String string2 = this.props.getProperty("http.proxyHost");
        return string2 != null || (string2 = this.props.getProperty("proxyHost")) != null ? string2 : string;
    }

    public int getHttpProxyPort(int n) {
        String string = this.props.getProperty("http.proxyPort");
        if (string != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string = this.props.getProperty("proxyPort")) != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    public String getHttpsProxyHost(String string) {
        return this.props.getProperty("https.proxyHost", string);
    }

    public int getHttpsProxyPort(int n) {
        String string = this.props.getProperty("https.proxyPort");
        if (string != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    public long getResponseAckTimeout(long l) {
        String string = this.props.getProperty("sun.rmi.transport.http.ackTimeout");
        if (string != null) {
            try {
                return Long.parseLong(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return l;
    }

    public long getConnectionTimeout(long l) {
        String string = this.props.getProperty("sun.rmi.transport.http.connectionTimeout");
        if (string != null) {
            try {
                return Long.parseLong(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return l;
    }

    public boolean nonProxied(String string, boolean bl) {
        return false;
    }
}

