/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.client.adapter.http.transport;

import java.security.AccessController;
import javax.wbem.client.adapter.http.transport.TimedConnection;
import javax.wbem.client.adapter.http.transport.TimedMap;
import sun.rmi.runtime.Executor;
import sun.rmi.runtime.GetThreadPoolAction;

public class ConnectionTimer {
    private static final Executor systemThreadPool = (Executor)AccessController.doPrivileged(new GetThreadPoolAction(false));
    private TimeoutMap timeouts;

    public ConnectionTimer(long l) {
        this.timeouts = new TimeoutMap(l);
    }

    public void scheduleTimeout(TimedConnection timedConnection, boolean bl) {
        if (timedConnection == null) {
            throw new NullPointerException();
        }
        this.timeouts.put(timedConnection, new Boolean(bl));
    }

    public boolean cancelTimeout(TimedConnection timedConnection) {
        if (timedConnection == null) {
            throw new NullPointerException();
        }
        return this.timeouts.remove(timedConnection) != null;
    }

    private static final class TimeoutMap
    extends TimedMap {
        TimeoutMap(long l) {
            super(systemThreadPool, l);
        }

        void evicted(Object object, Object object2) {
            boolean bl = (Boolean)object2;
            ((TimedConnection)object).shutdown(bl);
        }
    }
}

