/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.patchmgr.client.WBEMClient;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.fsmgr.client.WBEMClient.FsMgrMountClient;
import com.sun.admin.fsmgr.common.FsMgrMount;
import com.sun.admin.patchmgr.client.WBEMClient.ClientProxyException;
import com.sun.admin.patchmgr.common.AssessedPatchData;
import com.sun.admin.patchmgr.common.DownloadPatchesResults;
import com.sun.admin.patchmgr.common.InstallPatchesByPolicyResults;
import com.sun.admin.patchmgr.common.PatchMgrObj;
import com.sun.admin.patchmgr.common.PatchPropertiesConfig;
import com.sun.admin.patchmgr.common.RemoteFileData;
import com.sun.admin.patchmgr.common.SpooledPatchUtil;
import com.sun.admin.patchmgr.common.SunOSInfo;
import java.security.Principal;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.wbem.cim.CIMDateTime;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.client.CIMClient;
import javax.wbem.client.PasswordCredential;
import javax.wbem.client.UserPrincipal;

public class PatchMgrClient {
    private CIMClient cc = null;
    private static final String SOLARIS_PATCH = "Solaris_Patch";
    private static final String SOLARIS_PACKAGE = "Solaris_Package";
    private static final String SOLARIS_SUN_OS = "Solaris_OperatingSystem";
    private static final String SOLARIS_CS = "Solaris_ComputerSystem";
    private static final String SOLARIS_DIR = "Solaris_Directory";
    private static final String NAME = "Name";
    private static final String OBSOLETES = "Obsoletes";
    private static final String REQUIRES = "Requires";
    private static final String INCOMPATIBLES = "Incompatibles";
    private static final String PACKAGES = "Packages";
    private static final String PATCH_DIR_NAME = "PatchDirectoryName";
    private static final String PATCH_BACKOUT_DIR = "BackoutDirectory";
    private static final String DESCRIPTION = "Description";
    private static final String TARGET_OS = "TargetOperatingSystem";
    private static final String INSTALL_DATE = "InstallDate";
    private static final String RELEASE_DATE = "ReleaseDate";
    private static final String ARCH = "Architecture";
    private static final String PATCH_SOLARIS_REL = "PatchSolarisRelease";
    private static final String PATCH_SUNOS_REL = "PatchSunOSRelease";
    private static final String BACK_UP_FILES = "BackUpFiles";
    private static final String SUM_REC = "SingleUserRecommended";
    private static final String SUM_REQ = "SingleUserRequired";
    private static final String REB_AFT = "RebootAfter";
    private static final String REB_IMM = "RebootImmediate";
    private static final String REC_AFT = "ReconfigAfter";
    private static final String REC_IMM = "ReconfigImmediate";
    private static final String GETSPOOLEDPATCHINFO = "GetSpooledPatchInfo";
    private static final String GETSPOOLEDPATCHREADME = "GetSpooledPatchReadme";
    private static final String ASSESS_NEEDED_PATCHES = "AssessNeededPatches";
    private static final String DOWNLOAD_PATCHES = "DownloadPatches";
    private static final String DOWNLOAD_PATCHES_IN_JAR_FORMAT = "DownloadPatchesInJarFormat";
    private static final String INSTALL_PATCHES_BY_POLICY = "InstallPatchesByPolicy";
    private static final String ISA_TYPE_PROP = "ISAType";
    private static final String OS_VERSION = "Version";
    private static final String OTHER_VERSION_DESC = "OtherVersionDescription";
    private static final String EMPTY_STR = "";
    public static final String DEFAULT_MNT_POINT = "/patch_spool";
    private static final boolean TRUE = true;
    private static final boolean FALSE = false;
    private static final String PKG_PATCHPRO_NAME = "SUNWppro";

    public void init(CIMClient cIMClient) throws AdminException {
        this.cc = cIMClient;
    }

    public Vector getPatchList() throws AdminException {
        Vector<PatchMgrObj> vector = new Vector<PatchMgrObj>();
        try {
            CIMObjectPath cIMObjectPath = new CIMObjectPath(SOLARIS_PATCH);
            Enumeration enumeration = this.cc.enumerateInstances(cIMObjectPath, true, false, false, false, null);
            CIMInstance cIMInstance = null;
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    cIMInstance = (CIMInstance)enumeration.nextElement();
                    PatchMgrObj patchMgrObj = this.setPatchObj(cIMInstance);
                    vector.addElement(patchMgrObj);
                }
            }
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals("GENERAL_EXCEPTION")) {
                throw new ClientProxyException("EXM_PATCH_READALL");
            }
            throw this.mapException((Exception)((Object)cIMException));
        }
        catch (Exception exception) {
            throw this.mapException(exception);
        }
        if (vector == null || vector.size() == 0) {
            vector = new Vector(0);
        }
        return vector;
    }

    public Hashtable getPackageList() throws AdminException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        try {
            CIMObjectPath cIMObjectPath = new CIMObjectPath(SOLARIS_PACKAGE);
            Enumeration enumeration = this.cc.enumerateInstanceNames(cIMObjectPath);
            Object var4_6 = null;
            String string = null;
            CIMObjectPath cIMObjectPath2 = null;
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    cIMObjectPath2 = (CIMObjectPath)enumeration.nextElement();
                    Enumeration enumeration2 = cIMObjectPath2.getKeys().elements();
                    while (enumeration2.hasMoreElements()) {
                        CIMProperty cIMProperty = (CIMProperty)enumeration2.nextElement();
                        if (!cIMProperty.getName().equalsIgnoreCase(NAME)) continue;
                        string = (String)cIMProperty.getValue().getValue();
                        break;
                    }
                    hashtable.put(string, string);
                }
            }
            return hashtable;
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals("GENERAL_EXCEPTION")) {
                throw new ClientProxyException("EXM_PACKAGE_READALL", cIMException.getLocalizedMessage());
            }
            throw this.mapException((Exception)((Object)cIMException));
        }
        catch (Exception exception) {
            throw this.mapException(exception);
        }
    }

    public PatchMgrObj getPatchData(String string) throws AdminException {
        try {
            CIMObjectPath cIMObjectPath = new CIMObjectPath(SOLARIS_PATCH);
            cIMObjectPath.addKey(NAME, new CIMValue((Object)string));
            CIMInstance cIMInstance = this.cc.getInstance(cIMObjectPath, false, false, false, null);
            if (cIMInstance != null) {
                PatchMgrObj patchMgrObj = this.setPatchObj(cIMInstance);
                return patchMgrObj;
            }
            return null;
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals("GENERAL_EXCEPTION")) {
                throw new ClientProxyException("EXM_PATCH_READ", string);
            }
            throw this.mapException((Exception)((Object)cIMException));
        }
        catch (Exception exception) {
            throw this.mapException(exception);
        }
    }

    public void applySinglePatch(PatchMgrObj patchMgrObj) throws AdminException {
        try {
            Vector<CIMProperty> vector = new Vector<CIMProperty>();
            CIMProperty cIMProperty = null;
            cIMProperty = new CIMProperty(NAME);
            cIMProperty.setValue(new CIMValue((Object)patchMgrObj.getPatchName()));
            vector.addElement(cIMProperty);
            cIMProperty = new CIMProperty(PATCH_DIR_NAME);
            cIMProperty.setValue(new CIMValue((Object)patchMgrObj.getPatchDirName()));
            vector.addElement(cIMProperty);
            cIMProperty = new CIMProperty(PATCH_BACKOUT_DIR);
            cIMProperty.setValue(new CIMValue((Object)patchMgrObj.getBackoutDir()));
            vector.addElement(cIMProperty);
            CIMObjectPath cIMObjectPath = new CIMObjectPath(SOLARIS_PATCH, vector);
            CIMInstance cIMInstance = new CIMInstance();
            cIMInstance.setClassName(SOLARIS_PATCH);
            cIMInstance.setProperties(vector);
            this.cc.createInstance(cIMObjectPath, cIMInstance);
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals("GENERAL_EXCEPTION")) {
                Object[] objectArray = cIMException.getParams();
                if (objectArray != null && objectArray.length > 0) {
                    String string = (String)objectArray[0];
                    throw new ClientProxyException("EXM_PATCH_ADD_FAILED", string);
                }
                throw new ClientProxyException("EXM_PATCH_ADD_UNEXP", patchMgrObj.getPatchName());
            }
            throw this.mapException((Exception)((Object)cIMException));
        }
        catch (Exception exception) {
            throw this.mapException(exception);
        }
    }

    public void removeSinglePatch(PatchMgrObj patchMgrObj) throws AdminException {
        try {
            CIMObjectPath cIMObjectPath = new CIMObjectPath(SOLARIS_PATCH);
            cIMObjectPath.addKey(NAME, new CIMValue((Object)patchMgrObj.getPatchName()));
            this.cc.deleteInstance(cIMObjectPath);
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals("GENERAL_EXCEPTION")) {
                Object[] objectArray = cIMException.getParams();
                if (objectArray != null && objectArray.length > 0) {
                    String string = (String)objectArray[0];
                    throw new ClientProxyException("EXM_PATCH_REMOVE_FAILED", string);
                }
                throw new ClientProxyException("EXM_PATCH_REMOVE_UNEXP", patchMgrObj.getPatchName());
            }
            throw this.mapException((Exception)((Object)cIMException));
        }
        catch (Exception exception) {
            throw this.mapException(exception);
        }
    }

    private void checkForExports(FsMgrMountClient fsMgrMountClient, String string) throws AdminException {
        String string2 = new String();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        int n = stringTokenizer.countTokens();
        int n2 = 0;
        while (n2 < n) {
            String string3;
            if (stringTokenizer.hasMoreTokens() && (string3 = stringTokenizer.nextToken()) != EMPTY_STR) {
                string2 = string3;
                break;
            }
            ++n2;
        }
        if (string2 != null || !string2.equals(EMPTY_STR)) {
            fsMgrMountClient.showExports(string2);
        }
    }

    public void mountPatchServer(String string) throws AdminException {
        FsMgrMountClient fsMgrMountClient = new FsMgrMountClient();
        fsMgrMountClient.init(this.cc);
        try {
            this.checkForExports(fsMgrMountClient, string);
        }
        catch (AdminException adminException) {
            throw new ClientProxyException("EXM_MOUNT_FAILED", string);
        }
        fsMgrMountClient.makeDirectory(DEFAULT_MNT_POINT);
        FsMgrMount fsMgrMount = null;
        try {
            fsMgrMount = fsMgrMountClient.getMountEntry(string, DEFAULT_MNT_POINT);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (fsMgrMount == null) {
            fsMgrMount = new FsMgrMount(string, EMPTY_STR, DEFAULT_MNT_POINT, "NFS", EMPTY_STR, "no", EMPTY_STR);
            fsMgrMountClient.addMount(fsMgrMount);
        }
    }

    public void unmountPatchServer(String string) throws AdminException {
        FsMgrMountClient fsMgrMountClient = new FsMgrMountClient();
        fsMgrMountClient.init(this.cc);
        String string2 = DEFAULT_MNT_POINT;
        try {
            this.checkForExports(fsMgrMountClient, string);
        }
        catch (AdminException adminException) {
            throw new ClientProxyException("EXM_UNMOUNT_FAILED", string2);
        }
        FsMgrMount fsMgrMount = null;
        try {
            fsMgrMount = fsMgrMountClient.getMountEntry(string, string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (fsMgrMount != null) {
            fsMgrMount = new FsMgrMount(string, EMPTY_STR, string2, "NFS", EMPTY_STR, EMPTY_STR, EMPTY_STR);
            fsMgrMountClient.removeMount(fsMgrMount);
        }
    }

    public Vector getSpooledPatchInfo(String string) throws AdminException {
        try {
            Vector<CIMValue> vector = new Vector<CIMValue>();
            Vector vector2 = new Vector();
            CIMObjectPath cIMObjectPath = new CIMObjectPath(SOLARIS_PATCH);
            vector.addElement(new CIMValue((Object)string));
            this.cc.invokeMethod(cIMObjectPath, GETSPOOLEDPATCHINFO, vector, vector2);
            CIMValue cIMValue = (CIMValue)vector2.elementAt(0);
            Vector vector3 = (Vector)cIMValue.getValue();
            return vector3;
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals("GENERAL_EXCEPTION")) {
                Object[] objectArray = cIMException.getParams();
                if (objectArray != null && objectArray.length > 0) {
                    String string2 = (String)objectArray[0];
                    throw new ClientProxyException("EXM_PATCH_SPOOL_READ", string, string2);
                }
                throw new ClientProxyException("EXM_SPOOL_READ_UNEXP", string);
            }
            throw this.mapException((Exception)((Object)cIMException));
        }
        catch (Exception exception) {
            throw this.mapException(exception);
        }
    }

    public String getSpooledPatchReadme(String string, String string2) throws AdminException {
        try {
            Vector<CIMValue> vector = new Vector<CIMValue>();
            Vector vector2 = new Vector();
            CIMObjectPath cIMObjectPath = new CIMObjectPath(SOLARIS_PATCH);
            vector.addElement(new CIMValue((Object)string));
            vector.addElement(new CIMValue((Object)string2));
            this.cc.invokeMethod(cIMObjectPath, GETSPOOLEDPATCHREADME, vector, vector2);
            CIMValue cIMValue = (CIMValue)vector2.elementAt(0);
            String string3 = (String)cIMValue.getValue();
            return string3;
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals("GENERAL_EXCEPTION")) {
                Object[] objectArray = cIMException.getParams();
                if (objectArray != null && objectArray.length > 0) {
                    String string4 = (String)objectArray[0];
                    throw new ClientProxyException("EXM_PATCH_SPOOL_README", string2, string, string4);
                }
                throw new ClientProxyException("EXM_SPOOL_README_UNEXP", string2, string);
            }
            throw this.mapException((Exception)((Object)cIMException));
        }
        catch (Exception exception) {
            throw this.mapException(exception);
        }
    }

    public SunOSInfo getSunOSRelease() throws AdminException {
        try {
            CIMObjectPath cIMObjectPath = new CIMObjectPath(SOLARIS_SUN_OS);
            Enumeration enumeration = this.cc.enumerateInstances(cIMObjectPath, true, false, false, false, null);
            CIMInstance cIMInstance = null;
            String string = null;
            String string2 = null;
            if (enumeration != null && (cIMInstance = (CIMInstance)enumeration.nextElement()) != null) {
                CIMProperty cIMProperty = cIMInstance.getProperty(OS_VERSION);
                CIMValue cIMValue = cIMProperty.getValue();
                if (cIMValue != null) {
                    string = (String)cIMValue.getValue();
                }
                if ((cIMValue = (cIMProperty = cIMInstance.getProperty(OTHER_VERSION_DESC)).getValue()) != null) {
                    string2 = (String)cIMValue.getValue();
                }
                SunOSInfo sunOSInfo = new SunOSInfo(string, string2);
                return sunOSInfo;
            }
            return null;
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals("GENERAL_EXCEPTION")) {
                throw new ClientProxyException("EXM_SUN_OS_VERSION", cIMException.getLocalizedMessage());
            }
            throw this.mapException((Exception)((Object)cIMException));
        }
        catch (Exception exception) {
            throw this.mapException(exception);
        }
    }

    public String getSystemArch() throws AdminException {
        try {
            CIMProperty cIMProperty;
            CIMValue cIMValue;
            CIMObjectPath cIMObjectPath = new CIMObjectPath(SOLARIS_CS);
            Enumeration enumeration = this.cc.enumerateInstances(cIMObjectPath, true, false, false, false, null);
            String[] stringArray = new String[]{"sparc", "i386"};
            CIMInstance cIMInstance = null;
            String string = null;
            if (enumeration != null && (cIMInstance = (CIMInstance)enumeration.nextElement()) != null && (cIMValue = (cIMProperty = cIMInstance.getProperty(ISA_TYPE_PROP)).getValue()) != null) {
                UnsignedInt16 unsignedInt16 = (UnsignedInt16)cIMValue.getValue();
                if (unsignedInt16.intValue() > 0) {
                    return stringArray[unsignedInt16.intValue() - 1];
                }
                return null;
            }
            return string;
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals("GENERAL_EXCEPTION")) {
                throw new ClientProxyException("EXM_SYSTEM_ARCHITECTURE", cIMException.getLocalizedMessage());
            }
            throw this.mapException((Exception)((Object)cIMException));
        }
        catch (Exception exception) {
            throw this.mapException(exception);
        }
    }

    public Vector assessNeededPatches() throws AdminException {
        try {
            Vector vector = new Vector();
            Vector vector2 = new Vector();
            CIMObjectPath cIMObjectPath = new CIMObjectPath(SOLARIS_PATCH);
            this.cc.invokeMethod(cIMObjectPath, ASSESS_NEEDED_PATCHES, vector2, vector);
            CIMValue cIMValue = (CIMValue)vector.elementAt(0);
            Vector vector3 = (Vector)cIMValue.getValue();
            cIMValue = (CIMValue)vector.elementAt(1);
            Vector vector4 = (Vector)cIMValue.getValue();
            int n = 0;
            Vector<AssessedPatchData> vector5 = null;
            if (vector3 != null) {
                n = vector3.size();
                vector5 = new Vector<AssessedPatchData>(n);
            }
            int n2 = 0;
            while (n2 < n) {
                AssessedPatchData assessedPatchData = new AssessedPatchData((String)vector3.elementAt(n2), (String)vector4.elementAt(n2));
                vector5.addElement(assessedPatchData);
                ++n2;
            }
            return vector5;
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals("GENERAL_EXCEPTION")) {
                Object[] objectArray = cIMException.getParams();
                if (objectArray != null && objectArray.length > 0) {
                    String string = (String)objectArray[0];
                    throw new ClientProxyException("EXM_PAN_FAILED", string);
                }
                throw new ClientProxyException("EXM_PAN_UNEXP");
            }
            throw this.mapException((Exception)((Object)cIMException));
        }
        catch (Exception exception) {
            throw this.mapException(exception);
        }
    }

    public DownloadPatchesResults downloadPatches(Vector vector, String string) throws AdminException {
        try {
            Vector<CIMValue> vector2 = new Vector<CIMValue>();
            Vector vector3 = new Vector();
            CIMObjectPath cIMObjectPath = new CIMObjectPath(SOLARIS_PATCH);
            vector2.addElement(new CIMValue((Object)vector));
            vector2.addElement(new CIMValue((Object)string));
            this.cc.invokeMethod(cIMObjectPath, DOWNLOAD_PATCHES, vector2, vector3);
            CIMValue cIMValue = (CIMValue)vector3.elementAt(0);
            Vector vector4 = null;
            if (cIMValue != null) {
                vector4 = (Vector)cIMValue.getValue();
            }
            cIMValue = (CIMValue)vector3.elementAt(1);
            Vector vector5 = null;
            if (cIMValue != null) {
                vector5 = (Vector)cIMValue.getValue();
            }
            return new DownloadPatchesResults(vector, vector4, vector5);
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals("GENERAL_EXCEPTION")) {
                Object[] objectArray = cIMException.getParams();
                if (objectArray != null && objectArray.length > 0) {
                    String string2 = (String)objectArray[0];
                    throw new ClientProxyException("EXM_PDL_FAILED", string2);
                }
                throw new ClientProxyException("EXM_PDL_UNEXP");
            }
            throw this.mapException((Exception)((Object)cIMException));
        }
        catch (Exception exception) {
            throw this.mapException(exception);
        }
    }

    public DownloadPatchesResults downloadPatchesInJarFormat(Vector vector, String string) throws AdminException {
        try {
            Vector<CIMValue> vector2 = new Vector<CIMValue>();
            Vector vector3 = new Vector();
            CIMObjectPath cIMObjectPath = new CIMObjectPath(SOLARIS_PATCH);
            vector2.addElement(new CIMValue((Object)vector));
            vector2.addElement(new CIMValue((Object)string));
            this.cc.invokeMethod(cIMObjectPath, DOWNLOAD_PATCHES_IN_JAR_FORMAT, vector2, vector3);
            CIMValue cIMValue = (CIMValue)vector3.elementAt(0);
            Vector vector4 = null;
            if (cIMValue != null) {
                vector4 = (Vector)cIMValue.getValue();
            }
            cIMValue = (CIMValue)vector3.elementAt(1);
            Vector vector5 = null;
            if (cIMValue != null) {
                vector5 = (Vector)cIMValue.getValue();
            }
            return new DownloadPatchesResults(vector, vector4, vector5);
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals("GENERAL_EXCEPTION")) {
                Object[] objectArray = cIMException.getParams();
                if (objectArray != null && objectArray.length > 0) {
                    String string2 = (String)objectArray[0];
                    throw new ClientProxyException("EXM_PDL_FAILED", string2);
                }
                throw new ClientProxyException("EXM_PDL_UNEXP");
            }
            throw this.mapException((Exception)((Object)cIMException));
        }
        catch (Exception exception) {
            throw this.mapException(exception);
        }
    }

    public boolean isPatchProOnSystem() throws AdminException {
        boolean bl;
        block5: {
            bl = false;
            try {
                CIMObjectPath cIMObjectPath = new CIMObjectPath(SOLARIS_PACKAGE);
                cIMObjectPath.addKey(NAME, new CIMValue((Object)PKG_PATCHPRO_NAME));
                CIMInstance cIMInstance = this.cc.getInstance(cIMObjectPath, false, false, false, null);
                if (cIMInstance != null) {
                    CIMProperty cIMProperty = cIMInstance.getProperty(NAME);
                    CIMValue cIMValue = cIMProperty.getValue();
                    String string = EMPTY_STR;
                    if (cIMValue != null) {
                        string = (String)cIMValue.getValue();
                    }
                    if (string.equals(PKG_PATCHPRO_NAME)) {
                        bl = true;
                    }
                    break block5;
                }
                return bl;
            }
            catch (Exception exception) {
                throw this.mapException(exception);
            }
        }
        return bl;
    }

    public RemoteFileData getDirInfo(String string) throws AdminException {
        try {
            Vector<CIMValue> vector = new Vector<CIMValue>();
            Vector vector2 = new Vector();
            CIMObjectPath cIMObjectPath = new CIMObjectPath(SOLARIS_DIR);
            vector.addElement(new CIMValue((Object)string));
            this.cc.invokeMethod(cIMObjectPath, "getFile", vector, vector2);
            String string2 = (String)((CIMValue)vector2.elementAt(0)).getValue();
            String string3 = (String)((CIMValue)vector2.elementAt(1)).getValue();
            Boolean bl = (Boolean)((CIMValue)vector2.elementAt(2)).getValue();
            return new RemoteFileData(string2, string3, bl);
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals("GENERAL_EXCEPTION")) {
                throw new ClientProxyException("EXM_DIR_ACCESS", string);
            }
            throw this.mapException((Exception)((Object)cIMException));
        }
        catch (Exception exception) {
            throw this.mapException(exception);
        }
    }

    public void createDirectory(String string) throws AdminException {
        FsMgrMountClient fsMgrMountClient = new FsMgrMountClient();
        fsMgrMountClient.init(this.cc);
        try {
            fsMgrMountClient.makeDirectory(string);
        }
        catch (AdminException adminException) {
            throw this.mapException((Exception)((Object)adminException));
        }
    }

    private PatchMgrObj setPatchObj(CIMInstance cIMInstance) {
        Date date;
        Calendar calendar;
        PatchMgrObj patchMgrObj = new PatchMgrObj();
        CIMProperty cIMProperty = cIMInstance.getProperty(NAME);
        CIMValue cIMValue = cIMProperty.getValue();
        String string = EMPTY_STR;
        if (cIMValue != null) {
            string = (String)cIMValue.getValue();
        }
        if (string != null && string.trim().length() > 0) {
            patchMgrObj.setPatchName(string);
        }
        cIMProperty = cIMInstance.getProperty(OBSOLETES);
        cIMValue = cIMProperty.getValue();
        Vector vector = null;
        if (cIMValue != null) {
            vector = (Vector)cIMValue.getValue();
        }
        if (vector != null && vector.size() > 0) {
            patchMgrObj.setObsoletes(vector);
        }
        cIMProperty = cIMInstance.getProperty(PACKAGES);
        cIMValue = cIMProperty.getValue();
        Vector vector2 = null;
        if (cIMValue != null) {
            vector2 = (Vector)cIMValue.getValue();
        }
        if (vector2 != null && vector2.size() > 0) {
            patchMgrObj.setPackages(vector2);
        }
        cIMProperty = cIMInstance.getProperty(REQUIRES);
        cIMValue = cIMProperty.getValue();
        Vector vector3 = null;
        if (cIMValue != null) {
            vector3 = (Vector)cIMValue.getValue();
        }
        if (vector3 != null && vector3.size() > 0) {
            patchMgrObj.setRequires(vector3);
        }
        cIMProperty = cIMInstance.getProperty(INCOMPATIBLES);
        cIMValue = cIMProperty.getValue();
        Vector vector4 = null;
        if (cIMValue != null) {
            vector4 = (Vector)cIMValue.getValue();
        }
        if (vector4 != null && vector4.size() > 0) {
            patchMgrObj.setIncompatibles(vector4);
        }
        cIMProperty = cIMInstance.getProperty(PATCH_BACKOUT_DIR);
        cIMValue = cIMProperty.getValue();
        String string2 = null;
        if (cIMValue != null) {
            string2 = (String)cIMValue.getValue();
        }
        if (string2 != null && string2.length() > 0) {
            patchMgrObj.setBackoutDir(string2);
        }
        cIMProperty = cIMInstance.getProperty(DESCRIPTION);
        cIMValue = cIMProperty.getValue();
        String string3 = null;
        if (cIMValue != null) {
            string3 = (String)cIMValue.getValue();
        }
        if (string3 != null && string3.length() > 0) {
            patchMgrObj.setDescription(string3);
        }
        cIMProperty = cIMInstance.getProperty(INSTALL_DATE);
        cIMValue = cIMProperty.getValue();
        CIMDateTime cIMDateTime = null;
        if (cIMValue != null) {
            cIMDateTime = (CIMDateTime)cIMValue.getValue();
        }
        if (cIMDateTime != null) {
            calendar = cIMDateTime.getCalendar();
            date = calendar.getTime();
            patchMgrObj.setInstallDate(date);
        }
        cIMProperty = cIMInstance.getProperty(RELEASE_DATE);
        cIMValue = cIMProperty.getValue();
        CIMDateTime cIMDateTime2 = null;
        if (cIMValue != null) {
            cIMDateTime2 = (CIMDateTime)cIMValue.getValue();
        }
        if (cIMDateTime2 != null) {
            calendar = cIMDateTime2.getCalendar();
            date = calendar.getTime();
            patchMgrObj.setReleaseDate(date);
        }
        cIMProperty = cIMInstance.getProperty(ARCH);
        cIMValue = cIMProperty.getValue();
        String string4 = null;
        if (cIMValue != null) {
            string4 = (String)cIMValue.getValue();
        }
        if (string4 != null && string4.length() > 0) {
            patchMgrObj.setArchitecture(string4);
        }
        cIMProperty = cIMInstance.getProperty(PATCH_SOLARIS_REL);
        cIMValue = cIMProperty.getValue();
        String string5 = null;
        if (cIMValue != null) {
            string5 = (String)cIMValue.getValue();
        }
        if (string5 != null && string5.length() > 0) {
            patchMgrObj.setSolRelease(string5);
        }
        cIMProperty = cIMInstance.getProperty(PATCH_SUNOS_REL);
        cIMValue = cIMProperty.getValue();
        String string6 = null;
        if (cIMValue != null) {
            string6 = (String)cIMValue.getValue();
        }
        if (string6 != null && string6.length() > 0) {
            patchMgrObj.setSunOSRelease(string6);
        }
        if ((cIMValue = (cIMProperty = cIMInstance.getProperty(BACK_UP_FILES)).getValue()) != null) {
            patchMgrObj.setBackUpFiles((Boolean)cIMValue.getValue());
        }
        boolean bl = this.getBool(cIMInstance, SUM_REC);
        boolean bl2 = this.getBool(cIMInstance, SUM_REQ);
        boolean bl3 = this.getBool(cIMInstance, REB_AFT);
        boolean bl4 = this.getBool(cIMInstance, REB_IMM);
        boolean bl5 = this.getBool(cIMInstance, REC_AFT);
        boolean bl6 = this.getBool(cIMInstance, REC_IMM);
        PatchPropertiesConfig patchPropertiesConfig = new PatchPropertiesConfig(bl, bl2, bl3, bl4, bl5, bl6, false);
        patchMgrObj.setPatchPropertiesConfig(patchPropertiesConfig);
        return patchMgrObj;
    }

    private boolean getBool(CIMInstance cIMInstance, String string) {
        CIMProperty cIMProperty = cIMInstance.getProperty(string);
        CIMValue cIMValue = cIMProperty.getValue();
        if (cIMValue != null) {
            return (Boolean)cIMValue.getValue();
        }
        return false;
    }

    private AdminException mapException(Exception exception) {
        ClientProxyException clientProxyException;
        if (exception instanceof CIMException) {
            CIMException cIMException = (CIMException)((Object)exception);
            String string = cIMException.getID();
            if (string == null || string.trim().length() == 0) {
                clientProxyException = new ClientProxyException("EXM_NO_MESSAGE");
            } else if (string.equals("CIM_ERR_ACCESS_DENIED")) {
                clientProxyException = new ClientProxyException("EXM_AUTH_SEC");
            } else if (string.equals("GENERAL_EXCEPTION")) {
                Object[] objectArray = cIMException.getParams();
                if (objectArray != null && objectArray.length > 0) {
                    String string2 = (String)objectArray[0];
                    clientProxyException = new ClientProxyException("EXM_REMOTE", string2);
                } else {
                    clientProxyException = new ClientProxyException("EXM_NO_MESSAGE");
                }
            } else {
                clientProxyException = string.equals("CIM_ERR_INVALID_QUERY") ? new ClientProxyException("EXM_AUTH_QUERY") : new ClientProxyException("EXM_NO_MESSAGE");
            }
        } else {
            clientProxyException = new ClientProxyException("EXM_NO_MESSAGE");
        }
        return clientProxyException;
    }

    private void test() {
        boolean bl = false;
        while (!bl) {
            System.out.println("1 - List Patches");
            System.out.println("2 - Get Patch");
            System.out.println("3 - Apply a single Patch");
            System.out.println("4 - Remove a single Patch");
            System.out.println("5 - Mount Patch Server");
            System.out.println("6 - Unmount Patch Server");
            System.out.println("7 - Retrieve spooled patch id README file:");
            System.out.println("8 - Retrieve spooled patch info:");
            System.out.println("9 - Check if PatchPro is on system:");
            System.out.println("a - Get the system's arch type(ISA):");
            System.out.println("b - Get the system's SunOs Info, release/version:");
            System.out.println("c - Download Patches:");
            System.out.println("d - Assess the needed patches for your system:");
            System.out.println("e - Validate directory: ");
            System.out.println("q - To quit");
            System.out.println(EMPTY_STR);
            System.out.print("Enter option: ");
            try {
                byte[] byArray = new byte[100];
                char c = (char)System.in.read(byArray);
                System.out.println(EMPTY_STR);
                if (c != '\u0002') continue;
                char c2 = (char)byArray[0];
                switch (c2) {
                    case '1': {
                        this.testList();
                        break;
                    }
                    case '2': {
                        this.testGetPatch();
                        break;
                    }
                    case '3': {
                        this.testApplySinglePatch();
                        break;
                    }
                    case '4': {
                        this.testRemoveSinglePatch();
                        break;
                    }
                    case '5': {
                        this.testMountPatchServer();
                        break;
                    }
                    case '6': {
                        this.testUnmountPatchServer();
                        break;
                    }
                    case '7': {
                        this.testGetSpooledPatchReadme();
                        break;
                    }
                    case '8': {
                        this.testGetSpooledPatchInfo();
                        break;
                    }
                    case '9': {
                        this.testPProPkgs();
                        break;
                    }
                    case 'a': {
                        String string = this.getSystemArch();
                        System.out.println("Arch.: " + string);
                        break;
                    }
                    case 'b': {
                        SunOSInfo sunOSInfo = this.getSunOSRelease();
                        System.out.println(sunOSInfo.toString());
                        break;
                    }
                    case 'c': {
                        this.testDownloadPatches();
                        break;
                    }
                    case 'd': {
                        this.testAssessNeededPatches();
                        break;
                    }
                    case 'e': {
                        this.testGetDirInfo();
                        break;
                    }
                    case 'q': {
                        bl = true;
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            System.out.println(EMPTY_STR);
        }
    }

    private String getKeyBoard(String string) {
        System.out.print(string);
        try {
            byte[] byArray = new byte[100];
            char c = (char)System.in.read(byArray);
            if ((char)byArray[c - '\u0001'] == '\n') {
                byArray[c - '\u0001'] = 0;
            }
            String string2 = new String(byArray);
            return string2.trim();
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception);
            exception.printStackTrace();
            return new String(EMPTY_STR);
        }
    }

    public InstallPatchesByPolicyResults installPatchesByPolicy(Vector vector, String string) throws AdminException {
        try {
            Vector<CIMValue> vector2 = new Vector<CIMValue>();
            Vector vector3 = new Vector();
            CIMObjectPath cIMObjectPath = new CIMObjectPath(SOLARIS_PATCH);
            vector2.addElement(new CIMValue((Object)vector));
            vector2.addElement(new CIMValue((Object)string));
            this.cc.invokeMethod(cIMObjectPath, INSTALL_PATCHES_BY_POLICY, vector2, vector3);
            CIMValue cIMValue = (CIMValue)vector3.elementAt(0);
            Vector vector4 = null;
            if (cIMValue != null) {
                vector4 = (Vector)cIMValue.getValue();
            }
            return new InstallPatchesByPolicyResults(vector4);
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals("GENERAL_EXCEPTION")) {
                Object[] objectArray = cIMException.getParams();
                if (objectArray != null && objectArray.length > 0) {
                    String string2 = (String)objectArray[0];
                    throw new ClientProxyException("EXM_PDL_FAILED", string2);
                }
                throw new ClientProxyException("EXM_PDL_UNEXP");
            }
            throw this.mapException((Exception)((Object)cIMException));
        }
        catch (Exception exception) {
            throw this.mapException(exception);
        }
    }

    private void testList() throws AdminException {
        System.out.println("------ List Patches Begin -------\n");
        Vector vector = this.getPatchList();
        int n = 0;
        while (n < vector.size()) {
            PatchMgrObj patchMgrObj = (PatchMgrObj)vector.elementAt(n);
            System.out.println(patchMgrObj.toString());
            ++n;
        }
        System.out.println("\n------ List Patches End -------\n");
    }

    private void testGetPatch() throws AdminException {
        System.out.println("------ Get Patch Begin -------\n");
        String string = this.getKeyBoard("Patch ID: ");
        PatchMgrObj patchMgrObj = this.getPatchData(string);
        if (patchMgrObj == null) {
            System.out.println("Patch not found");
        } else {
            System.out.println(patchMgrObj.toString());
        }
        System.out.println("\n------ Get Patch End -------\n");
    }

    private void testApplySinglePatch() throws AdminException {
        System.out.println("------ Apply Single Patch Begin -------\n");
        String string = null;
        Object var2_2 = null;
        String string2 = this.getKeyBoard("Do you need to mount the patch server?(y or n)");
        if (string2.equals("y")) {
            this.testMountPatchServer();
            string = DEFAULT_MNT_POINT;
        } else {
            string = this.getKeyBoard("Local Patch Directory: ");
        }
        String string3 = this.getKeyBoard("Enter a patch id: ");
        String string4 = this.getKeyBoard("Enter non-default backout directory: ");
        PatchMgrObj patchMgrObj = new PatchMgrObj();
        if (string3 != null && string3.trim().length() > 0) {
            patchMgrObj.setPatchName(string3);
        }
        if (string != null && string.trim().length() > 0) {
            patchMgrObj.setPatchDirName(string);
        }
        if (string4 != null && string4.trim().length() > 0) {
            patchMgrObj.setBackoutDir(string4);
        }
        this.applySinglePatch(patchMgrObj);
        if (string2.equals("y")) {
            this.testUnmountPatchServer();
        }
        System.out.println("\n------ Apply Single Patch End -------\n");
    }

    private void testRemoveSinglePatch() throws AdminException {
        System.out.println("------ Remove Single Patch Begin -------\n");
        String string = this.getKeyBoard("Patch ID: ");
        PatchMgrObj patchMgrObj = this.getPatchData(string);
        if (patchMgrObj == null) {
            System.out.println("Patch not found");
        } else {
            this.removeSinglePatch(patchMgrObj);
        }
        System.out.println("\n------ Remove Single Patch End -------\n");
    }

    private void testMountPatchServer() throws AdminException {
        System.out.println("------ Mount Patch Server -------\n");
        String string = null;
        String string2 = this.getKeyBoard("Remote host where patches reside: ");
        String string3 = this.getKeyBoard("The exported/shared Directory: ");
        string = string2 + ":" + string3;
        this.mountPatchServer(string);
        System.out.println("\n------ Mount Patch Server -------\n");
    }

    private void testUnmountPatchServer() throws AdminException {
        System.out.println("------ Unmount Patch Server -------\n");
        String string = null;
        String string2 = this.getKeyBoard("Remote host where patches reside: ");
        String string3 = this.getKeyBoard("The exported/shared Directory: ");
        string = string2 + ":" + string3;
        this.unmountPatchServer(string);
        System.out.println("\n------ Unmount Patch Server -------\n");
    }

    private void testGetSpooledPatchInfo() throws AdminException {
        System.out.println("------ GetSpooledPatchInfo Begin -------\n");
        String string = this.getKeyBoard("Spooled Patch Dir: ");
        Vector vector = this.getSpooledPatchInfo(string);
        int n = 0;
        while (vector != null && n < vector.size()) {
            System.out.println((String)vector.elementAt(n));
            ++n;
        }
        System.out.println();
        Hashtable hashtable = SpooledPatchUtil.getHashTable(vector);
        Vector vector2 = SpooledPatchUtil.getPatchIds(hashtable);
        n = 0;
        while (vector2 != null && n < vector2.size()) {
            System.out.println((String)vector2.elementAt(n));
            ++n;
        }
        System.out.println(EMPTY_STR);
        System.out.println("Number of Patches: " + n);
        System.out.println("\n------ GetSpooledPatchInfo End -------\n");
    }

    private void testGetSpooledPatchReadme() throws AdminException {
        System.out.println("------ GetSpooledPatchReadme Begin -------\n");
        String string = this.getKeyBoard("Spooled Patch Dir: ");
        String string2 = this.getKeyBoard("Patch Id: ");
        String string3 = this.getSpooledPatchReadme(string, string2);
        System.out.println();
        System.out.println(string3);
        System.out.println();
        System.out.println("\n------ GetSpooledPatchReadme End -------\n");
    }

    private void testGetDirInfo() throws AdminException {
        System.out.println("------ GetDirInfo Begin -------\n");
        String string = this.getKeyBoard("Enetr directory: ");
        RemoteFileData remoteFileData = this.getDirInfo(string);
        remoteFileData.print();
        System.out.println("\n------ GetDirInfo End -------\n");
    }

    private void testPProPkgs() throws AdminException {
        System.out.println("------ Testing for PatchPro packages Begin -------\n");
        boolean bl = this.isPatchProOnSystem();
        if (bl) {
            System.out.println("Hey guess what?!?!?!?  PatchPro is on the targeted system");
        } else {
            System.out.println("Hey guess what? PatchPro is not on the targeted system, :-(");
        }
        System.out.println("\n------ Testing for PatchPro packages End -------\n");
    }

    private void testDownloadPatches() throws AdminException {
        System.out.println("------ Download Patches Begin -------\n");
        Vector<String> vector = new Vector<String>();
        String string = EMPTY_STR;
        int n = 0;
        while (true) {
            if ((string = this.getKeyBoard(++n + ") " + "Patch IDs list(type 'b' to break): ")).length() == 0) {
                --n;
                continue;
            }
            if (string.equals("b")) break;
            vector.addElement(string);
        }
        String string2 = this.getKeyBoard("Download Directory: ");
        this.downloadPatches(vector, string2);
        System.out.println();
        System.out.println();
        System.out.println("\n------ Download Patches End -------\n");
    }

    private void testAssessNeededPatches() throws AdminException {
        System.out.println("------  AssessNeededPatches Begin -------\n");
        Vector vector = this.assessNeededPatches();
        System.out.println();
        int n = 0;
        while (vector != null && n < vector.size()) {
            AssessedPatchData assessedPatchData = (AssessedPatchData)vector.elementAt(n);
            System.out.println(assessedPatchData.toString());
            ++n;
        }
        System.out.println();
        System.out.println("\n------ AssessNeededPatches End -------\n");
    }

    public static void main(String[] stringArray) {
        String string;
        if (stringArray.length != 3) {
            string = "Usage: PatchMgrObjClient host username password";
            System.out.println();
            System.exit(1);
        }
        string = null;
        try {
            CIMNameSpace cIMNameSpace = new CIMNameSpace(stringArray[0]);
            UserPrincipal userPrincipal = new UserPrincipal(stringArray[1]);
            PasswordCredential passwordCredential = new PasswordCredential(stringArray[2]);
            string = new CIMClient(cIMNameSpace, (Principal)userPrincipal, (Object)passwordCredential);
            PatchMgrClient patchMgrClient = new PatchMgrClient();
            patchMgrClient.init((CIMClient)string);
            patchMgrClient.test();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (string != null) {
            try {
                string.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

