/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.patchmgr.client;

import com.sun.admin.cis.common.ActionString;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ContextHelpListener;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.FlowArea;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.patchmgr.client.DownloadPatchWizard;
import com.sun.admin.patchmgr.client.FileParser;
import com.sun.admin.patchmgr.client.PatchContextHelpListener;
import com.sun.admin.patchmgr.client.VPatchMgr;
import com.sun.admin.patchmgr.common.PatchException;
import com.sun.management.viper.console.gui.wizard.VWizardCard;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.FocusListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DownloadTextCard
extends VWizardCard {
    VPatchMgr theApp;
    ResourceBundle bundle;
    private DownloadPatchWizard wiz;
    private JTextField fileNameField;
    private ActionString actionString;
    private GenInfoPanel infoPanel;
    private PatchContextHelpListener overviewHelpListener;
    public static final int HELP_CACHE_SIZE = 2;
    private static final String DOWNLOAD_STEP2b_OVERVIEW = "download_wiz_s2_file";
    private static final String DOWNLOAD_STEP2b_TEXT = "download_wiz_s2b_text";

    public DownloadTextCard(VPatchMgr vPatchMgr, DownloadPatchWizard downloadPatchWizard) {
        this.theApp = vPatchMgr;
        this.bundle = vPatchMgr.getResourceBundle();
        this.wiz = downloadPatchWizard;
        super.setTitle(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"download_filename_step"));
        this.constructStep();
    }

    private void constructStep() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        FlowArea flowArea = new FlowArea(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"dl_wiz_ascii_file_explain"));
        Constraints.constrain((Container)((Object)this), (Component)flowArea, (int)0, (int)0, (int)2, (int)1, (int)2, (int)17, (double)0.0, (double)0.0, (int)24, (int)12, (int)0, (int)0);
        this.actionString = new ActionString(this.bundle, "dl_wiz_filename");
        JLabel jLabel = new JLabel(this.actionString.getString());
        jLabel.setDisplayedMnemonic(this.actionString.getMnemonic());
        Constraints.constrain((Container)((Object)this), (Component)jLabel, (int)0, (int)1, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (int)5, (int)12, (int)0, (int)0);
        this.fileNameField = new JTextField("", 20);
        this.fileNameField.setMinimumSize(this.fileNameField.getPreferredSize());
        jLabel.setLabelFor(this.fileNameField);
        Constraints.constrain((Container)((Object)this), (Component)this.fileNameField, (int)1, (int)1, (int)1, (int)1, (int)0, (int)18, (double)1.0, (double)1.0, (int)5, (int)12, (int)0, (int)0);
        this.fileNameField.getDocument().addDocumentListener(new FileNameFieldListener());
    }

    public void loadHelp() {
        Vector vector = new Vector(2);
        this.infoPanel = this.wiz.getInfoPanel();
        this.overviewHelpListener = new PatchContextHelpListener(this.theApp, vector, this.infoPanel, DOWNLOAD_STEP2b_OVERVIEW);
        PatchContextHelpListener patchContextHelpListener = new PatchContextHelpListener(this.theApp, vector, this.infoPanel, DOWNLOAD_STEP2b_TEXT);
        this.fileNameField.addFocusListener((FocusListener)((Object)patchContextHelpListener));
        ContextHelpListener.loadHelp(vector);
    }

    public void start() {
        super.start();
        this.fileNameField.requestFocus();
        String string = this.wiz.getTextFilename();
        if (string == null || string.length() == 0) {
            this.setProperty("vwp.canmoveforward", "vwp.false");
        } else {
            this.fileNameField.setText(string);
            this.setProperty("vwp.canmoveforward", "vwp.true");
        }
        this.setProperty("vwp.canmovebackward", "vwp.true");
        this.setProperty("vwp.finishstate", "vwp.false");
        this.infoPanel.setFocusListener((FocusListener)((Object)this.overviewHelpListener), true);
    }

    public boolean stop(boolean bl) {
        if (!bl) {
            this.fileNameField.setText("");
            return true;
        }
        if (bl) {
            String string = this.fileNameField.getText();
            if (string == null || string.length() == 0) {
                new ErrorDialog(null, ResourceStrings.getString((ResourceBundle)this.bundle, (String)"dl_wiz_bad_filename"));
                return false;
            }
            FileParser fileParser = new FileParser();
            Vector vector = null;
            try {
                vector = fileParser.parsePatchFile(this.theApp, string);
            }
            catch (PatchException patchException) {
                new ErrorDialog(null, patchException.getLocalizedMessage());
                return false;
            }
            if (vector == null || vector.size() == 0) {
                new ErrorDialog(null, ResourceStrings.getString((ResourceBundle)this.bundle, (String)"dl_wiz_bad_file"));
                return false;
            }
            this.wiz.setTextFilename(string);
            this.wiz.setPatchIDList(vector);
            this.getManager().setNext(this.getManager().getCurrent(), "downloaddircard");
        }
        return true;
    }

    public boolean isSubStep() {
        return false;
    }

    public void reset() {
    }

    class FileNameFieldListener
    implements DocumentListener {
        FileNameFieldListener() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            String string = DownloadTextCard.this.fileNameField.getText();
            if (string != null && string.length() > 0) {
                DownloadTextCard.this.setProperty("vwp.canmoveforward", "vwp.true");
            } else {
                DownloadTextCard.this.setProperty("vwp.canmoveforward", "vwp.false");
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.insertUpdate(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.insertUpdate(documentEvent);
        }
    }
}

