/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client.wizards.cards;

import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.volmgr.client.ttk.RowLayout;
import com.sun.admin.volmgr.client.ttk.Spinner;
import com.sun.admin.volmgr.client.ttk.text.LongSpinnerModel;
import com.sun.admin.volmgr.client.ttk.text.SpinnerDataModel;
import com.sun.admin.volmgr.client.util.Util;
import com.sun.admin.volmgr.client.wizards.cards.SimpleVWizardCard;
import com.sun.admin.volmgr.client.wizards.command.VolumeCommandFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class MirrorResyncBufferSizeCard
extends SimpleVWizardCard {
    private static String TITLE = "MirrorResyncBufferSizeCard_title";
    private static final String HELPFILE = "MirrorResyncBufferSizeCard.html";
    private static String HEADER = "MirrorResyncBufferSizeCard_header";
    private Spinner spinner;
    private VolumeCommandFactory factory;

    public MirrorResyncBufferSizeCard(VolumeCommandFactory volumeCommandFactory) {
        super(TITLE, HELPFILE, HEADER);
        this.factory = volumeCommandFactory;
        this.initGUI();
    }

    public long getBufferSize() {
        return this.factory.getBufferSize();
    }

    protected Component getMainPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(15, 15));
        jPanel.add(super.getMainPanel(), "North");
        LongSpinnerModel longSpinnerModel = new LongSpinnerModel(128L, 2048L);
        this.spinner = new Spinner(Long.toString(128L), (SpinnerDataModel)longSpinnerModel);
        JTextField jTextField = this.spinner.getTextField();
        jTextField.setColumns(4);
        JLabel jLabel = new JLabel();
        Util.initLabel(jLabel, "MirrorResyncBufferSizeCard_size_label", jTextField);
        JPanel jPanel2 = new JPanel(new RowLayout(RowLayout.LEFT));
        jPanel2.add((Component)jLabel, RowLayout.VCENTER);
        jPanel2.add((Component)this.spinner, RowLayout.VCENTER);
        jPanel.add((Component)jPanel2, "Center");
        return jPanel;
    }

    public void refresh() {
        this.spinner.getTextField().setText(Long.toString(this.getBufferSize()));
    }

    public boolean stop(boolean bl) {
        if (bl) {
            String string = this.spinner.getTextField().getText();
            try {
                long l = Long.parseLong(string);
                if (l < 128L || l > 2048L) {
                    throw new NumberFormatException();
                }
                this.factory.setBufferSize(l);
            }
            catch (NumberFormatException numberFormatException) {
                Object[] objectArray = new Object[]{string, Long.toString(128L), Long.toString(2048L)};
                String string2 = Util.getResourceString("MirrorResyncBufferSizeCard_error", objectArray);
                new ErrorDialog(null, string2);
                return false;
            }
        }
        return true;
    }
}

