/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client.wizards.cards;

import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.FlowArea;
import com.sun.admin.volmgr.client.util.HelpCache;
import com.sun.admin.volmgr.client.util.Util;
import com.sun.admin.volmgr.client.wizards.command.HSPCommandFactory;
import com.sun.admin.volmgr.client.wizards.command.VolumeCommandFactory;
import com.sun.admin.volmgr.common.Device;
import com.sun.management.viper.console.gui.wizard.VWizardCard;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class HSPCard
extends VWizardCard {
    private VolumeCommandFactory vwFactory;
    private HSPCommandFactory hspwFactory;
    private JComboBox hspCombo;

    public HSPCard(VolumeCommandFactory volumeCommandFactory, HSPCommandFactory hSPCommandFactory) {
        this.vwFactory = volumeCommandFactory;
        this.hspwFactory = hSPCommandFactory;
        this.setTitle(Util.getResourceString("add_wiz_hsp_title"));
        this.setHelpHTML(HelpCache.getHelpText("HSPCard.html"));
        this.setLayout(new GridBagLayout());
        FlowArea flowArea = new FlowArea(Util.getResourceString("add_wiz_hsp_header"));
        Constraints.constrain((Container)((Object)this), (Component)flowArea, (int)0, (int)0, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)5, (int)5, (int)5, (int)5);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        Constraints.constrain((Container)((Object)this), (Component)jPanel, (int)0, (int)1, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
        JLabel jLabel = new JLabel();
        Constraints.constrain((Container)jPanel, (Component)jLabel, (int)0, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)0, (int)10, (int)0, (int)10);
        this.hspCombo = new JComboBox();
        Util.initLabel(jLabel, "add_wiz_hsp_label", this.hspCombo);
        Constraints.constrain((Container)jPanel, (Component)this.hspCombo, (int)1, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)0, (int)10, (int)0, (int)10);
    }

    public void refresh() {
        String[] stringArray;
        String string = this.vwFactory.getDiskSetName();
        Vector vector = Util.getApp().getServiceWrapper().getDevices("Hsp");
        int n = vector.size() - 1;
        while (n >= 0) {
            stringArray = (String[])vector.get(n);
            String string2 = Util.getDiskSetName((Device)stringArray);
            if (string == null && string2 != null || string != null && !string.equals(string2)) {
                vector.remove(n);
            }
            --n;
        }
        stringArray = this.hspwFactory.getDeviceName() != null ? new String[vector.size() + 1] : new String[vector.size()];
        int n2 = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Device device = (Device)enumeration.nextElement();
            stringArray[n2++] = Util.getDeviceFullName(device);
        }
        if (this.hspwFactory.getDeviceName() != null) {
            stringArray[vector.size()] = new String(this.hspwFactory.getDeviceName());
        }
        this.hspCombo.setModel(new DefaultComboBoxModel<String>(stringArray));
        if (this.vwFactory.getHSPName() != null) {
            this.hspCombo.setSelectedItem(this.vwFactory.getHSPName());
        } else if (this.hspwFactory.getDeviceName() != null) {
            this.hspCombo.setSelectedItem(this.hspwFactory.getDeviceName());
        } else {
            try {
                this.hspCombo.setSelectedIndex(0);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public void start() {
        this.setProperty("vwp.canmoveforward", "vwp.true");
        this.setProperty("vwp.canmovebackward", "vwp.true");
        this.setProperty("vwp.finishstate", "vwp.false");
        this.refresh();
    }

    public boolean stop(boolean bl) {
        this.vwFactory.setHSPName((String)this.hspCombo.getSelectedItem());
        return true;
    }

    public void reset() {
    }

    public boolean isSubStep() {
        return true;
    }
}

