/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client.volumes;

import com.sun.admin.volmgr.client.GeneralPropertySheet;
import com.sun.admin.volmgr.client.util.Util;
import com.sun.admin.volmgr.client.volumes.VolumeGeneralPropertySheet;
import com.sun.admin.volmgr.common.Device;
import javax.swing.JLabel;

public class RAIDGeneralPropertySheet
extends VolumeGeneralPropertySheet {
    private static final String HELPFILE = "RAIDGeneralPropertySheet.html";
    private JLabel interlaceValue;
    private JLabel progressValue;

    public RAIDGeneralPropertySheet(Device device) {
        super(device, HELPFILE);
        this.initGUI();
    }

    public String getDeviceInterlace() {
        Long l = (Long)this.getDevice().getProperty("interlace");
        if (l == null) {
            return "0";
        }
        return l.toString();
    }

    public String getDeviceProgress() {
        Device device = this.getDevice();
        Integer n = (Integer)device.getProperty("percent done");
        return Util.formatProperty(device, "percent done");
    }

    protected GeneralPropertySheet.LabeledComponent[] getLabeledComponents() {
        GeneralPropertySheet.LabeledComponent[] labeledComponentArray = super.getLabeledComponents();
        this.interlaceValue = new JLabel();
        this.progressValue = new JLabel();
        int n = labeledComponentArray.length;
        GeneralPropertySheet.LabeledComponent[] labeledComponentArray2 = new GeneralPropertySheet.LabeledComponent[n + 2];
        System.arraycopy(labeledComponentArray, 0, labeledComponentArray2, 0, n);
        labeledComponentArray2[n] = new GeneralPropertySheet.LabeledComponent("interlace_prop", this.interlaceValue);
        labeledComponentArray2[n + 1] = new GeneralPropertySheet.LabeledComponent("percent_done_prop", this.progressValue);
        return labeledComponentArray2;
    }

    protected void refresh() {
        super.refresh();
        this.interlaceValue.setText(this.getDeviceInterlace());
        this.progressValue.setText(this.getDeviceProgress());
    }
}

