/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client.volumes;

import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.WarningDialog;
import com.sun.admin.volmgr.client.DeviceTableModel;
import com.sun.admin.volmgr.client.DeviceTablePropertySheet;
import com.sun.admin.volmgr.client.util.GUIUtil;
import com.sun.admin.volmgr.client.util.Util;
import com.sun.admin.volmgr.client.volumes.ConfVolumePanel;
import com.sun.admin.volmgr.client.wizards.AttachConcatComponentWizard;
import com.sun.admin.volmgr.client.wizards.ReplaceStripeComponentWizard;
import com.sun.admin.volmgr.common.Device;
import com.sun.management.viper.console.gui.VFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;

public class ConcatStripeDeviceTablePropertySheet
extends DeviceTablePropertySheet {
    private static final String TITLE = "components_props_tab";
    private static final String HELPFILE = "ConcatStripeDeviceTablePropertySheet.html";
    private Device device;
    private String disksetFlag;
    private boolean isSubmirror;
    private JButton replaceButton;
    private JButton enableButton;

    public ConcatStripeDeviceTablePropertySheet(Device device) {
        super(TITLE, HELPFILE);
        this.device = device;
        this.isSubmirror = this.isSubmirror();
        this.initGUI();
    }

    protected synchronized String getDiskSetFlag() {
        if (this.disksetFlag == null) {
            this.disksetFlag = Util.getDiskSetFlag(this.device);
        }
        return this.disksetFlag;
    }

    private boolean isSubmirror() {
        Vector vector = Util.getApp().getServiceWrapper().getDependents(this.device, "BasedOn");
        int n = 0;
        int n2 = vector.size();
        while (n < n2) {
            Device device = (Device)vector.get(n);
            Object object = device.getProperty("type");
            if ("Mirror".equals(object)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private Device getMirrorFromSubmirror() {
        Vector vector = Util.getApp().getServiceWrapper().getDependents(this.device, "BasedOn");
        int n = 0;
        int n2 = vector.size();
        while (n < n2) {
            Device device = (Device)vector.get(n);
            Object object = device.getProperty("type");
            if ("Mirror".equals(object)) {
                return device;
            }
            ++n;
        }
        return null;
    }

    private void setButtonState() {
        int[] nArray;
        boolean bl = false;
        if (this.isSubmirror && Util.getApp().getServiceWrapper().hasVolMgrWriteAuth() && (nArray = this.table.getSelectedRows()).length > 0) {
            bl = true;
            int n = 0;
            while (n < nArray.length) {
                Device device = (Device)this.model.getRow(nArray[n]);
                Object object = device.getProperty("type");
                if (!"Slice".equals(object)) {
                    bl = false;
                    break;
                }
                ++n;
            }
        }
        this.replaceButton.setEnabled(bl);
        this.enableButton.setEnabled(bl);
    }

    private void attachComp() {
        new Thread(){

            public void run() {
                VFrame vFrame = new VFrame();
                Util.makeModal(GUIUtil.getParentJFrame((Component)((Object)ConcatStripeDeviceTablePropertySheet.this)), (Window)vFrame, true);
                AttachConcatComponentWizard attachConcatComponentWizard = new AttachConcatComponentWizard(ConcatStripeDeviceTablePropertySheet.this.device);
                attachConcatComponentWizard.init();
                attachConcatComponentWizard.setContainer((Component)vFrame);
                vFrame.showCenter((Component)GUIUtil.getAppFrame());
                attachConcatComponentWizard.start();
            }
        }.start();
    }

    private void replaceComp(final Device device) {
        new Thread(){

            public void run() {
                VFrame vFrame = new VFrame();
                Util.makeModal(GUIUtil.getParentJFrame((Component)((Object)ConcatStripeDeviceTablePropertySheet.this)), (Window)vFrame, true);
                Device device3 = ConcatStripeDeviceTablePropertySheet.this.device;
                Device device2 = ConcatStripeDeviceTablePropertySheet.this.getMirrorFromSubmirror();
                if (device2 == null) {
                    new ErrorDialog(null, Util.getResourceString("mirror_not_found_error", device3));
                    return;
                }
                device3 = device2;
                ReplaceStripeComponentWizard replaceStripeComponentWizard = new ReplaceStripeComponentWizard(device3, device);
                replaceStripeComponentWizard.init();
                replaceStripeComponentWizard.setContainer((Component)vFrame);
                vFrame.showCenter((Component)GUIUtil.getAppFrame());
                replaceStripeComponentWizard.start();
            }
        }.start();
    }

    private void enableComp() {
        String string;
        Object object;
        int[] nArray = this.table.getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        Device device = this.device;
        Device device2 = this.getMirrorFromSubmirror();
        if (device2 == null) {
            new ErrorDialog(null, Util.getResourceString("mirror_not_found_error", device));
            return;
        }
        device = device2;
        String string2 = Util.getDeviceBaseName(device);
        String[] stringArray = new String[nArray.length];
        String[] stringArray2 = new String[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            object = (Device)this.model.getRow(nArray[n]);
            string = Util.getDeviceBaseName((Device)object);
            stringArray[n] = Util.getResourceString("stripe_enable_comp_cmd", string);
            stringArray2[n] = Util.getBasedir() + "usr/sbin/metareplace" + this.getDiskSetFlag() + " -e " + string2 + " " + string;
            ++n;
        }
        object = Util.getConfirmListener(stringArray, stringArray2);
        string = Util.getResourceString("sure_enable_stripe_comp");
        ConfVolumePanel confVolumePanel = new ConfVolumePanel(stringArray2, string);
        String string3 = new String(Util.getResourceString("warning_enable_stripe_comp"));
        WarningDialog warningDialog = new WarningDialog(GUIUtil.getParentJFrame((Component)((Object)this)), string3, (JPanel)confVolumePanel, (ActionListener)object, Util.getResourceString("warning_enable"));
    }

    protected Device[] getDevices() {
        return Util.getComponentsOf(this.device);
    }

    public void tableSelectionChanged(ListSelectionEvent listSelectionEvent) {
        this.setButtonState();
    }

    protected Component getMainPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(super.getMainPanel(), "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(2));
        JButton jButton = null;
        if (!Util.isInnerStripe(this.device)) {
            jButton = new JButton();
            if (!Util.getApp().getServiceWrapper().hasVolMgrWriteAuth()) {
                jButton.setEnabled(false);
            } else {
                jButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ConcatStripeDeviceTablePropertySheet.this.attachComp();
                    }
                });
            }
            Util.initButton(jButton, "attach_stripe");
            jPanel2.add(jButton);
        }
        final JTable jTable = this.table;
        final DeviceTableModel deviceTableModel = this.model;
        this.replaceButton = new JButton();
        this.enableButton = new JButton();
        if (this.isSubmirror) {
            this.replaceButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int[] nArray = jTable.getSelectedRows();
                    Device device = (Device)deviceTableModel.getRow(nArray[0]);
                    ConcatStripeDeviceTablePropertySheet.this.replaceComp(device);
                }
            });
            Util.initButton(this.replaceButton, "replace_component");
            jPanel2.add(this.replaceButton);
            this.enableButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ConcatStripeDeviceTablePropertySheet.this.enableComp();
                }
            });
            Util.initButton(this.enableButton, "enable_component");
            jPanel2.add(this.enableButton);
        }
        jPanel.add((Component)jPanel2, "South");
        return jPanel;
    }

    protected void refresh() {
        super.refresh();
        this.setButtonState();
    }
}

