/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client.ttk;

import com.sun.admin.volmgr.client.ttk.table.RowMoveable;
import com.sun.admin.volmgr.client.ttk.table.TableRowUtil;
import com.sun.admin.volmgr.client.ttk.util.GUIUtility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class TableSelector
extends JPanel {
    private static final int SCROLLPANEHEIGHT = 125;
    private JTable inTable;
    private JTable outTable;
    private JScrollPane inTableScrollPane;
    private JScrollPane outTableScrollPane;
    private JLabel inLabel;
    private JLabel outLabel;
    private JButton moveUpButton;
    private JButton moveDownButton;
    private JButton moveAllUpButton;
    private JButton moveAllDownButton;
    private RowMoveable moveable;

    public TableSelector(JTable jTable, JTable jTable2, RowMoveable rowMoveable) {
        this.inTable = jTable;
        this.outTable = jTable2;
        this.moveable = rowMoveable;
        this.init();
    }

    public JTable getInTable() {
        return this.inTable;
    }

    public JTable getOutTable() {
        return this.outTable;
    }

    public JScrollPane getInTableScrollPane() {
        return this.inTableScrollPane;
    }

    public JScrollPane getOutTableScrollPane() {
        return this.outTableScrollPane;
    }

    public JLabel getInLabel() {
        return this.inLabel;
    }

    public JLabel getOutLabel() {
        return this.outLabel;
    }

    public JButton getMoveUpButton() {
        return this.moveUpButton;
    }

    public JButton getMoveDownButton() {
        return this.moveDownButton;
    }

    public JButton getMoveAllUpButton() {
        return this.moveAllUpButton;
    }

    public JButton getMoveAllDownButton() {
        return this.moveAllDownButton;
    }

    public RowMoveable getRowMoveable() {
        return this.moveable;
    }

    private void init() {
        this.inTableScrollPane = new JScrollPane(this.inTable);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(this.inTable.getBackground());
        jPanel.add(this.inTableScrollPane);
        this.inTableScrollPane.getViewport().setBackground(this.inTable.getBackground());
        Dimension dimension = this.inTableScrollPane.getPreferredSize();
        this.inTableScrollPane.setPreferredSize(new Dimension(dimension.width, 125));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        this.inLabel = new JLabel();
        jPanel2.add((Component)this.inLabel, "North");
        jPanel2.add((Component)jPanel, "Center");
        RowMoveable rowMoveable = this.getRowMoveable();
        this.moveDownButton = TableRowUtil.createMoveDownButton(this.inTable, rowMoveable, false, false);
        this.moveDownButton.setEnabled(this.inTable.getSelectedRow() != -1);
        this.moveAllDownButton = TableRowUtil.createMoveAllDownButton(this.inTable, rowMoveable);
        this.moveAllDownButton.setEnabled(this.inTable.getRowCount() != 0);
        this.moveUpButton = TableRowUtil.createMoveUpButton(this.outTable, rowMoveable, false, false);
        this.moveUpButton.setEnabled(this.outTable.getSelectedRow() != -1);
        this.moveAllUpButton = TableRowUtil.createMoveAllUpButton(this.outTable, rowMoveable);
        this.moveAllUpButton.setEnabled(this.outTable.getRowCount() != 0);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(GUIUtility.getGridLayout(1, 4));
        jPanel3.add(this.moveDownButton);
        jPanel3.add(this.moveAllDownButton);
        jPanel3.add(this.moveUpButton);
        jPanel3.add(this.moveAllUpButton);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout());
        jPanel4.add(jPanel3);
        this.outTableScrollPane = new JScrollPane(this.outTable);
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.setBackground(this.outTable.getBackground());
        jPanel5.add(this.outTableScrollPane);
        this.outTableScrollPane.getViewport().setBackground(this.outTable.getBackground());
        dimension = this.outTableScrollPane.getPreferredSize();
        this.outTableScrollPane.setPreferredSize(new Dimension(dimension.width, 125));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout());
        this.outLabel = new JLabel();
        jPanel6.add((Component)this.outLabel, "North");
        jPanel6.add((Component)jPanel5, "Center");
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        TableSelector.resetConstraints(gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        this.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        this.add((Component)jPanel4, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets.bottom = 0;
        this.add((Component)jPanel6, gridBagConstraints);
    }

    private static void resetConstraints(GridBagConstraints gridBagConstraints) {
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.insets.bottom = 15;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
    }

    public static void main(String[] stringArray) {
        JTable jTable = new JTable(new DefaultTableModel(10, 4));
        JTable jTable2 = new JTable(new DefaultTableModel(10, 4));
        JFrame jFrame = new JFrame();
        Container container = jFrame.getContentPane();
        container.setLayout(new BorderLayout());
        RowMoveable rowMoveable = new RowMoveable(){

            public boolean moveRowsDown(int n, int n2) {
                return true;
            }

            public boolean moveRowsUp(int n, int n2) {
                return true;
            }

            public boolean moveRowsTo(int n, int n2, int n3) {
                return false;
            }

            public boolean canMoveRowsDown(int n, int n2) {
                return true;
            }

            public boolean canMoveRowsUp(int n, int n2) {
                return true;
            }

            public boolean canMoveRowsTo(int n, int n2, int n3) {
                return false;
            }
        };
        TableSelector tableSelector = new TableSelector(jTable, jTable2, rowMoveable);
        tableSelector.getInLabel().setText("Top");
        tableSelector.getOutLabel().setText("Bottom");
        tableSelector.getMoveAllUpButton().setText("Move All Up");
        tableSelector.getMoveUpButton().setText("Move Up");
        tableSelector.getMoveDownButton().setText("Move Down");
        tableSelector.getMoveAllDownButton().setText("Move All Down");
        tableSelector.setBorder(GUIUtility.emptyBorder);
        container.add(tableSelector);
        jFrame.pack();
        jFrame.show();
    }
}

