/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client.disksets;

import com.sun.admin.cis.common.WarningDialog;
import com.sun.admin.volmgr.client.DeviceTablePropertySheet;
import com.sun.admin.volmgr.client.disksets.ConfDiskSetPanel;
import com.sun.admin.volmgr.client.util.GUIUtil;
import com.sun.admin.volmgr.client.util.Util;
import com.sun.admin.volmgr.client.wizards.AddDiskSetDiskWizard;
import com.sun.admin.volmgr.common.Device;
import com.sun.management.viper.console.gui.VFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;

public class DiskSetDiskTablePropertySheet
extends DeviceTablePropertySheet {
    private static final String TITLE = "disks_props_tab";
    private static final String HELPFILE = "DiskSetDiskTablePropertySheet.html";
    private Device device;
    private JButton addButton;
    private JButton deleteButton;

    public DiskSetDiskTablePropertySheet(Device device) {
        super(TITLE, HELPFILE);
        this.device = device;
        this.initGUI();
    }

    private void setButtonState() {
        boolean bl = false;
        boolean bl2 = false;
        if (Util.getApp().getServiceWrapper().hasVolMgrWriteAuth() && Util.serverOwnsDiskSet(this.device)) {
            bl = true;
            if (this.table.getSelectedRows().length > 0) {
                bl2 = true;
            }
        }
        this.addButton.setEnabled(bl);
        this.deleteButton.setEnabled(bl2);
    }

    private void deleteDisks() {
        String string;
        Object object;
        int[] nArray = this.table.getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        String string2 = Util.getDeviceBaseName(this.device);
        String[] stringArray = new String[nArray.length];
        String[] stringArray2 = new String[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            object = (Device)this.model.getRow(nArray[n]);
            string = Util.getDeviceBaseName((Device)object);
            stringArray[n] = Util.getResourceString("diskset_delete_disk_cmd", string);
            stringArray2[n] = Util.getBasedir() + "usr/sbin/metaset -s " + string2 + " -d -f " + string;
            ++n;
        }
        object = Util.getConfirmListener(stringArray, stringArray2);
        string = Util.getResourceString("sure_delete_diskset_disk");
        ConfDiskSetPanel confDiskSetPanel = new ConfDiskSetPanel(stringArray2, string);
        String string3 = new String(Util.getResourceString("warning_delete_diskset_disk"));
        WarningDialog warningDialog = new WarningDialog(GUIUtil.getParentJFrame((Component)((Object)this)), string3, (JPanel)confDiskSetPanel, (ActionListener)object, Util.getResourceString("warning_delete"));
    }

    private void addDisks() {
        new Thread(){

            public void run() {
                VFrame vFrame = new VFrame();
                Util.makeModal(GUIUtil.getParentJFrame((Component)((Object)DiskSetDiskTablePropertySheet.this)), (Window)vFrame, true);
                AddDiskSetDiskWizard addDiskSetDiskWizard = new AddDiskSetDiskWizard(DiskSetDiskTablePropertySheet.this.device);
                addDiskSetDiskWizard.init();
                addDiskSetDiskWizard.setContainer((Component)vFrame);
                vFrame.showCenter((Component)GUIUtil.getAppFrame());
                addDiskSetDiskWizard.start();
            }
        }.start();
    }

    protected Device[] getDevices() {
        return Util.getComponentsOf(this.device);
    }

    public void tableSelectionChanged(ListSelectionEvent listSelectionEvent) {
        this.setButtonState();
    }

    protected Component getMainPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        this.addButton = new JButton();
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DiskSetDiskTablePropertySheet.this.addDisks();
            }
        });
        Util.initButton(this.addButton, "add_disk");
        jPanel.add(this.addButton);
        this.deleteButton = new JButton();
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DiskSetDiskTablePropertySheet.this.deleteDisks();
            }
        });
        Util.initButton(this.deleteButton, "delete_disk");
        jPanel.add(this.deleteButton);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add(super.getMainPanel(), "Center");
        jPanel2.add((Component)jPanel, "South");
        return jPanel2;
    }

    protected void refresh() {
        super.refresh();
        this.setButtonState();
    }
}

