/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client;

import com.sun.admin.volmgr.client.Content;
import com.sun.admin.volmgr.client.ttk.util.RequestMonitor;
import com.sun.admin.volmgr.client.util.Util;
import com.sun.admin.volmgr.server.SVMEvent;
import com.sun.management.viper.ToolInfrastructure;
import com.sun.management.viper.VException;
import com.sun.management.viper.VMessage;
import com.sun.management.viper.services.Message;
import com.sun.management.viper.services.MessageException;
import com.sun.management.viper.services.MessageListener;
import com.sun.management.viper.services.MessagePushAgent;
import com.sun.management.viper.services.ServiceList;
import java.rmi.RemoteException;

public class VolMgrRefreshListener
implements MessageListener {
    private static final long SEQUENTIAL_REQUEST_DELAY = 5000L;
    private MessagePushAgent agent;
    private RequestMonitor monitor;
    private String channel;

    public VolMgrRefreshListener(ToolInfrastructure toolInfrastructure, String string) throws VException, RemoteException, MessageException {
        this.setChannel(string);
        Message message = (Message)toolInfrastructure.getServiceByName(ServiceList.MESSAGE);
        this.agent = message.getMessagePushAgent();
        this.agent.init(toolInfrastructure);
        this.agent.subscribe(string, (MessageListener)this);
        Runnable runnable = new Runnable(){

            public void run() {
                Content content = Util.getApp().getTree().getCurrentContent();
                content.refresh(false);
            }
        };
        this.monitor = new RequestMonitor(runnable, 5000L);
        this.monitor.start();
    }

    private void setChannel(String string) {
        this.channel = string;
    }

    public String getChannel() {
        return this.channel;
    }

    private boolean isEventRefreshWorthy(SVMEvent sVMEvent) {
        boolean bl = false;
        int n = sVMEvent.getEventType();
        switch (n) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 40: 
            case 42: {
                bl = true;
            }
        }
        return bl;
    }

    public void sendMessage(VMessage vMessage) throws MessageException {
    }

    public int getMode() {
        return 0;
    }

    public void handleMessage(VMessage vMessage) throws MessageException {
        try {
            SVMEvent sVMEvent = (SVMEvent)vMessage.getMessage();
            if (this.isEventRefreshWorthy(sVMEvent)) {
                this.monitor.requestAction();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }
}

