/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.ListProperties;
import com.sun.admin.cis.common.ProgressPanel;
import com.sun.admin.volmgr.client.ContentEvent;
import com.sun.admin.volmgr.client.ContentListener;
import com.sun.admin.volmgr.client.VVolMgr;
import com.sun.admin.volmgr.client.VolActionsListener;
import com.sun.admin.volmgr.client.util.GUIUtil;
import com.sun.admin.volmgr.client.util.Util;
import com.sun.admin.volmgr.client.wizards.CreateDiskSetWizard;
import com.sun.admin.volmgr.client.wizards.CreateHSPWizard;
import com.sun.admin.volmgr.client.wizards.CreateReplicasWizard;
import com.sun.admin.volmgr.client.wizards.CreateVolumeWizard;
import com.sun.admin.volmgr.common.Device;
import com.sun.admin.volmgr.common.DeviceFilter;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.console.gui.VAboutBox;
import com.sun.management.viper.console.gui.VContainer;
import com.sun.management.viper.console.gui.VFilter;
import com.sun.management.viper.console.gui.VFrame;
import com.sun.management.viper.util.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.tree.MutableTreeNode;

public abstract class Content {
    protected ListProperties listProperties;
    protected boolean bShowAll = true;
    private static Vector instances = new Vector();
    private Vector listeners = new Vector();
    protected boolean bRefresh = false;
    protected VScopeNode treeNode = null;
    protected VScopeNode rootNode = null;
    protected Vector vDataCache = new Vector();
    protected VVolMgr app = Util.getApp();
    protected String sortPreferencesKey;
    protected static boolean shownWarning = false;

    protected abstract String[][] getColumnHeaders();

    public Content() {
        instances.addElement(this);
    }

    public void find() {
        VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this.app, "vconsole.showfindcontrol", null);
        this.app.fireConsoleAction(vConsoleEvent);
    }

    public Vector getSelected() {
        return this.app.getDisplayModel().getSelectedNodes();
    }

    public void setSelected(Vector vector) {
        this.app.getDisplayModel().setSelectedNodes(vector);
        this.onSelection(vector);
    }

    public void onSelection(Vector vector) {
        this.fireItemPressed(vector.size());
    }

    public int getNumSelections() {
        return this.app.getDisplayModel().getSelectedNodes().size();
    }

    public void clearSelection() {
        this.app.getDisplayModel().clearSelection();
        this.fireItemPressed(0);
    }

    protected String[][] constructColumnHeaders(Object[][] objectArray) {
        int n = objectArray.length;
        String[][] stringArray = new String[n][3];
        JLabel jLabel = new JLabel();
        jLabel.setFont(ResourceManager.labelFont);
        FontMetrics fontMetrics = jLabel.getFontMetrics(ResourceManager.labelFont);
        jLabel.setFont(ResourceManager.bodyFont);
        FontMetrics fontMetrics2 = jLabel.getFontMetrics(ResourceManager.labelFont);
        int n2 = 0;
        while (n2 < n) {
            String string = (String)objectArray[n2][0];
            stringArray[n2][0] = Util.getResourceString(string);
            int n3 = fontMetrics.stringWidth(stringArray[n2][0]);
            n3 += fontMetrics.stringWidth("AAAA");
            int n4 = (Integer)objectArray[n2][1];
            int n5 = 0;
            if (n4 > 20000) {
                n5 = 20000;
            } else if (n4 > 10000) {
                n5 = 10000;
            }
            int n6 = fontMetrics2.stringWidth("A");
            n6 *= (n4 -= n5);
            stringArray[n2][1] = new String(String.valueOf(Math.max(n3, n6 += n5)));
            ++n2;
        }
        return stringArray;
    }

    public void refresh(final boolean bl) {
        new Thread(){

            public void run() {
                GUIUtil.waitOn();
                Content.this.vDataCache.clear();
                System.gc();
                Content.this.clear(false);
                Content.this.app.setStatusBar("");
                ProgressPanel progressPanel = new ProgressPanel(GUIUtil.getAppFrame(), 2, 30);
                progressPanel.setTitle(Util.getResourceString("device_refresh_progress_title"));
                progressPanel.setText(Util.getResourceString("device_refresh_reading_config"));
                progressPanel.setVisible(true);
                if (bl) {
                    Util.getApp().getServiceWrapper().flushDeviceCache();
                }
                Device[] deviceArray = Content.this.getDevices();
                progressPanel.dispose();
                Content.this.appendToResultsPane(deviceArray);
                Content.this.updateStatusBar();
                Content.this.showFilteredStatus();
                Content.this.checkForUnownedDiskSets();
                Content.this.bRefresh = true;
                GUIUtil.waitOff();
            }
        }.start();
    }

    protected void checkForUnownedDiskSets() {
        if (!shownWarning && !Util.serverOwnsAllDiskSets()) {
            new ErrorDialog(null, Util.getResourceString("dialog_title_warning"), Util.getResourceString("unowned_disksets_warning_message"));
            shownWarning = true;
        }
    }

    public abstract void appendToResultsPane(Device[] var1);

    protected abstract Hashtable getColumnValues(Device var1);

    public void repaintColumns() {
        Thread thread = new Thread(){

            public void run() {
                VScopeNode vScopeNode;
                GUIUtil.waitOn();
                int n = 0;
                while (n < Content.this.rootNode.getChildCount()) {
                    vScopeNode = (VScopeNode)Content.this.rootNode.getChildAt(n);
                    Device device = (Device)vScopeNode.getPayload();
                    vScopeNode.setColumnValues(Content.this.getColumnValues(device));
                    ++n;
                }
                vScopeNode = new VConsoleEvent((Object)Content.this.app, "vconsole.repaint", null);
                Content.this.app.fireConsoleAction((VConsoleEvent)vScopeNode);
                GUIUtil.waitOff();
            }
        };
        thread.start();
    }

    public abstract Device[] getDevices();

    public void viewProperties() {
        Vector vector = this.getSelected();
        if (vector.isEmpty()) {
            return;
        }
        Vector vector2 = this.getSelected();
        VScopeNode vScopeNode = (VScopeNode)vector2.elementAt(0);
        Device device = (Device)vScopeNode.getPayload();
        Util.viewProperties(device);
    }

    public void setPerformanceViewSelected(boolean bl) {
    }

    public void setPerformanceViewMode(int n) {
    }

    public void addDiskSet() {
        Thread thread = new Thread(){

            public void run() {
                GUIUtil.waitOn();
                VFrame vFrame = new VFrame();
                CreateDiskSetWizard createDiskSetWizard = new CreateDiskSetWizard();
                createDiskSetWizard.init();
                createDiskSetWizard.setContainer((Component)vFrame);
                vFrame.showCenter((Component)GUIUtil.getAppFrame());
                createDiskSetWizard.start();
                GUIUtil.waitOff();
            }
        };
        thread.start();
    }

    public void addReplica() {
        Thread thread = new Thread(){

            public void run() {
                GUIUtil.waitOn();
                VFrame vFrame = new VFrame();
                CreateReplicasWizard createReplicasWizard = new CreateReplicasWizard();
                createReplicasWizard.init();
                createReplicasWizard.setContainer((Component)vFrame);
                vFrame.showCenter((Component)GUIUtil.getAppFrame());
                createReplicasWizard.start();
                GUIUtil.waitOff();
            }
        };
        thread.start();
    }

    public void addHSP() {
        int n = Util.getNextAvailableHSPNumber("");
        if (n == -1) {
            new ErrorDialog(null, Util.getResourceString("no_hsps_available_error_title"), Util.getResourceString("no_hsps_available_error_msg"));
            return;
        }
        Thread thread = new Thread(){

            public void run() {
                GUIUtil.waitOn();
                VFrame vFrame = new VFrame();
                CreateHSPWizard createHSPWizard = new CreateHSPWizard();
                createHSPWizard.init();
                createHSPWizard.setContainer((Component)vFrame);
                vFrame.showCenter((Component)GUIUtil.getAppFrame());
                createHSPWizard.start();
                GUIUtil.waitOff();
            }
        };
        thread.start();
    }

    public void addVolume() {
        int n = Util.getNextAvailableVolumeNumber("");
        if (n == -1) {
            new ErrorDialog(null, Util.getResourceString("no_volumes_available_error_title"), Util.getResourceString("no_volumes_available_error_msg"));
            return;
        }
        Thread thread = new Thread(){

            public void run() {
                GUIUtil.waitOn();
                VFrame vFrame = new VFrame();
                CreateVolumeWizard createVolumeWizard = new CreateVolumeWizard();
                createVolumeWizard.init();
                createVolumeWizard.setContainer((Component)vFrame);
                vFrame.showCenter((Component)GUIUtil.getAppFrame());
                createVolumeWizard.start();
                GUIUtil.waitOff();
            }
        };
        thread.start();
    }

    public void showCommands() {
        this.app.fireConsoleAction(new VConsoleEvent((Object)this.app, "vconsole.showcommandlog", null));
    }

    public void deleteSelected() {
    }

    public void removeFromResultsPane(Device device) {
        int n = 0;
        while (n < this.rootNode.getChildCount()) {
            VScopeNode vScopeNode = (VScopeNode)this.rootNode.getChildAt(n);
            Device device2 = (Device)vScopeNode.getPayload();
            if (device2 == device) {
                this.rootNode.remove((MutableTreeNode)vScopeNode);
                VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this.app, "vconsole.updatescope", (Object)this.treeNode);
                this.app.fireConsoleAction(vConsoleEvent);
                break;
            }
            ++n;
        }
    }

    public void onDoubleClick() {
        this.fireItemPressed(2);
        ActionEvent actionEvent = new ActionEvent(this, 1001, "ViewProps");
        VolActionsListener volActionsListener = new VolActionsListener();
        volActionsListener.actionPerformed(actionEvent);
    }

    public void openSelected() {
        Vector vector = this.getSelected();
        if (vector.isEmpty()) {
            return;
        }
        VScopeNode vScopeNode = (VScopeNode)vector.elementAt(0);
        VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this.app, "vconsole.scopeselected", (Object)vScopeNode);
        this.app.fireConsoleAction(vConsoleEvent);
    }

    public void renameSelected() {
    }

    public abstract String whatAmI();

    protected abstract void updateStatusBar();

    public ListProperties getListProperties() {
        return this.listProperties;
    }

    public void setListProperties(ListProperties listProperties) {
        this.listProperties = listProperties;
    }

    public Vector getFilters() {
        if (this.listProperties != null) {
            return this.listProperties.getFilters();
        }
        return null;
    }

    public boolean isFilteringSupported() {
        return false;
    }

    public void showFilteredStatus() {
        Vector vector = this.getFilters();
        this.app.getProperties().setProperty("vconsole.filteredstate", vector == null || vector.size() == 0 ? "false" : "true");
    }

    public VFilter getFilterControl() {
        return null;
    }

    public boolean isShowByTypeSupported() {
        return false;
    }

    public void setDeviceFilters(DeviceFilter[] deviceFilterArray) {
        Vector<DeviceFilter> vector = new Vector<DeviceFilter>(deviceFilterArray.length);
        int n = 0;
        while (n < deviceFilterArray.length) {
            vector.add(deviceFilterArray[n]);
            ++n;
        }
        try {
            if (this.listProperties != null) {
                this.listProperties = new ListProperties();
            }
            this.listProperties.setFilters(vector);
        }
        catch (AdminException adminException) {
            // empty catch block
        }
    }

    public void showByType() {
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.die();
    }

    public void die() {
        instances.removeElement(this);
    }

    public static int getNumInstances() {
        return instances.size();
    }

    public static Content getInstance(int n) {
        if (n < 0 || n >= instances.size()) {
            return null;
        }
        return (Content)instances.elementAt(n);
    }

    public void setTreeNode(VScopeNode vScopeNode) {
        this.treeNode = vScopeNode;
    }

    public VScopeNode getTreeNode() {
        return this.treeNode;
    }

    public VScopeNode getInternalRoot() {
        return this.rootNode;
    }

    public Vector getDataCache() {
        return this.vDataCache;
    }

    public abstract void clear(boolean var1);

    public boolean isRefreshed() {
        return this.bRefresh;
    }

    public boolean getShowAll() {
        return this.bShowAll;
    }

    public void setShowAll(boolean bl) {
        this.bShowAll = bl;
    }

    public synchronized void addContentListener(ContentListener contentListener) {
        if (!this.listeners.contains(contentListener)) {
            this.listeners.addElement(contentListener);
        }
    }

    public synchronized void removeContentListener(ContentListener contentListener) {
        this.listeners.removeElement(contentListener);
    }

    protected void fireItemPressed(int n) {
        ContentEvent contentEvent = new ContentEvent(this, n, null);
        int n2 = 0;
        while (n2 < this.listeners.size()) {
            ContentListener contentListener = (ContentListener)this.listeners.elementAt(n2);
            contentListener.itemPressed(contentEvent);
            ++n2;
        }
    }

    public void updateSortPreferences() {
        VConsoleProperties vConsoleProperties = this.app.getProperties();
        String string = vConsoleProperties.getProperty(this.sortPreferencesKey);
        if (string == null || string.equals("null")) {
            return;
        }
        String string2 = "vconsole.sortup";
        if (string.indexOf(45) >= 0) {
            string2 = "vconsole.sortdown";
        }
        Integer[] integerArray = new Integer[1];
        try {
            int n = Integer.parseInt(string.substring(1));
            integerArray[0] = new Integer(n);
        }
        catch (Exception exception) {
            integerArray[0] = new Integer(0);
        }
        VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)Util.getApp(), string2, (Object)integerArray);
        this.app.fireConsoleAction(vConsoleEvent);
        vConsoleProperties.setProperty("vconsole.sortedcolumn", string);
    }

    public void saveSortPreferences() {
        VConsoleProperties vConsoleProperties = this.app.getProperties();
        vConsoleProperties.setProperty(this.sortPreferencesKey, vConsoleProperties.getProperty("vconsole.sortedcolumn"));
    }

    public void aboutBox() {
        VFrame vFrame = new VFrame();
        VAboutBox vAboutBox = new VAboutBox();
        vAboutBox.setTitle(Util.getResourceString("about_box_banner") + Util.getResourceString("VERSION"));
        String string = Util.getResourceString("CopyrightMsg");
        vAboutBox.setDescription(string);
        Dimension dimension = vAboutBox.getMinimumSize();
        dimension.height = 360;
        vAboutBox.setMinimumSize(dimension);
        vAboutBox.requestDefaultFocus();
        vAboutBox.setContainer((VContainer)vFrame);
        vFrame.setTitle(Util.getResourceString("about_box_title"));
        vFrame.getContentPane().setLayout(new BorderLayout());
        vFrame.getContentPane().add((Component)vAboutBox, "Center");
        vFrame.pack();
        vFrame.showCenter((Component)GUIUtil.getAppFrame());
    }

    public void distributeReplicas() {
    }

    public void releaseOwnership() {
    }

    public void takeOwnership() {
    }

    public void resync() {
    }

    public void makeRoot() {
    }

    public void unMakeRoot() {
    }
}

