/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.server;

import com.sun.admin.volmgr.common.Device;
import com.sun.admin.volmgr.server.SVM;
import com.sun.admin.volmgr.server.SVMEvent;
import com.sun.admin.volmgr.server.SVMEventListener;
import com.sun.admin.volmgr.server.SVMServices;
import java.rmi.RemoteException;
import java.util.Vector;

public class SVMTest {
    private static SVM SVMObject = null;

    public static void main(String[] stringArray) throws RemoteException {
        SVMObject = SVM.instance();
        SVMTest.printAvailableDisks();
        System.out.println();
        SVMTest.printAllDevices();
        if (SVMTest.haveArg(stringArray, "flush")) {
            System.out.println("****** Start Flush   *******");
            SVMObject.updateState(null);
            System.out.println("****** Flush Complete *******");
            SVMTest.printAllDevices();
        }
        if (SVMTest.haveArg(stringArray, "available")) {
            SVMTest.printAvailableDevices(true);
        }
        if (SVMTest.haveArg(stringArray, "attach")) {
            SVMTest.printAvailableDevices(false);
        }
        SVMTest.printAvailableDisks();
        System.out.println();
        if (SVMTest.haveArg(stringArray, "doevents")) {
            System.out.println("Doing Event Monitoring:");
            SVMObject.addEventListener(new SVMEventListener(){

                public void handleSVMEvent(SVMEvent sVMEvent) {
                    System.out.println("\tEvent: " + sVMEvent.toString());
                    SVMTest.printAllDevices();
                }
            });
        } else {
            System.exit(0);
        }
    }

    private static void printAllDevices() {
        try {
            SVMTest.printDevices("Concat");
            System.out.println();
            SVMTest.printDevices("Disk");
            System.out.println();
            SVMTest.printDevices("Diskset");
            System.out.println();
            SVMTest.printDevices("Filesystem");
            System.out.println();
            SVMTest.printDevices("Host");
            System.out.println();
            SVMTest.printDevices("Hsp");
            System.out.println();
            SVMTest.printDevices("Metadb");
            System.out.println();
            SVMTest.printDevices("Mirror");
            System.out.println();
            SVMTest.printDevices("Raid");
            System.out.println();
            SVMTest.printDevices("Slice");
            System.out.println();
            SVMTest.printDevices("Stripe");
            System.out.println();
            SVMTest.printDevices("Extent");
            System.out.println();
            SVMTest.printDevices("SoftPartition");
            System.out.println();
            SVMTest.printDevices("Trans");
        }
        catch (RemoteException remoteException) {
            System.out.println("Exception " + remoteException.getMessage());
        }
    }

    private static boolean haveArg(String[] stringArray, String string) {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static void printAllAntecedents(Device device) throws RemoteException {
        SVMTest.printAntecedents(device, "BasedOn");
        SVMTest.printAntecedents(device, "DriveInDiskGroup");
        SVMTest.printAntecedents(device, "ExtentInDiskGroup");
        SVMTest.printAntecedents(device, "ExtentInStateDatabase");
        SVMTest.printAntecedents(device, "ExtentRedundancyComponent");
        SVMTest.printAntecedents(device, "HostInDiskGroup");
        SVMTest.printAntecedents(device, "ResidesOn");
        SVMTest.printAntecedents(device, "TransLogOn");
    }

    private static void printAllDependents(Device device) throws RemoteException {
        SVMTest.printDependents(device, "BasedOn");
        SVMTest.printDependents(device, "DriveInDiskGroup");
        SVMTest.printDependents(device, "ExtentInDiskGroup");
        SVMTest.printDependents(device, "ExtentInStateDatabase");
        SVMTest.printDependents(device, "ExtentRedundancyComponent");
        SVMTest.printDependents(device, "HostInDiskGroup");
        SVMTest.printDependents(device, "ResidesOn");
        SVMTest.printDependents(device, "TransLogOn");
    }

    private static void printAntecedents(Device device, String string) throws RemoteException {
        Vector vector = SVMObject.getAntecedents(device, string);
        if (vector != null && vector.size() != 0) {
            System.out.println("Antecedents - Association Type = " + string);
            SVMTest.printAssociatedDevices(vector);
            System.out.println();
        }
    }

    private static void printAssociatedDevices(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            Device device = (Device)vector.get(n);
            System.out.println("\t" + device.toString());
            ++n;
        }
    }

    private static void printDependents(Device device, String string) throws RemoteException {
        Vector vector = SVMObject.getDependents(device, string);
        if (vector != null && vector.size() != 0) {
            System.out.println("Dependents - Association Type = " + string);
            SVMTest.printAssociatedDevices(vector);
            System.out.println();
        }
    }

    private static void printDevices(String string) throws RemoteException {
        System.out.println("DEVICE TYPE: " + string);
        System.out.println();
        Vector vector = SVMObject.getDevices(string);
        int n = 0;
        while (n < vector.size()) {
            System.out.println(string + " " + n + ":");
            System.out.println();
            Device device = (Device)vector.get(n);
            System.out.println(device.toString());
            System.out.println();
            SVMTest.printAllAntecedents(device);
            SVMTest.printAllDependents(device);
            System.out.println();
            if (string.equalsIgnoreCase("Diskset")) {
                SVMTest.printAvailableSlices(device);
            }
            ++n;
        }
        System.out.println();
    }

    private static void printAvailableDevices(boolean bl) throws RemoteException {
        String[] stringArray = new String[]{"Concat", "Stripe", "Raid", "Mirror", "SoftPartition", "Metadb", "Diskset", "master", "log"};
        SVMServices sVMServices = new SVMServices();
        if (bl) {
            System.out.println("\ngetDevicesAvailableForUseAs:");
        } else {
            System.out.println("\ngetDevicesAvailableForAttach:");
        }
        int n = 0;
        while (n < stringArray.length) {
            if (!bl && n > 3) break;
            System.out.println("DEVICE: " + stringArray[n]);
            Device[] deviceArray = bl ? sVMServices.getDevicesAvailableForUseAs(stringArray[n], "") : sVMServices.getDevicesAvailableForAttach(stringArray[n], "");
            int n2 = 0;
            while (n2 < deviceArray.length) {
                System.out.println("    " + deviceArray[n2]);
                System.out.println();
                ++n2;
            }
            ++n;
        }
        System.out.println();
    }

    private static void printAvailableDisks() throws RemoteException {
        System.out.println("DEVICE TYPE: Available Disk");
        Vector vector = SVMObject.getAvailableDisks();
        int n = 0;
        while (n < vector.size()) {
            System.out.println("Available Disk " + n + ":");
            System.out.println();
            Device device = (Device)vector.get(n);
            System.out.println(device.toString());
            System.out.println();
            SVMTest.printAllAntecedents(device);
            SVMTest.printAllDependents(device);
            ++n;
        }
        System.out.println();
    }

    private static void printAvailableSlices(Device device) throws RemoteException {
        System.out.println("Available Slices:");
        System.out.println();
        Device[] deviceArray = SVMObject.getAvailableSlices(device);
        int n = 0;
        while (n < deviceArray.length) {
            System.out.println(deviceArray[n].toString());
            ++n;
        }
        System.out.println();
    }
}

