/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.common.util;

import com.sun.admin.volmgr.common.util.CommandResult;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class Command {
    public static final int ERROR_OCCURRED = -1024;
    private String[][] commands;
    private String[] env;
    private boolean successful;
    private String[] stdout;
    private String[] stderr;
    private CommandResult[] results;

    public Command(String[][] stringArray) {
        this.setCommands(stringArray);
    }

    public Command(String[][] stringArray, String[] stringArray2) {
        this(stringArray);
        this.setEnv(stringArray2);
    }

    public Command(String[] stringArray) {
        this(Command.getTokenizedCommands(stringArray));
    }

    public Command(String[] stringArray, String[] stringArray2) {
        this(Command.getTokenizedCommands(stringArray), stringArray2);
    }

    private void setCommands(String[][] stringArray) {
        this.commands = stringArray;
    }

    public String[][] getCommands() {
        return this.commands;
    }

    private void setEnv(String[] stringArray) {
        this.env = stringArray;
    }

    public String[] getEnv() {
        return this.env;
    }

    public synchronized boolean getSuccessful() {
        CommandResult[] commandResultArray = this.getResults();
        int n = 0;
        while (n < commandResultArray.length) {
            if (commandResultArray[n].getExitCode() != 0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public synchronized String[] getStdOut() {
        CommandResult[] commandResultArray = this.getResults();
        String[][] stringArray = new String[commandResultArray.length][];
        int n = 0;
        while (n < commandResultArray.length) {
            stringArray[n] = commandResultArray[n].getStdOut();
            ++n;
        }
        return Command.combine(stringArray);
    }

    public synchronized String[] getStdErr() {
        CommandResult[] commandResultArray = this.getResults();
        String[][] stringArray = new String[commandResultArray.length][];
        int n = 0;
        while (n < commandResultArray.length) {
            stringArray[n] = commandResultArray[n].getStdErr();
            ++n;
        }
        return Command.combine(stringArray);
    }

    private synchronized void setResults(CommandResult[] commandResultArray) {
        this.results = commandResultArray;
    }

    public synchronized CommandResult[] getResults() {
        return this.results;
    }

    public synchronized void exec(boolean bl) {
        String[][] stringArray = this.getCommands();
        String[] stringArray2 = this.getEnv();
        ArrayList<CommandResult> arrayList = new ArrayList<CommandResult>(stringArray.length);
        Runtime runtime = Runtime.getRuntime();
        int n = 0;
        while (n < stringArray.length) {
            CommandResult commandResult;
            String[] stringArray3 = stringArray[n];
            try {
                Process process = stringArray2 == null ? runtime.exec(stringArray[n]) : runtime.exec(stringArray[n], stringArray2);
                boolean bl2 = false;
                while (!bl2) {
                    try {
                        process.waitFor();
                        bl2 = true;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                commandResult = new CommandResult(stringArray3, process.exitValue(), Command.inputStreamToArray(process.getInputStream()), Command.inputStreamToArray(process.getErrorStream()));
            }
            catch (IOException iOException) {
                commandResult = new CommandResult(stringArray3, -1024, new String[0], new String[]{iOException.getMessage()});
            }
            arrayList.add(commandResult);
            if (bl && commandResult.getExitCode() != 0) break;
            ++n;
        }
        this.setResults(arrayList.toArray(new CommandResult[arrayList.size()]));
    }

    private static String[][] getTokenizedCommands(String[] stringArray) {
        String[][] stringArray2 = new String[stringArray.length][];
        int n = 0;
        while (n < stringArray.length) {
            StringTokenizer stringTokenizer = new StringTokenizer(stringArray[n]);
            stringArray2[n] = new String[stringTokenizer.countTokens()];
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray2[n][n2++] = stringTokenizer.nextToken();
            }
            ++n;
        }
        return stringArray2;
    }

    private static String[] combine(String[][] stringArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            n += stringArray[n2].length;
            ++n2;
        }
        String[] stringArray2 = new String[n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < stringArray.length) {
            int n5 = 0;
            while (n5 < stringArray[n4].length) {
                stringArray2[n3++] = stringArray[n4][n5];
                ++n5;
            }
            ++n4;
        }
        return stringArray2;
    }

    private static String[] inputStreamToArray(InputStream inputStream) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                arrayList.add(string);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.exit(1);
        }
        Command command = new Command(new String[][]{stringArray});
        try {
            command.exec(false);
            System.out.println(command.getResults()[0].toString("Command:", "Exit code:", "STDOUT:", "STDERR:"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

