/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client.util;

import com.sun.admin.cis.common.WarningDialog;
import com.sun.admin.volmgr.client.util.Util;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import javax.swing.JFrame;

public class GUIUtil {
    private static Hashtable monitorCache = new Hashtable();

    public static JFrame getAppFrame() {
        return (JFrame)Util.getApp().getProperties().getPropertyObject("vconsole.frame");
    }

    public static final JFrame getParentJFrame(Component component) {
        while (component != null && !(component instanceof JFrame)) {
            component = component.getParent();
        }
        return (JFrame)component;
    }

    public static ComponentListener makeModal(JFrame jFrame, Window window) {
        return GUIUtil.makeModal(jFrame, window, true);
    }

    public static ComponentListener makeModal(final JFrame jFrame, Window window, boolean bl) {
        ComponentAdapter componentAdapter = new ComponentAdapter(){
            private boolean waiting = false;

            public synchronized void componentShown(ComponentEvent componentEvent) {
                if (this.waiting) {
                    return;
                }
                GUIUtil.waitOn(jFrame);
                this.waiting = true;
            }

            public synchronized void componentHidden(ComponentEvent componentEvent) {
                if (!this.waiting) {
                    return;
                }
                GUIUtil.waitOff(jFrame);
                this.waiting = false;
            }
        };
        if (bl) {
            componentAdapter.componentShown(null);
        }
        window.addComponentListener(componentAdapter);
        return componentAdapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitOn(JFrame jFrame) {
        Hashtable hashtable = monitorCache;
        synchronized (hashtable) {
            ModalMonitor modalMonitor = (ModalMonitor)monitorCache.get(jFrame);
            if (modalMonitor == null) {
                modalMonitor = new ModalMonitor(jFrame);
                monitorCache.put(jFrame, modalMonitor);
            }
            modalMonitor.waitOn();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitOff(JFrame jFrame) {
        Hashtable hashtable = monitorCache;
        synchronized (hashtable) {
            ModalMonitor modalMonitor = (ModalMonitor)monitorCache.get(jFrame);
            if (modalMonitor == null) {
                return;
            }
            modalMonitor.waitOff();
            if (modalMonitor.getBusyCount() == 0) {
                monitorCache.remove(jFrame);
            }
        }
    }

    public static void waitOn() {
        GUIUtil.waitOn(GUIUtil.getAppFrame());
    }

    public static void waitOff() {
        GUIUtil.waitOff(GUIUtil.getAppFrame());
    }

    private static void addDescendentComponentsTo(Container container, Collection collection) {
        Component[] componentArray = container.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            Component component = componentArray[n];
            collection.add(component);
            if (component instanceof Container) {
                GUIUtil.addDescendentComponentsTo((Container)component, collection);
            }
            ++n;
        }
    }

    public static Component[] getDescendentComponents(Container container) {
        ArrayList arrayList = new ArrayList();
        GUIUtil.addDescendentComponentsTo(container, arrayList);
        return arrayList.toArray(new Component[arrayList.size()]);
    }

    public static boolean getConfirmation(Component component, String string, String string2) {
        final StringBuffer stringBuffer = new StringBuffer();
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                stringBuffer.append("x");
            }
        };
        new WarningDialog(GUIUtil.getParentJFrame(component), string, string2, actionListener, Util.getResourceString("okay"));
        return stringBuffer.length() != 0;
    }

    private static class ModalMonitor {
        private JFrame frame;
        private int busyCount;
        private Component glassPane;
        private MouseListener listener;

        public ModalMonitor(JFrame jFrame) {
            this.frame = jFrame;
            this.glassPane = jFrame.getGlassPane();
        }

        public synchronized void waitOn() {
            if (this.busyCount == 0) {
                this.glassPane.setCursor(Cursor.getPredefinedCursor(3));
                this.listener = new MouseAdapter(this){
                    private final /* synthetic */ ModalMonitor this$0;
                    {
                        this.this$0 = modalMonitor;
                    }

                    public void mousePressed(MouseEvent mouseEvent) {
                        ModalMonitor.access$000(this.this$0).getToolkit().beep();
                    }
                };
                this.glassPane.addMouseListener(this.listener);
                this.glassPane.setVisible(true);
            }
            ++this.busyCount;
        }

        public synchronized void waitOff() {
            if (this.busyCount == 0) {
                return;
            }
            if (this.busyCount == 1) {
                this.glassPane.removeMouseListener(this.listener);
                this.glassPane.setVisible(false);
            }
            --this.busyCount;
        }

        public int getBusyCount() {
            return this.busyCount;
        }

        static /* synthetic */ JFrame access$000(ModalMonitor modalMonitor) {
            return modalMonitor.frame;
        }
    }
}

