/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client.ttk.text;

import com.sun.admin.volmgr.client.ttk.text.SpinnerDataModel;
import java.text.ParseException;

public class DoubleSpinnerModel
implements SpinnerDataModel {
    public static final double NOLIMIT = Double.NaN;
    private static final double _INCREMENT = 1.0;
    private double min;
    private double max;
    private double increment;

    public DoubleSpinnerModel() {
        this(Double.NaN, Double.NaN);
    }

    public DoubleSpinnerModel(double d, double d2) {
        this(d, d2, 1.0);
    }

    public DoubleSpinnerModel(double d, double d2, double d3) {
        this.setMin(d);
        this.setMax(d2);
        this.setIncrement(d3);
    }

    public void setMin(double d) {
        this.min = d;
    }

    public double getMin() {
        return this.min;
    }

    public void setMax(double d) {
        this.max = d;
    }

    public double getMax() {
        return this.max;
    }

    public void setIncrement(double d) {
        this.increment = d;
    }

    public double getIncrement() {
        return this.increment;
    }

    public String incrementValue(String string) throws ParseException {
        return this.incrementValueBy(string, 1L);
    }

    public String decrementValue(String string) throws ParseException {
        return this.incrementValueBy(string, -1L);
    }

    public boolean isValidBeginning(String string) {
        if (this.getMin() < 0.0 && string.trim().equals("-")) {
            return true;
        }
        try {
            Double.parseDouble(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private String incrementValueBy(String string, long l) throws ParseException {
        double d = this.getIncrement();
        double d2 = this.getMin();
        double d3 = this.getMax();
        double d4 = 0.0;
        if (string.trim().length() == 0) {
            d4 = d2 <= 0.0 && d3 >= 0.0 ? 0.0 : d2;
        } else {
            try {
                d4 = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException("Could not convert " + string + " to a double.", 0);
            }
            d4 += d * (double)l;
        }
        if (d2 != Double.NaN && d4 < d2 || d3 != Double.NaN && d4 > d3) {
            throw new ParseException("Incremented value " + d4 + " out of valid range (" + d2 + "-" + d3 + ")", 0);
        }
        return "" + d4;
    }
}

