/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client.ttk.table;

import com.sun.admin.volmgr.client.ttk.table.RowGroup;
import com.sun.admin.volmgr.client.ttk.table.TableRowHeaderConstraints;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Hashtable;
import javax.swing.JTable;

public class TableRowHeaderLayout
implements LayoutManager2 {
    protected static TableRowHeaderConstraints _CONSTRAINTS = new TableRowHeaderConstraints();
    private JTable table;
    private int spacing;
    private Hashtable hash = new Hashtable();

    public TableRowHeaderLayout(JTable jTable) {
        this.setTable(jTable);
    }

    public TableRowHeaderLayout(JTable jTable, int n) {
        this(jTable);
        this.setSpacing(n);
    }

    public void setTable(JTable jTable) {
        this.table = jTable;
    }

    public JTable getTable() {
        return this.table;
    }

    public void setSpacing(int n) {
        this.spacing = n;
    }

    public int getSpacing() {
        return this.spacing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLayoutComponent(Component component, Object object) {
        Object object2 = component.getTreeLock();
        synchronized (object2) {
            if (object == null) {
                object = _CONSTRAINTS;
            } else if (!(object instanceof TableRowHeaderConstraints)) {
                throw new IllegalArgumentException("Cannot add to layout: constraint must be a TableRowHeaderConstraints (or null)");
            }
            this.hash.put(component, ((TableRowHeaderConstraints)object).clone());
        }
    }

    public void addLayoutComponent(String string, Component component) {
        this.addLayoutComponent(component, _CONSTRAINTS);
    }

    public void removeLayoutComponent(Component component) {
        this.hash.remove(component);
    }

    public Dimension preferredLayoutSize(Container container) {
        Serializable serializable;
        int n = this.getTable().getPreferredSize().height;
        Dimension dimension = new Dimension(0, n);
        int n2 = container.getComponentCount();
        int n3 = 0;
        while (n3 < n2) {
            serializable = container.getComponent(n3);
            if (((Component)serializable).isVisible()) {
                Dimension dimension2 = ((Component)serializable).getPreferredSize();
                if (dimension2.width > dimension.width) {
                    dimension.width = dimension2.width;
                }
            }
            ++n3;
        }
        serializable = container.getInsets();
        dimension.width += ((Insets)serializable).left + ((Insets)serializable).right;
        return dimension;
    }

    public Dimension minimumLayoutSize(Container container) {
        Serializable serializable;
        int n = this.getTable().getMinimumSize().height;
        Dimension dimension = new Dimension(0, n);
        int n2 = container.getComponentCount();
        int n3 = 0;
        while (n3 < n2) {
            serializable = container.getComponent(n3);
            if (((Component)serializable).isVisible()) {
                Dimension dimension2 = ((Component)serializable).getMinimumSize();
                if (dimension2.width > dimension.width) {
                    dimension.width = dimension2.width;
                }
            }
            ++n3;
        }
        serializable = container.getInsets();
        dimension.width += ((Insets)serializable).left + ((Insets)serializable).right;
        return dimension;
    }

    public void layoutContainer(Container container) {
        Object object;
        JTable jTable = this.getTable();
        int n = this.getSpacing();
        int n2 = n / 2;
        int n3 = n - n2;
        Insets insets = container.getInsets();
        Dimension dimension = container.getPreferredSize();
        Dimension dimension2 = container.getSize();
        int n4 = container.getComponentCount();
        int n5 = jTable.getRowCount();
        int[] nArray = new int[n5];
        int n6 = 0;
        while (n6 < n4) {
            Component component = container.getComponent(n6);
            if (component.isVisible()) {
                try {
                    object = this.getConstraints(component).getRowGroup();
                    nArray[object.getFirstRow()] = 1;
                    nArray[object.getLastRow()] = 1;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
            ++n6;
        }
        int n7 = 0;
        while (n7 < n4) {
            block29: {
                object = container.getComponent(n7);
                if (((Component)object).isVisible()) {
                    int n8;
                    int n9;
                    int n10;
                    int n11;
                    int n12;
                    int n13;
                    RowGroup rowGroup;
                    TableRowHeaderConstraints tableRowHeaderConstraints;
                    Dimension dimension3 = ((Component)object).getPreferredSize();
                    try {
                        tableRowHeaderConstraints = this.getConstraints((Component)object);
                        rowGroup = tableRowHeaderConstraints.getRowGroup();
                    }
                    catch (NullPointerException nullPointerException) {
                        break block29;
                    }
                    TableRowHeaderConstraints.HOrient hOrient = tableRowHeaderConstraints.getHOrient();
                    if (hOrient == TableRowHeaderConstraints.LEFT) {
                        n13 = insets.left;
                        n12 = dimension3.width;
                    } else if (hOrient == TableRowHeaderConstraints.HFILL) {
                        n13 = insets.left;
                        n12 = dimension2.width - insets.left - insets.right;
                    } else if (hOrient == TableRowHeaderConstraints.RIGHT) {
                        n13 = dimension2.width - dimension3.width - insets.right;
                        n12 = dimension3.width;
                    } else {
                        n13 = dimension2.width / 2 - dimension3.width / 2;
                        n12 = dimension3.width;
                    }
                    int n14 = rowGroup.getFirstRow();
                    int n15 = rowGroup.getLastRow();
                    Rectangle rectangle = jTable.getCellRect(n14, 0, true);
                    Rectangle rectangle2 = jTable.getCellRect(n15, 0, true);
                    TableRowHeaderConstraints.VOrient vOrient = tableRowHeaderConstraints.getVOrient();
                    if (vOrient == TableRowHeaderConstraints.TOP) {
                        n11 = rectangle.y;
                        n10 = rectangle2.y + rectangle2.height;
                        n9 = rectangle.y + dimension3.height;
                        n8 = n10 < n9 ? n10 : n9;
                    } else if (vOrient == TableRowHeaderConstraints.VFILL) {
                        n11 = rectangle.y;
                        n8 = rectangle2.y + rectangle2.height;
                    } else if (vOrient == TableRowHeaderConstraints.BOTTOM) {
                        n10 = rectangle.y;
                        n8 = rectangle2.y + rectangle2.height;
                        n9 = n8 - dimension3.height;
                        n11 = n10 > n9 ? n10 : n9;
                    } else {
                        n8 = rectangle2.y + rectangle2.height;
                        n11 = rectangle.y;
                        n10 = n8 - n11;
                        if (n10 > dimension3.height) {
                            n8 = (n11 += (n10 - dimension3.height) / 2) + dimension3.height;
                        }
                    }
                    if (n14 == 0) {
                        n11 += insets.top;
                    } else if (nArray[n14 - 1] != 0) {
                        n11 += n2;
                    }
                    if (n15 == n5 - 1) {
                        if (dimension2.height <= jTable.getSize().height) {
                            n8 -= insets.bottom;
                        }
                    } else if (nArray[n15 + 1] != 0) {
                        n8 -= n3;
                    }
                    int n16 = n8 - n11;
                    ((Component)object).setBounds(n13, n11, n12, n16);
                }
            }
            ++n7;
        }
    }

    public Dimension maximumLayoutSize(Container container) {
        Dimension dimension = this.getTable().getSize();
        return new Dimension(Integer.MAX_VALUE, dimension.height);
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public void invalidateLayout(Container container) {
    }

    public void setConstraints(Component component, TableRowHeaderConstraints tableRowHeaderConstraints) {
        this.addLayoutComponent(component, tableRowHeaderConstraints);
    }

    public TableRowHeaderConstraints getConstraints(Component component) {
        return (TableRowHeaderConstraints)this.hash.get(component);
    }
}

