/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client.ttk;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Panel;
import java.awt.TextField;
import java.util.Hashtable;

public class RowLayout
implements LayoutManager2 {
    public static final VOrient TOP = new VOrient();
    public static final VOrient BOTTOM = new VOrient();
    public static final VOrient VFILL = new VOrient();
    public static final VOrient VCENTER = new VOrient();
    public static final HOrient LEFT = new HOrient();
    public static final HOrient RIGHT = new HOrient();
    public static final HOrient HFILL = new HOrient();
    public static final HOrient HCENTER = new HOrient();
    protected static HOrient _HORIENT = HFILL;
    protected static VOrient _VORIENT = VFILL;
    protected static int _GAP = 15;
    private int gap;
    private HOrient hOrient;
    private Hashtable table = new Hashtable();

    public RowLayout() {
        this(_HORIENT, _GAP);
    }

    public RowLayout(int n) {
        this(_HORIENT, n);
    }

    public RowLayout(HOrient hOrient) {
        this(hOrient, _GAP);
    }

    public RowLayout(HOrient hOrient, int n) {
        if (n < 0) {
            n = 0;
        }
        this.setGap(n);
        this.setHOrient(hOrient);
    }

    public void setGap(int n) {
        this.gap = n;
    }

    public int getGap() {
        return this.gap;
    }

    public void setHOrient(HOrient hOrient) {
        this.hOrient = hOrient;
    }

    public HOrient getHOrient() {
        return this.hOrient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLayoutComponent(Component component, Object object) {
        Object object2 = component.getTreeLock();
        synchronized (object2) {
            if (object == null) {
                object = _VORIENT;
            }
            if (!(object instanceof VOrient)) {
                throw new IllegalArgumentException("Cannot add to layout: constraint must be a VOrient (or null)");
            }
            this.table.put(component, object);
        }
    }

    public void addLayoutComponent(String string, Component component) {
        this.addLayoutComponent(component, _VORIENT);
    }

    public void removeLayoutComponent(Component component) {
        this.table.remove(component);
    }

    public Dimension preferredLayoutSize(Container container) {
        Insets insets = container.getInsets();
        Dimension dimension = new Dimension(0, 0);
        int n = container.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            Component component = container.getComponent(n2);
            if (component.isVisible()) {
                Dimension dimension2 = component.getPreferredSize();
                if (n2 > 0) {
                    dimension.width += this.gap;
                }
                dimension.width += dimension2.width;
                dimension.height = Math.max(dimension2.height, dimension.height);
            }
            ++n2;
        }
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    public Dimension minimumLayoutSize(Container container) {
        Insets insets = container.getInsets();
        Dimension dimension = new Dimension(0, 0);
        int n = container.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            Component component = container.getComponent(n2);
            if (component.isVisible()) {
                Dimension dimension2 = component.getMinimumSize();
                dimension.height = Math.max(dimension2.height, dimension.height);
                dimension.width += dimension2.width;
                if (n2 > 0) {
                    dimension.width += this.gap;
                }
            }
            ++n2;
        }
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        int n = insets.left;
        int n2 = container.getComponentCount();
        int n3 = 0;
        Dimension dimension = container.getPreferredSize();
        Dimension dimension2 = container.getSize();
        if (this.hOrient == HCENTER) {
            n += dimension2.width / 2 - dimension.width / 2;
        } else if (this.hOrient == RIGHT) {
            n += dimension2.width - dimension.width;
        } else if (this.hOrient == HFILL && n2 > 0 && (n3 = (dimension2.width - dimension.width) / n2) < 0) {
            n3 = 0;
        }
        int n4 = 0;
        while (n4 < n2) {
            Component component = container.getComponent(n4);
            if (component.isVisible()) {
                int n5;
                int n6;
                Dimension dimension3 = component.getPreferredSize();
                VOrient vOrient = (VOrient)this.table.get(component);
                if (vOrient == null) {
                    vOrient = _VORIENT;
                }
                if (vOrient == TOP) {
                    n6 = insets.top;
                    n5 = dimension3.height;
                } else if (vOrient == VFILL) {
                    n6 = insets.top;
                    n5 = dimension2.height - insets.top - insets.bottom;
                } else if (vOrient == BOTTOM) {
                    n6 = dimension2.height - dimension3.height - insets.bottom;
                    n5 = dimension3.height;
                } else {
                    n6 = dimension2.height / 2 - dimension3.height / 2;
                    n5 = dimension3.height;
                }
                component.setBounds(n, n6, dimension3.width + n3, n5);
                n += dimension3.width + n3 + this.gap;
            }
            ++n4;
        }
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public void invalidateLayout(Container container) {
    }

    public static void main(String[] stringArray) {
        VOrient[] vOrientArray = new VOrient[]{TOP, BOTTOM, VFILL, VCENTER};
        HOrient[] hOrientArray = new HOrient[]{LEFT, RIGHT, HFILL, HCENTER};
        Frame frame = new Frame();
        frame.setLayout(new GridLayout(hOrientArray.length, 1, 15, 15));
        Color color = Color.white;
        int n = 0;
        while (n < hOrientArray.length) {
            Panel panel = new Panel(new RowLayout(hOrientArray[n]));
            panel.setBackground(color);
            color = color.darker();
            int n2 = 0;
            while (n2 < vOrientArray.length) {
                panel.add((Component)new TextField("Hello"), vOrientArray[n2]);
                ++n2;
            }
            frame.add(panel);
            ++n;
        }
        frame.pack();
        frame.setVisible(true);
    }

    public static class HOrient {
        private HOrient() {
        }
    }

    public static class VOrient {
        private VOrient() {
        }
    }
}

