/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client.ttk;

import com.sun.admin.volmgr.client.ttk.event.ListAdditionEvent;
import com.sun.admin.volmgr.client.ttk.event.ListAdditionListener;
import com.sun.admin.volmgr.client.ttk.table.RowAddable;
import com.sun.admin.volmgr.client.ttk.table.RowRemovable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ListBuilder
extends JPanel {
    private static final int GAP = 10;
    private static final int SCROLLPANEHEIGHT = 125;
    private JLabel label;
    private JTextField field;
    private JList list;
    private JScrollPane listScrollPane;
    private AbstractButton addButton;
    private AbstractButton deleteButton;
    private RowRemovable removable;
    private RowAddable addable;
    private ListAdditionListener listener;

    public ListBuilder() {
        this("");
    }

    public ListBuilder(String string) {
        this(string.equals("") ? null : new JLabel(string));
    }

    public ListBuilder(JLabel jLabel) {
        this.label = jLabel;
        this.init();
    }

    public JLabel getLabel() {
        return this.label;
    }

    public JTextField getTextField() {
        return this.field;
    }

    public JList getList() {
        return this.list;
    }

    public JScrollPane getListScrollPane() {
        return this.listScrollPane;
    }

    public AbstractButton getAddButton() {
        return this.addButton;
    }

    public AbstractButton getDeleteButton() {
        return this.deleteButton;
    }

    public RowAddable getAddable() {
        return this.addable;
    }

    public RowRemovable getRemovable() {
        return this.removable;
    }

    public void setListAdditionListener(ListAdditionListener listAdditionListener) {
        this.listener = listAdditionListener;
    }

    protected JTextField createTextField() {
        return new JTextField();
    }

    private AbstractButton createButton() {
        JButton jButton = new JButton();
        jButton.setMargin(new Insets(0, 0, 0, 0));
        return jButton;
    }

    protected AbstractButton createAddButton() {
        return this.createButton();
    }

    protected AbstractButton createDeleteButton() {
        return this.createButton();
    }

    protected JList createList() {
        DefaultListModel defaultListModel = new DefaultListModel();
        return new JList(defaultListModel);
    }

    protected RowAddable createRowAddable() {
        DefaultListModel defaultListModel;
        try {
            defaultListModel = (DefaultListModel)this.list.getModel();
        }
        catch (Exception exception) {
            return null;
        }
        return new RowAddable(){

            public void addRow(Object object) {
                defaultListModel.addElement(object);
            }

            public void addRow(int n, Object object) {
                defaultListModel.add(n, object);
            }

            public void addRows(Object[] objectArray) {
                int n = 0;
                while (n < objectArray.length) {
                    defaultListModel.addElement(objectArray[n]);
                    ++n;
                }
            }

            public void addRows(int n, Object[] objectArray) {
                int n2 = objectArray.length - 1;
                while (n2 >= 0) {
                    defaultListModel.add(n, objectArray[n2]);
                    --n2;
                }
            }
        };
    }

    protected RowRemovable createRowRemovable() {
        DefaultListModel defaultListModel;
        try {
            defaultListModel = (DefaultListModel)this.list.getModel();
        }
        catch (Exception exception) {
            return null;
        }
        return new RowRemovable(){

            public void removeRow(int n) {
                defaultListModel.removeElementAt(n);
            }

            public void removeRows(int n, int n2) {
                defaultListModel.removeRange(n, n2);
            }

            public void removeAllRows() {
                defaultListModel.removeAllElements();
            }
        };
    }

    private void init() {
        this.field = this.createTextField();
        this.list = this.createList();
        this.addable = this.createRowAddable();
        this.removable = this.createRowRemovable();
        this.addButton = this.createAddButton();
        this.addAddListeners();
        this.deleteButton = this.createDeleteButton();
        this.addDeleteListeners();
        this.listScrollPane = new JScrollPane(this.list, 20, 30);
        Dimension dimension = this.listScrollPane.getPreferredSize();
        this.listScrollPane.setPreferredSize(new Dimension(dimension.width, 125));
        this.listScrollPane.getViewport().setBackground(this.list.getBackground());
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets.right = 10;
        gridBagConstraints.insets.bottom = 10;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        if (this.label != null) {
            this.add((Component)this.label, gridBagConstraints);
        }
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.field, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this.addButton, gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets.right = 10;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.gridwidth = this.label == null ? 1 : 2;
        this.add((Component)this.listScrollPane, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this.deleteButton, gridBagConstraints);
    }

    private void addAddListeners() {
        DocumentListener documentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.valueChanged();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.valueChanged();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                System.out.println("Changed Updated called");
            }

            public void valueChanged() {
                ListBuilder.this.addButton.setEnabled(ListBuilder.this.field.getText().length() != 0);
            }
        };
        documentListener.insertUpdate(null);
        this.field.getDocument().addDocumentListener(documentListener);
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ListAdditionEvent listAdditionEvent;
                String string = ListBuilder.this.field.getText();
                ListAdditionListener listAdditionListener = ListBuilder.this.listener;
                if (listAdditionListener != null && !listAdditionListener.additionPending(listAdditionEvent = new ListAdditionEvent(ListBuilder.this.list, string))) {
                    return;
                }
                ListBuilder.this.addable.addRow(string);
                ListBuilder.this.field.setText("");
                int n = ListBuilder.this.list.getModel().getSize() - 1;
                ListBuilder.this.list.setSelectedIndex(n);
                ListBuilder.this.list.ensureIndexIsVisible(n);
            }
        });
        this.field.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ListBuilder.this.addButton.doClick();
            }
        });
    }

    private void addDeleteListeners() {
        ListSelectionListener listSelectionListener = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                ListBuilder.this.deleteButton.setEnabled(ListBuilder.this.list.getSelectedIndices().length != 0);
            }
        };
        listSelectionListener.valueChanged(new ListSelectionEvent(this.list, 0, 0, false));
        this.list.getSelectionModel().addListSelectionListener(listSelectionListener);
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = ListBuilder.this.list.getSelectedIndices();
                int n = nArray[nArray.length - 1];
                int n2 = nArray.length - 2;
                while (n2 >= -1) {
                    int n3 = nArray[n2 + 1];
                    if (n2 == -1 || nArray[n2] != n3 - 1) {
                        ListBuilder.this.removable.removeRows(n3, n);
                        if (n2 != -1) {
                            n = nArray[n2];
                        }
                    }
                    --n2;
                }
                ListBuilder.this.deleteButton.setEnabled(false);
            }
        });
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        Container container = jFrame.getContentPane();
        container.setLayout(new BorderLayout());
        ListBuilder listBuilder = new ListBuilder();
        listBuilder.setListAdditionListener(new ListAdditionListener(){

            public boolean additionPending(ListAdditionEvent listAdditionEvent) {
                return listAdditionEvent.getItem().toString().startsWith("a");
            }
        });
        listBuilder.getAddButton().setText("Add");
        listBuilder.getDeleteButton().setText("Delete");
        listBuilder.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        container.add(listBuilder);
        jFrame.pack();
        jFrame.show();
    }
}

