/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client.hsps;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.ListProperties;
import com.sun.admin.cis.common.ProgressPanel;
import com.sun.admin.cis.common.WarningDialog;
import com.sun.admin.volmgr.client.Content;
import com.sun.admin.volmgr.client.VVolMgr;
import com.sun.admin.volmgr.client.hsps.ConfHSPPanel;
import com.sun.admin.volmgr.client.hsps.HSPFilterControl;
import com.sun.admin.volmgr.client.hsps.VMgrHSPsMenuBar;
import com.sun.admin.volmgr.client.hsps.VMgrHSPsTBar;
import com.sun.admin.volmgr.client.util.GUIUtil;
import com.sun.admin.volmgr.client.util.HelpCache;
import com.sun.admin.volmgr.client.util.Util;
import com.sun.admin.volmgr.common.Device;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.console.gui.VFilter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.tree.MutableTreeNode;

public class HSPsContent
extends Content {
    private static String[][] columnHeaders = null;
    private VFilter filterControl;
    private boolean stopped = false;

    public HSPsContent() {
        this.sortPreferencesKey = this.getClass().getName() + ".sortPreferences";
        this.rootNode = new VScopeNode();
        this.rootNode.setColumnHeaders(this.getColumnHeaders());
        this.rootNode.setMenuBar((JMenuBar)VMgrHSPsMenuBar.getMenuBar(this));
        this.rootNode.setToolBar((JToolBar)VMgrHSPsTBar.getToolBar(this));
        try {
            this.listProperties = new ListProperties();
            this.listProperties.setFilters(new Vector());
        }
        catch (AdminException adminException) {
            Util.getApp().reportErrorException((Exception)((Object)adminException));
        }
    }

    public String[][] getColumnHeaders() {
        Object[][] objectArray = new Object[][]{{Util.getResourceString("Diskset"), new Integer(16)}, {Util.getResourceString("sparecount"), new Integer(20016)}, {Util.getResourceString("hspusecount"), new Integer(20016)}};
        if (columnHeaders == null) {
            columnHeaders = this.constructColumnHeaders(objectArray);
        }
        return columnHeaders;
    }

    public Hashtable getColumnValues(Device device) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        String string = Util.getDisplayableDiskSetName(device);
        hashtable.put(Util.getResourceString("Diskset"), string);
        Vector vector = Util.getApp().getServiceWrapper().getAntecedents(device, "ExtentRedundancyComponent");
        int n = vector != null && !vector.isEmpty() ? vector.size() : 0;
        hashtable.put(Util.getResourceString("sparecount"), new Integer(n));
        vector = Util.getApp().getServiceWrapper().getDependents(device, "ExtentRedundancyComponent");
        n = vector != null && !vector.isEmpty() ? vector.size() - 1 : 0;
        hashtable.put(Util.getResourceString("hspusecount"), new Integer(n));
        return hashtable;
    }

    public Device[] getDevices() {
        Vector vector = Util.getApp().getServiceWrapper().getDevices("Hsp", this.getListProperties());
        return vector.toArray(new Device[vector.size()]);
    }

    public void deleteSelected() {
        String string;
        Object object;
        Object object2;
        Object object3;
        Vector vector = this.getSelected();
        if (vector.isEmpty()) {
            return;
        }
        int n = vector.size();
        final String[] stringArray = new String[n];
        final String[] stringArray2 = new String[n];
        int n2 = 0;
        int n3 = vector.size();
        while (n2 < n3) {
            object3 = (VScopeNode)vector.get(n2);
            object2 = (Device)object3.getPayload();
            object = Util.getDeviceBaseName((Device)object2);
            string = Util.getDiskSetFlag((Device)object2);
            stringArray[n2] = Util.getBasedir() + "usr/sbin/metaclear" + string + ' ' + (String)object;
            stringArray2[n2] = Util.getResourceString("hsp_delete_cmd", object);
            ++n2;
        }
        object3 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Util.executeCommands(stringArray, stringArray2);
            }
        };
        object2 = Util.getResourceString("sure_delete_hsp");
        object = new ConfHSPPanel(stringArray, (String)object2);
        string = new String(Util.getResourceString("warning_delete_hsp"));
        WarningDialog warningDialog = new WarningDialog(GUIUtil.getAppFrame(), string, (JPanel)object, (ActionListener)object3, Util.getResourceString("warning_delete"));
    }

    public String whatAmI() {
        return Util.getResourceString("hsps");
    }

    public void updateStatusBar() {
        String string = Util.getResourceString("HSPsListContents", new Integer(this.getDataCache().size()));
        Util.getApp().setStatusBar(string);
    }

    public boolean isFilteringSupported() {
        return true;
    }

    public synchronized VFilter getFilterControl() {
        if (this.isFilteringSupported() && this.filterControl == null) {
            this.filterControl = new HSPFilterControl(this);
        }
        return this.filterControl;
    }

    public void appendToResultsPane(Device[] deviceArray) {
        Object object;
        Object object2;
        if (deviceArray.length == 0) {
            return;
        }
        ProgressPanel progressPanel = new ProgressPanel(GUIUtil.getAppFrame(), 2, 30, true, true);
        progressPanel.setTitle(Util.getResourceString("device_refresh_progress_title"));
        progressPanel.setRange(0, deviceArray.length);
        progressPanel.setVisible(true);
        progressPanel.setStopListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HSPsContent.this.stopped = true;
            }
        });
        this.rootNode.setColumnHeaders(this.getColumnHeaders());
        int n = 0;
        while (n < deviceArray.length) {
            if (this.stopped) {
                this.stopped = false;
                break;
            }
            object2 = Util.getDeviceFullName(deviceArray[n]);
            object = Util.getResourceString("hsp_refresh_loading_device", object2);
            progressPanel.setText((String)object);
            progressPanel.setValue(n + 1);
            VMgrHSPsMenuBar vMgrHSPsMenuBar = VMgrHSPsMenuBar.getMenuBar(this);
            VScopeNode vScopeNode = new VScopeNode(null, null, null, null, null, vMgrHSPsMenuBar.getPopupMenu(), Util.getSmallIcon(deviceArray[n]), Util.getLargeIcon(deviceArray[n]), (String)object2, (String)object2, null, -1, (Object)deviceArray[n]);
            vScopeNode.setToolTipText(Util.getResourceString("tooltip_content_type") + " " + Util.getResourceString("HSP") + "  " + Util.getResourceString("tooltip_content_name") + " " + (String)object2);
            vScopeNode.setHTMLText(HelpCache.getHelpText(deviceArray[n]));
            vScopeNode.setColumnValues(this.getColumnValues(deviceArray[n]));
            this.rootNode.add((MutableTreeNode)vScopeNode);
            this.vDataCache.addElement(deviceArray[n]);
            ++n;
        }
        object2 = Util.getApp();
        object = new VConsoleEvent(object2, "vconsole.updatescope", (Object)this.getTreeNode());
        ((VVolMgr)object2).fireConsoleAction((VConsoleEvent)object);
        progressPanel.dispose();
    }

    public void clear(boolean bl) {
        this.clearSelection();
        this.getDataCache().removeAllElements();
        System.gc();
        this.rootNode = new VScopeNode();
        this.rootNode.setColumnHeaders(this.getColumnHeaders());
        this.rootNode.setMenuBar((JMenuBar)VMgrHSPsMenuBar.getMenuBar(this));
        this.rootNode.setToolBar((JToolBar)VMgrHSPsTBar.getToolBar(this));
        this.getTreeNode().setInternalRoot(this.rootNode);
        VVolMgr vVolMgr = Util.getApp();
        if (bl) {
            VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)vVolMgr, "vconsole.updatescope", (Object)this.treeNode);
            vVolMgr.fireConsoleAction(vConsoleEvent);
        }
        this.bRefresh = true;
    }
}

