#!/usr/bin/perl -w
# ------------------------------------------------------------------------------
#   ident "@(#)sl_router.pm 1.7     02/10/31 SMI"
# ------------------------------------------------------------------------------

BEGIN { 
   require "$ENV{'NHAS_PROD_DIR'}/nhsmct/lib/sl_iterator.pm"; 
}

# ------------------------------------------------------------------------------

package sl_router;

# ID fields separator
my $ID_SEP = '@';

# Router object attributes
my @ROUTER_ATTR = qw( Id
                      Name
		      IpAddressLst );
		           
# ------------------------------------------------------------------------------
#
sub new {
   my $class = shift;
   my %attr = @_;
   my $self = {};
   bless $self, $class;
   if ( ( defined $attr{'Id'} )  && 
        ( defined $attr{'Name'} ) ) {
      # Set mandatory attributes
      $self->{'Id'} = $attr{'Id'};
      $self->{'Name'} = $attr{'Name'};
      # Set optional attributes
      $self->{'IpAddressLst'} = $attr{'IpAddressLst'}
         if ( defined $attr{'IpAddressLst'} );
   }
   elsif ( defined $attr{'RouterObject'} ) {
      $self->_construct( $attr{'RouterObject'} );
   }
   else {
      &sl_traces::error( "Unable to create %s object.".
                         " Invalid creation method", 
			 "- sl_router::new - ".__LINE__,
			 ( "sl_router" ) );
   }
   &sl_traces::trace( 2, "- sl_router::new - Creating router object ".
                     "< $self->{'Name'} > Id < $self->{'Id'} >" );
   return $self;
}

# ------------------------------------------------------------------------------
#
sub _construct {
   my $self = shift;
   my ( $routerObject ) = @_;
   &sl_traces::trace( 3, "- sl_router::_construct - Building router object" );
   my $router = sl_iterator->new( 'Object' => $routerObject );
   $self->{'Id'} = $router->extract;
   $self->{'Name'} = $router->extract;
   @{$self->{'IpAddressLst'}} =
      $router->extractObjectArray( "sl_ip", "IpObject" );
}

# ------------------------------------------------------------------------------
#
sub serialize {
   my $self = shift;
   &sl_traces::trace( 2, "- sl_router::serialize - Serializing ".
                     "router object" );
   my $routerObject = sl_iterator->new( 'Object' => "" );
   foreach $attr ( @ROUTER_ATTR ) {
      if ( $attr eq 'IpAddressLst' ) {
         $routerObject->serializeObjectArray( @{$self->{'IpAddressLst'}} );
      } 
      else {
         $routerObject->serialize( $self->{$attr} ); 
      }
   }
   return $routerObject->get;
}

# ------------------------------------------------------------------------------
#
sub display {
   my $self = shift;
   my ( $brief ) = @_;
   &sl_traces::trace( 2, "- sl_router::display - Displaying router" );
   print STDOUT "Router\n";
   print STDOUT "------\n";
   foreach ( @ROUTER_ATTR ) {
      if ( defined $self->{$_} ) {
         if ( $_ eq 'IpAddressLst' ) {
	    print STDOUT "$_ = \n\n";
	    foreach $ip ( @{$self->{'IpAddressLst'}} ) {
	       $ip->display( $brief );
	    }
	 }
	 else {
	    print STDOUT "$_ = ";
	    print STDOUT "$self->{$_}";
	    print STDOUT "\n";
         }
      }
      else {
         print STDOUT "$_ =\n";
      }
   }
   print STDOUT "\n";
}

# ------------------------------------------------------------------------------
#
sub getName {
   my $self = shift;
   &sl_traces::trace( 2, "- sl_router::getName - Getting router Name" );
   return $self->{'Name'};
}

# ------------------------------------------------------------------------------
#
sub getIpAddressLst {
   my $self = shift;
   &sl_traces::trace( 2, "- sl_router::getIpAddressLst - Getting router ".
                     "IpAddressLst" );
   if ( defined $self->{'IpAddressLst'} ) {
      return @{$self->{'IpAddressLst'}};
   }
   else {
      return ();
   }
}

# ------------------------------------------------------------------------------
#
sub deploy {
   my $self = shift;
   my ( $destDir ) = @_;
   &sl_traces::trace( 2, "- sl_router::deploy - Configuring router ".
                     "< $self->{'Name'} >" );
   # Add router addresses to hosts file 
   foreach $ipAddress ( $self->getIpAddressLst ) { 
      sl_ip->addToHosts( $destDir, $ipAddress );
   }
   # Create defaultrouter file
   sl_ip->makeDefaultRouter( $destDir, $self->getIpAddressLst );
}

# ------------------------------------------------------------------------------
#
sub iD {
   my $self = shift;
   my $routerId = $self->{'Name'}.$ID_SEP.$self->{'Id'};
   &sl_traces::trace( 3, "- sl_router::iD - Router iD is < ${routerId} >" );
   return $routerId;
}

# ------------------------------------------------------------------------------

return 1;
