#!/usr/bin/perl -w
# ------------------------------------------------------------------------------
#   ident "@(#)sl_port.pm 1.6     02/10/31 SMI"
# ------------------------------------------------------------------------------


BEGIN { 
   require "$ENV{'NHAS_PROD_DIR'}/nhsmct/lib/sl_utils.pl"; 
   require "$ENV{'NHAS_PROD_DIR'}/nhsmct/lib/sl_port.pm"; 
   require "$ENV{'NHAS_PROD_DIR'}/nhsmct/lib/sl_iterator.pm"; 
}

# ------------------------------------------------------------------------------

package sl_port;

# ID fields separator
my $ID_SEP = '@';

# Port object attributes
my @PORT_ATTR = qw( Id
                    Name
		    Number
		    Nic );

# ------------------------------------------------------------------------------
#
sub new {
   my $class = shift;
   my %attr = @_;
   my $self = {};
   bless $self, $class;
   if ( ( defined $attr{'Id'} ) &&
        ( defined $attr{'Number'} ) &&
        ( defined $attr{'Nic'} ) &&
        ( defined $attr{'Name'} ) ) {
      # Set mandatory attributes
      $self->{'Name'} = $attr{'Name'};
      $self->{'Id'} = $attr{'Id'};
      $self->{'Number'} = $attr{'Number'};
      $self->{'Nic'} = $attr{'Nic'};
   }
   elsif ( defined $attr{'PortObject'} ) {
      $self->_construct( $attr{'PortObject'} );
   }
   else {
      &sl_traces::error( "Unable to create port object.".
                         " Invalid creation method", 
			 "- sl_port::new - ".__LINE__ );
   }
   &sl_traces::trace( 2, "- sl_port::new - Creating port object ".
                     "< $self->{'Name'} >" );
   return $self;
}

# ------------------------------------------------------------------------------
#
sub _construct {
   my $self = shift;
   my ( $portObject ) = @_;
   &sl_traces::trace( 3, "- sl_port::_construct - Building port object" );
   my $port = sl_iterator->new( 'Object' => $portObject );
   $self->{'Id'} = $port->extract;
   $self->{'Name'} = $port->extract;
   $self->{'Number'} = $port->extract;
   $self->{'Nic'} = $port->extract;
}

# ------------------------------------------------------------------------------
#
sub serialize {
   my $self = shift;
   &sl_traces::trace( 2, "- sl_port::serialize - Serializing ".
                      "port object" );
   my $portObject = sl_iterator->new( 'Object' => "" );
   foreach $attr ( @PORT_ATTR ) {
      $portObject->serialize( $self->{$attr} );
   }
   return $portObject->get;
}

# ------------------------------------------------------------------------------
#
sub display {
   my $self = shift;
   my ( $brief ) = @_;
   &sl_traces::trace( 2, "- sl_port::display - Displaying port" );
   print STDOUT "Port\n";
   print STDOUT "----\n";
   foreach ( @PORT_ATTR ) {
      if ( defined $self->{$_} ) {
	 print STDOUT "$_ = ";
	 print STDOUT "$self->{$_}";
	 print STDOUT "\n";
      }
      else {
         print STDOUT "$_ =\n";
      }
   }
   print STDOUT "\n";
}

# ------------------------------------------------------------------------------
#
sub compare {
   my $self = shift;
   return "";
}

# ------------------------------------------------------------------------------
#
sub getNic {
   my $self = shift;
   &sl_traces::trace( 2, "- sl_port::getNic - Getting port ".
                      "< $self->{'Name'} nic attribute" );
   return $self->{'Nic'};
}

# ------------------------------------------------------------------------------
#
sub getName {
   my $self = shift;
   &sl_traces::trace( 2, "- sl_port::getNic - Getting port ".
                      "< $self->{'Name'} name attribute" );
   return $self->{'Name'};
}

# ------------------------------------------------------------------------------
#
sub getNumber {
   my $self = shift;
   &sl_traces::trace( 2, "- sl_switch::getNumber - Getting < $self->{'Name'} > ".
                      "Number attribute" );
   return $self->{'Number'}; 
}

# ------------------------------------------------------------------------------
#
sub iD {
   my $self = shift;
   my $portId = $self->{'Name'}.$ID_SEP.$self->{'Id'};
   &sl_traces::trace( 3, "- sl_port::iD - Port iD is < ${portId} >" );
   return $portId;
}

# ------------------------------------------------------------------------------

return 1;
