#!/usr/bin/perl -w
# ------------------------------------------------------------------------------
#   ident "@(#)sl_nic.pm 1.10     02/10/31 SMI"
# ------------------------------------------------------------------------------

BEGIN { 
   require "$ENV{'NHAS_PROD_DIR'}/nhsmct/lib/sl_ip.pm"; 
   require "$ENV{'NHAS_PROD_DIR'}/nhsmct/lib/sl_iterator.pm"; 
}

# ------------------------------------------------------------------------------


package sl_nic;

# Nic Type constants
%NIC_TYPE = ( 'PHYSICAL' => "PHYSICAL",
              'LOGICAL' => "LOGICAL",
              'VIRTUAL' => "VIRTUAL" );

# Nic Class constants
%NIC_CLASS = ( 'PRIMARY' => "PRIMARY",
               'SECONDARY' => "SECONDARY" );

# Nic Role constants
%NIC_ROLE = ( 'CGTP_NIC0' => "CGTP_NIC0",
              'CGTP_NIC1' => "CGTP_NIC1",
              'CGTP' => "CGTP",
	      'NSM' => 'NSM',
              'GENERIC' => "GENERIC" );

# Nic hidden enum values
%NIC_HIDDEN_VALUES =  ( 
              'PHYSICAL' => 0,
              'LOGICAL' => 0,
              'VIRTUAL' => 0,
	      'PRIMARY' => 0,
              'SECONDARY' => 0,
	      'CGTP_NIC0' => 0,
              'CGTP_NIC1' => 0,
              'CGTP' => 0,
	      'NSM' => 0,
              'GENERIC' => 1 ); 

# ID fields separator
my $ID_SEP = '@';

# Nic object attributes
my @NIC_ATTR = qw( Id
                   Name
		   Type
		   Class
		   Role
		   Device
		   IpAddress
		   Address );
     
# ------------------------------------------------------------------------------
#
sub new {
   my $class = shift;
   my %attr = @_;
   my $self = {};
   bless $self, $class;
   if ( ( defined $attr{'Id'} )  && 
        ( defined $attr{'Name'} ) && 
        ( defined $attr{'Type'} ) &&
        ( defined $attr{'Role'} ) &&
        ( defined $attr{'Device'} ) &&
	( defined $attr{'Class'} ) ) {
      # Set mandatory attributes
      $self->{'Id'} = $attr{'Id'};
      $self->{'Name'} = $attr{'Name'};
      $self->{'Type'} = $attr{'Type'};
      $self->{'Class'} = $attr{'Class'};
      $self->{'Role'} = $attr{'Role'};
      $self->{'Device'} = $attr{'Device'};
      # Set optional attributes
      $self->{'IpAddress'} = $attr{'IpAddress'}
         if ( defined $attr{'IpAddress'} );
      $self->{'Address'} = $attr{'Address'} 
         if ( defined $attr{'Address'} );
   }
   elsif ( defined $attr{'NicObject'} ) {
      $self->_construct( $attr{'NicObject'} );
   }
   else {
      &sl_traces::error( "Unable to create nic object. ".
                         "Invalid creation method", 
			 "- sl_nic::new - ".__LINE__,
			 ( "sl_nic" ) );
   }
   &sl_traces::trace( 2, "- sl_nic::new - Creating nic object ".
                "< $self->{'Name'} > Id < $self->{'Id'} >" );
   return $self;
}

# ------------------------------------------------------------------------------
#
sub _construct {
   my $self = shift;
   my ( $nicObject ) = @_;
   &sl_traces::trace( 3, "- sl_nic::_construct - Building nic object" );
   my $nic = sl_iterator->new( 'Object' => $nicObject );
   $self->{'Id'} = $nic->extract;
   $self->{'Name'} = $nic->extract;
   $self->{'Type'} = $nic->extract;
   $self->{'Class'} = $nic->extract;
   $self->{'Role'} = $nic->extract;
   $self->{'Device'} = $nic->extract;
   $self->{'IpAddress'} = $nic->extractObject( "sl_ip", "IpObject" );
   $self->{'Address'} = $nic->extract;
}

# ------------------------------------------------------------------------------
#
sub serialize {
   my $self = shift;
   &sl_traces::trace( 2, "- sl_nic::serialize - Serializing nic object" );
   my $nicObject = sl_iterator->new( 'Object' =>  "" );
   foreach $attr ( @NIC_ATTR ) {
      if ( $attr eq "IpAddress" ) {
	 $nicObject->serializeObject( $self->{'IpAddress'} ); 
      }
      else {
	 $nicObject->serialize( $self->{$attr} );
      }
   }
   return $nicObject->get;
}

# ------------------------------------------------------------------------------
#
sub display {
   my $self = shift;
   my ( $brief ) = @_;
   &sl_traces::trace( 2, "- sl_nic::display - Displaying nic" );
   print STDOUT "Nic\n";
   print STDOUT "---\n";
   foreach ( @NIC_ATTR ) {
      if ( defined $self->{$_} ) {
         if ( $_ eq "IpAddress" ) {
	    print STDOUT "$_ =\n\n";
	    $self->{'IpAddress'}->display;
	    print STDOUT "\n";
	 }
	 else {
	    print STDOUT "$_ = ";
	    print STDOUT "$self->{$_}";
	    print STDOUT "\n";
         }
      }
      else {
         print STDOUT "$_ =\n";
      }
   }
   print STDOUT "\n";
}

# ------------------------------------------------------------------------------
#
sub getName {
   my $self = shift;
   &sl_traces::trace( 2, "- sl_nic::getName - Getting nic ".
                "< $self->{'Name'} > Name" );
   return $self->{'Name'};
}

# ------------------------------------------------------------------------------
#
sub getDevice {
   my $self = shift;
   &sl_traces::trace( 2, "- sl_nic::getDevice - Getting nic ".
                "< $self->{'Name'} > Device" );
   return $self->{'Device'};
}

# ------------------------------------------------------------------------------
#
sub getRole {
   my $self = shift;
   &sl_traces::trace( 2, "- sl_nic::getRole - Getting nic ".
                "< $self->{'Name'} > Role" );
   return $self->{'Role'};
}

# ------------------------------------------------------------------------------
#
sub getClass {
   my $self = shift;
   &sl_traces::trace( 2, "- sl_nic::getClass - Getting nic ".
                "< $self->{'Name'} > Class" );
   return $self->{'Class'};
}

# ------------------------------------------------------------------------------
#
sub getAddress {
   my $self = shift;
   &sl_traces::trace( 2, "- sl_nic::getAddress - Getting nic ".
                "< $self->{'Name'} > Address" );
   return $self->{'Address'};
}

# ------------------------------------------------------------------------------
#
sub getIpAddress {
   my $self = shift;
   &sl_traces::trace( 2, "- sl_nic::getIpAddress - Getting nic ".
                     "< $self->{'Name'} > IpAddress" );
   return $self->{'IpAddress'};
}

# ------------------------------------------------------------------------------
#
sub isHidden {
   my $class = shift;
   my $enumValue = shift;
   &sl_traces::trace( 2, "- sl_nic::isHidden - Testing ". 
                      "< ${enumValue} > hidden value" );
   return $NIC_HIDDEN_VALUES{$enumValue};
}

# ------------------------------------------------------------------------------
#
sub iD {
   my $self = shift;
   my $nicId = $self->{'Name'}.$ID_SEP.$self->{'Id'};
   &sl_traces::trace( 3, "- sl_nic::iD - Nic iD is < ${nicId} >" );
   return $nicId;
}

# ------------------------------------------------------------------------------
#
sub isNSM {
   my $self = shift;
   my $nicRole = $self->getRole;
   &sl_traces::trace( 3, "- sl_nic::isNSM -" );
   if ( $nicRole eq $NIC_ROLE{'NSM'} ) {
      return 1;
   }
   else {
      return 0;
   }
}

# ------------------------------------------------------------------------------

return 1;
