#!/usr/bin/perl -w
# ------------------------------------------------------------------------------
#   ident "@(#)sl_fs.pl 1.11     02/11/13 SMI"
# ------------------------------------------------------------------------------

package sl_fs;

# Common Foundation Service path and file name
$FS_CONF_DIR = "/etc/opt/SUNWcgha";
$FS_CONF = "nhfs.conf";

# RNFS properties
%FS_RNFS_PROPERTIES = ( 'SLICE' => "RNFS.Slice",
                        'STATD_ALT_PATH' => "RNFS.StatdAlternatePath",
                        'SHARE' => "RNFS.Share",
			'DEBUG_LEVEL' => "RNFS.DebugLevel" );

# CMM properties
%FS_CMM_PROPERTIES = ( 'IS_ELIGIBLE' => "CMM.IsEligible",
                       'MASTER_ID' => "CMM.Master.Id",
                       'LOCAL_CONFIG_DIR' => "CMM.LocalConfig.Dir",
		       'MINI_CONFIG_DIR' => "CMM.MiniConfig.Dir",
		       'MINI_CONFIG_FILE' => "CMM.MiniConfig.File",
		       'CURRENT_NODE_NAME' => "CMM.CurrentNodeName",
		       'DAEMONIZE' => "CMM.Daemonize",
		       'NO_PROBE_MODE' => "CMM.NoProbeMode",
		       'NO_IFCHECK_MODE' => "CMM.NoIfCheckMode",
		       'ELECTION_MAX_ELIGIBLE' => "CMM.Election.MaxEligible",
		       'ELECTION_DURATION' => "CMM.Election.Duration",
		       'PROBE_DETECTION_DELAY' => "CMM.Probe.DetectionDelay",
		       'PROBE_HB_NUMBER' => "CMM.Probe.HeartBeatNumber",
		       'PROBE_SELF_CHECK' => "CMM.Probe.SelfCheck",
		       'PROBE_FIRST_CHECK' => "CMM.Probe.FirstCheck",
		       'PROBE_DAEMONIZE' => "CMM.Probe.Daemonize" );

# Cluster properties
%FS_CLUSTER_PROPERTIES = (
                       'MASTER_ID' => "Cluster.Master.Id" );

# Node properties
%FS_NODE_PROPERTIES = ( 
                        'NODE_NIC0' => "Node.NIC0",
                        'NODE_NIC1' => "Node.NIC1",
                        'NODE_CGTP' => "Node.NICCGTP",
			'NODE_ID' => "Node.NodeId",
			'NODE_TYPE' => "Node.Type",
                        'NODE_DOMAIN_ID' => "Node.DomainId",
                        'NODE_USE_CGTP' => "Node.UseCGTP",
                        'NODES_GROUP' => "Node.NodesGroup",
			'NODE_RNFS_INSTALLED' => "Node.RNFS.Installed" );


# Node properties
%FS_NSM_PROPERTIES = ( 'EXEC_MASTER_DIR' => "NSM.Exec.Masterdir",
                       'EXEC_VMASTER_DIR' => "NSM.Exec.Vicemasterdir",
		       'LOG_MASTER_DIR' => "NSM.Log.Masterdir",
                       'LOG_VMASTER_DIR' => "NSM.Log.Vicemasterdir",
		       'MASTER_NIC' => "NSM.External.Master.Nic", 
		       'MASTER_ADDRESS' => "NSM.External.Master.Address" );


# ------------------------------------------------------------------------------
#
sub configure {
   my ( $node, $nodeDir, $drawer, $domain ) = @_;
   my $nodeName = $node->getName;
   &sl_traces::trace( 2, "- sl_fs::configure - Creating node ".
                      "< ${nodeName} > common configuration data" );
   # FS config file
   my $fsDir = "${nodeDir}${FS_CONF_DIR}";
   ( -d $fsDir ) || &sl_utils::createDir( $fsDir );
   my $fsConf = "${fsDir}/${FS_CONF}";
   my $command = "";
   # Set NIC0 NIC1 & CGTP common properties
   my @ipLst = $domain->getIpAddressLst;
   my $board = $drawer->getBoard( $node->getBoard );
   my @nicLst = $board->getNicLst;
   my %nicNet = ();
   my %nicDev = ();
   # Retrieve network number for each nic
   foreach $nic ( @nicLst ) {
      my $role = $nic->getRole;
      my $device = $nic->getDevice; 
      my $nicIP = $nic->getIpAddress;
      my $network = $nicIP->getNetwork;
      $nicNet{$role} = $network;
      $nicDev{$role} = $device;
   }
   # Look for the nic needed by FS
   foreach $ip ( @ipLst ) {
      my $network = $ip->getNetwork;
      if ( $network eq $nicNet{$sl_nic::NIC_ROLE{'CGTP_NIC0'}} ) {
	 $command .= 
            "echo \"$sl_fs::FS_NODE_PROPERTIES{'NODE_NIC0'}=".
	    "$nicDev{$sl_nic::NIC_ROLE{'CGTP_NIC0'}}\"".
	    ">> ${fsConf};";
      }
      elsif ( $network eq $nicNet{$sl_nic::NIC_ROLE{'CGTP_NIC1'}} ) {
	 $command .= 
            "echo \"$sl_fs::FS_NODE_PROPERTIES{'NODE_NIC1'}=".
	    "$nicDev{$sl_nic::NIC_ROLE{'CGTP_NIC1'}}\"".
	    ">> ${fsConf};";
      }
      elsif ( $network eq $nicNet{$sl_nic::NIC_ROLE{'CGTP'}} ) {
	 $command .= 
            "echo \"$sl_fs::FS_NODE_PROPERTIES{'NODE_CGTP'}=".
	    "$nicDev{$sl_nic::NIC_ROLE{'CGTP'}}\"".
	    ">> ${fsConf};";
	 $command .= 
            "echo \"$sl_fs::FS_NODE_PROPERTIES{'NODE_USE_CGTP'}=".
	    "True\"".
	    ">> ${fsConf};";
      }
   }
   # Set Node parameters
   my $nodeId = $node->getId;
   my $nodeGroup = $node->getGroupName;
   if ( $node->isMasterEligible ) {
      $command .=
	 "echo \"$sl_fs::FS_NODE_PROPERTIES{'NODE_TYPE'}=".
	 "Diskfull\"".
	 ">> ${fsConf};";
   } elsif ( $node->isDataless ) {
      $command .=
	 "echo \"$sl_fs::FS_NODE_PROPERTIES{'NODE_TYPE'}=".
	 "Dataless\"".
	 ">> ${fsConf};";
   } else {
      $command .=
	 "echo \"$sl_fs::FS_NODE_PROPERTIES{'NODE_TYPE'}=".
	 "Diskless\"".
	 ">> ${fsConf};";
   }
   $command .= 
      "echo \"$sl_fs::FS_NODE_PROPERTIES{'NODE_ID'}=".
      "${nodeId}\"".
      ">> ${fsConf};";
   $command .= 
      "echo \"$sl_fs::FS_NODE_PROPERTIES{'NODES_GROUP'}=".
      "${nodeGroup}\"".
      ">> ${fsConf};";
   &sl_utils::execCmd( $command )
      unless ( $command eq "" );
}

# ------------------------------------------------------------------------------

return 1;
