#!/usr/bin/perl -w
# ------------------------------------------------------------------------------
#   ident "@(#)fl_utils.pl 1.9     02/10/30 SMI"
# ------------------------------------------------------------------------------
BEGIN {
   require "$ENV{NHAS_PROD_DIR}/nhsmct/lib/fl_traces.pl";
}

my $RCP="/usr/bin/rcp";
my $RSH="/usr/bin/rsh";


#-------------------------------------------------------------------------------
#
# Managemnt of /etc/hosts and /etc/ethers files
#
#-------------------------------------------------------------------------------
sub add_host {
   my ( $address, $name ) = @_ ;
   my $count=0;
   my $ip;
   my $host;
   my $garbage;
 
   $count = 0;   
     
   open (HOSTS, "/etc/hosts" ) || &error("Unable to open /etc/hosts");
   while ( <HOSTS> ) {
      
      chop();
      next if ( /#/ );      
      #s/#.*//;
      ($ip, $host, $garbage) = split (/ /, $_) ;
      next unless (defined($ip));
      next unless (defined($host));
      if ( $ip eq $address ) {
	 &error("IP address \"%s\" does not match \"%s\" hostname ".
	        "\nbut \"%s\" in /etc/hosts",
	        ( $address, $name, $host ) ) 
	 unless ( $host eq $name );
         $count++;
	 last;
      }
      elsif ( $host eq $name ) {
	 &error("Host \"%s\" does not match \"%s\" IP address ".
	        "\nbut \"%s\" in /etc/hosts",
	        ( $name, $address, $ip ) ) 
	 unless ( $ip eq $address );
         $count++;
	 last;
      }
       	        
   }
   close (HOSTS);
   
   unless ( $count ) {
      open (HOSTS, ">>/etc/hosts" ) || &error("Cannot open < %s >", 
                                              ( "/etc/hosts" ) );
      print HOSTS "$address $name\n";
      close (HOSTS);
   }
   
}

# --------------------------------------------------------------------------------------

sub add_ether {
   
   my ( $address, $name ) = @_ ;
   my $count = 0;
   my $ether = undef;
   my $host = undef;
      
   if ( -f "/etc/ethers" ) {
      open (ETHERS, "/etc/ethers" ) || &error("Cannot open < %s >",
                                              ( "/etc/ethers" ) );
      while ( <ETHERS> ) {
      
         chop();
         next if ( /#/ );
         #s/#.*//;
         ( $ether, $host ) = split( /\s/, $_ ) ;
         next unless ( defined( $ether ) );
         next unless ( defined( $host ) );
      
         if ( &ethermatch ( "$ether", "$address" ) ) {  
	    &error( "MAC \"%s\" does not match \"%s\" ".
	            "as hostname in /etc/ethers",
		    ( $address, $name ) )
	    unless ( $host eq $name );
            $count++;
	    last;
         }

      }
      close (ETHERS);
   }
   
   if ( $count == 0 ) {
      open (ETHERS, ">>/etc/ethers" ) || 
         &error("Cannot open < %s >", ( "/etc/ethers" ) );
      print ETHERS "${address} ${name}\n";
      close (ETHERS);
   }

}

# --------------------------------------------------------------------------------------

sub getetherbyname {
   
   my ( $name ) = @_;
   my $ether;
   my $host;
   
   return 0 unless (defined($name));
   return 0 unless ( -f "/etc/ethers" );
  
   open (ETHERS, "/etc/ethers" ) ||
      &error("Cannot open < %s >", ( "/etc/ethers" ) );
   while ( <ETHERS> ) {
      
      chop();
      next if ( /#/ );
      #s/#.*//;
      ($ether, $host) = split (/ /, $_) ;
      next unless (defined($ether));
      next unless (defined($host));
      
      if ( "$host" eq "$name" ) {  
	 close(ETHERS);
	 return $ether;
      }
       	        
   }
   close (ETHERS);
   return 0;
   
}

# --------------------------------------------------------------------------------------

sub duplicated_ether {
   
   my ( $address ) = @_ ;
   my $count=0;
   my $ether;
   my $host;
         
   if ( -f "/etc/ethers" ) {
      open (ETHERS, "/etc/ethers" ) ||
         &error("Cannot open < %s >", ( "/etc/ethers" ) );
      while ( <ETHERS> ) {      
         chop();
         next if ( /#/ );
         #s/#.*//;
         ($ether, $host) = split (/ /, $_) ;
         next unless (defined($ether));
         next unless (defined($host));      
         $count++ if ( &ethermatch($ether,$address) );         	        
      }
      close (ETHERS);
   }

   return ( $count > 1 );
      
}

# --------------------------------------------------------------------------------------

sub ethermatch {

   my ( $addr1, $addr2 ) = @_;
   
   return 0 unless (defined($addr1));
   return 0 unless (defined($addr2));
   
   @a = split ( /:/, $addr1 );
   @b = split ( /:/, $addr2 );
   
   for ( $i=0; $i < 6; $i++ ) {
      return 0 unless (hex($a[$i]) == hex($b[$i])); 
   }
   
   return 1;
      
}

#-------------------------------------------------------------------------------
#
# Local and remote commande
#
#-------------------------------------------------------------------------------
sub ksh_exec {

   my ($options, $cmd) = @_;
   
   return !system ( "/bin/ksh \" set $options ; $cmd \" ");

}

# --------------------------------------------------------------------------------------

sub remote_exec {
   my ($client, $command ) = @_ ;
   my $status = "OK";
   my $statusfile = "/tmp/install-status.$$";
   
   #
   # Initialize status on client side
   #
   open (LSTATUS,">$statusfile") || return 0;
   print LSTATUS "$status\n" ;
   close(LSTATUS);
      
   unless ( &exec_cmd( "$RCP $statusfile $client:$statusfile" ) ) {  
        unlink($statusfile);
        &error ("Unable to initialize remote command status on client \"%s\"", ( $client ) );
   }
        
   
   unlink($statusfile);
      
   #
   # Execute  remote command
   #   
   
   open ( REMOTEXEC, " $RSH -n $client \'$command || echo \$? > $statusfile \' 2>&1 |" ) || return 0;
   while (<REMOTEXEC>) {
      chop();
      &trace(1,"$RSH -n $client \"$command\": $_");
   }
   close (REMOTEXEC) || &error ("$RSH $client \"$command\" 2>&1"); 
   
   #
   # Retrieve execution status on client side
   #   
   unless ( &exec_cmd( "$RCP $client:$statusfile $statusfile" ) ) { 
     unlink($statusfile);
     &error ("Unable to retrieve remote command status on client \"%s\"", ( $client ) );
   }
   
   unless ( open (LSTATUS,$statusfile) ) {
      unlink($statusfile);
      return 0;
   }   
   chop($status=<LSTATUS>);
   close(LSTATUS);
   unlink($statusfile);
   
   &error ( "remote command \"%s\" returned status: \"%s\" on client \"%s\"",
            ( $command,$status, $client ) )
   unless ( $status eq "OK" );
}

# --------------------------------------------------------------------------------------

sub exec_cmd {
   my ( $command ) = @_;
   my $status = system( "${command} 2>&1" );
   return !$status;
}

# --------------------------------------------------------------------------------------

sub replace_in_file {
  
  ( $input, $output, %dict) = @_ ;

  open ( INPUT, $input ) || 
     &error( "Cannot open < %s >", ( $input ) );
  open ( OUTPUT,">$output" ) || 
     &error( "Cannot open < %s >", ( $input ) );

  while ( <INPUT> ) {
  
     foreach $pattern ( keys %dict ) {
        s/<--$pattern-->/$dict{$pattern}/;
     }
 
     print OUTPUT;

  }
 
  close( OUTPUT );
  close( INPUT );
                                                                                                                                                           
}

# ------------------------------------------------------------------------------
# 'ask' get an answer to the question given as parameter
#  returns 1 if answer is y; returns 0 in the other cases
#
#  Parameters
#  ----------
#
#    $question : question
#
sub ask {
   my ($question) = @_;
   print STDOUT $question;
   while ( <STDIN> ) {
      chomp;
      if ( /^[yY]/ ) {
         print STDOUT"\n";
         return 1;
      }
      elsif ( /^[nN]/ ) {
         print STDOUT "\n";
         return 0;
      }
      else {
         print STDOUT $question;
      }
   }  
}

# --------------------------------------------------------------------------------------
#
sub checkMandatory {
   my( $paramValue, $paramName, $fileName ) = @_;
   &main::error( "Mandatory parameter \"%s\" is missing from file \"%s\"", 
                 ( $paramName, $fileName ) )
      unless ( defined $paramValue );
   return $paramValue;
}

# --------------------------------------------------------------------------------------

return 1;
