#!/usr/bin/perl -w
# ------------------------------------------------------------------------------
#   ident "@(#)fl_traces.pl 1.7     02/10/18 SMI"
# ------------------------------------------------------------------------------


BEGIN {
   require 5.005;
   use strict;
   use locale;
   use POSIX qw( locale_h ctime );
   use Sun::Solaris::Utils qw( textdomain gettext );
}


my $VERBOSE = 1;
my $DEBUG = 0;
my $LOG_FILE = undef;

# ------------------------------------------------------------------------------
# 'init' 
#
sub init {
   use strict;
   use locale;
   use POSIX qw( locale_h ctime );
   use Sun::Solaris::Utils qw( textdomain gettext );
   setlocale( LC_ALL, "" );
   textdomain( "nhsmct" );
}

sub set_logfile {
   my ($logfile) = @_;
   open(LOG, ">$logfile") || &error ( "Cannot open < %s >", ( $logfile ) );
   $LOG_FILE = $logfile;
}

sub set_verbose {
   my ( $verbosity ) = @_;
   if ( $verbosity =~ /\D+/ ) {
      &error( " - fl_traces::setVerbosity - Verbosity level must be ".
	      "numeric\nCurrent value is < ${verbosity} >", __LINE__ );   
   }
   else {
      if ( $verbosity > 0 ) { 
	 $VERBOSE = $verbosity;
      }
      else {
	 &error( " - fl_traces::setVerbosity - Verbosity value must be ".
	         "greater to 0\nCurrent value is < ${verbosity} >", 
		 __LINE__ );
      }
   }
}

sub more_debug {
   $DEBUG++;
}

sub error {
   my ($errorId, @paramLst) = @_;
   setlocale( LC_ALL, "" );
   textdomain( "nhsmct" );
   my $errorInfo = gettext( $errorId );
   printf STDERR "\nERROR: - $OPERATION - $errorInfo\n\n", @paramLst;
   printf LOG "\nERROR: - $OPERATION - $errorInfo\n\n", @paramLst
      if ( defined $LOG_FILE);
   exit 1;
}

sub warning {
   my ($warningId, @paramLst) = @_;
   setlocale( LC_ALL, "" );
   textdomain( "nhsmct" );
   my $warningInfo = gettext( $warningId );
   printf STDOUT "\nWARNING: $warningInfo\n\n", @paramLst;
   printf LOG "\nWARNING: $warningInfo\n\n", @paramLst
      if ( defined $LOG_FILE);
}

sub info {
   my ($level, $infoId, @paramLst) = @_;
   if ( $level le $VERBOSE ) { 
      setlocale( LC_ALL, "" );
      textdomain( "nhsmct" );
      my $info = gettext( $infoId );
      printf STDOUT "INFO: - $OPERATION - $info\n", @paramLst;
      printf LOG "INFO: - $OPERATION - $info\n", @paramLst
         if ( defined $LOG_FILE);
   }
}

sub trace {
   my ($level, $comment) =@_;
   if ( $level le $DEBUG ) { 
      print STDOUT "TRACE: $comment\n";
      print STDOUT "TRACE: $comment\n"
         if ( defined $LOG_FILE);
   }
}

sub message {
   my ( $msg ) = @_;
   print STDOUT "$msg";
   print LOG "$msg"
      if ( defined $LOG_FILE );
}

sub usage {
   &message( "\nUsage:\n\n" );
   if ( $INSTAL or $HELP ) {
      &message( "\tflinstall -n <swl-name> -v <swl-version> ".
                   "-g <group-name> [ -j <jumpstart-dir> ] [ -c <config-dir> ]\n".
                   "\t\t[ -e <export-dir> ] [ -l <log-file> ] [ -h ] ".
		   "[ -V <verbosity-level> ]\n" );
   }
   if ( $CONFIG or $HELP ) {
      &message( "\n\tflconfig -n <swl-name> -v <swl-version> ".
                   "-g <group-name> -f <flash-archive> [ -c <config-dir> ]\n".
                   "\t\t[ -e <export-dir> ] [ -l <log-file> ] [ -h ] ".
		   "[ -V <verbosity-level> ]\n" );
   }
   if ( $DEPLOY or $HELP ) {
      &message( "\n\tfldeploy -n <swl-name> -v <swl-version> ".
                   "-g <group-name> -f <flash-archive> ".
		   "[ -j <jumpstart-dir> ] [ -c <config-dir> ]\n".
                   "\t\t[ -e <export-dir> ] [ -l <log-file> ] [ -h ] ".
		   "[ -V <verbosity-level> ]\n" );
   }
   if ( $CREATE or $HELP ) {
      &message( "\n\tflcreate -n <swl-name> -v <swl-version> ".
                   "-g <group-name> -f <flash-archive> [ -c <config-dir> ]\n".
                   "\t\t[ -e <export-dir> ] [ -l <log-file> ] [ -h ] ".
		   "[ -V <verbosity-level> ]\n" );
   }
   &message( "\nParameters:\n\n" );
   if ( ( $INSTAL ) or
        ( $DEPLOY ) or
        ( $CONFIG ) or
        ( $CREATE ) or
	( $HELP ) ) {
      &message( "-n <swl-name>\n\tsoftware load name.\n\n" );
      &message( "-v <swl-version>\n\tsoftware load version.\n\n" );
      &message( "-g <group-name>\n\tname of the group to process.\n\n" );
      &message( "-c <config-dir>\n\tDirectory where the configuration ".
                   "files are stored.\n\n" );
      &message( "-e <export-dir>\n\tdirectory where the software load\n" );
      &message( "\tdata are exported.\n\n" );
   }
   if ( ( $INSTAL ) or
        ( $DEPLOY ) or
	( $HELP ) ) {
      &message( "-j <jumpstart-dir>\n\tdirectory where the Jumpstart.\n".
                 "\tenvironment is created.\n\n" );
   }
   if ( ( $CREATE ) or 
        ( $CONFIG ) or 
        ( $DEPLOY )  or
	( $HELP ) ) {
      &message( "-f <flash-archive>\n\tpath name to the Flash archive.\n".
                 "\tor name of the Flash archive.\n\n" );
   }
   &message( "-l <log-file>\n\tspecifies the name of the file ".
              "receiving \n\tinformation messages (default ".
              "is stdout).\n\tError messages are output to stderr.\n\n" );
   &message( "-V <verbosity-level>\n\tset the verbosity level. Verbosity ".
              "level is a value greater to 0.\n\n" );
   &message( "-h\n\tprint this help.\n\n" );

   &main::error( @_ ) if ( defined  $_[0] );
   exit 0;
}

return 1;
