#!/usr/bin/perl
# ------------------------------------------------------------------------------
#  ident "@(#)sequencer.pl 1.13 03/06/13 SMI"
# ------------------------------------------------------------------------------
#
#  Copyright 2001-2003 Sun Microsystems, Inc. All rights reserved.
#
# ------------------------------------------------------------------------------

package SEQUENCER;

use variables;

#
# PERL module description
#
#    index:   name of the module
#
#    perl:    name of the PERL script
#    package: name of the package defined in the PERL script
# 

my %module_array =
  (      
   "dialog"=> 
   {
    "perl"    => "$ENV{NHINSTALL_LIB}/tools/lib/dialog.pl",
    "package" => "DIALOG",
   } ,
   
   "wait_boot"=> 
   {
    "perl"    => "$ENV{NHINSTALL_LIB}/tools/lib/wait_boot.pl",
    "package" => "WAIT_BOOT",
   } ,
   
   "reboot"=> 
   {
    "perl"    => "$ENV{NHINSTALL_LIB}/tools/lib/reboot.pl",
    "package" => "REBOOT",
   } ,

   "addon"=> 
   {
    "perl"    => "$ENV{NHINSTALL_LIB}/tools/lib/addon.pl",
    "package" => "ADDON",
   } ,
   
   "mount_men"=> 
   {
    "perl"    => "$ENV{NHINSTALL_LIB}/tools/lib/mount_men.pl",
    "package" => "MOUNT_MEN",
   } ,

   "mount_nmen"=> 
   {
    "perl"    => "$ENV{NHINSTALL_LIB}/tools/lib/mount_nmen.pl",
    "package" => "MOUNT_NMEN",
   } ,

   "install_server"=> 
   {
    "perl"    => "$ENV{NHINSTALL_LIB}/tools/install_os/common/install_server.pl",
    "package" => "INSTALL_SERVER",
   } ,

   "men_solaris"=> 
   {
    "perl"    => "$ENV{NHINSTALL_LIB}/tools/install_os/common/men_jumpstart.pl",
    "package" => "MEN_JUMPSTART",
   } ,
   
   "men_getinfo"=> 
   {
    "perl"    => "$ENV{NHINSTALL_LIB}/tools/install_os/common/men_getinfo.pl",
    "package" => "MEN_GETINFO",
   } ,

   "men_check"=> 
   {
    "perl"    => "$ENV{NHINSTALL_LIB}/tools/install_os/common/men_check.pl",
    "package" => "MEN_CHECK",
   } ,
   
   "men_svm"=> 
   {
    "perl"    => "$ENV{NHINSTALL_LIB}/tools/install_os/common/men_svm.pl",
    "package" => "MEN_SVM",
   } ,
   
   "men_cgtppatch"=> 
   {
    "perl"    => "$ENV{NHINSTALL_LIB}/tools/install_os/common/men_cgtppatch.pl",
    "package" => "MEN_CGTPPATCH",
   } ,
   
   "men_checker"=> 
   {
    "perl"    => "$ENV{NHINSTALL_LIB}/tools/install_os/common/men_checker.pl",
    "package" => "MEN_CHECKER",
   } ,
   
   "men_dcss"=> 
   {
    "perl"    => "$ENV{NHINSTALL_LIB}/tools/install_os/common/men_dcss.pl",
    "package" => "MEN_DCSS",
   } ,
   
   "men_cgtp"=> 
   {
    "perl"    => "$ENV{NHINSTALL_LIB}/tools/install_os/common/men_cgtp.pl",
    "package" => "MEN_CGTP",
   } ,

   "men_cmm"=> 
   {
    "perl"    => "$ENV{NHINSTALL_LIB}/tools/install_os/common/men_cmm.pl",
    "package" => "MEN_CMM",
   } ,

   "men_rnfs"=> 
   {
    "perl"    => "$ENV{NHINSTALL_LIB}/tools/install_os/common/men_rnfs.pl",
    "package" => "MEN_RNFS",
   } ,

   "men_pmd"=> 
   {
    "perl"    => "$ENV{NHINSTALL_LIB}/tools/install_os/common/men_pmd.pl",
    "package" => "MEN_PMD",
   } ,

   "men_nsm"=> 
   {
    "perl"    => "$ENV{NHINSTALL_LIB}/tools/install_os/common/men_nsm.pl",
    "package" => "MEN_NSM",
   } ,

   "men_fsconf"=> 
   {
    "perl"    => "$ENV{NHINSTALL_LIB}/tools/install_os/common/men_fsconf.pl",
    "package" => "MEN_FSCONF",
   } ,

   "men_jdk"=> 
   {
    "perl"    => "$ENV{NHINSTALL_LIB}/tools/install_os/common/men_jdk.pl",
    "package" => "MEN_JDK",
   } ,

   "men_ma_jdmk"=> 
   {
    "perl"    => "$ENV{NHINSTALL_LIB}/tools/install_os/common/men_ma_jdmk.pl",
    "package" => "MEN_MA_JDMK",
   } ,

   "men_manpages"=> 
   {
    "perl"    => "$ENV{NHINSTALL_LIB}/tools/install_os/common/men_manpages.pl",
    "package" => "MEN_MANPAGES",
   } ,

   "men_end"=> 
   {
    "perl"    => "$ENV{NHINSTALL_LIB}/tools/install_os/common/men_end.pl",
    "package" => "MEN_END",
   } ,

   "men_wdt"=> 
   {
    "perl"    => "$ENV{NHINSTALL_LIB}/tools/install_os/common/men_wdt.pl",
    "package" => "MEN_WDT",
   } ,

   "nmen_solaris"=> 
   {
    "perl"    => "$ENV{NHINSTALL_LIB}/tools/install_os/common/nmen_solaris.pl",
    "package" => "NMEN_SOLARIS",
   } ,

   "nmen_diskless"=> 
   {
    "perl"    => "$ENV{NHINSTALL_LIB}/tools/install_os/common/nmen_diskless.pl",
    "package" => "NMEN_DISKLESS",
   } ,

   "nmen_disklesspkg"=> 
   {
    "perl"    => "$ENV{NHINSTALL_LIB}/tools/install_os/common/nmen_disklesspkg.pl",
    "package" => "NMEN_DISKLESSPKG",
   } ,

   "nmen_cgtppatch"=> 
   {
    "perl"    => "$ENV{NHINSTALL_LIB}/tools/install_os/common/nmen_cgtppatch.pl",
    "package" => "NMEN_CGTPPATCH",
   } ,

   "nmen_rbs"=> 
   {
    "perl"    => "$ENV{NHINSTALL_LIB}/tools/install_os/common/nmen_rbs.pl",
    "package" => "NMEN_RBS",
   } ,

   "nmen_nls"=> 
   {
    "perl"    => "$ENV{NHINSTALL_LIB}/tools/install_os/common/nmen_nls.pl",
    "package" => "NMEN_NLS",
   } ,

   "nmen_checker"=> 
   {
    "perl"    => "$ENV{NHINSTALL_LIB}/tools/install_os/common/nmen_checker.pl",
    "package" => "NMEN_CHECKER",
   } ,

   "nmen_cgtp"=> 
   {
    "perl"    => "$ENV{NHINSTALL_LIB}/tools/install_os/common/nmen_cgtp.pl",
    "package" => "NMEN_CGTP",
   } ,

   "nmen_cmm"=> 
   {
    "perl"    => "$ENV{NHINSTALL_LIB}/tools/install_os/common/nmen_cmm.pl",
    "package" => "NMEN_CMM",
   } ,

   "nmen_pmd"=> 
   {
    "perl"    => "$ENV{NHINSTALL_LIB}/tools/install_os/common/nmen_pmd.pl",
    "package" => "NMEN_PMD",
   } ,

   "nmen_fsconf"=> 
   {
    "perl"    => "$ENV{NHINSTALL_LIB}/tools/install_os/common/nmen_fsconf.pl",
    "package" => "NMEN_FSCONF",
   } ,

   "nmen_jdk"=> 
   {
    "perl"    => "$ENV{NHINSTALL_LIB}/tools/install_os/common/nmen_jdk.pl",
    "package" => "NMEN_JDK",
   } ,

   "nmen_ma"=> 
   {
    "perl"    => "$ENV{NHINSTALL_LIB}/tools/install_os/common/nmen_ma.pl",
    "package" => "NMEN_MA",
   } ,

   "nmen_end"=> 
   {
    "perl"    => "$ENV{NHINSTALL_LIB}/tools/install_os/common/nmen_end.pl",
    "package" => "NMEN_END",
   } ,

   "nmen_wdt"=> 
   {
    "perl"    => "$ENV{NHINSTALL_LIB}/tools/install_os/common/nmen_wdt.pl",
    "package" => "NMEN_WDT",
   } ,

   "ins_soldistrib"=> 
   {
    "perl"    => "$ENV{NHINSTALL_LIB}/tools/install_os/common/ins_soldistrib.pl",
    "package" => "INS_SOLDISTRIB",
   } ,
   )
;

#


#
# ACTION decription
#
#    index:    name of the action
#
#    module:   name of the module (entry in module_array)
#    init:     function executing intialisation action
#    action:   function executing nominal case
#    recovery: function executing recovery action
#    end:      function executing final action
#
my %action_array =
  (
   "configure_nic" =>
   {
    "module"   => "install_server",
    "action"   => "configure_iface",
   },

   "get_install_server_info" =>
   {
    "module"   => "install_server",
    "action"   => "get_install_server_info",
   },

   "prepare_directories" =>
   {
    "module"   => "install_server",
    "action"   => "prepare_directories",
   },

   "men_jumpstart" =>
   {
    "module"   => "men_solaris",
    "action"   => "men_jumpstart",
   },
   
   "ask_for_boot" =>
   {
    "module"   => "dialog",
    "action"   => "ask_for_boot",
   },

   "ask_for_solaris_installation" =>
   {
    "module"   => "dialog",
    "action"   => "ask_for_solaris_installation",
   },

   "ask_for_diskless" =>
   {
    "module"   => "dialog",
    "action"   => "ask_for_diskless",
   },

   "men_wait" =>
   {
    "module"   => "wait_boot",
    "action"   => "men_wait",
   },

   "men_getinfo" =>
   {
    "module"   => "men_getinfo",
    "action"   => "men_getinfo",
   },

   "men_check_solaris" =>
   {
    "module"   => "men_check",
    "action"   => "men_check_solaris",
   },

   "men_check_nhas" =>
   {
    "module"   => "men_check",
    "action"   => "men_check_nhas",
   },

   "men_svm" =>
   {
    "module"   => "men_svm",
    "action"   => "men_svm",
    "recovery" => "recovery_men_svm",
   },

   "men_cgtppatch" =>
   {
    "module"   => "men_cgtppatch",
    "action"   => "men_cgtppatch",
    "recovery" => "recovery_men_cgtppatch",
   },

   "men_checker" =>
   {
    "module"   => "men_checker",
    "action"   => "men_checker",
   },

   "men_cgtp" =>
   {
    "module"   => "men_cgtp",
    "action"   => "men_cgtp",
   },

   "men_cgtp_add_nodes" =>
   {
    "module"   => "men_cgtp",
    "action"   => "men_cgtp_add_nodes",
   },

   "men_cmm" =>
   {
    "module"   => "men_cmm",
    "action"   => "men_cmm",
    "recovery" => "recovery_men_cmm",
   },

   "men_cmm_add_nodes" =>
   {
    "module"   => "men_cmm",
    "action"   => "men_cmm_add_nodes",
   },

   "men_cmm_reload_file" =>
   {
    "module"   => "men_cmm",
    "action"   => "men_cmm_reload_file",
   },

   "men_rnfs" =>
   {
    "module"   => "men_rnfs",
    "action"   => "men_rnfs",
    "recovery" => "recovery_men_rnfs",
   },

   "men_sndrpatch" =>
   {
    "module"   => "men_rnfs",
    "action"   => "men_sndrpatch",
    "recovery" => "recovery_men_sndrpatch",
   },

   "men_pmd" =>
   {
    "module"   => "men_pmd",
    "action"   => "men_pmd",
   },

   "men_nsm" =>
   {
    "module"   => "men_nsm",
    "action"   => "men_nsm",
   },

   "men_wdt" =>
   {
    "module"   => "men_wdt",
    "action"   => "men_wdt",
   },

   "men_fsconf" =>
   {
    "module"   => "men_fsconf",
    "action"   => "men_fsconf",
   },

   "men_fsconf_add_nodes" =>
   {
    "module"   => "men_fsconf",
    "action"   => "men_fsconf_add_nodes",
   },

   "men_jdk" =>
   {
    "module"   => "men_jdk",
    "action"   => "men_jdk",
   },

   "men_ma_jdmk" =>
   {
    "module"   => "men_ma_jdmk",
    "action"   => "men_ma_jdmk",
    "recovery" => "recovery_men_ma_jdmk",
   },

   "men_manpages" =>
   {
    "module"   => "men_manpages",
    "action"   => "men_manpages",
   },

   "nmen_solaris" =>
   {
    "module"   => "nmen_solaris",
    "action"   => "nmen_solaris",
    "recovery" => "recovery_nmen_solaris",
   },

   "nmen_diskless" =>
   {
    "module"   => "nmen_diskless",
    "init"     => "save_files",
    "action"   => "nmen_diskless",
    "end"      => "restore_files",
    "recovery" => "recovery_nmen_diskless",
   },

   "nmen_disklesspkg" =>
   {
    "module"   => "nmen_disklesspkg",
    "action"   => "nmen_disklesspkg",
    "recovery" => "recovery_nmen_disklesspkg",
   },

   "nmen_cgtppatch" =>
   {
    "module"   => "nmen_cgtppatch",
    "action"   => "nmen_cgtppatch",
    "recovery" => "recovery_nmen_cgtppatch",
   },

   "nmen_rbs" =>
   {
    "module"   => "nmen_rbs",
    "action"   => "nmen_rbs",
    "recovery" => "recovery_nmen_rbs",
   },

   "nmen_rbs_add_nodes" =>
   {
    "module"   => "nmen_rbs",
    "action"   => "nmen_rbs_add_nodes",
   },

   "nmen_nls" =>
   {
    "module"   => "nmen_nls",
    "action"   => "nmen_nls",
#    "recovery" => "recovery_nmen_nls",
   },

   "nmen_nls_add_nodes" =>
   {
    "module"   => "nmen_nls",
    "action"   => "nmen_nls_add_nodes",
   },

   "men_dcss" =>
   {
    "module"   => "men_dcss",
    "action"   => "men_dcss",
   },

   "nmen_checker" =>
   {
    "module"   => "nmen_checker",
    "action"   => "nmen_checker",
   },

   "nmen_cgtp" =>
   {
    "module"   => "nmen_cgtp",
    "action"   => "nmen_cgtp",
   },

   "nmen_cgtp_add_nodes" =>
   {
    "module"   => "nmen_cgtp",
    "action"   => "nmen_cgtp_add_nodes",
   },

   "nmen_cmm" =>
   {
    "module"   => "nmen_cmm",
    "action"   => "nmen_cmm",
    "recovery" => "recovery_nmen_cmm",
   },

   "nmen_pmd" =>
   {
    "module"   => "nmen_pmd",
    "action"   => "nmen_pmd",
   },

   "nmen_wdt" =>
   {
    "module"   => "nmen_wdt",
    "action"   => "nmen_wdt",
   },

   "nmen_fsconf" =>
   {
    "module"   => "nmen_fsconf",
    "action"   => "nmen_fsconf",
   },

   "nmen_reset_men1_dfstab" =>
   {
    "module"   => "nmen_fsconf",
    "action"   => "nmen_reset_men1_dfstab",
   },

   "nmen_jdk" =>
   {
    "module"   => "nmen_jdk",
    "action"   => "nmen_jdk",
   },

   "nmen_ma" =>
   {
    "module"   => "nmen_ma",
    "action"   => "nmen_ma",
   },

   "nmen_end" =>
   {
    "module"   => "nmen_end",
    "action"   => "nmen_end",
   },

   "men_addon_solaris" =>
   {
    "module"   => "addon",
    "action"   => "men_addon_solaris",
    "recovery" => "recovery_men_addon_solaris",
   },

   "nmen_addon_solaris" =>
   {
    "module"   => "addon",
    "action"   => "nmen_addon_solaris",
    "recovery" => "recovery_nmen_addon_solaris",
   },

   "men_addon_fs" =>
   {
    "module"   => "addon",
    "action"   => "men_addon_fs",
    "recovery" => "recovery_men_addon_fs",
   },

   "nmen_addon_fs" =>
   {
    "module"   => "addon",
    "action"   => "nmen_addon_fs",
    "recovery" => "recovery_nmen_addon_fs",
   },

   "mount_men" =>
   {
    "module"   => "mount_men",
    "action"   => "mount_men",
   },

   "mount_nmen" =>
   {
    "module"   => "mount_nmen",
    "action"   => "mount_nmen",
   },

   "men_end" =>
   {
    "module"   => "men_end",
    "action"   => "men_end",
   },

   "men_reboot_for_diskless" =>
   {
    "module"   => "reboot",
    "action"   => "men_reboot",
   },

   "men_reboot_end" =>
   {
    "module"   => "reboot",
    "action"   => "men_reboot",
   },

   "men_manual_reboot_for_diskless" =>
   {
    "module"   => "dialog",
    "action"   => "ask_for_men_reboot",
   },

   "men_manual_reboot_end" =>
   {
    "module"   => "dialog",
    "action"   => "ask_for_men_reboot",
   },

   "boot_diskless" =>
   {
    "module"   => "dialog",
    "action"   => "boot_diskless",
   },

   "check_solaris_distrib" =>
   {
    "module"   => "ins_soldistrib",
    "action"   => "check_solaris_distrib",
   },
  ) 
;




my %data_array = ();

my $install_status_file = $ENV{NHINSTALL_STATUS_FILE};

my $action_forced="";


#--------------------------------------------------------------
#
#  load_state
#
#   load the current state of the installation
#
#--------------------------------------------------------------

sub load_state {

  my $type;
  my $name;
  my $param;
  my $value;

  if (! -f $install_status_file) {
    return ;
  }

  open(INSTALL_STATUS,"<$install_status_file");
  while(<INSTALL_STATUS>) {
    chomp();
    ($type, $name, $param, $value) = split(/,/,$_);
    if ($type eq "ACTION") {
      $action_array{$name}->{last_step}[$param] = $value;
    } else {
      $data_array{$name}->{value} = $value;
    }
  }

  close(INSTALL_STATUS);
}

#--------------------------------------------------------------
#
#  set_progress
#
#  update the progress state (in the installation status file
#  and in the array)
#
#--------------------------------------------------------------

sub set_progress {
  my ($action_name, $param, $step) = @_;

  open(INSTALL_STATUS,">>$install_status_file");

  print INSTALL_STATUS "ACTION,$action_name,$param,$step\n" ;
  $action_array{$action_name}->{last_step}[$param] = $step;

  close(INSTALL_STATUS);
}

#--------------------------------------------------------------
#
#  set_data
#
#  save data into the installation status file
#
#--------------------------------------------------------------

sub set_data {
  my ($data_name, $value) = @_;

  open(INSTALL_STATUS,">>$install_status_file");

  print INSTALL_STATUS "DATA,$data_name,-,$value\n" ;
  $data_array{$data_name}->{value} = $value;

  close(INSTALL_STATUS);
}

#--------------------------------------------------------------
#
#  get_data
#
#  return the data value
#
#--------------------------------------------------------------

sub get_data {
  my ($data_name) = @_;

  if (defined($data_array{$data_name})) {
    return $data_array{$data_name}->{value};
  } else {
    return "";
  }
}

#--------------------------------------------------------------
#
#  is_last_step
#
#  return true if the action is at the current step
#
#--------------------------------------------------------------

sub is_last_step {
  my ($action_name, $param, $step) = @_ ;

  
  if (! defined($action_array{$action_name}->{last_step}[$param])) {
    $action_array{$action_name}->{last_step}[$param] = "";
  }

  if ($action_array{$action_name}->{last_step}[$param] eq $step) {
    return 1;
  }

  return 0;
}

#--------------------------------------------------------------
#
#  load modules
#
#   load all PERL module defined in the module array
#
#--------------------------------------------------------------

sub load_modules {

  foreach my $module (keys %module_array) {
    my $perl=$module_array{$module}->{perl} ;
    require "$perl";
  }
}

#--------------------------------------------------------------
#
#    execute a step
#
#    execute the given step for a given action
#    undefined step are skipped
#
#--------------------------------------------------------------

sub execute_step {
  my ($action_name, $param, $step, $function) = @_ ;

  my $module = $action_array{$action_name}->{module};
  if (!defined($module)) {
    print "error: no module defined for action $action_name\n";
    exit 1;
  }
  
  my $package = $module_array{$module}->{package};

  # step is executed only if it is defined and not null

  if (defined($action_array{$action_name}->{$step})) {
    if ($action_array{$action_name}->{$step} ne "") {

      my $func = $package . "::" . $action_array{$action_name}->{$step};
      if ($step eq "action") {
	set_progress($action_name, $param, "running") ;
      }
      COMMON::print_debug("DEBUG_ACTION", "calling $func($param)");
      &$func($param) ;

    }
  }

  # set even if no step defined to activate next step
  set_progress($action_name, $param, $step);
}

#--------------------------------------------------------------
#
#    execute an action
#
#--------------------------------------------------------------

sub execute_action {

  my ($action_name, $param) = @_ ;

  if (!defined($param) || ($param eq "")) {
    $param = 0;
  }
  

  if (!defined($action_array{$action_name})) {
    COMMON::error("SEQUENCER: action $action_name unknown") ;
    return;
  }

  if (($TESTING ne "recovery") && ($TESTING ne "interrupt")) {

    #
    # normal case
    #
    # if action was running, the recovery is performed
    #

    if (is_last_step($action_name, $param, "running") || is_last_step($action_name, $param,"recovery")) {
      # failure during execution or during recovery
      # we execute (or re-execute) the recovery action
      # and reset the progress indicator to "init done"
      execute_step($action_name, $param, "recovery");
      set_progress($action_name, $param, "init");

      # the recovery indicator is reset
      $RECOVERY = "";
    }
    
    if (is_last_step($action_name,$param,"")) {
      execute_step($action_name, $param, "init");
    }
    if (is_last_step($action_name,$param, "init")) {
      execute_step($action_name, $param, "action");
    }
    if (is_last_step($action_name, $param, "action")) {
      execute_step($action_name, $param, "end");
    }


  } elsif ($TESTING eq "recovery") {
    
    #
    # instrumentation for recovery testing
    #
    #
    # if a recovery action is defined:
    # - action is executed
    # - recovery is then called
    # - action is re-executed again
    #
    # if no recovery is defined
    # - action is executed
    # - action is re-executed: this checks that the action
    #   can be executed twice without a recovery need
    
    if (is_last_step($action_name, $param, "running") || is_last_step($action_name, $param,"recovery")) {
      # failure during execution or during recovery
      # we execute (or re-execute) the recovery action
      # and reset the progress indicator to "init done"
      execute_step($action_name, $param, "recovery");
      set_progress($action_name, $param, "init");

      # the recovery indicator is reset
      $RECOVERY = "";
    }

    if (is_last_step($action_name,$param,"")) {
      execute_step($action_name, $param, "init");
    }
    if (is_last_step($action_name,$param, "init")) {
      execute_step($action_name, $param, "action");
      set_progress($action_name, $param, "action_1");
    }
    if (is_last_step($action_name,$param, "action_1")) {
      execute_step($action_name, $param, "recovery");
      set_progress($action_name, $param, "recovery");
    }
    if (is_last_step($action_name,$param, "recovery")) {
      execute_step($action_name, $param, "action");
      set_progress($action_name, $param, "action_2");
    }
    if (is_last_step($action_name, $param, "action_2")) {
      execute_step($action_name, $param, "end");
    }

  } elsif ($TESTING eq "interrupt") {

    #
    # the first time, execute the action and stop execution with exit status 2
    # the second time, execute the recovery then the action again and continue
    # 
    if (is_last_step($action_name, $param, "running") || is_last_step($action_name, $param,"recovery")) {
      # failure during execution or during recovery
      # we execute (or re-execute) the recovery action
      # and reset the progress indicator to "init done"
      execute_step($action_name, $param, "recovery");
      set_progress($action_name, $param, "init");

      # the recovery indicator is reset
      $RECOVERY = "";
    }
    if (is_last_step($action_name, $param, "exit")) {
      # interruption has been force: perform recovery, the action
      execute_step($action_name, $param, "recovery");
      set_progress($action_name, $param, "after_exit");

      # the recovery indicator is reset
      $RECOVERY = "";
    }
    
    if (is_last_step($action_name,$param,"")) {
      execute_step($action_name, $param, "init");
    }
    if (is_last_step($action_name,$param, "init")) {
      execute_step($action_name, $param, "action");
    }
    if (is_last_step($action_name,$param, "action")) {
      if ($action_forced eq "TRUE") {
	set_progress($action_name, $param, "after_exit");
      } else {
	set_progress($action_name, $param, "exit");
	exit 2;
      }
    }
    if (is_last_step($action_name,$param, "after_exit")) {
      execute_step($action_name, $param, "action");
      set_progress($action_name, $param, "action_2");
    }
    if (is_last_step($action_name, $param, "action_2")) {
      execute_step($action_name, $param, "end");
    }
  }

}

#--------------------------------------------------------------
#
#    force an action to be executed
#    . recovery is never executed by this way
#    . must be reserved to general initialization action
#
#--------------------------------------------------------------

sub force_action {

  my ($action_name, $param) = @_ ;
  
  if (!defined($action_array{$action_name})) {
    COMMON::error("ERROR: action $action_name unknown"); ;
    return;
  }

  # action_forced is tested when performing interrupt testing
  $action_forced = TRUE;

  set_progress($action_name, $param, "");
  execute_action($action_name, $param);

  $action_forced = FALSE;
}

#--------------------------------------------------------------
#
#   sequencer initialization
#
#--------------------------------------------------------------

sub init {

  load_modules();
  load_state();
}

{
}
