#!/usr/bin/perl
# ------------------------------------------------------------------------------
#  ident "@(#)dialog.pl 1.8 03/04/16 SMI"
# ------------------------------------------------------------------------------
#
#  Copyright 2001-2003 Sun Microsystems, Inc. All rights reserved.
#
# ------------------------------------------------------------------------------

package DIALOG ;

use variables;

require "$ENV{NHINSTALL_LIB}/tools/lib/conf.pl";
require "$ENV{NHINSTALL_LIB}/tools/lib/common.pl";

#------------------------------------------------------------------------------
#
# ask for boot
#
#------------------------------------------------------------------------------

sub ask_for_boot {
  
  my $c = "";

  print "Boot both master-eligible nodes.\n";
  print " On the console of each master-eligible node:\n";
  print " 1. Get the boot prompt.\n";
  print " 2. At the ok prompt, type:\n";
  print "        ok> boot net - install\n" ;
  while (($c ne "y") && ($c ne "Y")) {
    print "Answer 'y' after the command has been entered on both master-eligible nodes: ";
    chomp($c = <STDIN>) ;
  }
}

#------------------------------------------------------------------------------
#
# ask for end of Solaris installation
#
#------------------------------------------------------------------------------

sub ask_for_solaris_installation {
  
  my $c = "";

  print "Boot both master-eligible nodes.\n";
  print " On the console of each master-eligible node:\n";
  print " 1. Enable the boot prompt.\n";
  print " 2. At the ok prompt, type:\n" ;
  print "        ok> boot net - install\n" ;
  print "Wait until both installations are complete.\n";
  while (($c ne "y") && ($c ne "Y")) {
    print "Answer 'y' when the boot is complete on both nodes: ";
    chomp($c = <STDIN>) ;
  }

}

#------------------------------------------------------------------------------
#
# ask for reboot of MEN
#
#------------------------------------------------------------------------------

sub ask_for_men_reboot {

  ($NODE_ID) = @_;

  my $c = "";
  my $nodename = COMMON::get_external_name($NODE_ID);

  print "Reboot the master-eligible node $nodename\n";
  print "On the console of $nodename (login: root, password: $PASSWORD), type:\n";
  print "    # init 6\n" ;
  print "Wait for the console login prompt.\n";
  while (($c ne "y") && ($c ne "Y")) {
    print "Answer 'y' when it has been displayed: ";
    chomp($c = <STDIN>) ;
  }

}

#------------------------------------------------------------------------------
#
# ask for diskless
#
#------------------------------------------------------------------------------

sub ask_for_diskless {
  
  my $c = "";

  my $diskless_env = "YES";

  if (scalar(@NODE_LIST) <= 2) {
    print "No diskless defined.\n";
    while (($c ne "y") && ($c ne "Y") && ($c ne "n") && ($c ne "N")) {
      print "Do you want to install the Solaris services for diskless nodes anyway [y/n]: ";
      chomp($c = <STDIN>) ;
    }
    if (($c eq "n") || ($c eq "N")) {
      $diskless_env = "NO";
    }
  }

  SEQUENCER::set_data("DISKLESS_ENV", $diskless_env);
}

#------------------------------------------------------------------------------
#
# explaining how to boot diskless
#
#------------------------------------------------------------------------------

sub boot_diskless {
  
  print "Setup the eeprom boot paramaters on your diskless nodes:\n";
  print "At the ok prompt type:\n" ;
  print "        ok> setenv local-mac-address? true\n";
  print "        ok> setenv auto-boot-retry? true\n";
  print "        ok> setenv diag-switch? false\n";
  print "        ok> setenv boot-device net:dhcp,,,,,5 net2:dhcp,,,,,5\n";
  print "You can now boot your diskless nodes.\n";
}
