#!/usr/bin/perl
# ------------------------------------------------------------------------------
#   ident "@(#)nmen_solaris.pl 1.33 02/11/07 SMI"
# ------------------------------------------------------------------------------
#
#  Copyright 2001 Sun Microsystems, Inc. All rights reserved.
#
# ------------------------------------------------------------------------------
package NMEN_SOLARIS;

use variables;

#-------------------------------------------------------------------------------
#
# Set up OS services based on smosservice
#
#-------------------------------------------------------------------------------

sub smosservice {

   my ($proto_node_id,) = @_;
   my $proto_name = COMMON::build_node_name($proto_node_id, "");
   my $proto_ip   = COMMON::get_external_ip($proto_node_id);
   my $Solaris_file ="/var/sadm/system/admin/services/$TARGET_OS";
   my $local_solaris="$WORKING_DIR/solaris.tmp";
   my $local_bootparams ="$WORKING_DIR/bootparams_${proto_name}";
   my $remote_bootparams = "/etc/bootparams";
   my $idx;

   my $proto_name_if0;
   my $proto_name_cgtp;

   $proto_name_if0 = COMMON::build_node_name($proto_node_id, "NIC0");
   if ($USE_CGTP eq "YES") {
     $proto_name_cgtp = COMMON::build_node_name($proto_node_id, "CGTP");
   }
   
   $SERVICE_DIR = "/export/root/clone";

   #
   # Test the SOLARIS_DIR directory tree
   #
   COMMON::control_dir_is_readable ("$SOLARIS_DIR");
   
   #
   # remotely create /os (mandatory for smosservice Solaris mount point (bug))
   #
   COMMON::remote_exec ( "$proto_ip", "$RMKDIR -p /os" ) ||
     COMMON::error ( "Unable to create directory /os" );
	
   #
   # If it is MEN1 (master) : remotely execute smosservice
   #
   #
   # If it is MEN2 (vice-master), retrieve /var/sadm/system/admin/services/<os> 
   # from MEN1 and create /etc/bootparams
   #
   if ( $proto_node_id eq $MEN1_ID ) {

     #
     # mount SOLARIS_DIR
     #   
     COMMON::remote_mount($proto_ip, $SOLARIS_DIR, "/os") ;

     # execute smossservices
     COMMON::remote_exec ( "$proto_ip", "$RSMOSSERVICE add -p $PASSWORD -- -x mediapath=/os -x platform=sparc.$ARCH.$TARGET_OS -x cluster=SUNWCuser -x locale=$LOCALE" ) ||
       COMMON::error ( "Unable to execute $RSMOSSERVICE add -p $PASSWORD -- -x mediapath=/os -x platform=sparc.$ARCH.$TARGET_OS -x cluster=SUNWCuser -x locale=$LOCALE" );

     #
     # umount SOLARIS_DIR
     #   
     COMMON::remote_exec ( "$proto_ip", "$RUMOUNT /os" ) || 
       COMMON::error ( "Unable to NFS umount /os" );

   } else {
     # proto_node_id is MEN2
     #
     # retrieve /var/sadm/system/admin/services/<os>
     #
     my $men1_ip = COMMON::get_external_ip($MEN1_ID);
     COMMON::get_file($men1_ip, "$Solaris_file", "$local_solaris");
     COMMON::put_file($proto_ip, "$local_solaris", "$Solaris_file");
       		
     #
     # create bootparams file
     #
     open(BOOTPARAMS, ">${local_bootparams}") ||
       COMMON::error("Unable to create ${local_bootparams}");
     if ($USE_CGTP eq "YES") {
       print BOOTPARAMS "${proto_name_cgtp} boottype=:os\n";	
     } else {
       print BOOTPARAMS "${proto_name_if0} boottype=:os\n";	
     }
     close(BOOTPARAMS);	
     
     #
     # remote copy bootparams
     #
     COMMON::put_file($proto_ip, $local_bootparams, $remote_bootparams);
     
   }
 }

#-------------------------------------------------------------------------------
#
# Remove OS services
#
#-------------------------------------------------------------------------------
sub smosservice_cleanup {

   my ($node_id) = @_;
   my $node_ip   = COMMON::get_external_ip($node_id);
   
   my $loc = "/export/$TARGET_OS" ;

   # requires node to be reboot first (to remove running daemons
   # that can't be stopped by another way

   if ($AUTO_REBOOT eq "YES") {
     $REBOOT = "SOL";
     REBOOT::reboot($node_id);
   } else {
     DIALOG::ask_for_men_reboot($node_id);
   }

   COMMON::mount_nmen($node_id);
   COMMON::remote_exec("$node_ip", "$RRM -Rf $loc") ;
   COMMON::remote_exec("$node_ip", "$RRM -Rf /export/root/clone") ;
 }

#-------------------------------------------------------------------------------
#
# Set up OS services based on netraos
#
#-------------------------------------------------------------------------------

sub netraos {

   my ($proto_node_id) = @_;
   my $proto_name = COMMON::build_node_name($proto_node_id, "");
   my $proto_ip   = COMMON::get_external_ip($proto_node_id);
   my $dcservices_dir = "/var/sadm/system/admin/dcservices";
   my $dcservices_file ="$dcservices_dir/$TARGET_OS";
   my $local_dcservices="$WORKING_DIR/dcservices.tmp";
   my $local_bootparams ="$WORKING_DIR/bootparams_${proto_name}";
   my $remote_bootparams = "/etc/bootparams";
   my $idx;
   
   my $service_root_dir = "/export/exec";
   $SERVICE_DIR = "$service_root_dir/$TARGET_OS";

   #
   # Test the SOLARIS_DIR directory tree
   #
   COMMON::control_dir_is_readable ("$SOLARIS_DIR");

   #
   # remotely create /os (mandatory for smosservice Solaris mount point (bug))
   #
   COMMON::remote_exec ( "$proto_ip", "$RMKDIR -p /os" ) ||
     COMMON::error ( "Unable to create directory /os" );
	
   #
   # If it is MEN1 (master) : remotely execute smosservice
   #
   #
   # If it is MEN2 (vice-master) : issue 15 : retrieve /var/sadm/system/admin/services/<os> 
   # from MEN1 and create /etc/bootparams
   #
   if ( $proto_node_id eq $MEN1_ID ) {

     my $target_version = 8;
     if ($TARGET_OS eq "Solaris_9") {
       $target_version = 9;
     }

     #
     # mount SOLARIS_DIR
     #   
     COMMON::remote_mount($proto_ip, $SOLARIS_DIR, "/os") ;

     #
     # create service
     #

     COMMON::remote_exec("$proto_ip", "$RMKDIR -p $service_root_dir") || 
       COMMON::error("Unable to create $service_root_dir");
       
     COMMON::print_subaction("creating $TARGET_OS service ...");
     COMMON::remote_exec("$proto_ip",
			 "$RNETRAOS add -o Solaris -v $target_version -a sparc -p $ARCH -r $SERVICE_DIR -m SUNWCuser -M /os -l $LOCALE $TARGET_OS") ||
			   COMMON::error("Unable to create Solaris environment for diskless");
			   
     COMMON::remote_exec("$proto_ip",
			 "$RCOPY /etc/nsswitch.conf $SERVICE_DIR/etc/nsswitch.conf");


     #
     # umount SOLARIS_DIR
     #   
     COMMON::remote_exec ( "$proto_ip", "$RUMOUNT /os" ) || 
       COMMON::error ( "Unable to NFS umount /os" );
	
   } else {
     # proto_node_id is MEN2
     #
     # retrieve /var/sadm/system/admin/dcservices/<os> from MEN1 and copy it on MEN2
     #
     my $men1_ip = COMMON::get_external_ip($MEN1_ID);
     COMMON::transfer_file($men1_ip, $proto_ip, $dcservices_file);
   }
 }

#-------------------------------------------------------------------------------
#
# Remove Netra  OS services
#
#-------------------------------------------------------------------------------

sub netraos_cleanup {

   my ($node_id) = @_;
   my $node_ip   = COMMON::get_external_ip($node_id);
   
   my $loc = "/export/exec/$TARGET_OS" ;

   COMMON::remote_exec("$node_ip", "$RRM -Rf /var/sadm/system/admin/dcservices/*") ;
   COMMON::remote_exec("$node_ip", "$RRM -Rf $loc") ;
 }

#-------------------------------------------------------------------------------
#
# installation of Solaris environment for diskless
#
#-------------------------------------------------------------------------------

sub nmen_solaris {

  ($NODE_ID) = @_;

  if ($SOLARIS_INSTALL eq "NO") {
    return ;
  }

  COMMON::init_and_check([SOLARIS_DIR]);

  # just for displaying the correct messages
  if ($NODE_ID eq $MEN1_ID) {
    
    COMMON::print_stage_node("Solaris OS services installation for diskless") ;
    my $duration = 40 ;

    if ($ENV{OPTIMIZED_INSTALL} eq "YES") {
      $duration = 20;
    }
    COMMON::print_action("this operation may take about $duration minutes to complete") ;
        
  } else {
    COMMON::print_stage_node("Bootparams configuration for diskless") ;
  }
  
  # real operation
  if ($USE_DCSS eq "YES") {
    netraos($NODE_ID);
  } else {
    smosservice($NODE_ID);
  }
}

#-------------------------------------------------------------------------------
#
# recovery after failure when installing Solaris environment for diskless
#
#-------------------------------------------------------------------------------

sub recovery_nmen_solaris {

  ($NODE_ID) = @_;

  if ($SOLARIS_INSTALL eq "NO") {
    return ;
  }

  COMMON::init_and_check([SOLARIS_DIR]);

  if ($NODE_ID eq $MEN1_ID) {
    COMMON::print_recovery_node("Solaris OS services for diskless clean-up") ;
    
    if ($USE_DCSS eq "YES") {
      netraos_cleanup($NODE_ID)
    } else {
      smosservice_cleanup($NODE_ID) ;
    }
    
  }
}

{
}

