#!/usr/bin/perl
# -----------------------------------------------------------------------------
#  ident "@(#)nmen_fsconf.pl 1.8 02/10/22 SMI"  
# -----------------------------------------------------------------------------
#
#  Copyright 2001 Sun Microsystems, Inc. All rights reserved.
#
# -----------------------------------------------------------------------------

package NMEN_FSCONF;

use variables;

#------------------------------------------------------------------------------
#
# remove blank line, comments from dfstab
#
#------------------------------------------------------------------------------
sub clean_dfstab {
   my ($file) = @_;

   my $before_root_entry;
   my $root_till_end_line;
   my $cgha_before_flag;
   my $cgha_after_flag;
   
   open (FILE, $file ) || COMMON::error("Unable to open $file");
   open (FILE_TMP, ">${file}.tmp" ) || COMMON::error("Unable to open ${file}.tmp");
   
   while ( <FILE> ) {
     
     # ignore comment
     chop();
     s/#.*//;
     if ($_ eq "") {
       next ;
     }

     #ignore line that doesn't match what we want
     ($before_root_entry, $root_till_end_line) = split (/,/, $_) ;
     
     if (! defined($before_root_entry)) {
       next;
     }
     

     print FILE_TMP "$_\n";
   }
   close (FILE);
   close (FILE_TMP);
   
   COMMON::exec_cmd ( "$MV ${file}.tmp ${file}") ||
     COMMON::error ( "Unable to move ${file}.tmp ${file}");
   
   # Remove the comments lines (specially those added by CRFS : CGHA START & CGHA END)
   
   open (FILE, $file ) || COMMON::error("Unable to open $file");
   open (FILE_TMP, ">${file}.tmp" ) || COMMON::error("Unable to open ${file}.tmp");
   
   while ( <FILE> ) {
     chop();
     ($cgha_before_flag, $cgha_after_flag) = split ("#", $_);
     if (!defined($cgha_after_flag) || ("$cgha_after_flag" eq "")) {
       print FILE_TMP "$_\n";
     }
     next;
   }
   close (FILE);
   close (FILE_TMP);
   
   COMMON::exec_cmd ( "$MV ${file}.tmp ${file}") ||
     COMMON::error ( "Unable to move ${file}.tmp ${file}");
 }

#------------------------------------------------------------------------------
#
# update address entry in share lines to have:
#  -o [ rw | ro ]=$name:$name_nic1:$name_cgtp0,root=$name:$name_nic1:$name_cgtp0
#
#------------------------------------------------------------------------------
sub update_address_in_file {
   my ($file, $name, $name_nic0, $name_nic1, $name_cgtp0) = @_;

   my $count=0;
   my $before_root_entry;
   my $root_till_end_line;
   my $cgha_before_flag;
   my $cgha_after_flag;
   my $root_entry;
   my $new_root;
   my $new_entry;
   my $fs_Path;
   my $current_access;
   my $share_entry ="share -F nfs -o";
   my $access_entry_ro ="ro=${name}";
   my $access_entry_rw ="rw=${name}";

   # Update the rw= or ro= with the triplet diskless addresses
   # Update the root= with the triplet diskless addresses
   
   open (FILE, $file ) || COMMON::error("Unable to open $file");
   open (FILE_TMP, ">${file}.tmp" ) || COMMON::error("Unable to open ${file}.tmp");
   
   while ( <FILE> ) {
     
     # ignore comment
     chop();
     s/#.*//;
     if ($_ eq "") {
       next ;
     }

     ($before_root_entry, $root_till_end_line) = split (/,/, $_) ;
     
     if (! defined($before_root_entry)) {
       next;
     }
     
     if (( "$before_root_entry" ne "${share_entry} ${access_entry_rw}" ) 
	 && ( "$before_root_entry" ne "${share_entry} ${access_entry_ro}" )) {
       print FILE_TMP "$_\n";
     } else {
       $current_access="ro";
       if ( "$before_root_entry" eq "${share_entry} ${access_entry_rw}" ) {
	 $current_access="rw";
       }
       ($root_entry, $fs_path) = split(/ /, $root_till_end_line);
       if ($USE_CGTP eq "YES") {
	 $new_root="root=${name_nic0}:${name_nic1}:${name_cgtp0}";
	 $new_access="${current_access}=${name_nic0}:${name_nic1}:${name_cgtp0}";
       } else {
	 $new_root="root=${name_nic0}";
	 $new_access="${current_access}=${name_nic0}";
       }
       $new_entry="${share_entry} ${new_access},${new_root} ${fs_path}";
       print FILE_TMP "${new_entry}\n";
     }
     next; 	        
   }
   close (FILE);
   close (FILE_TMP);
   
   COMMON::exec_cmd ( "$MV ${file}.tmp ${file}") ||
     COMMON::error ( "Unable to move ${file}.tmp ${file}");
   
   # Remove the comments lines (specially those added by CRFS : CGHA START & CGHA END)
   
   open (FILE, $file ) || COMMON::error("Unable to open $file");
   open (FILE_TMP, ">${file}.tmp" ) || COMMON::error("Unable to open ${file}.tmp");
   
   while ( <FILE> ) {
     chop();
     ($cgha_before_flag, $cgha_after_flag) = split ("#", $_);
     if (!defined($cgha_after_flag) || ("$cgha_after_flag" eq "")) {
       print FILE_TMP "$_\n";
     }
     next;
   }
   close (FILE);
   close (FILE_TMP);
   
   COMMON::exec_cmd ( "$MV ${file}.tmp ${file}") ||
     COMMON::error ( "Unable to move ${file}.tmp ${file}");
}

#------------------------------------------------------------------------------
#
# update FS configuration file for MEN to add exported diskless directories
#
#------------------------------------------------------------------------------

sub update_men_fsconf {

  my $men_ip = COMMON::get_external_ip($NODE_ID);
  my $men1_ip = COMMON::get_external_ip($MEN1_ID);
  my $dfstab  = "$WORKING_DIR/dfstab.tmp";
  my $fsconf  = "$WORKING_DIR/fsconf.tmp";

  COMMON::print_action("Updating $FSCONF_FILE");

  # CAUTION: ONLY THE DFSTAB FROM MEN1 CONTAINS INFO ABOUT DISKLESS
  # USE IT EVEN FOR MEN2
  # get the /etc/dfstab file containing share command
  COMMON::get_file($men1_ip, "/etc/dfs/dfstab", $dfstab);

  # get the current fsconf file
  COMMON::get_file($men_ip, $FSCONF_FILE, $fsconf);

  #
  # remove all invalid lines in /etc/dfstab: clean-up is made when processing diskless
  # but it is not made if there is only the diskless environment
  #
  if (scalar(@NODE_LIST) <= 2) {
    clean_dfstab($dfstab);
  }

  #
  # locally update the dfstab file with all diskless triplet addresses.
  #

  for my $node (0..$#NODE_LIST) {
    if (($NODE_LIST[$node]{type} eq "DISKLESS") && ($NODE_LIST[$node]{concerned} eq "TRUE")) {
      my $node_id=$NODE_LIST[$node]{id};
      my $node_name_template = COMMON::build_node_name($node_id, "");
      my $node_name_if0_template = COMMON::build_node_name($node_id, "NIC0");
      my $node_name_if1_template = COMMON::build_node_name($node_id, "NIC1");
      my $node_name_cgtp0_template = COMMON::build_node_name($node_id, "CGTP");

      update_address_in_file($dfstab, "${node_name_template}", "${node_name_if0_template}",
			      "${node_name_if1_template}", "${node_name_cgtp0_template}") ||
				COMMON::error( "Unable to update diskless $node_name_template in $dfstab" );
    }
  }

  # look for the higher rank of RNFS.Share
  my $rank = -1;
  open(FSCONF, "<$fsconf");
  while (<FSCONF>) {
    chomp();
    s/#.*//;
    if ($_ eq "") {
      next ;
    }
    if ($_ =~ m/RNFS.SHARE.([0-9]*)[\s\t]*=/i) {
      if ($1 > $rank) {
	$rank = $1;
      }
    }
  }
  close(FSCONF);
  
  # for each line in dfstab, copy it into fsconf with the property name
  open(DFSTAB, "<$dfstab");
  open(FSCONF, ">>$fsconf");
  while (<DFSTAB>) {
    chomp();
    s/#.*//;
    if ($_ eq "") {
      next ;
    }
    $rank++;
    print FSCONF "RNFS.Share.$rank=$_\n";
  }
  close(DFSTAB);
  close(FSCONF);

  # update fsconf on MEN
  COMMON::put_file($men_ip, $fsconf, $FSCONF_FILE);
}

#------------------------------------------------------------------------------
#
# create an empty /etc/dfs/dfstab on MEN1
#
#------------------------------------------------------------------------------

sub nmen_reset_men1_dfstab {

  ($NODE_ID) = @_;

  my $men1_ip = COMMON::get_external_ip($MEN1_ID);
  my $men2_ip = COMMON::get_external_ip($MEN2_ID);

  COMMON::print_stage_node("Resetting /etc/dfs/dfstab");

  # create an empty dfstab on MEN1 by copying the dfstab from MEN2
  COMMON::transfer_file($men2_ip, $men1_ip, "/etc/dfs/dfstab");
}

#------------------------------------------------------------------------------
#
# create FS configuration file for NMEN
#
#------------------------------------------------------------------------------

sub create_nmen_fsconf {

  my $tmpfile =     "$WORKING_DIR/fsconf.tmp";


  COMMON::print_action("Creating $FSCONF_FILE on diskless");

  #
  # create and copy the configuration file on the MEN for each NMEN
  #

  my $node_ip = COMMON::get_external_ip($NODE_ID);

  for my $node (0..$#NODE_LIST) {
    if (($NODE_LIST[$node]{type} eq "DISKLESS") && ($NODE_LIST[$node]{concerned} eq "TRUE")) {
      
      my $node_id = $NODE_LIST[$node]{id};
      my $node_name_template = COMMON::build_node_name($node_id, "") ;
      
      COMMON::print_subaction("configuring $node_name_template ...");

      open(FSCONF, ">$tmpfile") ||
	COMMON::error("Can not create $tmpfile");

      #
      # common part
      #
      
      print FSCONF "Node.Type=Diskless\n";
      print FSCONF "Node.DomainId=$CLUSTER\n";
      print FSCONF "Node.NodeId=$node_id\n";

      if ($USE_CGTP eq "YES") {
	print FSCONF "Node.UseCGTP=True\n";
	print FSCONF "Node.Nic0=$NODE_LIST[$node]{nic0}\n";
	print FSCONF "Node.Nic1=$NODE_LIST[$node]{nic1}\n";
	print FSCONF "Node.NicCgtp=$CGTP_INTERFACE\n";
      } else {
	print FSCONF "Node.UseCGTP=False\n";
	print FSCONF "Node.Nic0=$NODE_LIST[$node]{nic0}\n";
      }

      #
      # CLUSTER part
      # 
      print FSCONF "Cluster.Master.Id=$MASTER_ID\n";
      
      # RNFS
      print FSCONF "Node.RNFS.Installed=False\n";
      
      #
      # CMM part
      #
      
      print FSCONF "CMM.isEligible=False\n";
      print FSCONF "CMM.MiniConfig.Dir=$FSCONF_DIR\n";
      print FSCONF "CMM.MiniConfig.File=target.conf\n";
      
      close(FSCONF);

      COMMON::put_file($node_ip, "$tmpfile", "/export/root/$node_name_template/$FSCONF_FILE");
      
      unlink($tmpfile);
    }
  }

}

#------------------------------------------------------------------------------
#
# configure fs for a MEN
#
#------------------------------------------------------------------------------

sub nmen_fsconf {

  ($NODE_ID) = @_;

  COMMON::init_and_check([]);
  
  COMMON::print_stage_node("Foundation Services configuration for diskless") ;
  
  update_men_fsconf();

  if ($NODE_ID eq $MEN1_ID) {
    create_nmen_fsconf();
  }
}

{
}







