#!/usr/bin/perl
# ------------------------------------------------------------------------------
#   ident "@(#)nmen_end.pl 1.18 02/11/07 SMI"
# ------------------------------------------------------------------------------
#
#  Copyright 2001 Sun Microsystems, Inc. All rights reserved.
#
# ------------------------------------------------------------------------------

package NMEN_END;

use variables;

#-------------------------------------------------------------------------------
#
# update node reference in /etc/vfstab
#
# Replace all references to a node with logical address of master interface 
# typically for root partition of a diskless
#
#-------------------------------------------------------------------------------

sub update_vfstab_master {
  my ( $vfstab_file, $update_nfs_ip_address_input ) = @_ ;
  my $update_nfs_ip_address;
  my $update_nfs_value;
  my $line ;

  open (VFSTAB, $vfstab_file ) || COMMON::error("Unable to open $vfstab_file");
  open (VFSTAB_TMP, ">${vfstab_file}.tmp" ) || COMMON::error("Unable to open ${vfstab_file}.tmp");
  
  while ( <VFSTAB> ) {
    
    chop();
    $line = $_ ;
    s/#.*//;
    ($update_nfs_ip_address, $update_nfs_value) = split (/:/, $_) ;
    
    if (defined($update_nfs_value) && ( "$update_nfs_value" ne "" )) {
      print VFSTAB_TMP "$update_nfs_ip_address_input:$update_nfs_value\n";
    } else {
      print VFSTAB_TMP "$line\n";
    }
    
    next;       	        
  }
  close (VFSTAB);
  close (VFSTAB_TMP);
  
  COMMON::exec_cmd ( "$MV ${vfstab_file}.tmp ${vfstab_file}") ||
    COMMON::error ( "Unable to move ${vfstab_file}.tmp ${vfstab_file}");  
}

#-------------------------------------------------------------------------------
#
# update mounting point in /etc/vfstab 
#
#  add a mounting point in vfstab
#
#-------------------------------------------------------------------------------

sub update_vfstab_nfs {
  my ( $vfstab_file, $update_nfs_input, $update_nfs_value_input ) = @_ ;
  my $update_nfs;
  my $update_nfs_value;
  my $garbage;
  my $count = 0;
  my $line ;
  
  open (VFSTAB, $vfstab_file ) || COMMON::error("Unable to open $vfstab_file");
  open (VFSTAB_TMP, ">${vfstab_file}.tmp" ) || COMMON::error("Unable to open ${vfstab_file}.tmp");
  
  while ( <VFSTAB> ) {
    
    chop();
    $line = $_ ;
    s/#.*//;
    ($update_nfs, $garbage) = split (/\t/, $_) ;
    
    if (defined($update_nfs) && ( "$update_nfs" eq "$update_nfs_input" )) {
      print VFSTAB_TMP "$update_nfs\t$update_nfs_value_input\n";
      $count++;
    } else {
      print VFSTAB_TMP "$line\n";
    }
    next;       	        
  }
  close (VFSTAB);
  close (VFSTAB_TMP);
  
  unless ($count) {
    open (VFSTAB_TMP, ">>${vfstab_file}.tmp" ) || COMMON::error("Unable to update $vfstab_file");
    print VFSTAB_TMP "$update_nfs_input\t$update_nfs_value_input\n";
    close (VFSTAB_TMP);
  }
   
  COMMON::exec_cmd ( "$MV ${vfstab_file}.tmp ${vfstab_file}") ||
    COMMON::error ( "Unable to move ${vfstab_file}.tmp ${vfstab_file}");  
}



#-------------------------------------------------------------------------------
#
# VFSTAB end
#
#-------------------------------------------------------------------------------
sub vfstab_end {

  my ($proto_node_id) = @_;
  
  my $proto_ip   = COMMON::get_external_ip($proto_node_id);

  my $node_name_template;
  my $node_root;
	
  my $local_vfstab;
  my $remote_vfstab;

  my $master_name;
  my $master_nic0;
  my $master_cgtp;

  $master_nic0 = COMMON::build_node_name($MASTER_ID, "NIC0") ;
  $master_name = $master_nic0;
  if ($USE_CGTP eq "YES") {
    $master_cgtp = COMMON::build_node_name($MASTER_ID, "CGTP") ;
    $master_name = $master_cgtp;
  }

  COMMON::print_action("Updating /etc/vfstab") ;
	
  for $node (0..$#NODE_LIST) {

    if (($NODE_LIST[$node]{type} eq "DISKLESS") && ($NODE_LIST[$node]{concerned} eq "TRUE")) {
      
      $node_name_template = COMMON::build_node_name($NODE_LIST[$node]{id}, "");
      COMMON::print_subaction("for $node_name_template") ;

      $node_root = "/export/root/$node_name_template";
      
      $local_vfstab = "$WORKING_DIR/vfstab_${node_name_template}";
      $remote_vfstab = "$node_root/etc/vfstab";
						
      #
      # retrieve diskless node /etc/vfstab file
      #
      COMMON::get_file($proto_ip, "$remote_vfstab", "$local_vfstab");
			
      # 
      # update mounted ip address with master_ip
      #
      update_vfstab_master($local_vfstab, $master_name);

      #
      # add an entry for each remote directory
      for $i (0..$#DIR_MOUNTED) {
	# create the mounting point
	COMMON::remote_exec( $proto_ip, "$RMKDIR -p $node_root/$DIR_MOUNTED[$i]{local}" ) ||
	  COMMON::error ( "Unable to create $node_root/$DIR_MOUNTED[$i]{local}" );

	update_vfstab_nfs($local_vfstab,"${master_name}:$DIR_MOUNTED[$i]{remote}","-\t$DIR_MOUNTED[$i]{local}\tnfs\t-\tyes\trw,hard,fg,intr,noac")
	}
      #
      # putback modified proto_node /etc/vfstab on diskless node branch
      #
      COMMON::put_file($proto_ip, "$local_vfstab", "$remote_vfstab");
    }
    
  }

}

	
#-------------------------------------------------------------------------------
#
# remote the configured file
#
#-------------------------------------------------------------------------------

sub cmm_end {

  my ($proto_node_id) = @_;

  my $proto_ip   = COMMON::get_external_ip($proto_node_id);
	
  my $node_name_template;
  my $node_root;
  
  my $config_in_progress;

  COMMON::print_action("Removing /etc/opt/SUNWcgha/not_configured file");
  
  for $node (0..$#NODE_LIST) {
	
    my $node_id = $NODE_LIST[$node]{id};
    $node_name_template = COMMON::build_node_name($node_id, "");

    if (($NODE_LIST[$node]{type} eq "DISKLESS") && ($NODE_LIST[$node]{concerned} eq "TRUE")) {
      
      COMMON::print_subaction("for $node_name_template") ;
      $node_root = "/export/root/$node_name_template";
      
      $config_in_progress = "$node_root/etc/opt/SUNWcgha/not_configured";				
      
      #
      # remove file /etc/opt/SUNWcgha/not_configured on diskless node
      #
      COMMON::remote_exec( "$proto_ip", "$RRM -f $config_in_progress" ) ||
	COMMON::error ( "Unable to remove $config_in_progress file" );	
      
    }
  }
}

#-------------------------------------------------------------------------------
#
# remote the configured file
#
#-------------------------------------------------------------------------------

sub nmen_end {

  ($NODE_ID) = @_;

  COMMON::init_and_check([]);

  COMMON::print_stage_node("Foundation services post-installation for diskless") ;
  vfstab_end ($NODE_ID);
  cmm_end ($NODE_ID);
}

{
}







