#!/usr/bin/perl
# ------------------------------------------------------------------------------
#   ident "@(#)nmen_cgtp.pl 1.19 02/11/07 SMI"
# ------------------------------------------------------------------------------
#
#  Copyright 2001 Sun Microsystems, Inc. All rights reserved.
#
# ------------------------------------------------------------------------------

package NMEN_CGTP;

use variables;
    

#------------------------------------------------------------------------------
#
# Configure CGTP and/or network
#
#------------------------------------------------------------------------------
sub net_configure {

  my ($proto_node_id) = @_;
  
  my $proto_name =  COMMON::build_node_name($proto_node_id, "");
  my $proto_ip   = COMMON::get_external_ip($proto_node_id);
  my $proto_net_if0;
  my $proto_net_if1;
  my $proto_net_cgtp0;
    
  my $hostname_if0;
  my $hostname_if1;
  my $proto_hosts = "$WORKING_DIR/hosts_${proto_name}";
  
  my $proto_netmasks;
  
  my $node_name_template;
  my $node_name_if0_template;
  my $node_name_if1_template;
  
  my $node_root;

  $proto_net_if0   = $CLUSTER_DOTTED_NIC0_NET;
  if ($USE_CGTP eq "YES") {
    $proto_net_if1   = $CLUSTER_DOTTED_NIC1_NET;
    $proto_net_cgtp0 = $CLUSTER_DOTTED_CGTP_NET;
  }
  
  
  for my $node (0..$#NODE_LIST) {
    
    if ($NODE_LIST[$node]{type} eq "DISKLESS") {
      
      my $node_id = $NODE_LIST[$node]{id};
      
      $node_name_template =  COMMON::build_node_name($node_id, "");
      $node_name_if0_template =  COMMON::build_node_name($node_id, "NIC0");
      $node_root = "/export/root/$node_name_template";      
      $proto_netmasks = "$WORKING_DIR/netmasks_${node_name_template}";
      $hostname_if0 = "/etc/hostname.$NODE_LIST[$node]{nic0}";

      if ($USE_CGTP eq "YES") {
	$node_name_if1_template =  COMMON::build_node_name($node_id, "NIC1");
	$hostname_if1 = "/etc/hostname.$NODE_LIST[$node]{nic1}";
      }

      #
      # remote create diskless node /etc/hostname.<nic0>
      #
      COMMON::remote_exec ( "$proto_ip", "echo $node_name_if0_template > $node_root/$hostname_if0") || 
	COMMON::error ( "Unable to create $node_root/$hostname_if0" );
      
      #
      # remote create diskless node /etc/hostname.<nic1>
      #
      if ($USE_CGTP eq "YES") {
	COMMON::remote_exec ( "$proto_ip", "echo $node_name_if1_template > $node_root/$hostname_if1") || 
	  COMMON::error ( "Unable to create $node_root/$hostname_if1" );
      }

      #
      # remote create diskless node /etc/hostname.<pubNic>
      #
      if ($USE_PUBLIC_NETWORK eq "YES") {
	my $hostname_pub = "/etc/hostname.$NODE_LIST[$node]{pubNic}";
	COMMON::remote_exec ( "$proto_ip", "echo $NODE_LIST[$node]{pubName} > $node_root/$hostname_pub") || 
	  COMMON::error ( "Unable to create $node_root/$hostname_pub" );
      }

      
      #
      # retrieve diskless node /etc/netmasks 
      #
      COMMON::get_file($proto_ip, "$node_root/etc/netmasks", "$proto_netmasks");
      
      #
      # modify locally proto_node /etc/netmasks 
      #
      COMMON::add_netmask( $proto_netmasks, $proto_net_if0, 
			   $CLUSTER_DOTTED_NETMASK);
      if ($USE_CGTP eq "YES") {
	COMMON::add_netmask( $proto_netmasks, $proto_net_if1, 
			     $CLUSTER_DOTTED_NETMASK);
	COMMON::add_netmask( $proto_netmasks, $proto_net_cgtp0, 
			     $CLUSTER_DOTTED_NETMASK);
      }
      if ($USE_PUBLIC_NETWORK eq "YES") {
	COMMON::add_netmask( $proto_netmasks, $PUBLIC_DOTTED_NETWORK, 
			     $PUBLIC_DOTTED_NETMASK)
      }
      
      #
      # putback modified proto_node /etc/netmasks
      #
      COMMON::put_file($proto_ip, "$proto_netmasks", "$node_root/etc/netmasks");
      
      #
      # create /etc/hosts
      #
      COMMON::create_hosts_file($proto_hosts, $node_id);
      COMMON::put_file($proto_ip, "$proto_hosts", "$node_root/etc/hosts");
    }
  }
}

		       
#------------------------------------------------------------------------------
#
# installation of CGTP
#
#------------------------------------------------------------------------------

sub nmen_cgtp {

  ($NODE_ID) = @_;

  COMMON::init_and_check([]);

  if ($USE_CGTP eq "YES") {

    my $cgtp_packages = $ENV{CGTP_PACKAGES};

    COMMON::print_stage_node("Carrier-Grade Transport Protocol (CGTP) installation for diskless") ;
    COMMON::install_nmen_pkg($NODE_ID, $ROOT_DIR, $PACKAGE_SUBDIR, $cgtp_packages, "");

    COMMON::print_action("CGTP configuration") ;
    net_configure ($NODE_ID);
    
  } else {
    
    COMMON::print_stage_node("Network configuration for diskless") ;
    
    net_configure ($NODE_ID);
    
  }
}

#------------------------------------------------------------------------------
#
# adding a new host in the already installed diskless
#
#------------------------------------------------------------------------------

sub nmen_cgtp_add_nodes {

  ($NODE_ID) = @_;
  
  my $proto_hosts = "$WORKING_DIR/hosts";
  my $proto_ip = COMMON::get_external_ip($NODE_ID);

  COMMON::print_stage_node("Network configuration for already installed diskless") ;
  
  for my $node (0..$#NODE_LIST) {
    
    # if it's an already installed diskless
    if (($NODE_LIST[$node]{type} eq "DISKLESS") && ($NODE_LIST[$node]{concerned} ne "TRUE")) {
      
      my $node_id = $NODE_LIST[$node]{id};
      
      $node_name_template =  COMMON::build_node_name($node_id, "");			      
      $node_root = "/export/root/$node_name_template";
      
      #
      # retrieve the /etc/hosts file
      #
      COMMON::get_file($proto_ip, "$node_root/etc/hosts", "$proto_hosts");

      # add a entry for each new node
      for my $newnode (0..$#NODE_LIST) {
	if ($NODE_LIST[$newnode]{concerned} eq "TRUE") {
	  COMMON::add_hosts_file_entry($proto_hosts, $newnode, $NODE_LIST[$node]{id});
	}
      }

      #
      # put the /etc/hosts back
      #
      COMMON::put_file($proto_ip, "$proto_hosts", "$node_root/etc/hosts");
    }
  }
}

{
}








