#!/usr/bin/perl
# -----------------------------------------------------------------------------
#  ident "@(#)men_fsconf.pl 1.8 03/06/18 SMI"  
# -----------------------------------------------------------------------------
#
#  Copyright 2001 Sun Microsystems, Inc. All rights reserved.
#
# -----------------------------------------------------------------------------

package MEN_FSCONF;

use variables;

#------------------------------------------------------------------------------
#
# create FS configuration file for MEN
#
#------------------------------------------------------------------------------

sub create_fsconf {

  my $tmpfile =     "$WORKING_DIR/fsconf.tmp";
  my $node;

  COMMON::print_action("Creating $FSCONF_FILE");
  open(FSCONF, ">$tmpfile") ||
    COMMON::error("Can not create $tmpfile");

  #
  # common part
  #

  $node = COMMON::getnode($NODE_ID);

  print FSCONF "Node.Type=Diskfull\n";
  print FSCONF "Node.NodeId=$NODE_ID\n";
  print FSCONF "Node.DomainId=$CLUSTER\n";

  if ($USE_CGTP eq "YES") {
    print FSCONF "Node.UseCGTP=True\n";
    print FSCONF "Node.Nic0=$NODE_LIST[$node]{nic0}\n";
    print FSCONF "Node.Nic1=$NODE_LIST[$node]{nic1}\n";
    print FSCONF "Node.NicCgtp=$CGTP_INTERFACE\n";
  } else {
    print FSCONF "Node.UseCGTP=False\n";
    print FSCONF "Node.Nic0=$NODE_LIST[$node]{nic0}\n";
  }

  #
  # CLUSTER part
  # 

  print FSCONF "Cluster.Master.Id=$MASTER_ID\n";

  # BugId 4813153
  print FSCONF "Cluster.DataManagementPolicy=$DATA_MGT_POLICY\n";

  #
  # CMM part
  #

  print FSCONF "CMM.isEligible=True\n";
  print FSCONF "CMM.MiniConfig.Dir=$FSCONF_DIR\n";
  print FSCONF "CMM.MiniConfig.File=target.conf\n";
  print FSCONF "CMM.LocalConfig.Dir=$FSCONF_DIR\n";

  #
  # RNFS part
  #
  print FSCONF "Node.RNFS.Installed=True\n";
  print FSCONF "RNFS.StatdAlternatePath=$SLICE_SUNWCGHA\n";

  print FSCONF "RNFS.SyncType=$SYNC_TYPE\n";

  # RNFS.Slice

  for my $i (0..$#SLICE_LIST) {
    if ($SLICE_LIST[$i]{bitmap} ne "") {
      my $bitmap_index;
      # look for the raw name of the bitmap slice (because of SVM)
      CONF::slice_search("name", $SLICE_LIST[$i]{bitmap}, \$bitmap_index);
      print FSCONF "RNFS.Slice.$i=$SLICE_LIST[$i]{raw} $SLICE_LIST[$bitmap_index]{raw} $SLICE_LIST[$i]{raw} $SLICE_LIST[$bitmap_index]{raw} 1\n" ;
     }
   }

  # RNFS.Share

  # build the node name list
  my $node_string = "";
  for $node (0..$#NODE_LIST) {
    my $node_id = $NODE_LIST[$node]{id};

    my $nicname = "CGTP" ;
    if ($USE_CGTP ne "YES") {
      $nicname = "NIC0" ;
    }

    if ($node_string eq "") {
      $node_string = COMMON::build_node_name($node_id, $nicname);
    } else {
      $node_string .= ":" . COMMON::build_node_name($node_id, $nicname) ;
    }
  }

  # create properties for each exported directory
  for my $i (0..$#DIR_EXPORTED) {
    print FSCONF "RNFS.Share.$i=share -F nfs -o rw,root=$node_string $DIR_EXPORTED[$i]\n";
  }
  
  # NSM part
  if ($USE_NSM eq "YES") {

    print FSCONF "NSM.Exec.Masterdir=/opt/SUNWcgha/actions/master\n";
    print FSCONF "NSM.Exec.Vicemasterdir=/opt/SUNWcgha/actions/vicemaster\n";
    print FSCONF "NSM.Log.Masterdir=/var/adm/log/SUNWcgha/nsm_master\n";
    print FSCONF "NSM.Log.Vicemasterdir=/var/adm/log/SUNWcgha/nsm_vicemaster\n";
  }

  if ($USE_EXTERNAL_ACCESS eq "YES") {
    print FSCONF "NSM.External.Master.Address=$EXTERNAL_IP\n";
    print FSCONF "NSM.External.Master.Nic=$EXTERNAL_NIC\n";
  }

  close(FSCONF);

  #
  # copy the configuration file on the MEN
  #

  my $node_ip = COMMON::get_external_ip($NODE_ID);
  COMMON::put_file($node_ip, "$tmpfile", $FSCONF_FILE);
}

#-------------------------------------------------------------------------------
#
# update fs.conf: change authorized node for shared directory
#
#-------------------------------------------------------------------------------

sub update_fsconf_and_share {
 
  my $node_ip = COMMON::get_external_ip($NODE_ID);
  my $tmpfile = "$WORKING_DIR/fsconf.tmp";

  COMMON::print_action("Updating $FSCONF_FILE");

  COMMON::get_file($node_ip, $FSCONF_FILE, "$tmpfile");

  # RNFS.Share

  # build the node name list
  my $node_string = "";
  for $node (0..$#NODE_LIST) {
    my $node_id = $NODE_LIST[$node]{id};

    my $nicname = "CGTP" ;
    if ($USE_CGTP ne "YES") {
      $nicname = "NIC0" ;
    }

    if ($node_string eq "") {
      $node_string = COMMON::build_node_name($node_id, $nicname);
    } else {
      $node_string .= ":" . COMMON::build_node_name($node_id, $nicname) ;
    }
  }

  # update the existing line
  open(FSCONF, "<$tmpfile");
  open(FSCONFTMP, ">$tmpfile.new");
  while (<FSCONF>) {
    my $line = $_;
    chomp($line);
    if ($line =~ m/RNFS.SHARE.([0-9]*)[\s\t]*=[\s\t]*share[\s\t]*-F[\s\t]*nfs[\s\t]*-o[\s\t]*rw,root=[^\s\t]*[\s\t]*$DIR_SUNWCGHA_EXPORTED/i) {
      print FSCONFTMP "RNFS.Share.$1=share -F nfs -o rw,root=$node_string $DIR_SUNWCGHA_EXPORTED\n";
    } else {
      print FSCONFTMP "$_";
    }
  }
  close(FSCONF);
  close(FSCONFTMP);
 
  COMMON::put_file($node_ip, "$tmpfile.new", $FSCONF_FILE);
  unlink("$tmpfile");
  unlink("$tmpfile.new");
}

#-------------------------------------------------------------------------------
#
# configure fs for a MEN
#
#-------------------------------------------------------------------------------

sub men_fsconf {

  ($NODE_ID) = @_;
  
  COMMON::init_and_check([]);
  
  COMMON::print_stage_node("Foundation Services configuration") ;
  
  create_fsconf();
}

#-------------------------------------------------------------------------------
#
# update fs.conf when adding diskless
#
#-------------------------------------------------------------------------------

sub men_fsconf_add_nodes {

  ($NODE_ID) = @_;
  
  COMMON::init_and_check([]);
  
  COMMON::print_stage_node("Foundation Services configuration: adding new diskless nodes");
  
  update_fsconf_and_share();
}

{
}

