#!/usr/bin/perl
# ------------------------------------------------------------------------------
#   ident "@(#)men_cgtp.pl 1.15 02/11/07 SMI"
# ------------------------------------------------------------------------------
#
#  Copyright 2001 Sun Microsystems, Inc. All rights reserved.
#
# ------------------------------------------------------------------------------
package MEN_CGTP;

use variables;

#-------------------------------------------------------------------------------
#
# Configure CGTP and/or network 
#
#-------------------------------------------------------------------------------
sub net_configure {

   my ($proto_node_id) = @_;

   my $proto_name = COMMON::build_node_name($proto_node_id, "");
   my $proto_ip   = COMMON::get_external_ip($proto_node_id);

   my $proto_name_if0;
   my $proto_name_if1;
   my $proto_name_cgtp0;

   my $proto_ip_if1;
   my $proto_ip_cgtp0;
   my $proto_net_if0;
   my $proto_net_if1;
   my $proto_net_cgtp0;
   
   my $hostname_if0;
   my $hostname_if;
   my $hostname_cgtp0;
	
   my $proto_netmasks = "$WORKING_DIR/netmasks_${proto_name}";
   my $proto_hosts = "$WORKING_DIR/hosts_${proto_name}";

   my $node = COMMON::getnode($proto_node_id);
	
   $proto_name_if0   = COMMON::build_node_name($proto_node_id, "NIC0");
   $proto_net_if0   = $CLUSTER_DOTTED_NIC0_NET;
   $hostname_if0   = "/etc/hostname.$NODE_LIST[$node]{nic0}";

   if ($USE_CGTP eq "YES") {
     $proto_name_if1   = COMMON::build_node_name($proto_node_id, "NIC1");
     $proto_name_cgtp0 = COMMON::build_node_name($proto_node_id, "CGTP");
     
     $proto_ip_if1    = COMMON::build_node_ip($proto_node_id, "NIC1");
     $proto_ip_cgtp0  = COMMON::build_node_ip($proto_node_id, "CGTP");
     $proto_net_if1   = $CLUSTER_DOTTED_NIC1_NET;
     $proto_net_cgtp0 = $CLUSTER_DOTTED_CGTP_NET;
     
     $hostname_if1   = "/etc/hostname.$NODE_LIST[$node]{nic1}";
     $hostname_cgtp0 = "/etc/hostname.$CGTP_INTERFACE";
   }

   #
   # remote create /etc/hostname.<nic0> (already exists but incorrect)
   #
   COMMON::remote_exec ( "$proto_ip", "echo $proto_name_if0 > $hostname_if0") || 
     COMMON::error ( "Unable to create $hostname_if0" );

   if ($USE_CGTP eq "YES") {
     #
     # remote create /etc/hostname.<nic1>
     #
     COMMON::remote_exec ( "$proto_ip", "echo $proto_name_if1 > $hostname_if1") || 
       COMMON::error ( "Unable to create $hostname_if1" );

     #
     # remote create /etc/hostname.<cgtp>
     #
     COMMON::remote_exec ( "$proto_ip", "echo $proto_name_cgtp0 > $hostname_cgtp0") || 
       COMMON::error ( "Unable to create $hostname_cgtp0" );
   }

   if ($USE_PUBLIC_NETWORK eq "YES") {
     #
     # remote create /etc/hostname.<pubNic>
     #
     my $proto_name_pub = $NODE_LIST[$node]{pubName};
     my $hostname_pub = "/etc/hostname.$NODE_LIST[$node]{pubNic}";
     COMMON::remote_exec ( "$proto_ip", "echo $proto_name_pub > $hostname_pub") || 
       COMMON::error ( "Unable to create $hostname_pub" );
   }

   #
   # retrieve proto_node /etc/netmasks 
   #
   COMMON::get_file($proto_ip, "/etc/netmasks", "$proto_netmasks");
	
   #
   # modify locally proto_node /etc/netmasks 
   #

   COMMON::add_netmask( $proto_netmasks, $proto_net_if0, $CLUSTER_DOTTED_NETMASK);


   if ($USE_CGTP eq "YES") {
     COMMON::add_netmask( $proto_netmasks, $proto_net_if1, $CLUSTER_DOTTED_NETMASK);
     COMMON::add_netmask( $proto_netmasks, $proto_net_cgtp0, $CLUSTER_DOTTED_NETMASK);
   }
	
   if ($USE_PUBLIC_NETWORK eq "YES") {
     COMMON::add_netmask( $proto_netmasks, $PUBLIC_DOTTED_NETWORK, $PUBLIC_DOTTED_NETMASK );
   }

   #
   # putback modified proto_node /etc/netmasks
   #
   COMMON::put_file($proto_ip, "$proto_netmasks", "/etc/netmasks");
	
   #
   # retrieve /etc/hosts
   #
   COMMON::get_file($proto_ip, "/etc/hosts", "$proto_hosts");

   #
   # create locally proto_node /etc/hosts 
   #
   COMMON::update_hosts_file($proto_hosts, $proto_node_id) ;

   #
   # putback modified proto_node /etc/hosts
   #
   COMMON::put_file($proto_ip, "$proto_hosts", "/etc/hosts");
	
}

#--------------------------------------------------------------
#
# installation of CGTP packages
#
#--------------------------------------------------------------

sub men_cgtp {

  ($NODE_ID) = @_;

  COMMON::init_and_check([ROOT_DIR]);

  my $packages = $ENV{CGTP_PACKAGES};

  if ($USE_CGTP eq "YES") {
    COMMON::print_stage_node("Carrier-Grade Transport Protocol (CGTP) installation") ;
    COMMON::install_men_pkg($NODE_ID, $ROOT_DIR, $PACKAGE_SUBDIR, $packages, "LOCAL", "") ;

    COMMON::print_action("CGTP configuration") ;
    net_configure ($NODE_ID);
    
  } else {
    COMMON::print_stage_node("Network configuration") ;
    net_configure ($NODE_ID);
  }
}

#------------------------------------------------------------------------------
#
# adding a new host in the already installed MEN
#
#------------------------------------------------------------------------------

sub men_cgtp_add_nodes {

  ($NODE_ID) = @_;
  
  my $proto_hosts = "$WORKING_DIR/hosts";
  my $node_ip = COMMON::get_external_ip($NODE_ID);

  COMMON::print_stage_node("Network configuration") ;
  
  #
  # retrieve the /etc/hosts file
  #
  COMMON::get_file($node_ip, "/etc/hosts", "$proto_hosts");

  COMMON::print_action("Updating /etc/hosts");
  # add a entry for each new node
  for my $newnode (0..$#NODE_LIST) {
    if ($NODE_LIST[$newnode]{concerned} eq "TRUE") {
      COMMON::add_hosts_file_entry($proto_hosts, $newnode, $NODE_ID);
    }
  }

  #
  # put the /etc/hosts back
  #
  COMMON::put_file($node_ip, "$proto_hosts", "/etc/hosts");
}

{
}







