#!/usr/bin/perl
# -----------------------------------------------------------------------------
#  ident "@(#)install_server.pl 1.3 03/04/24 SMI"
# -----------------------------------------------------------------------------
#
#  Copyright 2001-2003 Sun Microsystems, Inc. All rights reserved.
#
# -----------------------------------------------------------------------------

package INSTALL_SERVER;

#use strict;    Does not accecpt TRUE/FALSE with strict...
use variables;
require "$ENV{NHINSTALL_LIB}/tools/lib/common.pl";

my $plumb = TRUE;

#------------------------------------------------------------------------------
#
# prepare the directories
# - creation
# - sharing
#
#------------------------------------------------------------------------------

sub prepare_directories {

  COMMON::init_and_check([ SOLARIS_DIR ]) ;

  COMMON::print_stage("Installation server directories");

  COMMON::print_action("Exporting the Netra HA Suite distribution");
  COMMON::share("$ROOT_DIR");

  if ($SOLARIS_INSTALL ne "YES") {
    return ;
  }

  COMMON::print_action("Exporting the Solaris distribution");
  COMMON::share("$SOLARIS_DIR");

}

#------------------------------------------------------------------------------
#
# get install server info
#
#------------------------------------------------------------------------------

sub get_install_server_info {

  my $timezone;

  COMMON::print_stage("Installation server: getting information") ;

   # get the local information of the installation server
   open(FILE, "</etc/default/init") ;
   while (<FILE>)
     {
       chop();
       s/#.*//;
       if ($_ eq "") {
	 next;
       }
       my ($var, $value) = split (/=/, $_) ;
       next unless ($var ne "") ;
       if ($var eq "TZ")
	 {
	   $timezone = $value ;
	 }
     }
   close(FILE) ;

   $timezone = "US/Central" unless ($timezone ne "") ;
   SEQUENCER::set_data("TIMEZONE", "$timezone");
}

#------------------------------------------------------------------------------
#
# determine NIC to configure
#
#------------------------------------------------------------------------------

sub determine_iface
  {
    my ($interface_to_configure) = @_ ;

    my $exist_physical = FALSE ;
    my $current_interface ;
    my $current_ip ;
    my $current_netmask ;
    my $current_broadcast ;
    my $interface ;
    my $route_interface ;
    my $physical ;
    my $alias ;
    my $ip ;
    my $broadcast ;
    my $netmask ;
    my $network;
    my $flags;
    my $found = FALSE ;
    my $bit_ip;
    my $bit_server = COMMON::convertDottedToBitmask($SERVER_IP);
    
    COMMON::error("You must specify real network interface name, not an alias (aka name:number)")
      if ( defined($IFACE) && $IFACE =~ /:/ );

    #
    # look for an interface with a matching IP Address
    #
    open (IFCONFIG, "$IFCONFIG -a |") ||
      COMMON::error ("Unable to perform \"$IFCONFIG -a\" command") ;

    # output looks like
    # hme0:x: flags=1000842<BROADCAST,RUNNING,MULTICAST,IPv4> mtu 1500 index 2
    #	inet x.x.x.x netmask ff000000 broadcast x.x.x.x
    
    while ( <IFCONFIG> ) {
      chop() ;
      
      if (m/([^\s\t]*): flags/) {

        # it's the first line of an interface output
        # keep the interface name
        $current_interface = $1 ;
	
        # if the physical interface exists, keep the information
        if ($current_interface eq $IFACE) {
          $exist_physical = TRUE ;
        }
	
      } elsif (m/inet ([^\s\t]*) netmask ([^\s\t]*) broadcast ([^\s\t]*)/) {
        # it's the second line of an interface output
        $current_ip = $1 ;
        $current_netmask = $2 ;
        $current_broadcast = $3 ;
    
        # convert the IP address to have the same format
        my $bit_ip = COMMON::convertDottedToBitmask($current_ip);
        $current_ip = COMMON::convertBitmaskToDotted($bit_ip);

        # check if it's the same IP address
        if ($current_ip eq $SERVER_IP) {

          if ($found eq TRUE) {
            # another one has already been found: problem
            COMMON::error("At least two interfaces ($interface and $current_interface) with the server IP address: please check the configuration") ;
          }

          # it's the first interface for the server IP address
          # keep all the information
          $found = TRUE ;
          $interface = $current_interface ;
          ($physical, $alias) = split(/:/, $interface) ;
          $ip = $current_ip;
          $netmask = $current_netmask;
          $broadcast = $current_broadcast;

        } else {

          # check if the IP address is in the same sub-network
    	  # this lead to reach the cluster by two different interfaces
	      # which may cause problem
    	  if (($bit_ip & $BIT_NETMASK) == ($bit_server & $BIT_NETMASK)) {
	        COMMON::error("$current_ip on $current_interface in the same sub-network: please check the configuration");
          }
        }
      }
    }
    close(IFCONFIG) ;

    if ($found ne TRUE) {
      if ($exist_physical eq FALSE) {
        # use it because we can not create an alias
        $$interface_to_configure = $IFACE ;
      } else {
        # the physical exists and it's not for cluster access (because no cluster access found)
        # create an alias
        $$interface_to_configure = "$IFACE:$CLUSTER" ;
      }
      return;
    }

    $plumb = FALSE;

    # check if there is no conflict
    if ($physical ne $IFACE) {
      COMMON::error("Configuration of $IFACE requested but server IP address $SERVER_IP already configured on another physical device (interface $interface)") ;
    }

    # cluster access found: reuse the same interface
    $$interface_to_configure = $interface;

    return;
}

#------------------------------------------------------------------------------
#
# Configure NIC
#
#------------------------------------------------------------------------------

sub configure_iface {

  # directly called by the sequencer

  COMMON::init_and_check([]);

  my $interface_to_configure;

  determine_iface(\$interface_to_configure) ;

  COMMON::print_stage("Installation server environment setting") ;
  COMMON::print_action("configuring $interface_to_configure") ;

  COMMON::add_netmask("/etc/netmasks", $DOTTED_NETWORK, $DOTTED_NETMASK);

  #
  # Configure interface
  #
  if ($plumb eq TRUE) {
    COMMON::exec_cmd ("$IFCONFIG $interface_to_configure plumb")||
      COMMON::error("Unable to plumb \"$interface_to_configure\" network interface");
  }

  COMMON::exec_cmd ("$IFCONFIG $interface_to_configure $SERVER_IP netmask $DOTTED_NETMASK broadcast + up -private") ||
    COMMON::error("Unable to configure \"$interface_to_configure\" network interface");
  
  #
  # as the interface has just been created or re-created, the rarpd may be not aware
  # that it exists
  # it needs to be relaunched in order to take into account the new interface.
  #
  COMMON::exec_cmd("$PKILL in.rarpd ; /usr/sbin/in.rarpd -a") ||
    COMMON::error("Unable to kill and restart rarpd daemon file");
}

{
}






