#!/usr/bin/perl -w
# ------------------------------------------------------------------------------
#   ident "@(#)sl_service.pm 1.14     02/10/31 SMI"
# ------------------------------------------------------------------------------

BEGIN {
   require "$ENV{'NHAS_PROD_DIR'}/nhsmct/lib/sl_node.pm";
   require "$ENV{'NHAS_PROD_DIR'}/nhsmct/lib/sl_config.pm";
   require "$ENV{'NHAS_PROD_DIR'}/nhsmct/lib/sl_iterator.pm"; 
}

# ------------------------------------------------------------------------------

package sl_service;

# ID fields separator
my $ID_SEP = '@';

# -----------------------------------------------------------------------------
# Service Name values

%SERVICE_NAME = ( 
	       'NHAS_MASTER_ELIGIBLE' => "NHAS_MASTER_ELIGIBLE",
               'NHAS_DISKLESS' => "NHAS_DISKLESS",
	       'NHAS_DATALESS' => "NHAS_DATALESS",
	       'CGTP' => "CGTP",
               'CMM_CGTP' => "CMM_CGTP",
	       'CMM_IP' => "CMM_IP",
	       'RNFS_SNDR' => "RNFS_SNDR",
	       'RNFS_SHARED_MEDIA' => "RNFS_SHARED_MEDIA",
	       'MA_MASTER_ELIGIBLE' => "MA_MASTER_ELIGIBLE",
	       'MA_DISKLESS' => "MA_DISKLESS",
	       'MA_DATALESS' => "MA_DATALESS",
	       'RBS' => "RBS",
	       'SMCT' => "SMCT",
	       'WDT_MASTER_ELIGIBLE' => "WDT_MASTER_ELIGIBLE",
	       'WDT_DISKLESS' => "WDT_DISKLESS",
	       'WDT_DATALESS' => "WDT_DATALESS",
	       'PMD' => "PMD",
	       'NSM' => "NSM",
               'GENERIC' => "GENERIC",
	       'PATCH_MASTER_ELIGIBLE' => "PATCH_MASTER_ELIGIBLE",
	       'PATCH_DISKLESS' => "PATCH_DISKLESS",
	       'PATCH_DATALESS' => "PATCH_DATALESS",
	       'NLS_SWITCH_PORT_POLICY' => "SWITCH_PORT_POLICY",
	       'STATIC_CLIENT_ID_POLICY' => "STATIC_CLIENT_ID_POLICY",
	       'MAC_ADDR_POLICY' => "MAC_ADDR_POLICY" );

# -----------------------------------------------------------------------------
# Service Hidden enum values

%SERVICE_HIDDEN_VALUES = ( 
	       'NHAS_MASTER_ELIGIBLE' => 0,
               'NHAS_DISKLESS' => 0,
	       'NHAS_DATALESS' => 0,
	       'CGTP' => 1,
               'CMM_CGTP' => 1,
	       'CMM_IP' => 1,
	       'RNFS_SNDR' => 1,
	       'RNFS_SHARED_MEDIA' => 1,
	       'MA_MASTER_ELIGIBLE' => 1,
	       'MA_DISKLESS' => 1,
	       'MA_DATALESS' => 1,
	       'RBS' => 0,
	       'SMCT' => 1,
	       'WDT_MASTER_ELIGIBLE' => 1,
	       'WDT_DISKLESS' => 1,
	       'WDT_DATALESS' => 1,
	       'PMD' => 1,
	       'NSM' => 1,
               'GENERIC' => 1,
	       'PATCH_MASTER_ELIGIBLE' => 1,
	       'PATCH_DISKLESS' => 1,
	       'PATCH_DATALESS' => 1,
	       'NLS_SWITCH_PORT_POLICY' => 1,
	       'STATIC_CLIENT_ID_POLICY' => 0,
	       'MAC_ADDR_POLICY' => 0 );


# -----------------------------------------------------------------------------
# Service Category

%SERVICE_CATEGORY_VALUE = ( 
               'SOFTCONF' => "SOFTCONF",
               'SOFT' => "SOFT",
	       'CONF' => "CONF" );

my %SERVICE_CATEGORY = ( 
               'NHAS_MASTER_ELIGIBLE' => $SERVICE_CATEGORY_VALUE{'SOFTCONF'},
               'NHAS_DISKLESS' => $SERVICE_CATEGORY_VALUE{'SOFTCONF'},
               'NHAS_DATALESS' => $SERVICE_CATEGORY_VALUE{'SOFTCONF'},
	       'CGTP' => $SERVICE_CATEGORY_VALUE{'SOFTCONF'},
               'CMM' => $SERVICE_CATEGORY_VALUE{'SOFTCONF'},
               'CMM_CGTP' => $SERVICE_CATEGORY_VALUE{'SOFTCONF'},
	       'CMM_IP' => $SERVICE_CATEGORY_VALUE{'SOFTCONF'},
	       'SNDR' => $SERVICE_CATEGORY_VALUE{'SOFTCONF'},
	       'RNFS' => $SERVICE_CATEGORY_VALUE{'SOFTCONF'},
	       'RNFS_SNDR' => $SERVICE_CATEGORY_VALUE{'SOFTCONF'},
	       'RNFS_SHARED_MEDIA' => $SERVICE_CATEGORY_VALUE{'SOFTCONF'},
	       'MA' => $SERVICE_CATEGORY_VALUE{'SOFTCONF'},
	       'MA_MASTER_ELIGIBLE' => $SERVICE_CATEGORY_VALUE{'SOFTCONF'},
	       'MA_DISKLESS' => $SERVICE_CATEGORY_VALUE{'SOFTCONF'},
	       'MA_DATALESS' => $SERVICE_CATEGORY_VALUE{'SOFTCONF'},
	       'RBS' => $SERVICE_CATEGORY_VALUE{'SOFTCONF'},
	       'SMCT' => $SERVICE_CATEGORY_VALUE{'SOFT'},
	       'WDT_MASTER_ELIGIBLE' => $SERVICE_CATEGORY_VALUE{'SOFTCONF'},
	       'WDT_DISKLESS' => $SERVICE_CATEGORY_VALUE{'SOFTCONF'},
	       'WDT_DATALESS' => $SERVICE_CATEGORY_VALUE{'SOFTCONF'},
	       'PMD' => $SERVICE_CATEGORY_VALUE{'SOFT'},
	       'NSM' => $SERVICE_CATEGORY_VALUE{'SOFTCONF'},
	       'GENERIC' => $SERVICE_CATEGORY_VALUE{'CONF'},
	       'PATCH_MASTER_ELIGIBLE' => $SERVICE_CATEGORY_VALUE{'SOFT'},
	       'PATCH_DISKLESS' => $SERVICE_CATEGORY_VALUE{'SOFT'},
	       'PATCH_DATALESS' => $SERVICE_CATEGORY_VALUE{'SOFT'},
	       'NLS_SWITCH_PORT_POLICY' => $SERVICE_CATEGORY_VALUE{'CONF'},
	       'STATIC_CLIENT_ID_POLICY' => $SERVICE_CATEGORY_VALUE{'CONF'},
	       'MAC_ADDR_POLICY' => $SERVICE_CATEGORY_VALUE{'CONF'} );

# -----------------------------------------------------------------------------
# Service Type

%SERVICE_TYPE_VALUE = ( 
               'MASTER_ELIGIBLE' => "MASTER_ELIGIBLE",
               'DISKLESS' => "DISKLESS",
               'DATALESS' => "DATALESS",
	       'GENERIC' => "GENERIC" );

%SERVICE_TYPE = ( 
               'NHAS_MASTER_ELIGIBLE' => $SERVICE_TYPE_VALUE{'MASTER_ELIGIBLE'},
               'NHAS_DISKLESS' => $SERVICE_TYPE_VALUE{'DISKLESS'},
               'NHAS_DATALESS' => $SERVICE_TYPE_VALUE{'DATALESS'},
	       'CGTP' => $SERVICE_TYPE_VALUE{'GENERIC'},
               'CMM' => $SERVICE_TYPE_VALUE{'GENERIC'},
               'CMM_CGTP' => $SERVICE_TYPE_VALUE{'GENERIC'},
	       'CMM_IP' =>  $SERVICE_TYPE_VALUE{'GENERIC'},
	       'SNDR' => $SERVICE_TYPE_VALUE{'MASTER_ELIGIBLE'},
	       'RNFS' => $SERVICE_TYPE_VALUE{'MASTER_ELIGIBLE'},
	       'RNFS_SNDR' => $SERVICE_TYPE_VALUE{'MASTER_ELIGIBLE'},
	       'RNFS_SHARED_MEDIA' => $SERVICE_TYPE_VALUE{'MASTER_ELIGIBLE'},
	       'MA' => $SERVICE_TYPE_VALUE{'GENERIC'},
	       'MA_MASTER_ELIGIBLE' => $SERVICE_TYPE_VALUE{'GENERIC'},
	       'MA_DISKLESS' => $SERVICE_TYPE_VALUE{'GENERIC'},
	       'MA_DATALESS' => $SERVICE_TYPE_VALUE{'GENERIC'},
	       'RBS' => $SERVICE_TYPE_VALUE{'MASTER_ELIGIBLE'},
	       'SMCT' => $SERVICE_TYPE_VALUE{'GENERIC'},
	       'WDT_MASTER_ELIGIBLE' => $SERVICE_TYPE_VALUE{'GENERIC'},
	       'WDT_DISKLESS' => $SERVICE_TYPE_VALUE{'GENERIC'},
	       'WDT_DATALESS' => $SERVICE_TYPE_VALUE{'GENERIC'},
	       'PMD' => $SERVICE_TYPE_VALUE{'GENERIC'},
	       'NSM' => $SERVICE_TYPE_VALUE{'MASTER_ELIGIBLE'},
	       'GENERIC' => $SERVICE_TYPE_VALUE{'GENERIC'},
	       'PATCH_MASTER_ELIGIBLE' => $SERVICE_TYPE_VALUE{'GENERIC'},
	       'PATCH_DISKLESS' => $SERVICE_TYPE_VALUE{'GENERIC'},
	       'PATCH_DATALESS' => $SERVICE_TYPE_VALUE{'GENERIC'},
	       'NLS_SWITCH_PORT_POLICY' => $SERVICE_TYPE_VALUE{'DISKLESS'},
	       'STATIC_CLIENT_ID_POLICY' => $SERVICE_TYPE_VALUE{'DISKLESS'},
	       'MAC_ADDR_POLICY' => $SERVICE_TYPE_VALUE{'DISKLESS'} );

# -----------------------------------------------------------------------------
# Service Class

my %SERVICE_CLASS_VALUE = ( 
               'MULTIPLE' => "MULTIPLE",
	       'SINGLE' => "SINGLE" );

my %SERVICE_CLASS = ( 
               'NHAS_MASTER_ELIGIBLE' => $SERVICE_CLASS_VALUE{'MULTIPLE'},
               'NHAS_DISKLESS' => $SERVICE_CLASS_VALUE{'MULTIPLE'},
               'NHAS_DATALESS' => $SERVICE_CLASS_VALUE{'MULTIPLE'},
	       'CGTP' => $SERVICE_CLASS_VALUE{'SINGLE'},
               'CMM' => $SERVICE_CLASS_VALUE{'SINGLE'},
               'CMM_CGTP' => $SERVICE_CLASS_VALUE{'SINGLE'},
	       'CMM_IP' => $SERVICE_CLASS_VALUE{'SINGLE'},
	       'SNDR' => $SERVICE_CLASS_VALUE{'SINGLE'},
	       'RNFS' => $SERVICE_CLASS_VALUE{'SINGLE'},
	       'RNFS_SNDR' => $SERVICE_CLASS_VALUE{'SINGLE'},
	       'RNFS_SHARED_MEDIA' => $SERVICE_CLASS_VALUE{'SINGLE'},
	       'MA' => $SERVICE_CLASS_VALUE{'SINGLE'},
	       'MA_MASTER_ELIGIBLE' => $SERVICE_CLASS_VALUE{'SINGLE'},
	       'MA_DISKLESS' => $SERVICE_CLASS_VALUE{'SINGLE'},
	       'MA_DATALESS' => $SERVICE_CLASS_VALUE{'SINGLE'},
	       'RBS' => $SERVICE_CLASS_VALUE{'SINGLE'},
	       'SMCT' => $SERVICE_CLASS_VALUE{'SINGLE'},
	       'WDT_MASTER_ELIGIBLE' => $SERVICE_CLASS_VALUE{'SINGLE'},
	       'WDT_DISKLESS' => $SERVICE_CLASS_VALUE{'SINGLE'},
	       'WDT_DATALESS' => $SERVICE_CLASS_VALUE{'SINGLE'},
	       'PMD' => $SERVICE_CLASS_VALUE{'SINGLE'},
	       'NSM' => $SERVICE_CLASS_VALUE{'SINGLE'},
	       'GENERIC' => $SERVICE_CLASS_VALUE{'SINGLE'},
	       'PATCH_MASTER_ELIGIBLE' => $SERVICE_CLASS_VALUE{'SINGLE'},
	       'PATCH_DISKLESS' => $SERVICE_CLASS_VALUE{'SINGLE'},
	       'PATCH_DATALESS' => $SERVICE_CLASS_VALUE{'SINGLE'},
	       'STATIC_CLIENT_ID_POLICY' => $SERVICE_CLASS_VALUE{'SINGLE'},
	       'MAC_ADDR_POLICY' => $SERVICE_CLASS_VALUE{'SINGLE'},
	       'NLS_SWITCH_PORT_POLICY' => $SERVICE_CLASS_VALUE{'SINGLE'} );

# -----------------------------------------------------------------------------
# Service Family 

%SERVICE_FAMILY_VALUE = ( 
               'RNFS' => "RNFS",
               'CMM' => "CMM",
	       'CGTP' => "CGTP",
	       'MA' => "MA",
	       'RBS' => "RBS",
	       'SMCT' => "SMCT",
	       'WDT' => "WDT",
	       'PMD' => "PMD",
	       'NSM' => "NSM",
	       'NLS' => "NLS",
	       'MASTER_ELIGIBLE' => "MASTER_ELIGIBLE",
	       'DISKLESS' => "DISKLESS",
	       'DATALESS' => "DATALESS",
	       'GENERIC' => "GENERIC" );
	       

my %SERVICE_FAMILY = (
               'NHAS_MASTER_ELIGIBLE' => $SERVICE_FAMILY_VALUE{'MASTER_ELIGIBLE'},
               'NHAS_DISKLESS' => $SERVICE_FAMILY_VALUE{'DISKLESS'},
               'NHAS_DATALESS' => $SERVICE_FAMILY_VALUE{'DATALESS'},
	       'CGTP' => $SERVICE_FAMILY_VALUE{'CGTP'},
               'CMM' => $SERVICE_FAMILY_VALUE{'CMM'},
               'CMM_CGTP' => $SERVICE_FAMILY_VALUE{'CMM'},
	       'CMM_IP' => $SERVICE_FAMILY_VALUE{'CMM'},
               'SNDR' => $SERVICE_FAMILY_VALUE{'RNFS'},
	       'RNFS' => $SERVICE_FAMILY_VALUE{'RNFS'},
	       'RNFS_SNDR' => $SERVICE_FAMILY_VALUE{'RNFS'},
	       'RNFS_SHARED_MEDIA' => $SERVICE_FAMILY_VALUE{'RNFS'},
	       'MA' => $SERVICE_FAMILY_VALUE{'MA'},
	       'MA_MASTER_ELIGIBLE' => $SERVICE_FAMILY_VALUE{'MA'},
	       'MA_DISKLESS' => $SERVICE_FAMILY_VALUE{'MA'},
	       'MA_DATALESS' => $SERVICE_FAMILY_VALUE{'MA'},
	       'RBS' => $SERVICE_FAMILY_VALUE{'RBS'},
	       'SMCT' => $SERVICE_FAMILY_VALUE{'SMCT'},
	       'WDT_MASTER_ELIGIBLE' => $SERVICE_FAMILY_VALUE{'WDT'},
	       'WDT_DISKLESS' => $SERVICE_FAMILY_VALUE{'WDT'},
	       'WDT_DATALESS' => $SERVICE_FAMILY_VALUE{'WDT'},
	       'PMD' => $SERVICE_FAMILY_VALUE{'PMD'},
	       'NSM' => $SERVICE_FAMILY_VALUE{'NSM'},
	       'GENERIC' => $SERVICE_FAMILY_VALUE{'GENERIC'},
	       'PATCH_MASTER_ELIGIBLE' => $SERVICE_FAMILY_VALUE{'GENERIC'},
	       'PATCH_DISKLESS' => $SERVICE_FAMILY_VALUE{'GENERIC'},
	       'PATCH_DATALESS' => $SERVICE_FAMILY_VALUE{'GENERIC'},
	       'STATIC_CLIENT_ID_POLICY' => $SERVICE_FAMILY_VALUE{'NLS'},
	       'MAC_ADDR_POLICY' => $SERVICE_FAMILY_VALUE{'NLS'},
	       'NLS_SWITCH_PORT_POLICY' => $SERVICE_FAMILY_VALUE{'NLS'} );

# -----------------------------------------------------------------------------
# Service package list configuration
#
# Naming rule:
#
#   o case 1: the package list is the same and the installation mode of each
#             package is the same whatever the node type is
#             => package list name = <service-name>.<arch>.<os>
#                e.g. CMM.SPARC.SOLARIS 
#
#   o case 2: the package list is different or the installation mode of each
#             package is different according to the node type
#             => package list name = <service-name>_<node_type>.<arch>.<os>
#                e.g. MA_MASTER_ELIGIBLE.SPARC.SOLARIS 
#
my %SERVICE_LST = ();

# Multiple service software config (1 per node type)
@{$SERVICE_LST{'NHAS_MASTER_ELIGIBLE'}} =
   qw ( GENERIC 
        CGTP
	CMM
	SNDR
	RNFS
	PMD 
	SMCT 
	WDT_MASTER_ELIGIBLE 
	MA_MASTER_ELIGIBLE
	PATCH_MASTER_ELIGIBLE );

@{$SERVICE_LST{'NHAS_DISKLESS'}} = 
   qw ( GENERIC
        CGTP
	CMM 
	PMD 
	SMCT
	WDT_DISKLESS
	MA_DISKLESS 
	PATCH_DISKLESS );
	
@{$SERVICE_LST{'NHAS_DATALESS'}} = 
   qw ( GENERIC
        CGTP
	CMM
	PMD 
	SMCT
	WDT_DATALESS 
	MA_DATALESS 
	PATCH_DATALESS );

# CGTP/CMM packages config
@{$SERVICE_LST{'CGTP'}} = qw ( CGTP );
@{$SERVICE_LST{'CMM_CGTP'}} = qw ( CGTP CMM );
@{$SERVICE_LST{'CMM_IP'}} = qw ( CMM );

# RNFS packages config
@{$SERVICE_LST{'RNFS_SNDR'}} = qw ( SNDR RNFS );
@{$SERVICE_LST{'RNFS_SHARED_MEDIA'}} = qw ( RNFS );

# NMA packages config
@{$SERVICE_LST{'MA_DISKLESS'}} = qw ( MA_DISKLESS );
@{$SERVICE_LST{'MA_DATALESS'}} = qw ( MA_DATALESS );
@{$SERVICE_LST{'MA_MASTER_ELIGIBLE'}} = qw ( MA_MASTER_ELIGIBLE );

# WDT packages config
@{$SERVICE_LST{'WDT_MASTER_ELIGIBLE'}} = qw ( WDT_MASTER_ELIGIBLE );
@{$SERVICE_LST{'WDT_DATALESS'}} = qw ( WDT_DATALESS );
@{$SERVICE_LST{'WDT_DISKLESS'}} = qw ( WDT_DISKLESS );

# Misc. packages config
@{$SERVICE_LST{'RBS'}} = qw ( RBS );
@{$SERVICE_LST{'SMCT'}} = qw ( SMCT );
@{$SERVICE_LST{'PMD'}} = qw ( PMD );
@{$SERVICE_LST{'NSM'}} = qw ( NSM );
@{$SERVICE_LST{'GENERIC'}} = qw ( GENERIC );

# No software associated to these 3 services 
# (defined to trigger NLS config. on MEN for the associated diskless)
@{$SERVICE_LST{'STATIC_CLIENT_ID_POLICY'}} = ();
@{$SERVICE_LST{'MAC_ADDR_POLICY'}} = ();
@{$SERVICE_LST{'NLS_SWITCH_PORT_POLICY'}} = ();

# -----------------------------------------------------------------------------
# Service object attributes

my @SERVICE_ATTR = qw( Id
                       Name
		       Class
		       ConfigLst
		       Category
		       Family
		       Type );

%SERVICE_DEF_COMP_MASK = ( 'Id' => 0,
                           'Name' => 1,
			   'Class' => 1,
			   'ConfigLst' => 0,
			   'Category' => 1,
			   'Family' => 1,
			   'Type' => 1 );

# ------------------------------------------------------------------------------
#
sub new {
   my $class = shift;
   my %attr = @_;
   my $self = {};
   bless $self, $class;
   if ( ( defined $attr{'Id'} ) &&
        ( defined $attr{'Name'} ) ) {
      # Set mandatory attributes
      $self->{'Name'} = $attr{'Name'};
      $self->{'Id'} = $attr{'Id'};
      $self->{'Class'} = $SERVICE_CLASS{$attr{'Name'}};
      $self->{'Category'} = $SERVICE_CATEGORY{$attr{'Name'}};
      $self->{'Family'} = $SERVICE_FAMILY{$attr{'Name'}};
      $self->{'Type'} = $SERVICE_TYPE{$attr{'Name'}};
      # Set optional attributes
      $self->{'ConfigLst'} = $attr{'ConfigLst'}
         if ( defined $attr{'ConfigLst'} );
   }
   elsif ( defined $attr{'ServiceObject'} ) {
      $self->_construct( $attr{'ServiceObject'} );
   }
   else {
      &sl_traces::error( "Unable to create %s object.".
                         " Invalid creation method", 
			 "- sl_service::new - ".__LINE__,
			 ( "sl_service" ) );
   }
   &sl_traces::trace( 2, "- sl_service::new - Creating service object ".
                     "< $self->{'Name'} >" );
   return $self;
}

# ------------------------------------------------------------------------------
#
sub _construct {
   my $self = shift;
   my ( $serviceObject ) = @_;
   &sl_traces::trace( 3, "- sl_service::_construct - Building service object" );
   my $service = sl_iterator->new( 'Object' => $serviceObject );
   $self->{'Id'} = $service->extract;
   $self->{'Name'} = $service->extract;;
   $self->{'Class'} = $service->extract;
   @{$self->{'ConfigLst'}} = 
      $service->extractObjectArray( "sl_config", "ConfigObject" );      
   $self->{'Category'} = $service->extract;
   $self->{'Family'} = $service->extract;
   $self->{'Type'} = $service->extract;
}

# ------------------------------------------------------------------------------
#
sub serialize {
   my $self = shift;
   &sl_traces::trace( 2, "- sl_service::serialize - Serializing ".
                     "service object" );
   my $serviceObject = sl_iterator->new( 'Object' => "" );
   foreach $attr ( @SERVICE_ATTR ) {
      if ( $attr eq 'ConfigLst' ) {
         $serviceObject->serializeObjectArray( @{$self->{'ConfigLst'}} );
      }
      else {
         $serviceObject->serialize( $self->{$attr} );
      }
   }
   return $serviceObject->get;
}

# ------------------------------------------------------------------------------
#
sub display {
   my $self = shift;
   my ( $brief ) = @_;
   &sl_traces::trace( 2, "- sl_service::display - Displaying service" );
   print STDOUT "Service\n";
   print STDOUT "-------\n";
   foreach ( @SERVICE_ATTR ) {
      if ( defined $self->{$_} ) {
         if ( $_ eq 'ConfigLst' ) {
	    print STDOUT "$_ =\n";
	    foreach $config ( @{$self->{'ConfigLst'}} ) {
	       $config->display;
	    }
	 }
	 else {
	    print STDOUT "$_ = ";
	    print STDOUT "$self->{$_}";
	    print STDOUT "\n";
	 }
      }
      else {
         print STDOUT "$_ =\n";
      }
   }
   print STDOUT "\n";
}

# ------------------------------------------------------------------------------
#
sub compare {
   my $class = shift;
   my ( $service1, $service2 ) = @_;
   my $service1Name = ( defined $service1 ) ? $service1->getName:"<undefined>";
   my $service2Name = ( defined $service2 ) ? $service2->getName:"<undefined>";
   &sl_traces::trace( 2, "- sl_service::compare - Comparing services ".
                     "< ${service1Name} > and < ${service2Name} >" );
   # String holding differences if any
   my $diffStr = undef;
   # Extract the differences if any
   foreach $attr ( keys %SERVICE_DEF_COMP_MASK ) {
      $diffStr1 = "Comparing service : ${service1Name}.";
      $diffStr2 = "       to service : ${service2Name}.";
      if ( $SERVICE_DEF_COMP_MASK{$attr} ) {
         if ( &sl_utils::testAttribute( $service1->{$attr} ) and 
	      &sl_utils::testAttribute( $service2->{$attr} ) and
	      ( $service1->{$attr} ne $service2->{$attr} ) ) {
            $diffStr1 .= "${attr}=".$service1->{$attr}."\n";
	    $diffStr2 .= "${attr}=".$service2->{$attr}."\n";
            $diffStr .= $diffStr1.$diffStr2;
	 }
         elsif ( ! &sl_utils::testAttribute( $service1->{$attr} ) and
	           &sl_utils::testAttribute( $service2->{$attr} ) )  {
               $diffStr1 .= "${attr}= <undefined>\n";
	       $diffStr2 .= "${attr}= <defined>\n";
               $diffStr .= $diffStr1.$diffStr2;
         }
         elsif ( ! &sl_utils::testAttribute( $service2->{$attr} ) and
	           &sl_utils::testAttribute( $service1->{$attr} ) ) {
               $diffStr2 .= "${attr}= <undefined>\n";
	       $diffStr1 .= "${attr}= <defined>\n";
               $diffStr .= $diffStr1.$diffStr2;
	 }
      }
   }
   return $diffStr;
}

# ------------------------------------------------------------------------------
#
sub getName {
   my $self = shift;
   &sl_traces::trace( 2, "- sl_service::getName - Getting service ".
                     "< $self->{'Name'} > Name" );
   return $self->{'Name'};
}

# ------------------------------------------------------------------------------
#
sub getType {
   my $self = shift;
   &sl_traces::trace( 2, "- sl_service::getType - Getting service ".
                     "< $self->{'Name'} > Type" );
   return $self->{'Type'};
}

# ------------------------------------------------------------------------------
#
sub getClass {
   my $self = shift;
   &sl_traces::trace( 2, "- sl_service::getClass - Getting service ".
                     "< $self->{'Name'} > Class" );
   return $self->{'Class'};
}

# ------------------------------------------------------------------------------
#
sub getCategory {
   my $self = shift;
   &sl_traces::trace( 2, "- sl_service::getCategory - Getting service ".
                     "< $self->{'Name'} > Category" );
   return $self->{'Category'};
}

# ------------------------------------------------------------------------------
#
sub getConfigLst {
   my $self = shift;
   &sl_traces::trace( 2, "- sl_service::getConfig - Getting service ".
                     "< $self->{'Name'} > ConfigLst" );
   if ( defined $self->{'ConfigLst'} ) {
      return @{$self->{'ConfigLst'}};
   }
   else {
      return ();
   }
}

# ------------------------------------------------------------------------------
#
sub getFamily {
   my $self = shift;
   &sl_traces::trace( 2, "- sl_service::getFamily - Getting service ".
                     "< $self->{'Name'} > Family" );
   return $self->{'Family'};
}

# ------------------------------------------------------------------------------
#
sub setConfigLst {
   my $self = shift;
   my @configLst = @_;
   if ( defined $configLst[0] ) {
      &sl_traces::trace( 2, "- sl_service::setConfigLst - Setting config to ".
                         "the service < $self->{'Name'} >" );
      push( @{$self->{'ConfigLst'}}, @configLst );
   }
   else {
      &sl_traces::error( "%s is undefined", 
                         "sl_service::setConfigLst - ".__LINE__,
			 ( "Config list" ) );
   }
}

# ------------------------------------------------------------------------------
#
sub getServiceLst {
   my $self = shift;
   my $serviceName = $self->getName;
   &sl_traces::trace( 2, "- sl_service::getServiceLst - Getting service ". 
                      "< ${serviceName} > service list" );
   if ( defined $SERVICE_LST{$serviceName} ) {
      return @{$SERVICE_LST{$serviceName}};
   }
   else {
      return ();
   }
}

# ------------------------------------------------------------------------------
#
sub hasSoftware {
   my $self = shift;
   my $serviceName = $self->getName;
   &sl_traces::trace( 2, "- sl_service::hasSoftware - Testing service ". 
                      "< ${serviceName} > Category" );
   my $category = $self->getCategory;
   if ( $category ne $SERVICE_CATEGORY_VALUE{'CONF'} ) {
      return 1;
   }
   else {
      return 0;
   }
}

# ------------------------------------------------------------------------------
#
sub isRBS {
   my $self = shift;
   my $serviceName = $self->getName;
   &sl_traces::trace( 2, "- sl_service::isRBS - Testing service ". 
                      "< ${serviceName} > Family" );
   my $family = $self->getFamily;
   if ( $family eq $SERVICE_FAMILY_VALUE{'RBS'} ) {
      return 1;
   }
   else {
      return 0;
   }
}

# ------------------------------------------------------------------------------
#
sub isNLS {
   my $self = shift;
   my $serviceName = $self->getName;
   &sl_traces::trace( 2, "- sl_service::isNLS - Testing service ". 
                      "< ${serviceName} > Family" );
   my $family = $self->getFamily;
   if ( $family eq $SERVICE_FAMILY_VALUE{'NLS'} ) {
      return 1;
   }
   else {
      return 0;
   }
}

# ------------------------------------------------------------------------------
#
sub isCMM {
   my $self = shift;
   my $serviceName = $self->getName;
   &sl_traces::trace( 2, "- sl_service::isCMM - Testing service ". 
                      "< ${serviceName} > Family" );
   my $family = $self->getFamily;
   if ( $family eq $SERVICE_FAMILY_VALUE{'CMM'} ) {
      return 1;
   }
   else {
      return 0;
   }
}

# ------------------------------------------------------------------------------
#
sub isRNFS {
   my $self = shift;
   my $serviceName = $self->getName;
   &sl_traces::trace( 2, "- sl_service::isRNFS - Testing service ". 
                      "< ${serviceName} > Family" );
   my $family = $self->getFamily;
   if ( $family eq $SERVICE_FAMILY_VALUE{'RNFS'} ) {
      return 1;
   }
   else {
      return 0;
   }
}

# ------------------------------------------------------------------------------
#
sub isGENERIC {
   my $self = shift;
   my $serviceName = $self->getName;
   &sl_traces::trace( 2, "- sl_service::isGENERIC - Testing service ". 
                      "< ${serviceName} > Family" );
   my $family = $self->getFamily;
   if ( $family eq $SERVICE_FAMILY_VALUE{'GENERIC'} ) {
      return 1;
   }
   else {
      return 0;
   }
}

# ------------------------------------------------------------------------------
#
sub isMA {
   my $self = shift;
   my $serviceName = $self->getName;
   &sl_traces::trace( 2, "- sl_service::isMA - Testing service ". 
                      "< ${serviceName} > Family" );
   my $family = $self->getFamily;
   if ( $family eq $SERVICE_FAMILY_VALUE{'MA'} ) {
      return 1;
   }
   else {
      return 0;
   }
}

# ------------------------------------------------------------------------------
#
sub isMasterEligible {
   my $self = shift;
   my $serviceName = $self->getName;
   &sl_traces::trace( 2, "- sl_service::isMasterEligible - Testing service ". 
                      "< ${serviceName} > Family" );
   my $family = $self->getFamily;
   if ( $family eq $SERVICE_FAMILY_VALUE{'MASTER_ELIGIBLE'} ) {
      return 1;
   }
   else {
      return 0;
   }
}

# ------------------------------------------------------------------------------
#
sub isDiskless {
   my $self = shift;
   my $serviceName = $self->getName;
   &sl_traces::trace( 2, "- sl_service::isDiskless - Testing service ". 
                      "< ${serviceName} > Family" );
   my $family = $self->getFamily;
   if ( $family eq $SERVICE_FAMILY_VALUE{'DISKLESS'} ) {
      return 1;
   }
   else {
      return 0;
   }
}

# ------------------------------------------------------------------------------
#
sub isDataless {
   my $self = shift;
   my $serviceName = $self->getName;
   &sl_traces::trace( 2, "- sl_service::isDataless - Testing service ". 
                      "< ${serviceName} > Family" );
   my $family = $self->getFamily;
   if ( $family eq $SERVICE_FAMILY_VALUE{'DATALESS'} ) {
      return 1;
   }
   else {
      return 0;
   }
}

# ------------------------------------------------------------------------------
#
sub isNSM {
   my $self = shift;
   my $serviceName = $self->getName;
   &sl_traces::trace( 2, "- sl_service::isNSM - Testing service ". 
                      "< ${serviceName} > Family" );
   my $family = $self->getFamily;
   if ( $family eq $SERVICE_FAMILY_VALUE{'NSM'} ) {
      return 1;
   }
   else {
      return 0;
   }
}

# ------------------------------------------------------------------------------
#
sub isHidden {
   my $class = shift;
   my $enumValue = shift;
   &sl_traces::trace( 2, "- sl_service::isHidden - Testing enum ". 
                      "< ${enumValue} > hidden value" );
   return $SERVICE_HIDDEN_VALUES{$enumValue};
}

# ------------------------------------------------------------------------------
#
sub iD {
   my $self = shift;
   my $serviceId = $self->{'Name'}.$ID_SEP.$self->{'Id'};
   &sl_traces::trace( 3, "- sl_service::iD - Service iD is < ${serviceId} >" );
   return $serviceId;
}

# ------------------------------------------------------------------------------

return 1;
