#!/usr/bin/perl -w
# ------------------------------------------------------------------------------
#   ident "@(#)sl_node_solaris.pm 1.13     02/11/13 SMI"
# ------------------------------------------------------------------------------


BEGIN { 
   require "$ENV{'NHAS_PROD_DIR'}/nhsmct/lib/sl_node.pm"; 
   require "$ENV{'NHAS_PROD_DIR'}/nhsmct/lib/sl_ip.pm"; 
   require "$ENV{'NHAS_PROD_DIR'}/nhsmct/lib/sl_filesys.pm"; 
   require "$ENV{'NHAS_PROD_DIR'}/nhsmct/lib/sl_fs.pl"; 
   require "$ENV{'NHAS_PROD_DIR'}/nhsmct/lib/sl_rnfs.pl"; 
   require "$ENV{'NHAS_PROD_DIR'}/nhsmct/lib/sl_swl.pm"; 
   require "$ENV{'NHAS_PROD_DIR'}/nhsmct/lib/sl_cmm.pl"; 
   require "$ENV{'NHAS_PROD_DIR'}/nhsmct/lib/sl_nsm.pl"; 
   require "$ENV{'NHAS_PROD_DIR'}/nhsmct/lib/sl_dhcp.pl"; 
   require "$ENV{'NHAS_PROD_DIR'}/nhsmct/lib/sl_nls.pl"; 
   require "$ENV{'NHAS_PROD_DIR'}/nhsmct/lib/sl_utils.pl"; 
   require "$ENV{'NHAS_PROD_DIR'}/nhsmct/lib/sl_registry.pl"; 
}

# ------------------------------------------------------------------------------

package sl_node_solaris;

# sl_node_solaris Inherits from sl_node
@ISA = qw( sl_node );

# ------------------------------------------------------------------------------
#
sub new {
   my $class = shift;
   my %attr = @_;
   my $self = {};
   bless $self, $class;
   if ( ( defined $attr{'Id'} ) && 
        ( defined $attr{'Name'} ) ) {
      while ( ( $key, $value ) = each( %attr ) ) {
         $self->{$key} = $value;
      }
   }
   else {
      &sl_traces::error( "Unable to create %s object. Invalid creation method", 
		         "- sl_node_solaris::new - ".__LINE__,
			 ( $sl_node_solaris ) );
   }
   &sl_traces::trace( 2, "- sl_node_solaris::new - Creating solaris_node object ".
                "< $self->{'Name'} > Id < $self->{'Id'} >" );
   return $self;
}

# ------------------------------------------------------------------------------
#
sub deploy {
   my $self = shift;
   my ( $service, $groupDir, $domain, 
        $swlVersion, $clusterName, @shelfLst ) = @_;
   my $nodeName = $self->getName;
   my $serviceName = $service->getName;
   my $domainId = $domain->getId;
   &sl_traces::info( 2, "Configuring service < $serviceName > on node ".
                     "< $self->{'Name'} >" );
   # Retrieve the drawer object associated to the node
   # (used later to retrieve node-board and drawer-disk)
   my $drawerId = $self->getDrawer;
   my $drawer = undef;
   foreach $shelf ( @shelfLst ) {
      $drawer = $shelf->getDrawer( $drawerId );
      last if (defined $drawer);
   }
   if ( defined $drawer ) {
      # Determine node directory
      my $nodeDir = "${groupDir}/".$self->{'Id'};
      ( -d $nodeDir ) || &sl_utils::createDir( $nodeDir );
      # Configure the service according to its family
      if ( $service->isGENERIC ) {
	 # Create service independant configuration
	 sl_ip->configure( $self, $nodeDir, $drawer );
	 sl_swl->configureSWLID( $self, $nodeDir, $swlVersion );
	 sl_filesys->configure( 
	    $self, $nodeDir, $swlVersion, $clusterName, $drawer );
      }
      elsif ( $service->isCMM ) {
         sl_fs::configure( $self, $nodeDir, $drawer, $domain );
	 sl_cmm::configure( 
	    $self, $nodeDir, $domain, $drawer, $clusterName, $serviceName );
      }
      elsif ( $service->isRNFS ) {
         sl_fs::configure( $self, $nodeDir, $drawer, $domain );
         sl_rnfs::configure( 
           $node, $groupDir, $nodeDir, $drawer, 
	   $clusterName, $swlVersion, @shelfLst );
      }
      elsif ( $service->isNLS ) {
         sl_nls::configureNLT( $self, $nodeDir, $clusterName, $serviceName, 
         	               $drawer, $domain, $swlVersion, @shelfLst );
      }
      elsif ( $service->isNSM ) {
         sl_nsm::configure( $self, $nodeDir, $drawer );
      }
      elsif ( $service->isRBS ) {
         sl_nls::configureNLS( $self, $nodeDir, $clusterName, $serviceName, 
  	                       $drawer, $domain, $swlVersion, @shelfLst );
         sl_dhcp::configure( $self, $nodeDir, $drawer, $clusterName );

      }
      elsif ( ( $service->isMasterEligible ) or 
              ( $service->isDiskless ) or 
	      ( $service->isDataless ) ) {
         sl_fs::configure( $self, $nodeDir, $drawer, $domain );
	 sl_cmm::configure( 
	    $self, $nodeDir, $domain, $drawer, $clusterName, $serviceName );
         sl_rnfs::configure( 
            $self, $groupDir, $nodeDir, $drawer, 
	    $clusterName, $swlVersion, @shelfLst );
      }
      else {
	 &sl_traces::error( "Unknown service < %s >",
	                    "- sl_node_solaris::deploy - ".__LINE__,
			    ( $serviceName ) );
      }
   }
   else {
      &sl_traces::error( "Drawer < %s > ".
                         "is undefined for node < %s >",
			 "- sl_node_solaris::deploy - ".__LINE__,
			 ( $drawerId, $nodeName ) );
   }
}

# ------------------------------------------------------------------------------

return 1;
