#!/usr/bin/perl -w
# ------------------------------------------------------------------------------
#   ident "@(#)sl_nls.pl 1.13     02/11/13 SMI"
# ------------------------------------------------------------------------------

BEGIN {
   require  "$ENV{'NHAS_PROD_DIR'}/nhsmct/lib/sl_fs.pl"; 
}

# ------------------------------------------------------------------------------

package sl_nls;

# Define NLS constants
$NLS_DIR = "/etc/opt/SUNWcgha";
$NLS_CONF = "nhnls.conf";
$NLS_MODULE = "com.sun.nhas.nls.module.BridgeSnmpManager";
$NLS_CONF_SEP = ":";

# ------------------------------------------------------------------------------

$NLT_DIR = "/etc";
$NLT_CONF = "SUNWnhnls_table";
$NLT_CONF_SEP = "\|";
$NLT_DEF_VALUE = "00";
$NLT_LOC_NO_LOC = "00";
$NLT_LOC_STATIC = "01";
$NLT_LOC_SWITCH = "02";
$NLT_LOC_ID_SEP = '@';
$NLT_BOOT_PARAM_SEP = ':';

# ------------------------------------------------------------------------------
# Temporary variables used for DHCP config script creation 
# (waiting for NLS implementation in C)

my %NLS_DICT = ();

my $NLS_DHCP_CONFIG_DIR="services/config/DHCP";
my $NLS_DHCP_COMMON_CONFIG_SCRIPT = "create_dhcp_common_config.sh";
my $NLS_DHCP_NODE_CONFIG_SCRIPT = "create_dhcp_node_config.sh";

my $NLS_DHCP_CONFIG_SCRIPT_TEMPLATE = 
   "NetworkNumNic0=<--SUBNET_NUM_0-->\n".
   "NetworkNumNic1=<--SUBNET_NUM_1-->\n".
   "NetworkNumCgtp=<--SUBNET_NUM_2-->\n".
   "\n".
   "NetworkMaskNic0=<--SUBNET_MASK_0-->\n".
   "NetworkMaskNic1=<--SUBNET_MASK_1-->\n".
   "NetworkMaskCgtp=<--SUBNET_MASK_2-->\n".
   "\n".
   "NetworkBroadCastNic0=<--SUBNET_BROADCAST_0-->\n".
   "NetworkBroadCastNic1=<--SUBNET_BROADCAST_1-->\n".
   "NetworkBroadCastCgtp=<--SUBNET_BROADCAST_2-->\n".
   "\n".
   "NetworkMasterNic0=<--SUBNET_MASTER_0-->\n".
   "NetworkMasterNic1=<--SUBNET_MASTER_1-->\n".
   "NetworkMasterCgtp=<--SUBNET_MASTER_2-->\n".
   "\n".
   "VendorLst=\"<--VENDOR_LST-->\"\n".
   "\n".
   "# Create DHCP network table for network configured on NIC0.\n".
   "\${PNTADM} -C \$\{NetworkNumNic0\}\n".
   "\n".
   "#Create DHCP network table for network configured on NIC1.\n".
   "\${PNTADM} -C \$\{NetworkNumNic1\}\n".
   "\n".
   "# Create the DHCP service configuration table\n".
   "\${DHTADM} -C\n".
   "\n".
   "# Initialize dhcptab container with standard Solaris symbols\n".
   "eval \${DHTADM} -A -s SbootFIL -d \\'Vendor=\$\{VendorLst\},7,ASCII,1,0\\'\n".
   "eval \${DHTADM} -A -s SswapPTH -d \\'Vendor=\${VendorLst},6,ASCII,1,0\\'\n".
   "eval \${DHTADM} -A -s SswapIP4 -d \\'Vendor=\${VendorLst},5,IP,1,0\\'\n".
   "eval \${DHTADM} -A -s SrootPTH -d \\'Vendor=\${VendorLst},4,ASCII,1,0\\'\n".
   "eval \${DHTADM} -A -s SrootNM -d \\'Vendor=\${VendorLst},3,ASCII,1,0\\'\n".
   "eval \${DHTADM} -A -s SrootIP4 -d \\'Vendor=\${VendorLst},2,IP,1,0\\'\n".
   "eval \${DHTADM} -A -s SrootOpt -d \\'Vendor=\${VendorLst},1,ASCII,1,0\\'\n".
   "eval \${DHTADM} -A -s NhCgtpAddr -d \\'Site,128,IP,1,1\\'\n".
   "\n".
   "# Add macros to dhcptab container\n".
   "eval \${DHTADM} -A -m \${NetworkNumNic0} \\\n".
   "-d ':Broadcst=\${NetworkBroadCastNic0}\\\n".
   ":MTU=1500:Router=\${NetworkMasterNic0}\\\n".
   ":Subnet=\${NetworkMaskNic0}:'\n".
   "\n".
   "eval \${DHTADM} -A -m \${NetworkNumNic1} \\\n".
   "-d ':Broadcst=\${NetworkBroadCastNic1}\\\n".
   ":MTU=1500:Router=\${NetworkMasterNic1}\\\n".
   ":Subnet=\${NetworkMaskNic1}:'\n".
   "\n".
   "eval \${DHTADM} -A -m Common \\\n".
   "-d ':BootSrvA=\${NetworkMasterCgtp}\\\n".
   ":SrootIP4=\${NetworkMasterCgtp}\\\n".
   ":SswapIP4=\${NetworkMasterCgtp}\\\n".
   ":BootSrvN=\${NetworkMasterCgtp}\\\n".
   ":SrootNM=\${NetworkMasterCgtp}:'\n";

# ------------------------------------------------------------------------------
#
sub configureNLS {
   my ( $node, $nodeDir, $clusterName, $serviceName, 
        $drawer, $domain, $swlVersion, @shelfLst ) = @_;
   my $nodeName = $node->getName;
   &sl_traces::trace( 2, "- sl_nls::configureNLS - Creating node ".
                      "< ${nodeName} > NLS configuration file" );
   my @switchLst =  ();
   foreach $shelf ( @shelfLst ) {
      push( @switchLst, $shelf->getSwitchLst );
   }
   # DHCP configuration directory and file
   my $dhcpConfigDir = "$ENV{'SMCT_TMP_DIR'}/${NLS_DHCP_CONFIG_DIR}";
   ( -d $dhcpConfigDir ) || &sl_utils::createDir( $dhcpConfigDir );
   my $dhcpConfigScript = 
      "${dhcpConfigDir}/${NLS_DHCP_COMMON_CONFIG_SCRIPT}";
   # Retrieve nics associated to the node from the switches
   # (one should find at least one nic)
   my $boardOid = $node->getBoard;
   my $board = $drawer->getBoard( $boardOid );
   my @nicLst = $board->getNicLst;
   my $moduleConfig = "";
   my $nlsSubnets = "";
   my $subnetCount = 0;
   my @masterIpAddrLst = $domain->getIpAddressLst;
   # Capture parameters used by the dhcp config. template
   foreach $nic ( @nicLst ) {
      my $nicName = $nic->getName;
      my $nicOid = $nic->iD;
      my $role = $nic->getRole;
      if ( ( $role eq $sl_nic::NIC_ROLE{'CGTP_NIC0'} ) or
	   ( $role eq $sl_nic::NIC_ROLE{'CGTP_NIC1'} ) or 
	   ( $role eq $sl_nic::NIC_ROLE{'CGTP'} ) ) {
	 my $ipAddress = $nic->getIpAddress;
	 my $ipNetworkOid = $ipAddress->getNetwork;
	 my $ipNetwork = $domain->getNetwork( $ipNetworkOid );
	 my $ipNetmask = $ipNetwork->getNetMask;
	 my $ipNetWorkNumber = $ipNetwork->getNumber;
	 my $broadcast = $ipNetwork->getBroadCast;
	 # Retrieve master address according to the network number
	 my $masterAddrTag = "<--SUBNET_MASTER_${subnetCount}-->";
	 foreach $ip ( @masterIpAddrLst ) {
	    my $masterNetworkOid = $ip->getNetwork;
	    my $masterNetwork = $domain->getNetwork( $masterNetworkOid );
	    my $masterNetworkNumber = $masterNetwork->getNumber;
	    if ( $masterNetworkNumber eq $ipNetWorkNumber ) {
	       $NLS_DICT{$masterAddrTag} = $ip->getAddress;
	       last;
	    }
         }
	 my $subnetNumTag = "<--SUBNET_NUM_${subnetCount}-->";
	 my $subnetMaskTag = "<--SUBNET_MASK_${subnetCount}-->";
	 my $subnetBroadCastTag = "<--SUBNET_BROADCAST_${subnetCount}-->";
         $NLS_DICT{$subnetNumTag} = $ipNetWorkNumber; 
	 $NLS_DICT{$subnetMaskTag} = $ipNetmask;
	 $NLS_DICT{$subnetBroadCastTag} = $broadcast;
         $NLS_DICT{$subnetNumTag} =~ s/(\s)+$//;
         $NLS_DICT{$subnetMaskTag} =~ s/(\s)+$//;
	 $NLS_DICT{$subnetBroadCastTag} =~ s/(\s)+$//;
	 $NLS_DICT{$masterAddrTag} =~ s/(\s)+$//;
	 $subnetCount++;
      }
   }
   # Fill the dhcp config creation script template
   open( DHCP_CONFIG , ">".$dhcpConfigScript ) ||
      &sl_traces::error( "Cannot open < %s >",
        "- sl_nls::configureNLS - ".__LINE__,
        ( $dhcpConfigScript ) );
   print DHCP_CONFIG $NLS_DHCP_CONFIG_SCRIPT_TEMPLATE;
   close( DHCP_CONFIG );      
}

# ------------------------------------------------------------------------------
#
sub configureNLT {
   my ( $node, $nodeDir, $clusterName, $serviceName, 
        $drawer, $domain, $swlVersion, @shelfLst ) = @_;
   my $nodeName = $node->getName;
   &sl_traces::trace( 2, "- sl_nls::configureNLT - Creating node ".
                      "< ${nodeName} > NLT configuration files" );
   my $dhcpConfigDir = "$ENV{'SMCT_TMP_DIR'}/${NLS_DHCP_CONFIG_DIR}";
   ( -d $dhcpConfigDir ) || &sl_utils::createDir( $dhcpConfigDir );
   my $dhcpConfigScript = "${dhcpConfigDir}/${NLS_DHCP_NODE_CONFIG_SCRIPT}";
   open( DHCP_CONFIG , ">>".$dhcpConfigScript ) ||
      &sl_traces::error( "Cannot open < %s >",
        "- sl_nls::configureNLS - ".__LINE__,
        ( $dhcpConfigScript ) );
   my @switchLst =  ();
   foreach $shelf ( @shelfLst ) {
      push( @switchLst, $shelf->getSwitchLst );
   }
   my $dataRemote = &sl_registry::getValue( $clusterName, "DATA_REMOTE" );
   my $nltConfFile = "$ENV{'SMCT_TMP_DIR'}/${NLT_CONF}"; 
   my $boardOid = $node->getBoard;
   my $board = $drawer->getBoard( $boardOid );
   my $boardName = $board->getName;
   my $clientId = $board->getSlotId;
   my $class = $board->getClass;
   my $cmd = "$ENV{'SMCT_LS'} $ENV{'SMCT_SOL_DIR'} | ".
             "$ENV{'SMCT_GREP'} Solaris";
   my $soe = `${cmd}`; chop( $soe );
   my @nicLst = $board->getNicLst;
   my $nlsSubnet = "";
   my $nodeOs = lc( $node->getOs );
   my $nodeArch = lc( $node->getArch );
   my $nodeGroup = $node->getGroupName;
   my $exportRoot = &sl_registry::getValue( $clusterName, "EXPORT_ROOT" );
   my $bootParamRoot = 
      "${exportRoot}/${swlVersion}/${nodeArch}/${nodeOs}/${nodeGroup}";
   # Get node CGTP address (used to initialize NhCgtpAddr parameter)
   my $nodeCgtpIpAddress = "";
   foreach $nic ( @nicLst ) {
      my $role = $nic->getRole;
      if ( $role eq $sl_nic::NIC_ROLE{'CGTP'} ) {
	 my $ipAddress = $nic->getIpAddress;
	 $nodeCgtpIpAddress = $ipAddress->getAddress;
      }
   }
   foreach $nic ( @nicLst ) {
      my $nodeIpAddress = "";
      my $ipNetworkNumber = "";
      my $netmask = "";
      my $nicName = $nic->getName;
      my $locId = undef;
      my $role = $nic->getRole;
      my $hardwareId = $NLT_DEF_VALUE;
      if ( ( $role eq $sl_nic::NIC_ROLE{'CGTP_NIC0'} ) or
	   ( $role eq $sl_nic::NIC_ROLE{'CGTP_NIC1'} ) ) {
	 my $ipAddress = $nic->getIpAddress;
	 $nodeIpAddress = $ipAddress->getAddress;
	 my $ipNetworkOid = $ipAddress->getNetwork;
	 my $ipNetwork = $domain->getNetwork( $ipNetworkOid );
	 $ipNetworkNumber = $ipNetwork->getNumber;
	 $locId = $ipNetworkNumber;
	 $netmask = $ipNetwork->getNetMask( "prefixLength" );
	 $locId .= "/${netmask}";
      }
      else {
	 next;
      }	     
      my $locType = $NLT_DEF_VALUE;
      if ( $serviceName eq
           $sl_service::SERVICE_NAME{'NLS_SWITCH_PORT_POLICY'} ) {
         $locType = $NLT_LOC_SWITCH;
	 # Check that the port number are not allocated multiple times
	 foreach $switch ( @switchLst ) {
	    my %portNumbers = ();
	    my $switchName = $switch->getName;
	    foreach $port ( $switch->getPortLst ) {
	       my $portNumber = $port->getNumber;
	       my $portName = $port->getName;
	       &sl_traces::error(
	          "Port number < ${portNumber} > is already ".
	          "allocated to port < $portNumbers{$portNumber} > of switch ".
		  "< ${switchName} >",
		  "- sl_nls::configureNLT - ".__LINE__ )
	       if ( defined $portNumbers{$portNumber} );
	       $portNumbers{$portNumber} = $portName;
	    }
	 }
	 my $nicOid = $nic->iD;
	 my $portNumber = undef;
	 foreach $switch ( @switchLst ) {
	    if ( defined $switch->getNic( $nicOid ) ) {
	       # The current nic is connected to the current switch
	       # Retrieve the associated Port
	       my $port = $switch->getPort( $nicOid );
	       $portNumber = $port->getNumber;
	    }
	 }
         &sl_traces::error( "The node < %s > is not ".
	                    "connected to a switch through the nic < %s >",
			    "- sl_nls::configureNLT - ".__LINE__,
			    ( $nodeName, $nicName ) )
            unless ( defined $portNumber );
         $locId = ${portNumber}.${NLT_LOC_ID_SEP}.${locId};
      }
      elsif ( $serviceName eq
              $sl_service::SERVICE_NAME{'MAC_ADDR_POLICY'} ) {
         $locType = $NLT_LOC_STATIC;
	 my $macAddress = $nic->getAddress;
	 &sl_traces::error( "The following parameter of the node ".
                            "< %s > is undefined:\n%s",
			    "- sl_nls::configureNLT -".__LINE__,
			    ( $nodeName, "${nicName} ethernet mac address" ) )
            unless ( defined $macAddress );
	 my $colMacAddress = sl_ip->collapseMacAddress( $macAddress );
         $hardwareId = ${locType}.${colMacAddress};
      }
      elsif ( $serviceName eq
              $sl_service::SERVICE_NAME{'STATIC_CLIENT_ID_POLICY'} ) {
         $locType = $NLT_LOC_STATIC;
	 &sl_traces::error( "The following parameter of the node ".
                            "< %s > is undefined:\n%s",
			    "- sl_nls::configureNLT -".__LINE__,
			    ( $nodeName, "${boardName} cPCI slot id" ) )
            unless ( defined $clientId );
         $hardwareId .= ${clientId};
      }
      # nodeId
      my $nodeId = $node->getId;
      my $nltConfigRaw = $nodeId;
      # nodeId | locType
      $nltConfigRaw .= "${NLT_CONF_SEP}${locType}";
      # nodeId | locType | locId
      $nltConfigRaw .= "${NLT_CONF_SEP}${locId}";
      # nodeId | locType | locId | hardwareId
      $nltConfigRaw .= "${NLT_CONF_SEP}${hardwareId}";
      # nodeId | locType | locId | hardwareId | bootParameters
      $bootParams = "SrootPTH=${bootParamRoot}/root/${nodeId}";
      $bootParams .= "${NLT_BOOT_PARAM_SEP}".
	             "SswapPTH=${bootParamRoot}/swap/${nodeId}/swap";
      $bootParams .= "${NLT_BOOT_PARAM_SEP}".
	             "BootFile=inetboot.${class}.${soe}";
      $nltConfigRaw .= "${NLT_CONF_SEP}${bootParams}";
      my $command = "echo \"${nltConfigRaw}\" >> ${nltConfFile};";
      #
      my $dhtadmCmd = "\${DHTADM} -A -m ${nodeIpAddress}";
      $dhtadmCmd .= " -d ':NhCgtpAddr=${nodeCgtpIpAddress}";
      $dhtadmCmd .= ":Include=Common:${bootParams}";
      $dhtadmCmd .= ":Include=${ipNetworkNumber}:'\n";
      print DHCP_CONFIG $dhtadmCmd;
      my $pntadmCmd = "\${PNTADM} -A ${nodeIpAddress}";
      $pntadmCmd .= " -i ${hardwareId} -f 'PERMANENT+MANUAL'";
      $pntadmCmd .= " -m ${nodeIpAddress} ${ipNetworkNumber}\n";
      print DHCP_CONFIG $pntadmCmd;
      $pntadmCmd = "\${PNTADM} -M ${nodeIpAddress}";
      $pntadmCmd .= " -i ${hardwareId} -f 'PERMANENT+MANUAL'";
      $pntadmCmd .= " -m ${nodeIpAddress} ${ipNetworkNumber}\n";
      print DHCP_CONFIG $pntadmCmd;
   }
   # Create NLS module config (in temporary file ; to be copied in MEN nls 
   # config file)
   if ( $serviceName eq
        $sl_service::SERVICE_NAME{'NLS_SWITCH_PORT_POLICY'} ) {
      # Look if module config already exists (to create config only once)
      my $tmpNlsConfDir = "$ENV{'SMCT_TMP_DIR'}";
      my $tmpNlsConfFile = "${tmpNlsConfDir}/${NLS_CONF}";
      my $moduleConfig = "";
      foreach $switch ( @switchLst ) {
         my @ipAddrLst = $switch->getIpAddressLst;
	 foreach $ip ( @ipAddrLst ) {
	    my $ipAddress = $ip->getAddress;
	    my $ipNetworkOid = $ip->getNetwork;
	    my $ipNetwork = $domain->getNetwork( $ipNetworkOid );
	    my $ipNetmask = $ipNetwork->getNetMask( "prefixLength" );
            # Prepare module config data
	    $moduleConfig .= ${NLS_CONF_SEP}
	       unless ( $moduleConfig eq "" );
	    $moduleConfig .= $ipAddress."/".$ipNetmask;
	 }
      }
      unless ( -f $tmpNlsConfFile ) {
	 my $command  = "echo \"NLS_MODULE=${NLS_MODULE}\" ".
			">> ${tmpNlsConfFile};";
	 $command .= "echo \"NLS_MODULE_CONFIG=${moduleConfig}\" ".
		     ">> ${tmpNlsConfFile};";
	 &sl_utils::execCmd( $command );
      }
   } elsif ( $serviceName eq
             $sl_service::SERVICE_NAME{'STATIC_CLIENT_ID_POLICY'} ) {
      # Configure the dhcp agent
      &sl_dhcp::configureAgent( $node, $nodeDir, $clientId );
   }
   close( DHCP_CONFIG );
}

# ------------------------------------------------------------------------------
#
sub _configureNLS {
   my ( $node, $nodeDir, $clusterName, $serviceName, 
        $drawer, $domain, $swlVersion, @shelfLst ) = @_;
   my $nodeName = $node->getName;
   &sl_traces::trace( 2, "- sl_nls::configureNLS - Creating node ".
                      "< ${nodeName} > NLS configuration file" );
   my @switchLst =  ();
   foreach $shelf ( @shelfLst ) {
      push( @switchLst, $shelf->getSwitchLst );
   }
   my $nlsConfDir = "${nodeDir}${sl_nls::NLS_DIR}";
   ( -d $nlsConfDir ) || &sl_utils::createDir( $nlsConfDir );
   my $nlsConfFile = "${nlsConfDir}/${NLS_CONF}";
   my $dataRemote = &sl_registry::getValue( $clusterName, "DATA_REMOTE" );
   my $nltPath = "${dataRemote}${NLT_DIR}";
   my $command = "echo \"NLS_PATH=${nltPath}\" ".
                 ">> ${nlsConfFile};";
   # Retrieve nics associated to the node from the switches
   # (one should find at least one nic)
   my $boardOid = $node->getBoard;
   my $board = $drawer->getBoard( $boardOid );
   my @nicLst = $board->getNicLst;
   my $moduleConfig = "";
   my $nlsSubnets = "";
   foreach $nic ( @nicLst ) {
      my $nicName = $nic->getName;
      my $nicOid = $nic->iD;
      my $role = $nic->getRole;
      if ( ( $role eq $sl_nic::NIC_ROLE{'CGTP_NIC0'} ) or
	   ( $role eq $sl_nic::NIC_ROLE{'CGTP_NIC1'} ) or 
	   ( $role eq $sl_nic::NIC_ROLE{'CGTP'} ) ) {
	 my $ipAddress = $nic->getIpAddress;
	 my $ipNetworkOid = $ipAddress->getNetwork;
	 my $ipNetwork = $domain->getNetwork( $ipNetworkOid );
	 my $ipNetmask = $ipNetwork->getNetMask( "prefixLength" );
	 my $ipNetWorkNumber = $ipNetwork->getNumber;
	 $nlsSubnets .= ${NLS_CONF_SEP}
	    unless ( $nlsSubnets eq "" );
	 $nlsSubnets .= "${ipNetWorkNumber}/${ipNetmask}";
      }
      $nlsSubnets =~ s/(\s)+$//;    
   }
   $command .= "echo \"NLS_SUBNETS=${nlsSubnets}\" ".
	       ">> ${nlsConfFile};";

   &sl_utils::execCmd( $command );
}

# ------------------------------------------------------------------------------
#
sub _configureNLT {
   my ( $node, $nodeDir, $clusterName, $serviceName, 
        $drawer, $domain, $swlVersion, @shelfLst ) = @_;
   my $nodeName = $node->getName;
   &sl_traces::trace( 2, "- sl_nls::configureNLT - Creating node ".
                      "< ${nodeName} > NLT configuration files" );
   my @switchLst =  ();
   foreach $shelf ( @shelfLst ) {
      push( @switchLst, $shelf->getSwitchLst );
   }
   my $boardOid = $node->getBoard;
   my $board = $drawer->getBoard( $boardOid );
   my $class = $board->getClass;
   my $cmd = "$ENV{'SMCT_LS'} $ENV{'SMCT_SOL_DIR'} | ".
             "$ENV{'SMCT_GREP'} Solaris";
   my $soe = `${cmd}`; chop( $soe );
   my @nicLst = $board->getNicLst;
   my $nlsSubnet = "";
   my $nodeOs = lc( $node->getOs );
   my $nodeArch = lc( $node->getArch );
   my $nodeGroup = $node->getGroupName;
   my $exportRoot = &sl_registry::getValue( $clusterName, "EXPORT_ROOT" );
   my $bootParamRoot = 
      "${exportRoot}/${swlVersion}/${nodeArch}/${nodeOs}/${nodeGroup}";
   foreach $nic ( @nicLst ) {
      my $nicName = $nic->getName;
      my $locId = undef;
      my $role = $nic->getRole;
      my $hardwareId = $NLT_DEF_VALUE;
      if ( ( $role eq $sl_nic::NIC_ROLE{'CGTP_NIC0'} ) or
	   ( $role eq $sl_nic::NIC_ROLE{'CGTP_NIC1'} ) ) {
	 my $ipAddress = $nic->getIpAddress;
	 my $ipNetworkOid = $ipAddress->getNetwork;
	 my $ipNetwork = $domain->getNetwork( $ipNetworkOid );
	 $locId = $ipNetwork->getNumber;
	 my $netmask = $ipNetwork->getNetMask( "prefixLength" );
	 $locId .= "/${netmask}";
      }
      else {
	 next;
      }	     
      my $locType = $NLT_DEF_VALUE;
      if ( $serviceName eq
           $sl_service::SERVICE_NAME{'NLS_SWITCH_PORT_POLICY'} ) {
         $locType = $NLT_LOC_SWITCH;
	 # Check that the port number are not allocated multiple times
	 foreach $switch ( @switchLst ) {
	    my %portNumbers = ();
	    my $switchName = $switch->getName;
	    foreach $port ( $switch->getPortLst ) {
	       my $portNumber = $port->getNumber;
	       my $portName = $port->getName;
	       &sl_traces::error(
	          "Port number < ${portNumber} > is already ".
	          "allocated to port < $portNumbers{$portNumber} > of switch ".
		  "< ${switchName} >",
		  "- sl_nls::configureNLT - ".__LINE__ )
	       if ( defined $portNumbers{$portNumber} );
	       $portNumbers{$portNumber} = $portName;
	    }
	 }
	 my $nicOid = $nic->iD;
	 my $portNumber = undef;
	 foreach $switch ( @switchLst ) {
	    if ( defined $switch->getNic( $nicOid ) ) {
	       # The current nic is connected to the current switch
	       # Retrieve the associated Port
	       my $port = $switch->getPort( $nicOid );
	       $portNumber = $port->getNumber;
	    }
	 }
         &sl_traces::error( "The node < %s > is not ".
	                    "connected to a switch through the nic < %s >",
			    "- sl_nls::configureNLT - ".__LINE__,
			    ( $nodeName, $nicName ) )
            unless ( defined $portNumber );
         $locId = ${portNumber}.${NLT_LOC_ID_SEP}.${locId};
      }
      elsif ( $serviceName eq
              $sl_service::SERVICE_NAME{'MAC_ADDR_POLICY'} ) {
         $locType = $NLT_LOC_STATIC;
	 my $macAddress = $nic->getAddress;
	 &sl_traces::error( "The following parameter of the node ".
                            "< %s > is undefined:\n%s",
			    "- sl_nls::configureNLT -".__LINE__,
			    ( $nodeName, "${nicName} ethernet mac address" ) )
            unless ( defined $macAddress );
	 my $colMacAddress = sl_ip->collapseMacAddress( $macAddress );
         $hardwareId = ${locType}.${colMacAddress};
      }
      elsif ( $serviceName eq
              $sl_service::SERVICE_NAME{'STATIC_CLIENT_ID_POLICY'} ) {
         $locType = $NLT_LOC_STATIC;
	 my $board = $drawer->getBoard( $node->getBoard );
	 my $boardName = $board->getName;
	 my $clientId = $board->getSlotId;
	 &sl_traces::error( "The following parameter of the node ".
                            "< %s > is undefined:\n%s",
			    "- sl_nls::configureNLT -".__LINE__,
			    ( $nodeName, "${boardName} cPCI slot id" ) )
            unless ( defined $clientId );
         $hardwareId .= ${clientId};
      }
      # nodeId
      my $nodeId = $node->getId;
      my $nltConfigRaw = $nodeId;
      # nodeId | locType
      $nltConfigRaw .= "${NLT_CONF_SEP}${locType}";
      # nodeId | locType | locId
      $nltConfigRaw .= "${NLT_CONF_SEP}${locId}";
      # nodeId | locType | locId | hardwareId
      $nltConfigRaw .= "${NLT_CONF_SEP}${hardwareId}";
      # nodeId | locType | locId | hardwareId | bootParameters
      $bootParams = "SrootPTH=${bootParamRoot}/root/${nodeId}";
      $bootParams .= "${NLT_BOOT_PARAM_SEP}".
	             "SswapPTH=${bootParamRoot}/swap/${nodeId}/swap";
      $bootParams .= "${NLT_BOOT_PARAM_SEP}".
	             "BootFile=inetboot.${class}.${soe}";
      $nltConfigRaw .= "${NLT_CONF_SEP}${bootParams}";
      my $command = "echo \"${nltConfigRaw}\" >> ${nltConfFile};";
      &sl_utils::execCmd( $command );
   }
   # Create NLS module config (in temporary file ; to be copied in MEN nls 
   # config file)
   if ( $serviceName eq
        $sl_service::SERVICE_NAME{'NLS_SWITCH_PORT_POLICY'} ) {
      # Look if module config already exists (to create config only once)
      my $tmpNlsConfDir = "$ENV{'SMCT_TMP_DIR'}";
      my $tmpNlsConfFile = "${tmpNlsConfDir}/${NLS_CONF}";
      my $moduleConfig = "";
      foreach $switch ( @switchLst ) {
         my @ipAddrLst = $switch->getIpAddressLst;
	 foreach $ip ( @ipAddrLst ) {
	    my $ipAddress = $ip->getAddress;
	    my $ipNetworkOid = $ip->getNetwork;
	    my $ipNetwork = $domain->getNetwork( $ipNetworkOid );
	    my $ipNetmask = $ipNetwork->getNetMask( "prefixLength" );
            # Prepare module config data
	    $moduleConfig .= ${NLS_CONF_SEP}
	       unless ( $moduleConfig eq "" );
	    $moduleConfig .= $ipAddress."/".$ipNetmask;
	 }
      }
      unless ( -f $tmpNlsConfFile ) {
	 my $command  = "echo \"NLS_MODULE=${NLS_MODULE}\" ".
			">> ${tmpNlsConfFile};";
	 $command .= "echo \"NLS_MODULE_CONFIG=${moduleConfig}\" ".
		     ">> ${tmpNlsConfFile};";
	 &sl_utils::execCmd( $command );
      }
   }
}

# ------------------------------------------------------------------------------
#
sub finalize {
   my ( $menGroupDir, %vendorTab ) = @_;
   &sl_traces::trace( 2, "- sl_nls::finalize - Terminating NLS ".
                      "configuration" );
   $NLS_DICT{'<--VENDOR_LST-->'} = "";
   foreach $vendor ( keys %vendorTab ) {
      $vendor =~ s/,/./g;
      $NLS_DICT{'<--VENDOR_LST-->'} .= "${vendor} ";
   }
   # Suppress trailing spaces from vendor list string
   $NLS_DICT{'<--VENDOR_LST-->'}  =~ s/(\s)+$//;
   # Move dhcp config script into the men group service config dir
   my $tmpConfigDir = "$ENV{'SMCT_TMP_DIR'}/${NLS_DHCP_CONFIG_DIR}";
   if ( -d $tmpConfigDir ) {
      my $configDir = "${menGroupDir}/${NLS_DHCP_CONFIG_DIR}";
      ( -d $configDir ) || &sl_utils::createDir( $configDir );
      my $tmpConfigScript = "${tmpConfigDir}/${NLS_DHCP_NODE_CONFIG_SCRIPT}";
      my $configScript = "${configDir}/${NLS_DHCP_NODE_CONFIG_SCRIPT}";
      &sl_utils::replaceInFile( $tmpConfigScript, $configScript, %NLS_DICT )
	 if ( -f $tmpConfigScript );
      $tmpConfigScript = "${tmpConfigDir}/${NLS_DHCP_COMMON_CONFIG_SCRIPT}";
      $configScript = "${configDir}/${NLS_DHCP_COMMON_CONFIG_SCRIPT}";
      &sl_utils::replaceInFile( $tmpConfigScript, $configScript, %NLS_DICT )
	 if ( -f $tmpConfigScript );
   }
}   

# ------------------------------------------------------------------------------

return 1;

