#!/usr/bin/perl -w
# ------------------------------------------------------------------------------
#   ident "@(#)sl_cmm.pl 1.12     02/11/13 SMI"
# ------------------------------------------------------------------------------

BEGIN {
   require  "$ENV{'NHAS_PROD_DIR'}/nhsmct/lib/sl_fs.pl"; 
}

# ------------------------------------------------------------------------------

package sl_cmm;

# Define CMM constants
$CMM_TARGET_CONF_FILE = "target.conf";
$CMM_CLUSTER_NODES_TABLE = "cluster_nodes_table";
$CMM_PACKAGES = "$ENV{'SMCT_SOFTREP_DIR'}/SUNWnhcm*";

# ------------------------------------------------------------------------------
#
sub _checkIpAddresses {
   my ( $domain, $role, %addrLst ) = @_;
   &sl_traces::trace( 2, "- sl_cmm::checkIpAddresses - Checking ".
                      "< ${role} > network ip addresses" );
   my $networkRef = undef;
   foreach $node ( keys %addrLst ) {
      my $ip = $addrLst{$node};
      my $ipAddr = $ip->getAddress;
      # Take as reference first network number
      $networkRef = $ip->getNetwork 
         unless ( defined $networkRef );
      my $networkOid = $ip->getNetwork;
      # Check that all the ip addresses belong to the same network
      &sl_traces::error( 
            "Node < %s > cannot use an ip ".
            "address which does not belong to the network ".
	    "< %s >".
	    "\nCurrent address   : %s".
	    "\nNetwork role      : %s".
	    "\nReference network : %s".
	    "\nCurrent network   : %s",
	    " - sl_cmm:checkIpAddresses - ".__LINE__,
	    ( $node, $networkRef, $ipAddr, $role, $networkRef, $networkOid ) )
         unless ( $networkOid eq $networkRef );
   }
}

# ------------------------------------------------------------------------------
#
sub checkConfig {
   my ( $domain, @nodeLst ) = @_;
   &sl_traces::trace( 2, "- sl_cmm::checkConfig - Checking cmm ".
                      "configuration" );
   my %cmm0IpLst = ();
   my %cmm1IpLst = ();
   my %cgtpIpLst = ();
   foreach $node ( @nodeLst ) {
      my $nodeName = $node->getName;
      my $nodeId = $node->getId;
      my $board = $node->getBoardObject;
      my @nicLst = $board->getNicLst;
      # Build ip list by network role
      foreach $nic ( @nicLst ) {
         my $ip = $nic->getIpAddress;
	 my $address = $ip->getAddress;
         my $networkOid = $ip->getNetwork;
         my $network = $domain->getNetwork( $networkOid );
	 my $hostId = sl_ip->getHostId( $ip, $network->getNetMask );
	 my $intHostId = sl_ip->hostToInt( $hostId );
         my $role = $nic->getRole;
	 if ( ( $role eq $sl_nic::NIC_ROLE{'CGTP'} ) or
	      ( $role eq $sl_nic::NIC_ROLE{'CGTP_NIC0'} ) or
	      ( $role eq $sl_nic::NIC_ROLE{'CGTP_NIC1'} ) ) {
	    &sl_traces::error( "The node id of the node < %s > ".
			       "cannot be equal to < %s >",
			       " - sl_cmm::checkConfig -".__LINE__,
			      ( $nodeName, $nodeId ) )
               unless ( $intHostId eq $nodeId );
	 }
	 if ( $role eq $sl_nic::NIC_ROLE{'CGTP'} ) {
	    unless ( defined $cgtpIpLst{$nodeName} ) {
               $cgtpIpLst{$nodeName} = $ip;
	    }
	    else {
	       &sl_traces::error( "The node < %s > uses two nics ".
	                          "the role of which is < %s >",
			          " - sl_cmm::checkConfig -".__LINE__,
				  ( $nodeName, $role ) );
	    }
	 }
	 elsif ( $role eq $sl_nic::NIC_ROLE{'CGTP_NIC0'} ) {
	    unless ( defined $cmm0IpLst{$nodeName} ) {
               $cmm0IpLst{$nodeName} = $ip;
	    }
	    else {
	       &sl_traces::error( "The node < %s > uses two nics ".
	                          "the role of which is < %s >",
			          " - sl_cmm::checkConfig -".__LINE__,
				  ( $nodeName, $role ) );
	    }
	 }
	 elsif ( $role eq $sl_nic::NIC_ROLE{'CGTP_NIC1'} ) {
	    unless ( defined $cmm1IpLst{$nodeName} ) {
               $cmm1IpLst{$nodeName} = $ip;
	    }
	    else {
	       &sl_traces::error( "The node < %s > uses two nics ".
	                          "the role of which is < %s >",
			          " - sl_cmm::checkConfig -".__LINE__,
				  ( $nodeName, $role ) );
	    }
	 }
      }
      # Check cmm ip addresses triplet
      &sl_traces::error( "The node < %s > must use 3 nics with ".
                         "the role %s/%s/%s",
			 " - sl_cmm::checkConfig -".__LINE__,
			 ( $nodeName, $sl_nic::NIC_ROLE{'CGTP'}, 
			   $sl_nic::NIC_ROLE{'CGTP_NIC0'}, 
			   $sl_nic::NIC_ROLE{'CGTP_NIC1'} ) )
         unless ( ( defined $cgtpIpLst{$nodeName} ) and
	          ( defined $cmm0IpLst{$nodeName} ) and
		  ( defined $cmm1IpLst{$nodeName} ) );
   }
   # Add floating CGTP master address to the cgtp ip addresses list
   $cgtpIpLst{$sl_domain::DOMAIN_MASTER_NAME} = $domain->getMasterIpAddress;
   # Check consistency of all the ip addresses of a network
   # (must belong to the same network)
   &_checkIpAddresses( $domain, $sl_nic::NIC_ROLE{'CGTP'}, %cgtpIpLst );
   &_checkIpAddresses( $domain, $sl_nic::NIC_ROLE{'CGTP_NIC0'}, %cmm0IpLst );
   &_checkIpAddresses( $domain, $sl_nic::NIC_ROLE{'CGTP_NIC1'}, %cmm1IpLst );
}

# ------------------------------------------------------------------------------
#
sub configure {
   my ( $node, $nodeDir, $domain, $drawer, $clusterName, $serviceName ) = @_;
   my $nodeName = $node->getName;
   my $domainId = $domain->getId;
   &sl_traces::trace( 2, "- sl_cmm::configure - Creating node ".
                      "< ${nodeName} > CMM configuration files" );
   # FS config file
   my $fsDir = "${nodeDir}${sl_fs::FS_CONF_DIR}";
   ( -d $fsDir ) || &sl_utils::createDir( $fsDir );
   my $fsConf = "${fsDir}/${sl_fs::FS_CONF}";
   my $tmpFsConf = "$ENV{'SMCT_TMP_DIR'}/${sl_fs::FS_CONF}";
   my $command = "";
   # Set CMM.DomainId
   $command .= "echo \"$sl_fs::FS_NODE_PROPERTIES{'NODE_DOMAIN_ID'}=".
      "${domainId}\" ".
      ">> ${fsConf};";
   # Set CMM.IsEligible
   $command .= ( $node->isMasterEligible ) ?
      "echo \"$sl_fs::FS_CMM_PROPERTIES{'IS_ELIGIBLE'}=".
      "True\" ".
      ">> ${fsConf};":
      "echo \"$sl_fs::FS_CMM_PROPERTIES{'IS_ELIGIBLE'}=".
      "False\" ".
      ">> ${fsConf};";
   # Set CMM.LocalConfig.Dir
   my $localConfigDir = "/etc/opt/SUNWcgha";
   $command .= "echo \"$sl_fs::FS_CMM_PROPERTIES{'LOCAL_CONFIG_DIR'}=".
      "${localConfigDir}\" ".
      ">> ${fsConf};";
   # Set CMM.MiniConfig.Dir
   $command .= "echo \"$sl_fs::FS_CMM_PROPERTIES{'MINI_CONFIG_DIR'}=".
      "${sl_fs::FS_CONF_DIR}\" ".
      ">> ${fsConf};";
   # Set CMM.MiniConfig.File
   $command .= "echo \"$sl_fs::FS_CMM_PROPERTIES{'MINI_CONFIG_FILE'}=".
      "${CMM_TARGET_CONF_FILE}\" ".
      ">> ${fsConf};";
   # Calculate CMM.Master.Id
   my $masterIpAddress = $domain->getMasterIpAddress;
   my $masterNetwork = $domain->getNetwork( $masterIpAddress->getNetwork );
   my $masterNetmask = $masterNetwork->getNetMask;
   my $masterHostId = sl_ip->getHostId( $masterIpAddress, $masterNetmask );
   my $masterIntHostId = sl_ip->hostToInt( $masterHostId );
   $command .= "echo \"$sl_fs::FS_CLUSTER_PROPERTIES{'MASTER_ID'}=".
      "${masterIntHostId}\" ".
      ">> ${fsConf};";      
   &sl_utils::execCmd( $command );
   # Populate cluster node table (copied back to node specific location by
   # class method sl_node::deploy
   my $clusterNodesTable = 
      "$ENV{'SMCT_TMP_DIR'}/${CMM_CLUSTER_NODES_TABLE}";
   my $nodeId = $node->getId;
   $command = "echo \"${nodeId} ${domainId} ${nodeName} -\" ".
      ">> ${clusterNodesTable}";
   &sl_utils::execCmd( $command );
   # Create target.conf file 
   $command = "$ENV{'SMCT_FIND'} ${CMM_PACKAGES} | ".
              "$ENV{'SMCT_GREP'} ${CMM_TARGET_CONF_FILE}.template";
   # If several versions of the package exist, one can have more 
   # than one target.conf template 
   my @targetConfFileTmplTab = `$command`;
   my $targetConfFileTmpl = $targetConfFileTmplTab[0];
   chomp( $targetConfFileTmpl );
   $command = "$ENV{'SMCT_CAT'} ${targetConfFileTmpl}";
   # Set domain_id
   $command .= "|$ENV{'SMCT_SED'} -e ".
               "'s,^domain_id.*:.*,domain_id : ${domainId},'";
   if ( $node->isMasterEligible ) {
      # Set election
      $command .= "|$ENV{'SMCT_SED'} -e ".
        	  "'s,^election.*:.*,election : 5,'";
      # Set role
      $command .= "|$ENV{'SMCT_SED'} -e ".
        	  "'s,^role.*:.*,role : MASTER,'";
   }
   $command .= " > ${fsDir}/${CMM_TARGET_CONF_FILE}";
   &sl_utils::execCmd( $command );
}

# ------------------------------------------------------------------------------

return 1;
