#!/usr/bin/perl -w
# ------------------------------------------------------------------------------
#   ident "@(#)fl_iplink.pm 1.9     02/11/19 SMI"
# ------------------------------------------------------------------------------

BEGIN {
  require "$ENV{NHAS_PROD_DIR}/nhsmct/lib/fl_filesys.pl";
  require "$ENV{NHAS_PROD_DIR}/nhsmct/lib/fl_traces.pl";
  require "$ENV{NHAS_PROD_DIR}/nhsmct/lib/fl_utils.pl";
}

package fl_iplink;

sub new {

   my $class = shift;
   my $solaris_dist = undef;
   my %attr = @_;
   my $self = {};
   bless $self, $class;
   
   my $if;
   my $alias;
   my $gateway;
   my $flags;
   my $ref;
   my $use;
   my $interface;
   my $netstat = "/usr/bin/netstat";
   my $ifconfig = "/usr/sbin/ifconfig";

   $self->{'IFACE'} = $attr{'IFACE'} if ( defined($attr{'IFACE'}) );

   &_checkIp( $attr{'NETMASK'}, "netmask" );
   $self->{'netmask'} = $attr{'NETMASK'};

   &_checkIp( $attr{'IP_SERVER'} );
   $self->{'node_server'} = 
      &_hostToInt( &_getHostId( $attr{'IP_SERVER'}, $attr{'NETMASK'} ) );
   $self->{'server_ip'} = $attr{'IP_SERVER'};
   
   &_checkIp( $attr{'IP_PROTOTYPE'} );
   $self->{'node_prototype'} = 
      &_hostToInt( &_getHostId( $attr{'IP_PROTOTYPE'}, $attr{'NETMASK'} ) );
   $self->{'node_ip'} = $attr{'IP_PROTOTYPE'};
   $self->{'node_ether'} = $attr{'ETHER'};
   
   $self->_checkNetwork;
   
   unless ( defined $attr{'NAME_SERVER'} ) {
      $self->{'server'} = "install-server-$self->{'node_server'}";
   }
   else {
      $self->{'server'} = $attr{'NAME_SERVER'};
   }
   unless ( defined $attr{'NAME_PROTOTYPE'} ) {
      $self->{'prototype'} = "prototype-$self->{'node_prototype'}";
   }
   else {
      $self->{'prototype'} = $attr{'NAME_PROTOTYPE'};
   }
   
   &main::error("You must specify real network interface name, not an alias (aka name:number)")
   if ( defined($self->{'IFACE'}) &&  $self->{'IFACE'} =~ /:/ );

   &main::control_file_is_executable($netstat);   
   open ( NETSTAT, "$netstat -rn |" ) || &error("Unable to perform \"$netstat -rn\" command");  
   
   while ( <NETSTAT> ) {
      chop(); 
      ( $network, $gateway, $flags, $ref, $use, $interface ) = split /\s+/;
      next unless ( defined($network) );  
      if ( $network eq $self->{'network'} ) {
         $count++;
         &main::error("route to master system is not local") 
	    unless ( $flags eq "U" );
	# unless ( $gateway eq $self->{'server_ip'} ) {
        #    &main::warning(
	#       "IP adresse of \"$interface\" interface must be $self->{'server_ip'}") ;
        # }
	 if ( $self->{'IFACE'} ) {
            ($if, $alias) = split ( /:/,$interface) ;
            &main::error("Configuration of interface \"$interface\"conflict with request")
	    unless ( $if eq $self->{'IFACE'} );
         }
         last;
      }
   }
 
   #
   # No route exist
   #
   #if ( ! $count ) {
   
        &main::error("Master system no accessible, you must specify an interface with -i option")
	unless ( defined($self->{'IFACE'}) );
   
        &main::control_file_is_executable($ifconfig);
	   
   	#
	# Test if real interface is configured
	#
        # 
        #
        # Unplumb and "re"plumb  alias corresponding to cluster/subnet
	#
        my @ipTab = split( '\.', $self->{'server_ip'} );
	$alias = $ipTab[3];
	&main::exec_cmd ("$ifconfig $self->{'IFACE'}:$alias unplumb > /dev/null 2>&1");
	&main::exec_cmd ("$ifconfig $self->{'IFACE'}:$alias plumb")||
        &main::error("Unable to plumb \"%s:%s\" network interface", ( $self->{'IFACE'}, $alias ) );
	
	#
	# Configure interface
	#
	my $cmd = "$ifconfig  $self->{'IFACE'}:$alias $self->{'server_ip'} ".
	          "netmask $self->{'netmask'} broadcast + up -private";
	&main::exec_cmd ( $cmd ) ||
	&main::error("Unable to configure \"%s:%s\" network interface", ( $self->{'IFACE'}, $alias ));
   #}   

   return $self;
   
}

# ------------------------------------------------------------------------------
#
sub _getHostId {
   my ( $ipAddress, $netmask ) = @_;
   &main::trace( 2, "- sl_ip::getHostId - Extracting host-id from ".
                    "ip address < ${ipAddress} >" );
   my @splittedAddr = split( '\.', $ipAddress );
   my @splittedMask = split( '\.', $netmask );
   my @splittedHostId = ();
   for ( my $i = 0; $i < scalar @splittedAddr; $i++ ) {
      $splittedHostId[$i] = 
         $splittedAddr[$i] & ( $splittedMask[$i] ^ 0xFF );
   }
   return join( ".", @splittedHostId );
}

# ------------------------------------------------------------------------------
#
sub _hostToInt {
   my $hostId = shift;
   &main::trace( 2, "- sl_ip::hostToInt - Calculating node-id from ".
                      "host id < ${hostId} >" );
   my @splittedHostId =  split( '\.', $hostId );
   my $intHostId = 0;
   for (my $i = 0; $i < 4; $i++ ) {
      $intHostId += ( 16**(3 - $i) ) * $splittedHostId[$i];
   }
   return $intHostId;
}

# ------------------------------------------------------------------------------

sub _checkIp {
   my ( $ip, $netmask ) = @_;
   my @mLst = split( '\.', $ip );
   my $count = 0;
   &main::error("Invalid ip or netmask value \"%s\"", ( $ip ) ) 
      if ( scalar @mLst != 4 );
   foreach $m ( @mLst ) {
      &main::error("Invalid value \"%s\"", ( $ip ) ) 
	 unless ( $m =~ /^\d+$/ );
      if ( defined $netmask ) {
	 &main::error("Invalid netmask value \"%s\"", ( $ip ) ) 
	    unless ( $m >= 0 and  $m <= 255 );
      }
      else {
	 &main::error("Invalid ip value \"%s\"", ( $ip ) ) 
	    if ( ( $count == 3 ) and ( $m == 0)  );
	 &main::error("Invalid ip value \"%s\"", ( $ip ) ) 
	    if ( $m > 255 );
      }
      $count++;
   }
}

# ------------------------------------------------------------------------------
# '_getNetworkNumber'
#
sub _getNetworkNumber {
   my ( $maskItem, $ipItem ) = @_;
   my $strMask = unpack( "B32", pack("N", $maskItem) );
   $strMask =~ s/^0+(?=\d)//;
   my @strMaskTab = split( "", $strMask );
   my $strIp = unpack( "B32", pack("N", $ipItem) );
   $strIp =~ s/^0+(?=\d)//; 
   my @strIpTab = split( "", $strIp );
   my $netNumber = "";
   for ( my $i = 0; $i < scalar @strIpTab; $i++ ) {
      last if ( $strMaskTab[$i] == 0 );
      $netNumber .= $strIpTab[$i]
         if ( $strMaskTab[$i] == 1 );
   }
   return $netNumber;
}

# ------------------------------------------------------------------------------
# '_bintodec'
#
sub _bintodec {
    unpack( "N", pack( "B32", substr( "0" x 32 . shift, -32) ) );
}

# ------------------------------------------------------------------------------
# 'getNetworkNumber'
#
sub getNetworkNumber {
   my $self = shift;
   my ( $item ) = @_;
   my @ipTab = split( '\.', $self->{$item} );
   my @maskTab = split( '\.', $self->{'netmask'} );
   my @netNumber = ();
   for ( my $i = 0; $i < scalar @ipTab; $i++ ) {
      push( @netNumber, 
            &_bintodec( &_getNetworkNumber( $maskTab[$i], $ipTab[$i] ) ) );
   }
   return join( '.', @netNumber );
}

# ------------------------------------------------------------------------------

sub _checkNetwork {
   $self = shift;
   my $nodeNetNumber = $self->getNetworkNumber( "node_ip" );
   my $serverNetNumber = $self->getNetworkNumber( "server_ip" );
   if ( $serverNetNumber ne $nodeNetNumber ) {
      &main::error( "Network numbers for master or  system and ".
                    "install-server are different\nmaster or ".
		    "clone system: \"%s\" install-server: \"%s\"",
		    ( $nodeNetNumber, $serverNetNumber ) );
   }
   else {
      $self->{'network'} = $nodeNetNumber;
   }
}

# ------------------------------------------------------------------------------

return 1;   
