#!/bin/sh
# ------------------------------------------------------------------------------
#   ident "@(#)wdt.conf.sh 1.5     02/10/30 SMI"
# ------------------------------------------------------------------------------
#   - WDT configuration script -
# ------------------------------------------------------------------------------

if [ $SMCT_DEBUG ]
then
   set -x
fi

if [ $GROUP_TYPE = "DISKLESS" ]
then
   PATH_PREFIX=/a${SHARED_ROOT}/${GROUP_NAME}/root
   for NODE in $NODE_LIST
   do
      WDT_CONF_DIR_LST=${PATH_PREFIX}/${NODE}/etc/opt/SUNWcgha" "
   done
else
   WDT_CONF_DIR_LST=/a/etc/opt/SUNWcgha
fi

WDT_CONF=nhwdt.conf

for WDT_CONF_DIR in $WDT_CONF_DIR_LST
do
   # Save previous version of the configuration file
   /bin/mv ${WDT_CONF_DIR}/${WDT_CONF} ${WDT_CONF_DIR}/${WDT_CONF}.bak

   # Disable OS Watchdog (default mode) 
   echo "nhas_watchdog=false" > ${WDT_CONF_DIR}/${WDT_CONF}
   # Set a timeout of 3s and a patting interval of 2s
   echo "os_timeout=3000" >> ${WDT_CONF_DIR}/${WDT_CONF}
   echo "patting_intvl=2000" >> ${WDT_CONF_DIR}/${WDT_CONF}
   # Set the OS Watchdog timeout at 5s during shutdown phase
   echo "shutdown_timeout=5000" >> ${WDT_CONF_DIR}/${WDT_CONF}

   if [ $GROUP_TYPE = "DISKLESS" ]
   then
      # Enable OBP timeout (timeout=300s)
      echo "obp_enable=true" >> ${WDT_CONF_DIR}/${WDT_CONF}
      echo "obp_timeout=300000" >> ${WDT_CONF_DIR}/${WDT_CONF}
   else
      # Enable OBP timeout (timeout=300s)
      echo "obp_enable=false" >> ${WDT_CONF_DIR}/${WDT_CONF}
      echo "obp_timeout=300000" >> ${WDT_CONF_DIR}/${WDT_CONF}
   fi
done

exit 0
