#!/usr/bin/perl -w
# ------------------------------------------------------------------------------
#   ident "@(#)flash.pl 1.9     02/10/30 SMI"
# ------------------------------------------------------------------------------

BEGIN {
   require "$ENV{NHAS_PROD_DIR}/nhsmct/lib/fl_traces.pl";
   require "$ENV{NHAS_PROD_DIR}/nhsmct/lib/fl_utils.pl";
   require "$ENV{NHAS_PROD_DIR}/nhsmct/lib/fl_filesys.pl";
   require "$ENV{NHAS_PROD_DIR}/nhsmct/lib/fl_slb.pm";
   require "$ENV{NHAS_PROD_DIR}/nhsmct/lib/fl_group.pm";
   require "$ENV{NHAS_PROD_DIR}/nhsmct/lib/fl_solaris.pm";
   require "$ENV{NHAS_PROD_DIR}/nhsmct/lib/fl_iplink.pm";
   require "$ENV{NHAS_PROD_DIR}/nhsmct/lib/fl_flash.pm";
   require "$ENV{NHAS_PROD_DIR}/nhsmct/lib/sl_registry.pl";
   require "$ENV{NHAS_PROD_DIR}/nhsmct/lib/fl_jumpstart.pl";
}

# ------------------------------------------------------------------------------

  # flxxx Config. files
  my $INSTALL_SERVER_CONF = "install-server.conf";
  my $PROTOTYPE_CONF = "master-system.conf";

  # prototype and instal-server config. parameters
  my $ROUTER = "n";
  my $IFACE = undef;
  my $IP_INSTALL = undef;
  my $IP_PROTOTYPE = undef;
  my $NAME_PROTOTYPE = undef;
  my $NAME_INSTALL = undef;
  my $NETMASK = undef;
  my $ETHER = undef;

  # Operation flags
  $INSTAL = 0;
  $CREATE = 0;
  $CONFIG = 0;
  $DEPLOY = 0;
  $HELP = 0;
  $OPERATION = undef;

  # Operation parameters and default values
  my $FLASH_ARCHIVE = undef;
  my $GROUP_NAME = undef;
  my $SOLARIS_DIST = $ENV{'SMCT_SOL_DIR'};
  my $EXPORT_DIR = $ENV{'SMCT_EXPORT_DIR'};
  my $JUMPSTART_DIR = $ENV{'SMCT_JUMPSTART_DIR'};
  my $CONFIG_DIR = $ENV{'SMCT_CONFIG_DIR'};
  my $FLASH_DIR = $ENV{'SMCT_FLASH_DIR'};
  my $VERBOSE = undef;

  # Execution directory
  my $EXECDIR = undef;
  
  # Local command (on the instal-server)
  my @BINARIES=();
  $CP = $ENV{'SMCT_CP'}; @BINARIES=( @BINARIES, $CP );
  $RCP = $ENV{'SMCT_RCP'}; @BINARIES=( @BINARIES, $RCP );  
  $CKSUM = $ENV{'SMCT_CKSUM'}; @BINARIES=( @BINARIES, $CKSUM );
  $KSH = $ENV{'SMCT_KSH'}; @BINARIES=( @BINARIES, $KSH );
  $SHARE = $ENV{'SMCT_SHARE'}; @BINARIES=( @BINARIES, $SHARE );
  $UNSHARE = $ENV{'SMCT_UNSHARE'}; @BINARIES=( @BINARIES, $UNSHARE );
  $RSH = $ENV{'SMCT_RSH'}; @BINARIES=( @BINARIES, $RSH );
  $PING = $ENV{'SMCT_PING'}; @BINARIES=( @BINARIES, $PING ); 
  $CAT = $ENV{'SMCT_CAT'}; @BINARIES=( @BINARIES, $CAT );
  $PERL = $ENV{'SMCT_PERL'}; @BINARIES=( @BINARIES, $PERL );
  $PWD = $ENV{'SMCT_PWD'}; @BINARIES=( @BINARIES, $PWD );
  $MKDIR = $ENV{'SMCT_MKDIR'}; @BINARIES=( @BINARIES,$MKDIR );
  $BASENAME = $ENV{'SMCT_BASENAME'}; @BINARIES=( @BINARIES, $BASENAME );
  $DIRNAME = $ENV{'SMCT_DIRNAME'}; @BINARIES=( @BINARIES, $DIRNAME );
  $GZIP = $ENV{'SMCT_GZIP'}; @BINARIES=( @BINARIES, $GZIP );
  $UUENCODE = $ENV{'SMCT_UUENCODE'}; @BINARIES=( @BINARIES, $UUENCODE );
  $TAR = $ENV{'SMCT_TAR'}; @BINARIES=( @BINARIES, $TAR );
  $LS = $ENV{'SMCT_LS'}; @BINARIES=( @BINARIES, $LS );
  $MV = $ENV{'SMCT_MV'}; @BINARIES=( @BINARIES, $MV );
                   
#-------------------------------------------------------------------------------
#
sub loadConfig {
   my ( $file, $target, $absolute ) = @_;
   my $configFile = ( defined $absolute ) ? 
     $file:
     "${CONFIG_DIR}/models/${file}";
   &trace ( 2, "Loading config file < ${configFile} >" );
   &control_file_is_readable( $configFile );
   &sl_registry::import( $target, $configFile );
   my %reg = &sl_registry::getRegistry( $target );
   if ( $target eq "INSTALL" ) { 
      $IP_INSTALL =
         checkMandatory( $reg{'ip'}, "ip", $configFile );
      $NAME_INSTALL = 
         checkMandatory( $reg{'name'}, "name", $configFile );
      $NETMASK = 
	 checkMandatory( $reg{'netmask'}, "netmask", $configFile );
      $IFACE = 
	 checkMandatory( $reg{'nic'}, "nic", $configFile );
      $ROUTER = $reg{'router'} if ( defined $reg{'router'} );
   }
   if ( $target eq "PROTOTYPE" ) { 
      $IP_PROTOTYPE =
         &checkMandatory( $reg{'ip'}, "ip", $configFile );
      $NAME_PROTOTYPE =
         &checkMandatory( $reg{'name'}, "name", $configFile );
      $ETHER = 
	 &checkMandatory( $reg{'mac'}, "mac", $configFile );
   }
}

##################################################################################
#
#                               This is the main
#
##################################################################################
    
#--------------------------------------------------------------------------------#
#
# Where am i
#
#--------------------------------------------------------------------------------#
chop($EXECDIR=`$PWD`);

#--------------------------------------------------------------------------------#
#
# Get Parameters
#
#--------------------------------------------------------------------------------#
# Look for the operation requested
$OPERATION="fl$ARGV[0]";

for ( $i=0; $i <= $#ARGV; $i++ ) {
   if ( ( $ARGV[$i] eq 'create' ) or
    ( $ARGV[$i] eq 'deploy' ) or
    ( $ARGV[$i] eq 'create' ) or
    ( $ARGV[$i] eq 'config' ) or
    ( $ARGV[$i] eq 'install' ) ) { $OPERATION="fl$ARGV[$i]"; last } 
}

# Check the operation parameters
if ( $OPERATION eq "fldeploy" ) {
   for ($i=0; $i <= $#ARGV; $i++) {
      if    ($ARGV[$i] eq '-V' ) { $VERBOSE= $ARGV[++$i]; }
      elsif ($ARGV[$i] eq '-d' ) { &more_debug() ;}
      elsif ($ARGV[$i] eq 'deploy' ) { $DEPLOY=1; }
      elsif ($ARGV[$i] eq '-n' ) { $SWL_NAME=$ARGV[++$i]; }
      elsif ($ARGV[$i] eq '-v' ) { $SWL_VERSION=$ARGV[++$i]; }
      elsif ($ARGV[$i] eq '-g' ) { $GROUP_NAME=$ARGV[++$i]; }
      elsif ($ARGV[$i] eq '-j' ) { $JUMPSTART_DIR=$ARGV[++$i]; }
      elsif ($ARGV[$i] eq '-e' ) { $EXPORT_DIR=$ARGV[++$i]; }
      elsif ($ARGV[$i] eq '-c' ) { $CONFIG_DIR=$ARGV[++$i]; }
      elsif ($ARGV[$i] eq '-f' ) { $FLASH_ARCHIVE=$ARGV[++$i]; }
      elsif ($ARGV[$i] eq '-h' ) { &usage; }
      elsif ($ARGV[$i] eq '-l' ) { &set_logfile($ARGV[++$i]); }
      else {
	 &usage( "Illegal option < $ARGV[$i] >" );
      }
   }
}
elsif ( $OPERATION eq "flconfig" ) {
   for ($i=0; $i <= $#ARGV; $i++) {
      if    ($ARGV[$i] eq '-V' ) { $VERBOSE= $ARGV[++$i]; }
      elsif ($ARGV[$i] eq '-d' ) { &more_debug() ;}
      elsif ($ARGV[$i] eq 'config' ) { $CONFIG=1; }
      elsif ($ARGV[$i] eq '-n' ) { $SWL_NAME=$ARGV[++$i]; }
      elsif ($ARGV[$i] eq '-v' ) { $SWL_VERSION=$ARGV[++$i]; }
      elsif ($ARGV[$i] eq '-g' ) { $GROUP_NAME=$ARGV[++$i]; }
      elsif ($ARGV[$i] eq '-e' ) { $EXPORT_DIR=$ARGV[++$i]; }
      elsif ($ARGV[$i] eq '-c' ) { $CONFIG_DIR=$ARGV[++$i]; }
      elsif ($ARGV[$i] eq '-f' ) { $FLASH_ARCHIVE=$ARGV[++$i]; }
      elsif ($ARGV[$i] eq '-h' ) { &usage; }
      elsif ($ARGV[$i] eq '-l' ) { &set_logfile($ARGV[++$i]); }
      else {
	 &usage( "Illegal option < $ARGV[$i] >" );
      }
   }
}
elsif ( $OPERATION eq "flinstall" ) {
   for ($i=0; $i <= $#ARGV; $i++) {
      if    ($ARGV[$i] eq '-V' ) { $VERBOSE= $ARGV[++$i]; }
      elsif ($ARGV[$i] eq '-d' ) { &more_debug() ;}
      elsif ($ARGV[$i] eq 'install' ) { $INSTAL=1; }
      elsif ($ARGV[$i] eq '-n' ) { $SWL_NAME=$ARGV[++$i]; }
      elsif ($ARGV[$i] eq '-v' ) { $SWL_VERSION=$ARGV[++$i]; }
      elsif ($ARGV[$i] eq '-g' ) { $GROUP_NAME=$ARGV[++$i]; }
      elsif ($ARGV[$i] eq '-j' ) { $JUMPSTART_DIR=$ARGV[++$i]; }
      elsif ($ARGV[$i] eq '-e' ) { $EXPORT_DIR=$ARGV[++$i]; }
      elsif ($ARGV[$i] eq '-c' ) { $CONFIG_DIR=$ARGV[++$i]; }
      elsif ($ARGV[$i] eq '-h' ) { &usage; }
      elsif ($ARGV[$i] eq '-l' ) { &set_logfile($ARGV[++$i]); }
      else {
	 &usage( "Illegal option < $ARGV[$i] >" );
      }
   }
}
elsif ( $OPERATION eq "flcreate" ) {
   for ($i=0; $i <= $#ARGV; $i++) {
      if    ($ARGV[$i] eq '-V' ) { $VERBOSE= $ARGV[++$i]; }
      elsif ($ARGV[$i] eq '-d' ) { &more_debug() ;}
      elsif ($ARGV[$i] eq 'create' ) { $CREATE=1; }
      elsif ($ARGV[$i] eq '-n' ) { $SWL_NAME=$ARGV[++$i]; }
      elsif ($ARGV[$i] eq '-v' ) { $SWL_VERSION=$ARGV[++$i]; }
      elsif ($ARGV[$i] eq '-g' ) { $GROUP_NAME=$ARGV[++$i]; }
      elsif ($ARGV[$i] eq '-e' ) { $EXPORT_DIR=$ARGV[++$i]; }
      elsif ($ARGV[$i] eq '-c' ) { $CONFIG_DIR=$ARGV[++$i]; }
      elsif ($ARGV[$i] eq '-f' ) { $FLASH_ARCHIVE=$ARGV[++$i]; }
      elsif ($ARGV[$i] eq '-h' ) { &usage; }
      elsif ($ARGV[$i] eq '-l' ) { &set_logfile($ARGV[++$i]); }
      else {
	 &usage( "Illegal option < $ARGV[$i] >" );
      }
   }
}
else {
   $HELP = 1;
   &usage( "Unknown operation < ${OPERATION} >" );
}


#--------------------------------------------------------------------------------#
#
# Test parameters
#
#--------------------------------------------------------------------------------#
if ( $INSTAL ) {
   &usage( "Missing option <swl-name>" )
       unless defined( $SWL_NAME );
   &usage( "Missing option <swl-version>" )
      unless defined( $SWL_VERSION ); 
   &usage( "Missing option <group-name>" )
      unless defined( $GROUP_NAME );
}
elsif ( $CREATE or $DEPLOY or $CONFIG ) {
   &usage( "Missing option <swl-name>" )
       unless defined( $SWL_NAME );
   &usage( "Missing option <swl-version>" )
      unless defined( $SWL_VERSION ); 
   &usage( "Missing option <group-name>" )
      unless defined( $GROUP_NAME );
   &usage( "Missing option <flash-archive>" )
      unless defined( $FLASH_ARCHIVE );
}
else {
   $HELP = 1;
   &usage;
}

&set_verbose( $VERBOSE ) if ( defined $VERBOSE );

#------------------------------------------------------------------------------
#
# Control we have access to executables
#
#------------------------------------------------------------------------------
foreach $binary (@BINARIES) {
  &main::control_file_is_executable("$binary");
}

#------------------------------------------------------------------------------
#
# Use absolute pathname for directories
#
#------------------------------------------------------------------------------
if ( defined( $EXPORT_DIR ) ) {
   $EXPORT_DIR = "${EXECDIR}/".$EXPORT_DIR 
      unless ( $EXPORT_DIR =~ /^\// );
}
if ( defined( $JUMPSTART_DIR ) ) {
   $JUMPSTART_DIR = "${EXECDIR}/".$JUMPSTART_DIR 
      unless ( $JUMPSTART_DIR =~ /^\// );
}
if ( defined( $SOLARIS_DIST ) ) {
   $SOLARIS_DIST = "$EXECDIR}/".$SOLARIS_DIST 
      unless ( $SOLARIS_DIST =~ /^\// );
}
if ( defined($FLASH_ARCHIVE) ) {
   if ($FLASH_ARCHIVE =~ /^\// ) {
      $FLASH_ARCHIVE = $FLASH_ARCHIVE;
   }
   elsif ( $FLASH_ARCHIVE =~ /\// ) {
      $FLASH_ARCHIVE = "${EXECDIR}/".$FLASH_ARCHIVE 
   }
   else {
      $FLASH_ARCHIVE = "${FLASH_DIR}/".$FLASH_ARCHIVE
   }
}
if ( defined( $CONFIG_DIR ) ) {
   $CONFIG_DIR = "${EXECDIR}/${CONFIG_DIR}"
      unless ( $CONFIG_DIR =~ /^\// );
}

#------------------------------------------------------------------------------
#
# Control directory accessibility
#
#------------------------------------------------------------------------------
&control_dir_is_readable( $EXPORT_DIR );
&control_dir_is_readable( $JUMPSTART_DIR );
&control_dir_is_readable( $SOLARIS_DIST );
&control_dir_is_readable( $CONFIG_DIR );

#------------------------------------------------------------------------------
#
# Load configuration flxxx parameters from files
#
#------------------------------------------------------------------------------
&loadConfig( $INSTALL_SERVER_CONF, "INSTALL" );

if ( $CREATE or $INSTAL or $DEPLOY ) {  
  # /etc/notrouter 
  unless ( defined $ROUTER ) {
    &error ("File /etc/notrouter must exist on this host") 
       unless ( -f "/etc/notrouter" );
  }  
}

#------------------------------------------------------------------------------
#
# Create common objects from parameters
#
#------------------------------------------------------------------------------

# Create Solaris distribution object
my $solaris = fl_solaris->new( SOLARIS_MEDIA => $SOLARIS_DIST );

# Create Software Load object
my $SWL_DIR = "${EXPORT_DIR}/${SWL_NAME}\@${SWL_VERSION}";
my $slbt = fl_slb->new( EXPORT => $SWL_DIR );

# Create group object
my $group = fl_group->new( DIR => $slbt->{'CLUSTER_DIR'}, NAME => $GROUP_NAME );


#------------------------------------------------------------------------------
#
#  We want to perform a jumpstart install package based on a prototype machine
#
#------------------------------------------------------------------------------
if ( $INSTAL ) {

   &info( 1, "Installing software load < ${SWL_NAME} > ".
          "version < ${SWL_VERSION} > for nodes group < ${GROUP_NAME} >" );

   # Create ip-link object
   &loadConfig( $PROTOTYPE_CONF, "PROTOTYPE" );
   my $iplink = fl_iplink->new ( NETMASK => $NETMASK,
				 IP_PROTOTYPE => $IP_PROTOTYPE,
				 IP_SERVER => $IP_INSTALL,
                        	 NAME_PROTOTYPE => $NAME_PROTOTYPE,
                        	 NAME_SERVER => $NAME_INSTALL,
				 IFACE   => $IFACE,
			         ETHER => $ETHER );

   &jumpstart_configure( $iplink );
   &jumpstart_create( undef, $JUMPSTART_DIR, $solaris, 
                      $slbt, $iplink, undef, $group );

   &info( 1, "has succeeded" );
}
#------------------------------------------------------------------------------
#
#  We want to create a generic Flash archive from a prototype machine
#
#------------------------------------------------------------------------------
elsif ( $CREATE ) {

   &info( 1, "Creating Flash archive < ${FLASH_ARCHIVE} > ".
          "for nodes group < ${GROUP_NAME} > " );
   
   if ( -e $FLASH_ARCHIVE ) {
      # The file already exist
      $yes_or_no = &ask( "\nWARNING: The Flash Archive < ${FLASH_ARCHIVE} > ".
                         "already exists\n".
			 "Do you want to remove it [ y | n ] ? " );
      unless ( $yes_or_no ) {
         &info( 1, "has failed" );
	 exit(1);
      }
   }

   # Create ip-link object
   &loadConfig( $PROTOTYPE_CONF, "PROTOTYPE" );
   my $iplink = fl_iplink->new ( NETMASK => $NETMASK,
				 IP_PROTOTYPE => $IP_PROTOTYPE,
				 IP_SERVER => $IP_INSTALL,
                        	 NAME_PROTOTYPE => $NAME_PROTOTYPE,
                        	 NAME_SERVER => $NAME_INSTALL,
				 IFACE   => $IFACE,
			         ETHER => $ETHER );

   &jumpstart_configure( $iplink );

   fl_flash->create_remote_flash_archive( 
      $FLASH_ARCHIVE, $slbt, $iplink, $group, $solaris );

   &info( 1, "has succeeded" );
}

#------------------------------------------------------------------------------
#
#  We want to add configuration sections on top of a generic Flash archive
#
#------------------------------------------------------------------------------
elsif ( $CONFIG ) {   

   &info( 1, "Configuring Flash archive < ${FLASH_ARCHIVE} > ".
          "for nodes group < ${GROUP_NAME} > " );
   
   my $swlState = $slbt->getState;
   if ( defined  $swlState ) {
      &error( "Invalid software load state \"${swlState}\" ".
              "\nCheck that slconfig and/or slexport have been run" )
	 unless ( ( $swlState eq "DPL_DONE" ) or
	          ( $swlState eq "CFG_DONE" ) );
   }
   else {
      &error( "Unknown software load state".
              "\nCheck that slconfig and/or slexport have been run" )
   }

   my $flash  = fl_flash->new ( PATH =>  $FLASH_ARCHIVE,
                                SOLARIS_DIST => $solaris );

   # Test coherency of flash archive and SLB export dir
   my $diff = $flash->compare( $slbt, $group, $solaris );      
   &error( "The Flash archive < ${FLASH_ARCHIVE} > does not match ".
           "the input parameters:\n${diff}" )
      if ( defined $diff );
      
   # Create User group config sections
   my @sectionLst = $group->createSections( "config" );
   
   # Take (re-create) nodes-group config section if deployment data already
   # exist or takes current nodes-group section in order to collect existing
   # config post installation scripts (if any)
   push( @sectionLst, $group->createSections );
   
   # Create slb sections
   push( @sectionLst, $slbt->createSections );
   
   # Add group & slb sections to the Flash archive
   $flash->addSections( @sectionLst );
   
   &info( 1, "has succeeded" );
}
#------------------------------------------------------------------------------
#
#  We want to perform a jumpstart install Flash archive based 
#  on the cluster nodes
#
#------------------------------------------------------------------------------
elsif ( $DEPLOY ) {

   &info( 1, "Deploying Flash archive < ${FLASH_ARCHIVE} > ".
          "for nodes group < ${GROUP_NAME} > " );
   
   my $swlState = $slbt->getState;
   if ( defined  $swlState ) {
      &error( "Invalid software load state \"${swlState}\" ".
              "\nCheck that sldeploy and/or slexport have been run" )
	 unless ( $swlState eq "DPL_DONE" );
   }
   else {
      &error( "Unknown software load state".
              "\nCheck that sldeploy and/or slexport have been run" )
   }

   my $flash  = fl_flash->new ( PATH =>  $FLASH_ARCHIVE,
                                SOLARIS_DIST => $solaris );
   # Test coherency of flash archive and SLB export dir
   my $diff = $flash->compare( $slbt, $group, $solaris );      
   &error( "The Flash archive < ${FLASH_ARCHIVE} > does not match ".
           "the input parameters:\n${diff}" )
      if ( defined $diff );
      
   # Check network configuration between cluster nodes and the install-server
   my $jumpstart_config_dir = "$slbt->{'CLUSTER_DIR'}/${GROUP_NAME}".
                              "/jumpstart/deploy";
   my $command = "${LS} ${jumpstart_config_dir}/clone-system.*.conf";
   my $nodeConfigFiles = `${command}`; chop( $nodeConfigFiles );
   my @confFileLst = split( "\n", $nodeConfigFiles );
   foreach $confFile ( @confFileLst ) {
      &loadConfig( $confFile, "PROTOTYPE", "absolute" );
      my $iplink = fl_iplink->new ( NETMASK => $NETMASK,
			      IP_PROTOTYPE => $IP_PROTOTYPE,
			      IP_SERVER => $IP_INSTALL,
                              NAME_PROTOTYPE => $NAME_PROTOTYPE,
                              NAME_SERVER => $NAME_INSTALL,
			      IFACE   => $IFACE,
     		              ETHER => $ETHER );
      &jumpstart_configure( $iplink );
   }
   
   # Create User nodes-group config sections (may not exist)
   my @sectionLst = $group->createSections( "config" );

   # Create nodes-group config sections
   push( @sectionLst , $group->createSections );
   
   # Create slb sections
   push( @sectionLst, $slbt->createSections );
   
   # Add group & slb sections to the Flash archive
   $flash->addSections( @sectionLst );
   
   # Create a jumpstart environment foreach node of the group
   foreach $confFile ( @confFileLst ) {
      &loadConfig( $confFile, "PROTOTYPE", "absolute" );
      my $iplink = fl_iplink->new ( NETMASK => $NETMASK,
			      IP_PROTOTYPE => $IP_PROTOTYPE,
			      IP_SERVER => $IP_INSTALL,
                              NAME_PROTOTYPE => $NAME_PROTOTYPE,
                              NAME_SERVER => $NAME_INSTALL,
			      IFACE   => $IFACE,
			      ETHER => $ETHER );
      # Extract node id from config file name: 
      # clone-system.<node-Id>.<node-host-name>.conf
      my $confName = `${BASENAME} ${confFile}`; chop( $confName );
      $confName =~ /\.(\d+)\./;
      my $nodeId =$1 if ( defined $1 );
      &error( "Unable to extract nodeId from config. file name: \"$confName\"")
         unless ( defined $nodeId );
      &jumpstart_create(
	 $nodeId, $JUMPSTART_DIR, $solaris, $slbt, $iplink, $flash, $group );
   }   

   &info( 1, "has succeeded" );
} 
#------------------------------------------------------------------------------
#
#  For which operation the tool has been launched ?
#
#------------------------------------------------------------------------------
else {
   $HELP = 1;
   &usage;
}   

# That's all folk!
exit( 0 );







