#!/usr/bin/perl
# ------------------------------------------------------------------------------
#  ident "@(#)variables.pm 1.14 02/10/15 SMI"
# ------------------------------------------------------------------------------
#
#  Copyright 2001 Sun Microsystems, Inc. All rights reserved.
#
# ------------------------------------------------------------------------------

package variables ;

require Exporter;
@ISA = qw(Exporter);
@EXPORT = ();

#------------------------------------------------------------------------------
#
# GLOBAL VARIABLES
#
#   Configuration data used by others modules
#   Handle with care !
#
#------------------------------------------------------------------------------

# type of installation: CLUSTER, ADD_DISKLESS
$INSTALL_TYPE = ""; export("\$INSTALL_TYPE");

# maximum number of nodes
$MAX_NODES=12; export("\$MAX_NODES");

# Cluster ID
$CLUSTER=""; export("\$CLUSTER");

# Node ID of the Production/Install server
$SERVER_NODE=""; export("\$SERVER_NODE");

# IP address of the server
$SERVER_IP=""; export("\$SERVER_IP");

# Production/Install Server interface name for private network
$IFACE=""; export("\$IFACE");

# Architecture of machines
$ARCH=sun4u; export("\$ARCH");

# description of nodes
@NODE_LIST=(); export("\@NODE_LIST");

# List of slices
@SLICE_LIST=(); export("\@SLICE_LIST");

# List of patches
$DO_ADDON=TRUE; export("\$DO_ADDON");
@PATCH_LIST=(); export("\@PATCH_LIST");
@PACKAGE_LIST=(); export("\@PACKAGE_LIST");

# predefined mounting point
$SLICE_ROOT="/" ; export("\$SLICE_ROOT");
$SLICE_SUNWCGHA="/SUNWcgha/local" ; export("\$SLICE_SUNWCGHA");
$SLICE_EXPORT="/export" ; export("\$SLICE_EXPORT");
$SLICE_TAG_REPLICA="replica"; export("\$SLICE_TAG_REPLICA");
$SLICE_UNMOUNTED="unnamed"; export("\$SLICE_UNMOUNTED");
$SLICE_ROOT_MIN_SIZE=2048; export("\$SLICE_ROOT_MIN_SIZE");
$SLICE_SUNWCGHA_MIN_SIZE=2048; export("\$SLICE_SUNWCGHA_MIN_SIZE");
$SLICE_EXPORT_MIN_SIZE=1024 ; export("\$SLICE_EXPORT_MIN_SIZE");
$SLICE_EXPORT_MIN_SIZE_PER_DISKLESS=100; export("\$SLICE_EXPORT_MIN_SIZE_PER_DISKLESS");
$SLICE_REPLICA=""; export("\$SLICE_REPLICA");

$DIR_SUNWCGHA_EXPORTED="/SUNWcgha/local/export" ; export("\$DIR_SUNWCGHA_EXPORTED");

# network interfaces for MEN
$MEN_NIC0="hme0" ; export("\$MEN_NIC0");
$MEN_NIC1="hme1" ; export("\$MEN_NIC1");

# network interfaces for NMEN
$NMEN_NIC0="eri0" ; export("\$NMEN_NIC0");
$NMEN_NIC1="eri1" ; export("\$NMEN_NIC1");

# name of cgtp interface
$CGTP_INTERFACE="cgtp0"; export("\$CGTP_INTERFACE");

# CGTP support
$USE_CGTP="YES" ; export("\$USE_CGTP");

# DSCC use
$USE_DCSS="NO" ; export("\$USE_DCSS");

# NSM use
$USE_NSM="NO" ; export("\$USE_NSM");

# WDT use
$USE_WDT="NO" ; export("\$USE_WDT");

# NLS use (if not, DHCP is used)
$USE_NLS="NO" ; export("\$USE_NLS");

# list of exported directories
@DIR_EXPORTED= ( $DIR_SUNWCGHA_EXPORTED ) ; export("\@DIR_EXPORTED");

# postfix for hostname depending on network interfaces
$POST_NIC0=""; export("\$POST_NIC0");
$POST_NIC1="-nic1"; export("\$POST_NIC1");
$POST_CGTP="-cgtp"; export("\$POST_CGTP");

# Node id for master and vice_master
$MASTER_ID=1; export("\$MASTER_ID");
$VICEMASTER_ID=2; export("\$VICEMASTER_ID");
$MEN1=0; export("\$MEN1");
$MEN2=1; export("\$MEN2");
$MEN1_ID=0; export("\$MEN1_ID");
$MEN2_ID=0; export("\$MEN2_ID");

# Public network
$USE_PUBLIC_NETWORK="NO"; export("\$USE_PUBLIC_NETWORK");
$PUBLIC_BIT_NETWORK=""; export("\$PUBLIC_BIT_NETWORK");
$PUBLIC_BIT_NETMASK=""; export("\$PUBLIC_BIT_NETMASK");
$PUBLIC_DOTTED_NETWORK=""; export("\$PUBLIC_DOTTED_NETWORK");
$PUBLIC_DOTTED_NETMASK=""; export("\$PUBLIC_DOTTED_NETMASK");

# External floating access for master
$USE_EXTERNAL_ACCESS="NO"; export("\$USE_EXTERNAL_ACCESS");
$EXTERNAL_HOSTNAME=""; export("\$EXTERNAL_HOSTNAME");
$EXTERNAL_IP=""; export("\$EXTERNAL_IP");
$EXTERNAL_NIC=""; export("\$EXTERNAL_NIC");

# network info to be used
$SERVER_IP=""; export("\$SERVER_IP");
$BIT_NETWORK=""; export("\$BIT_NETWORK");
$BIT_NETMASK=""; export("\$BIT_NETMASK");
$DOTTED_NETWORK=""; export("\$DOTTED_NETWORK");
$DOTTED_NETMASK=""; export("\$DOTTED_NETMASK");

# list of couple (remore directory, local mounting point)
@DIR_MOUNTED=(
	      {
	       "remote" => "$DIR_SUNWCGHA_EXPORTED/data" ,
	       "local"  => "/SUNWcgha/remote"
	      } ,
	      {
	       "remote" => "$DIR_SUNWCGHA_EXPORTED/services/ha_v1/opt" ,
	       "local"  => "/SUNWcgha/services"
	      } ,
	      {
	       "remote" => "$DIR_SUNWCGHA_EXPORTED/services" ,
	       "local"  => "/SUNWcgha/swdb"
	      } ,
	     ) ;
export("\@DIR_MOUNTED");

# vendor type list initialized with predefined vendor type string
@VENDOR_TYPE=(
	      "SUNW.UltraSPARC-IIi-cEngine",
	      "SUNW.UltraSPARC-IIi-Netract",
	      "SUNW.UltraSPARCengine_CP-60",
	      "SUNW.UltraAX-i2",
	      );
export("\@VENDOR_TYPE");

# diskless boot
$DISKLESS_BOOT_POLICY="DHCP_DYNAMIC";  export("\$DISKLESS_BOOT_POLICY");

# YES is Solaris installation is performed
$SOLARIS_INSTALL="YES"; export("\$SOLARIS_INSTALL");

# OS version
$TARGET_OS=""; export("\$TARGET_OS");

$AUTO_REBOOT = "YES"; export("\$AUTO_REBOOT");

# use by reboot to determine the process that need to be checked after booting
$REBOOT=""; export("\$REBOOT");

# -----------------------------------------------------------------------------
#
#   Netra HAS 2 variables (do not change!)
#
# -----------------------------------------------------------------------------

# info regarding the cluster network
$USE_CLUSTER_NETWORK="FALSE"; export("\$USE_CLUSTER_NETWORK");
$CLUSTER_BIT_NETMASK="";  export("\$CLUSTER_BIT_NETMASK");
$CLUSTER_BIT_NIC0_NET=""; export("\$CLUSTER_BIT_NIC0_NET");
$CLUSTER_BIT_NIC1_NET=""; export("\$CLUSTER_BIT_NIC1_NET");
$CLUSTER_BIT_CGTP_NET=""; export("\$CLUSTER_BIT_CGTP_NET");
$CLUSTER_DOTTED_NETMASK="";  export("\$CLUSTER_DOTTED_NETMASK");
$CLUSTER_DOTTED_NIC0_NET=""; export("\$CLUSTER_DOTTED_NIC0_NET");
$CLUSTER_DOTTED_NIC1_NET=""; export("\$CLUSTER_DOTTED_NIC1_NET");
$CLUSTER_DOTTED_CGTP_NET=""; export("\$CLUSTER_DOTTED_CGTP_NET");

# WORKAROUND_CMMLDAPSIMU flag
# If set to TRUE, we activate workaround CMMLDAPSIMU during install/config
$WORKAROUND_CMMLDAPSIMU="FALSE"; export("\$WORKAROUND_CMMLDAPSIMU");

# WORKAROUND_DISKLESS_CGTPMASTER_MOUNT flag
# If set to TRUE, we activate workaround DISKLESS_CGTPMASTER_MOUNT during install/config
$WORKAROUND_DISKLESS_CGTPMASTER_MOUNT="FALSE"; export("\$WORKAROUND_DISKLESS_CGTPMASTER_MOUNT");

# WORKAROUND_DISKLESS_CGTPMASTER_DHCP flag
# If set to TRUE, we activate workaround DISKLESS_CGTPMASTER_DHCP during install/config
$WORKAROUND_DISKLESS_CGTPMASTER_DHCP="FALSE"; export("\$WORKAROUND_DISKLESS_CGTPMASTER_DHCP");

# WORKAROUND_RBS_VICEMASTER_TFTP flag
# if set to TRUE, we activate the workaround WORKAROUND_RBS_VICEMASTER_TFTP during the install/config
$WORKAROUND_RBS_VICEMASTER_TFTP="TRUE"; export("\$WORKAROUND_RBS_VICEMASTER_TFTP");

# WORKAROUND_RBS_MEN_CRFS_SHARE flag
# if set to TRUE, we activate the workaround WORKAROUND_RBS_MEN_CRFS_SHARE during the install/config
# to set access and root permission to the triplet addresses of diskless nodes
$WORKAROUND_RBS_MEN_CRFS_SHARE="TRUE"; export("\$WORKAROUND_RBS_MEN_CRFS_SHARE");

# WORKAROUND_RBSCONFIG_SCRIPT flag
# if set to TRUE, we do nothing and let the installer use rbsconfig script
$WORKAROUND_RBSCONFIG_SCRIPT="FALSE"; export("\$WORKAROUND_RBSCONFIG_SCRIPT");

# force SVM support
$USE_SVM="NO"; export("\$USE_SVM");

# support of IDE disks
$IDE_SUPPORT="NO"; export("\$IDE_SUPPORT");

# restrictive access for /.rhosts
$RESTRICT_RHOSTS="NO"; export("\$RESTRICT_RHOSTS");


#
# module variables
#

$G_verbose = FALSE ; export("\$G_verbose");

# debug setting

$DEBUG_FILE   = "FALSE"; export("\$DEBUG_FILE");
$DEBUG_CMD    = "FALSE"; export("\$DEBUG_CMD");
$DEBUG_ACTION = "FALSE"; export("\$DEBUG_ACTION");
$DEBUG_CONFIG = "FALSE"; export("\$DEBUG_CONFIG");

# testing setting
$TESTING = "";  export("\$TESTING");


#-----------------------------------------------------------
#
# general variable definition
#
#-----------------------------------------------------------

$NHAS_PRODUCT       = "Netra HA Suite 2.1" ; export("\$NHAS_PRODUCT");

# Default FD if <log-file> is not defined
$LOG                = \*STDOUT;  export("\$LOG"); 
$LOGERR             = \*STDERR;  export("\$LOGERR"); 

$IN_LOGFILE         = FALSE ; export("\$IN_LOGFILE");
$LOGFILE_NAME       = ""; export("\$LOGFILE_NAME");
$VERBOSE            = 0; export("\$VERBOSE");
$NODE_ID            = 0; export("\$NODE_ID");
$CHECK_MOUNT_ERROR  = "TRUE"; export("\$CHECK_MOUNT_ERROR");

#-----------------------------------------------------------
#
# diskless environment definition
#
#-----------------------------------------------------------

$SHARED_FS          = "/SUNWcgha/local/export/services" ; export("\$SHARED_FS");
$OPT_SUBDIR         = "ha_v1/opt" ; export("\$OPT_SUBDIR");

$SERVICE_DIR        = ""; export("\$SERVICE_DIR");
$SERVICE_USR_PATH   = ""; export("\$SERVICE_USR_PATH");
$SERVICE_USR_BASEDIR= ""; export("\$SERVICE_USR_BASEDIR");

#-----------------------------------------------------------
#
#  variables set by reading the arguments when
#  scripts are called
#
#-----------------------------------------------------------

$ROOT_DIR                  = "" ; export("\$ROOT_DIR");
$JUMPSTART                 = "" ; export("\$JUMPSTART");
$SOLARIS_DIR               = "" ; export("\$SOLARIS_DIR");
$JDK_DIR                   = "" ; export("\$JDK_DIR");
$WORKING_DIR               = "" ; export("\$WORKING_DIR");
$SOLARIS_PACKAGE_SUBDIR    = "" ; export("\$SOLARIS_PACKAGE_SUBDIR");
$SOLARIS_PATCH_SUBDIR      = "" ; export("\$SOLARIS_PATCH_SUBDIR");
$PACKAGE_SUBDIR            = "" ; export("\$PACKAGE_SUBDIR");
$PATCH_SUBDIR              = "" ; export("\$PATCH_SUBDIR");
$LDAP_SUBDIR               = "" ; export("\$LDAP_SUBDIR");
$JDK_SUBDIR                = "" ; export("\$JDK_SUBDIR");

$LOCAL_PACKAGES            = "" ; export("\$LOCAL_PACKAGES");
$SHARED_PACKAGES           = "" ; export("\$SHARED_PACKAGES");
$JDMK_PACKAGES             = "" ; export("\$JDMK_PACKAGES");
$JDK_PACKAGES              = "" ; export("\$JDK_PACKAGES");
$SUPP_PACKAGES             = "" ; export("\$SUPP_PACKAGES");
$PATCH_NUMBER              = "" ; export("\$PATCH_NUMBER");
$NODE_ROLE                 = "" ; export("\$NODE_ROLE");
$PROFILE                   = "" ; export("\$PROFILE");
$ROUTER                    = "" ; export("\$ROUTER");
$LDAP_IPLANET              = "" ; export("\$LDAP_IPLANET");
$PHASE                     = "" ; export("\$PHASE");

$RECOVERY                  = "" ; export("\$RECOVERY");

#-----------------------------------------------------------
#
#  file name
#
#-----------------------------------------------------------

$FSCONF_DIR                = "/etc/opt/SUNWcgha";
    export("\$FSCONF_DIR");

$FSCONF_FILE               = "$FSCONF_DIR/nhfs.conf";    
    export("\$FSCONF_FILE");

$NODE_TABLE_FILE               = "$FSCONF_DIR/cluster_nodes_table";    
    export("\$NODE_TABLE_FILE");

$NLS_REMOTE_PATH                  = "/SUNWcgha/remote/etc";
    export("\$NLS_REMOTE_PATH");

$NLS_TABLE                = "/SUNWcgha/local/export/data/etc/SUNWnhnls_table";
    export("\$NLS_TABLE");

$NLSCONF_FILE              = "$FSCONF_DIR/nhnls.conf";
    export("\$NLSCONF_FILE");

#-----------------------------------------------------------
#
#  command definition
#
#-----------------------------------------------------------

$CP="/usr/bin/cp"; export("\$CP");
$RCP="/usr/bin/rcp"; export("\$RCP");
$KSH="/usr/bin/ksh"; export("\$KSH");
$SHARE="/usr/sbin/share"; export("\$SHARE");
$UNSHARE="/usr/sbin/unshare"; export("\$UNSHARE");
$RSH="/usr/bin/rsh"; export("\$RSH");
$PING="/usr/sbin/ping"; export("\$PING");
$CAT="/usr/bin/cat"; export("\$CAT");
$PERL="/usr/bin/perl"; export("\$PERL");
$PKILL="/usr/bin/pkill"; export("\$PKILL");
$PWD="/usr/bin/pwd"; export("\$PWD");
$NETSTAT="/usr/bin/netstat"; export("\$NETSTAT");
$RM="/usr/bin/rm"; export("\$RM");
$IFCONFIG="/usr/sbin/ifconfig"; export("\$IFCONFIG");
$MV="/usr/bin/mv"; export("\$MV");
$FIND="/usr/bin/find"; export("\$FIND"); 
$CAT="/usr/bin/cat"; export("\$CAT");
$SUM="/usr/bin/sum"; export("\$SUM");
$GREP="/usr/bin/grep"; export("\$GREP");
$ECHO="/usr/bin/echo"; export("\$ECHO");

$RMOUNT="/usr/sbin/mount";  export("\$RMOUNT");
$RUMOUNT="/usr/sbin/umount"; export("\$RUMOUNT");
$RPKGADD="/usr/sbin/pkgadd"; export("\$RPKGADD");
$RPATCHADD="/usr/sbin/patchadd"; export("\$RPATCHADD");
$RPATCHRM="/usr/sbin/patchrm"; export("\$RPATCHRM");
$RCHMOD="/usr/bin/chmod"; export("\$RCHMOD");
$RMKDIR="/usr/bin/mkdir"; export("\$RMKDIR");
$RPKGRM="/usr/sbin/pkgrm"; export("\$RPKGRM");
$RPKGINFO="/usr/bin/pkginfo"; export("\$RPKGINFO");
$RRM="/usr/bin/rm"; export("\$RRM");
$RDD="/usr/bin/dd";  export("\$RDD");
$RDHCPCONFIG="/usr/sbin/dhcpconfig"; export("\$RDHCPCONFIG");
$RPNTADM="/usr/sbin/pntadm"; export("\$RPNTADM");
$RDHTADM="/usr/sbin/dhtadm"; export("\$RDHTADM");
$RMV="/usr/bin/mv"; export("\$RMV");
$RLN="/usr/bin/ln"; export("\$RLN");
$RFIND="/usr/bin/find" ; export("\$RFIND");
$RCPIO="/usr/bin/cpio" ; export("\$RCPIO");
$RRSH="/usr/bin/rsh" ; export("\$RRSH");
$RSMOSSERVICE="/usr/sadm/bin/smosservice"; export("\$RSMOSSERVICE");
$RSMDISKLESS="/usr/sadm/bin/smdiskless"; export("\$RSMDISKLESS");
$RCOPY="/usr/bin/cp"; export("\$RCOPY");
$RECHO="/usr/bin/echo"; export("\$RECHO");
$RPKILL="/usr/bin/pkill"; export("\$RPKILL");
$RCAT="/usr/bin/cat"; export("\$RCAT");
$RRMDIR="/usr/bin/rmdir"; export("\$RRMDIR");
$RMETADB="/usr/sbin/metadb"; export("\$RMETADB");
$RMETAINIT="/usr/sbin/metainit"; export("\$RMETAINIT");
$RMETACLEAR="/usr/sbin/metaclear"; export("\$RMETACLEAR");
$RNEWFS="/usr/sbin/newfs"; export("\$RNEWFS");
$RUNAME="/usr/bin/uname"; export("\$RUNAME");

$RNETRAOS="/opt/SUNWdcss/bin/netraos"; export("\$RNETRAOS");
$RNETRADC="/opt/SUNWdcss/bin/netradc"; export("\$RNETRADC");

$CMMROLE="/opt/SUNWcgha/sbin/nhcmmrole"; export("\$CMMROLE");
$CMMADM="/opt/SUNWcgha/sbin/nhcmmadm"; export("\$CMMADM");

#
# information for Solaris installation
#
$PASSWORD="sunrules"; export("\$PASSWORD");
$ENCRYPTED_PASSWORD="mWlhY0O7LCRBc"; export("\$ENCRYPTED_PASSWORD");

$LOCALE="en_US"; export("\$LOCALE");
$TERMINAL="vt100"; export("\$TERMINAL");



sub export {
  my ($name) = @_;
#  print "name=$name\n";
  push @EXPORT, ("$name");
}

{
}
