#!/usr/bin/perl
# ------------------------------------------------------------------------------
#   ident "@(#)nmen_nls.pl 1.3 02/11/07 SMI"
# ------------------------------------------------------------------------------
#
#  Copyright 2001 Sun Microsystems, Inc. All rights reserved.
#
# ------------------------------------------------------------------------------

package NMEN_NLS;

use variables;

#--------------------------------------------------------------
#
# creation of NLS configuration file
#
#--------------------------------------------------------------

sub create_conf_file {

  my $tmpfile = "$WORKING_DIR/nhnls.tmp";
  my $net_nic0;
  my $net_nic1;
  my $net_cgtp;
  
  open(NLSCONF, ">$tmpfile");
  
  print NLSCONF "NLS_PATH=$NLS_REMOTE_PATH\n";
  print NLSCONF "NLS_LOGGING=NONE\n";
  
  if ($DISKLESS_BOOT_POLICY eq "NLS_SWITCH_PORT_POLICY") {
    my $NLS_SWITCH_ID = 250;
    print "Not completely implemented: Switch Id forced to 250\n";
    print NLSCONF "NLS_MODULE=com.sun.nhas.nls.module.BridgeSnmpManager\n";
    print NLSCONF "NLS_MODULE_CONFIG=10.$CLUSTER.1.$NLS_SWITCH_ID/24:10.$CLUSTER.2.$NLS_SWITCH_ID/24\n";
  }
  
  $net_nic0 = convertBitmaskToDotted($CLUSTER_NIC0_NET);
  if ($USE_CGTP eq "YES") {
    $net_nic1 = convertBitmaskToDotted($CLUSTER_NIC1_NET);
    $net_cgtp = convertBitmaskToDotted($CLUSTER_CGTP_NET);
    print NLSCONF "NLS_SUBNETS=$net_nic0/24:$net_nic1/24:$net_cgtp/24\n";
  } else {
    print NLSCONF "NLS_SUBNETS=$net_nic0/24\n";
  }
  
  print NLSCONF "NLS_VENDOR=";
  for my $i (0..$#VENDOR_TYPE) {
    print NLSCONF "$VENDOR_TYPE[$i] ";
  }
  print NLSCONF "\n";
  
  close(NLSCONF);
  
  my $node_ip = COMMON::get_external_ip($NODE_ID);
  COMMON::put_file($node_ip, $tmpfile, "$NLSCONF_FILE");
  unlink($tmpfile);
}

#--------------------------------------------------------------
#
# update the NLS Localization Table
#
#--------------------------------------------------------------

sub update_loc_table {

  ($filename) = @_;

  open(NLT,">>$filename");

  for my $node (0..$#NODE_LIST) {
    if (($NODE_LIST[$node]{type} eq "DISKLESS") 
	&& ($NODE_LIST[$node]{concerned} eq "TRUE")) {
      
      my $node_id = $NODE_LIST[$node]{id} ;
      my $node_name = COMMON::build_node_name($node_id, "");


      if ($DISKLESS_BOOT_POLICY eq "NLS_DYNAMIC") {

	print NLT "$node_id|00|00|00|BootFile=inetboot.$ARCH.$TARGET_OS:SrootPTH=/export/root/$node_name:SswapPTH=/export/swap/$node_name\n";
	
      } elsif ($DISKLESS_BOOT_POLICY eq "NLS_MAC_ADDR") {
	
	my $ip_nic0 = $CLUSTER_DOTTED_NIC0_NET;
	my $ip_nic1 = $CLUSTER_DOTTED_NIC1_NET;
	my $cid_nic0 = NMEN_RBS::build_cid($NODE_LIST[$node]{eth0});
	my $cid_nic1 = NMEN_RBS::build_cid($NODE_LIST[$node]{eth1}); 

	# CAUTION: MASK SIZE FORCED TO 24
	my $nic0_masksize = 24;
	my $nic1_masksize = 24;
	
	print NLT "$node_id|01|$ip_nic0/$nic0_masksize|$cid_nic0|BootFile=inetboot.$ARCH.$TARGET_OS:SrootPTH=/export/root/$node_name:SswapPTH=/export/swap/$node_name\n";
	print NLT "$node_id|01|$ip_nic1/$nic1_masksize|$cid_nic1|BootFile=inetboot.$ARCH.$TARGET_OS:SrootPTH=/export/root/$node_name:SswapPTH=/export/swap/$node_name\n";
	
      } elsif ($DISKLESS_BOOT_POLICY eq "NLS_CPCI_SLOT") {
	
	print "WARNING: CPI SLOT BOOT FOR DISKLESS NOT YET SUPPORTED\n";
	
      } elsif ($DISKLESS_BOOT_POLICY eq "NLS_SWITCH_PORT") {
	print "WARNING: SWITCH PORT BOOT FOR DISKLESS NOT YET SUPPORTED\n";
	# eth0 and eth1 contain complete reference to the switch connection (port + IP address)
	print NLT "$node_id|02|$NODE_LIST$[$node]{eth0}|00|BootFile=inetboot.$ARCH.$TARGET_OS:SrootPTH=/export/root/$node_name:SswapPTH=/export/swap/$node_name\n";
	print NLT "$node_id|02|$NODE_LIST$[$node]{eth1}|00|BootFile=inetboot.$ARCH.$TARGET_OS:SrootPTH=/export/root/$node_name:SswapPTH=/export/swap/$node_name\n";
	
      }
    }
  }

  close(NLT);
}
  
#--------------------------------------------------------------
#
# creation of NLS Localization Table
#
#--------------------------------------------------------------

sub create_loc_table {

  my $tmpfile = "$WORKING_DIR/nlt.tmp";
  my $node_ip = COMMON::get_external_ip($NODE_ID);

  open(NLT,">$tmpfile");
  close(NLT);

  update_loc_table($tmpfile);
  COMMON::put_file($node_ip, $tmpfile, "$NLS_TABLE");

  unlink($tmpfile);
}

#--------------------------------------------------------------
#
# installation of NLS packages
#
#--------------------------------------------------------------

sub nmen_nls {

  ($NODE_ID) = @_;

  if ($USE_NLS ne "YES") {
    return ;
  }

  COMMON::init_and_check([]);

  my $packages = $ENV{NLS_PACKAGES};
  COMMON::print_stage_node("Node Localization Service (NLS) installation") ;
  COMMON::install_men_pkg ($NODE_ID, $ROOT_DIR, $PACKAGE_SUBDIR, $packages, "LOCAL", "");

  create_conf_file();
  if ($NODE_ID eq $MEN1_ID) {
    create_loc_table();
  }

  # NMEN_RBS::rbs_vicemaster_workaround is executed while installing RBS

}

#--------------------------------------------------------------
#
# adding a diskless
#
#--------------------------------------------------------------

sub nmen_nls_add_nodes {

  ($NODE_ID) = @_;

  if ($USE_NLS ne "YES") {
    return ;
  }

  if ($NODE_ID ne $MEN1_ID) {
    return ;
  }

  my $node_ip = COMMON::get_external_ip($NODE_ID, "");
  my $men2_ip= COMMON::get_external_ip($MEN2_ID);
  my $tmpfile = "$WORKING_DIR/nlt.tmp";

  COMMON::init_and_check([]);

  COMMON::print_stage_node("Node Localization Service (NLS): configuration of additional nodes") ;

  COMMON::get_file($node_ip, $NLS_TABLE, $tmpfile);
  update_loc_table($tmpfile);
  COMMON::put_file($node_ip, $tmpfile, $NLS_TABLE);
  unlink($tmpfile);

  NMEN_RBS::rbs_vicemaster_workaround ($node_ip,$men2_ip);
}

{
}







