#!/usr/bin/perl
# ------------------------------------------------------------------------------
#   ident "@(#)nmen_cmm.pl 1.15 02/11/07 SMI"
# ------------------------------------------------------------------------------
#
#  Copyright 2001 Sun Microsystems, Inc. All rights reserved.
#
# ------------------------------------------------------------------------------

package NMEN_CMM;

use variables;

#-------------------------------------------------------------------------------
#
# Configure CMM 
#
#-------------------------------------------------------------------------------
sub cmm_configure {

  my ($proto_node_id) = @_;
  
  my $proto_ip   = COMMON::get_external_ip($proto_node_id);
  
  my $node_name_template;
  my $node_root;
    
  my $local_nodename = "$WORKING_DIR/nodename" ;
  my $remote_nodename;
  
  for $node (0..$#NODE_LIST) {
    
    if (($NODE_LIST[$node]{type} eq "DISKLESS") && ($NODE_LIST[$node]{concerned} eq "TRUE")) {
      
      my $node_id = $NODE_LIST[$node]{id};
      $node_name_template = COMMON::build_node_name($node_id, "") ;
      
      COMMON::print_subaction("configuring $node_name_template ...");
      
      $node_root = "/export/root/$node_name_template";
      $remote_cmm_conf = "$node_root/etc/opt/SUNWcgha/nhcmm.conf";		
      $remote_nodename = "$node_root/etc/nodename";
      
        
    #
    # create nodename file
    #
    open(NODENAME, ">$local_nodename") ||
      COMMON::error("Unable to create $local_nodename");
    
    if ($USE_CGTP eq "YES") {
      my $node_name_cgtp_template = COMMON::build_node_name($node_id, "CGTP") ;
      print NODENAME "${node_name_cgtp_template}\n";
    } else {
      my $node_name_nic0_template = COMMON::build_node_name($node_id, "NIC0") ;
      print NODENAME "${node_name_nic0_template}\n";
    }
    close(NODENAME);
    
    #
    # remote copy nodename
    #
    COMMON::put_file($proto_ip, "$local_nodename", "$remote_nodename");
    }
  }	
}				
       
#------------------------------------------------------------------------------
#
# installation and configuration of CMM
#
#------------------------------------------------------------------------------

sub nmen_cmm {

  ($NODE_ID) = @_;

  COMMON::init_and_check([]);

  my $cmm_packages = $ENV{CMM_PACKAGES};

  COMMON::print_stage_node("Cluster Membership Monitor (CMM) installation for diskless") ;
  COMMON::install_nmen_pkg ($NODE_ID, $ROOT_DIR, $PACKAGE_SUBDIR, $cmm_packages, "");
  
  COMMON::print_action("CMM configuration") ;
  cmm_configure($NODE_ID);

}

#------------------------------------------------------------------------------
#
# recovery after failure
#
#------------------------------------------------------------------------------

sub recovery_nmen_cmm {

  ($NODE_ID) = @_;

  COMMON::init_and_check([]);

  my $cmm_packages = $ENV{CMM_PACKAGES};

  COMMON::print_recovery_node("Cluster Membership Monitor (CMM) clean-up for diskless") ;
  COMMON::remove_nmen_pkg ($NODE_ID, $cmm_packages);
}


{
}

