#!/usr/bin/perl
# -----------------------------------------------------------------------------
#   ident "@(#)men_rnfs.pl 1.40 02/10/15 SMI"
# -----------------------------------------------------------------------------
#
#  Copyright 2001 Sun Microsystems, Inc. All rights reserved.
#
# -----------------------------------------------------------------------------
package MEN_RNFS;

use variables;
                  
#--------------------------------------------------------------
#
# installation of SNDR and RNFS packages
#		    
#--------------------------------------------------------------

sub install_packages {

  my $answers_file_name ="answers_sndr";
  my $answers_file ="${WORKING_DIR}/${answers_file_name}";
  
  # 
  # Create a pkgadd answers file
  # answers file is for SUNWscmu package
  #
  open(ANSWERS, ">$answers_file") ||
    COMMON::error("Unable to create $answers_file");
  
  print ANSWERS <<"FEO";
  
FILE_LOC=$ENV{SNDR_DATABASE}
  
FEO

  close(ANSWERS);
  
  my $packages = $ENV{RNFS_PACKAGES};
  COMMON::install_men_pkg($NODE_ID, $ROOT_DIR, $PACKAGE_SUBDIR, $packages, "LOCAL", $answers_file) ;
}

#--------------------------------------------------------------
#
# integer division (if there is a remaining, take the following
# integer value).
#		    
#--------------------------------------------------------------

sub divrounded
  {
    my ($value, $mod) = @_ ;

    my $res = int(($value-1)  / $mod + 1) ;
    return $res;
  }

#------------------------------------------------------------------------------
# replace the value of entry looking like <etrny>=<value>
# note that the final ";" must be part of the replacement string if needed
#------------------------------------------------------------------------------

sub update_file {
  my ( $rdc_file, $update_entry_input, $update_value_input ) = @_ ;
  my $count=0;
  my $update_entry;
  my $update_value;
  my $garbage;
  
  open (RDCFILE, $rdc_file ) || COMMON::error("Unable to open $rdc_file");
  open (RDCFILE_TMP, ">${rdc_file}.tmp" ) || COMMON::error("Unable to open ${rdc_file}.tmp");
	
  while ( <RDCFILE> ) {
    
    chop();
    if ($_ eq "") {
      next ;
    }

    ($update_entry, $update_value, $garbage) = split (/=/, $_) ;
    
    if ( "$update_entry" eq "$update_entry_input" ) {
      print RDCFILE_TMP "${update_entry}=${update_value_input}\n";
      $count++;
    } else {
      print RDCFILE_TMP "$_\n";
    }
    next;
    
  }
  close (RDCFILE);
  close (RDCFILE_TMP);
  
  unless ( $count ) {
    open (RDCFILE_TMP, ">>${rdc_file}.tmp" ) || COMMON::error("Unable to update $rdc_file");
    print RDCFILE_TMP "$update_entry_input=$update_value_input\n";
    close (RDCFILE_TMP);
  }
  
  COMMON::exec_cmd ( "$MV ${rdc_file}.tmp ${rdc_file}") ||
    COMMON::error ( "Unable to move ${rdc_file}.tmp ${rdc_file}");
  
}

sub update_vfstab_ufs {
  my ( $vfstab_file, $update_rdsk_input, $update_mountatboot_input ) = @_ ;
  my $update_rdsk;
  my $update_mountatboot;
  my $garbage1;
  my $garbage2;
  my $garbage3;
  my $garbage4;
  my $garbage5;
  my $garbage6;

  open (VFSTAB, $vfstab_file ) || COMMON::error("Unable to open $vfstab_file");
  open (VFSTAB_TMP, ">${vfstab_file}.tmp" ) || COMMON::error("Unable to open ${vfstab_file}.tmp");
	
  while ( <VFSTAB> ) {
    
    chop();
    s/#.*//;
    ($garbage1, $update_rdsk, $garbage2, $garbage3, $garbage4, $update_mountatboot, $garbage6) = split (/[\s\t]+/, $_) ;
    next unless (defined($update_rdsk));
    next unless (defined($update_mountatboot));
    
    if ( "$update_rdsk" eq "$update_rdsk_input" ) {
      print VFSTAB_TMP "$garbage1\t$update_rdsk\t$garbage2\t$garbage3\t$garbage4\t$update_mountatboot_input\t$garbage6\n";
    } else {
      print VFSTAB_TMP "$garbage1\t$update_rdsk\t$garbage2\t$garbage3\t$garbage4\t$update_mountatboot\t$garbage6\n";
    }
    
  }
  close (VFSTAB);
  close (VFSTAB_TMP);
  
  COMMON::exec_cmd ( "$MV ${vfstab_file}.tmp ${vfstab_file}") ||
    COMMON::error ( "Unable to move ${vfstab_file}.tmp ${vfstab_file}");  
}

sub update_vfstab_nfs {
   my ( $vfstab_file, $update_nfs_input, $update_nfs_value_input ) = @_ ;
   my $update_nfs;
   my $update_nfs_value;
   my $garbage;
   my $count = 0;
      
   open (VFSTAB, $vfstab_file ) || COMMON::error("Unable to open $vfstab_file");
   open (VFSTAB_TMP, ">${vfstab_file}.tmp" ) || COMMON::error("Unable to open ${vfstab_file}.tmp");
	
   while ( <VFSTAB> ) {
     
     chop();
     s/#.*//;
     ($update_nfs, $garbage) = split (/[\s\t]+/, $_) ;
            
     if ( "$update_nfs" eq "$update_nfs_input" ) {
       print VFSTAB_TMP "$update_nfs\t$update_nfs_value_input\n";
       $count++;
     } else {
       print VFSTAB_TMP "$_\n";
     }
     next;       	        
   }
   close (VFSTAB);
   close (VFSTAB_TMP);
	
   unless ($count) {
     open (VFSTAB_TMP, ">>${vfstab_file}.tmp" ) || COMMON::error("Unable to update $vfstab_file");
     print VFSTAB_TMP "$update_nfs_input\t$update_nfs_value_input\n";
     close (VFSTAB_TMP);
   }
	
   COMMON::exec_cmd ( "$MV ${vfstab_file}.tmp ${vfstab_file}") ||
     COMMON::error ( "Unable to move ${vfstab_file}.tmp ${vfstab_file}");  
}


#-------------------------------------------------------------------------------
#
# Configure RNFS 
#
#-------------------------------------------------------------------------------
sub rnfs_configure {

   my ($proto_node_id) = @_;

   my $proto_name = COMMON::build_node_name($proto_node_id, "");
   my $proto_ip   = COMMON::get_external_ip($proto_node_id);
   my $master_ip;
   my $master_name;
	   
   my $local_rdcconf = "$WORKING_DIR/rdcconf_${proto_name}";
   my $remote_rdcconf = "/usr/kernel/drv/rdc.conf";
   my $RDC_BITMAP_MODE_ENTRY = "rdc_bitmap_mode";
   my $RDC_BITMAP_MODE_VALUE = "1;";
   	   
   my $local_sdbcconf = "$WORKING_DIR/sdbc_${proto_name}";
   my $remote_sdbcconf = "/usr/kernel/drv/sdbc.conf";
   my $SDBC_FBAS_ENTRY = "sdbc_max_fbas";
   my $SDBC_FBAS_VALUE = "256;";

   my $local_vfstab = "$WORKING_DIR/vfstab_${proto_name}";
   my $remote_vfstab = "/etc/vfstab";
	
   my $i = 0;
	
  
   COMMON::print_subaction("updating /usr/kernel/drv/rdc.conf ...");

   #
   # update the bitmap mode in /usr/kernel/drv/rdc.conf file
   #
   COMMON::get_file($proto_ip, "$remote_rdcconf", "$local_rdcconf");
   &update_file( $local_rdcconf, $RDC_BITMAP_MODE_ENTRY, $RDC_BITMAP_MODE_VALUE);
   COMMON::put_file($proto_ip,"$local_rdcconf", "$remote_rdcconf");

   # if IDE support, set sdbc_max_fbas to 256 in /usr/kernel/drv/sdbc.conf

   if ($IDE_SUPPORT eq "YES") {
     COMMON::get_file($proto_ip, "$remote_sdbcconf", "$local_sdbcconf");
     &update_file( $local_sdbcconf, $SDBC_FBAS_ENTRY, $SDBC_FBAS_VALUE);
     COMMON::put_file($proto_ip,"$local_sdbcconf", "$remote_sdbcconf");
   }
	
   #
   # create exported directories and mounting points
   #
   if ($proto_node_id eq $MEN1_ID) {
     # create the exported directories on the main node
     for my $i (0..$#DIR_EXPORTED) {
       COMMON::remote_exec ( "$proto_ip", "$RMKDIR -p $DIR_EXPORTED[$i]") ||
	 COMMON::error ( "Unable to create directory $DIR_EXPORTED[$i] on MEN1");;
     }
     # create also the remote mounted directories
     for my $i (0..$#DIR_MOUNTED) {
       COMMON::remote_exec ( "$proto_ip", "$RMKDIR -p $DIR_MOUNTED[$i]{remote}") ||
	 COMMON::error ( "Unable to create directory $DIR_MOUNTED[$i]{remote} on MEN1");;
     }
     
   }

   #
   # retrieve proto_node /etc/vfstab file
   #
   COMMON::get_file($proto_ip, "$remote_vfstab", "$local_vfstab");
	
   #
   # modify locally /etc/vfstab for each replicated slice
   # no mount at boot: managed by CRFS
   #
   for $i (0..$#SLICE_LIST) {
     if ($SLICE_LIST[$i]{bitmap} ne "") {
       update_vfstab_ufs( $local_vfstab, "$SLICE_LIST[$i]{raw}", "no" );
     }
   }
   
   #
   # define all mounted directories
   #
   for $i (0..$#DIR_MOUNTED) {
     # create the directory if it doesn't exist
     COMMON::remote_exec ( "$proto_ip", "$RMKDIR -p $DIR_MOUNTED[$i]{local}" ) || 
       COMMON::error ( "Unable to remotely create directory $DIR_MOUNTED[$i]{local}" ) ;
     # add an entry in /etc/vfstab
     if ($USE_CGTP eq "YES") {
       $master_name  = COMMON::build_node_name($MASTER_ID, "CGTP");
     } else {
       $master_name  = COMMON::build_node_name($MASTER_ID, "NIC0");
     }

     update_vfstab_nfs( $local_vfstab,
			"${master_name}:$DIR_MOUNTED[$i]{remote}",
			"-\t$DIR_MOUNTED[$i]{local}\tnfs\t-\tno\trw,hard,fg,intr,noac");
   }

   #
   # putback modified proto_node /etc/vfstab
   #
   COMMON::put_file($proto_ip, "$local_vfstab", "$remote_vfstab");
}

 
#--------------------------------------------------------------
#
# installation of RNFS packages
#
#--------------------------------------------------------------

sub men_rnfs {

  ($NODE_ID) = @_;

  COMMON::init_and_check([ROOT_DIR]);

  COMMON::print_stage_node("Reliable NFS (RNFS) installation") ;
  install_packages();

  COMMON::print_action ("RNFS configuration") ;
  rnfs_configure ($NODE_ID);
}

#--------------------------------------------------------------
#
# installation of RNFS packages
#
#--------------------------------------------------------------

sub recovery_men_rnfs {

  ($NODE_ID) = @_;

  COMMON::init_and_check([ROOT_DIR]);

  my $packages = $ENV{RNFS_PACKAGES};
  COMMON::print_recovery_node("Reliable NFS (RNFS) clean-up") ;	
  COMMON::remove_men_pkg($NODE_ID, $packages, "LOCAL") ;
}

{
}







