#!/usr/bin/perl
# -----------------------------------------------------------------------------
#  ident "@(#)men_jumpstart.pl 1.27 03/04/24 SMI"
# -----------------------------------------------------------------------------
#
#  Copyright 2001-2003 Sun Microsystems, Inc. All rights reserved.
#
# -----------------------------------------------------------------------------

package MEN_JUMPSTART;

use variables;
require "$ENV{NHINSTALL_LIB}/tools/lib/common.pl";

my $SOLARIS_DIST ;
my $mountpoint = "/a/mnt_tmp" ;
my $finish;


#
# build node name for install
#
#-------------------------------------------------------------------------------

sub build_node_name_for_install {

  my ($node_id) = @_;

  if ($USE_PUBLIC_NETWORK) {
    # the public name can be used
    return COMMON::get_external_name($node_id);

  } else {

    # if we do not explicitly use the nic0 name,
    # an invalid entry is created into /etc/hosts file of the installed
    # host (that will stay as this file is not re-created):
    # IP address for nic0 associated with the node name not postfixed
    # we do not update the function get_external_name because
    # it is used to display messages and for other stuff

    return COMMON::build_node_name($NODE_ID, "NIC0");
  }
}

#------------------------------------------------------------------------------
#
# SVM installation and configuration
#
#------------------------------------------------------------------------------

sub svm_install {

  my $mountpoint = "/a/mnt_tmp" ;
  
  # installation of package: there are not located on the standard directory

  my $svm_package_subdir = $ENV{SVM_PACKAGE_SUBDIR};
  my $svm_packages = $ENV{SVM_PACKAGES};

   open (FINISH, ">>$finish") || 
     COMMON::error("Unable to update $finish file");

   print FINISH <<"FEO";

$RMKDIR -p $mountpoint

# mount distribution
$RMOUNT $SERVER_IP:/$SOLARIS_DIR $mountpoint

# create admin file
$RECHO "mail=" > /a/tmp/admin
$RECHO "instance=overwrite" >> /a/tmp/admin
$RECHO "partial=nocheck" >> /a/tmp/admin
$RECHO "runlevel=quit" >> /a/tmp/admin
$RECHO "idepend=nocheck" >> /a/tmp/admin
$RECHO "rdepend=nocheck" >> /a/tmp/admin
$RECHO "space=quit" >> /a/tmp/admin
$RECHO "setuid=nocheck" >> /a/tmp/admin
$RECHO "conflict=nocheck" >> /a/tmp/admin
$RECHO "action=nocheck" >> /a/tmp/admin
$RECHO "basedir=default" >> /a/tmp/admin

# install packages
$RPKGADD -d $mountpoint/$svm_package_subdir -R /a -a /a/tmp/admin $svm_packages
# umount distribution
$RUMOUNT $mountpoint
$RRMDIR $mountpoint

FEO

  close(FINISH);

}

#-------------------------------------------------------------------------------
#
#  Additional packages and patches installation
#
#------------------------------------------------------------------------------

sub addon_install {

  
  # installation of package: there are not located on the standard directory

  ADDON::update_finish ($finish, $mountpoint);

}

#------------------------------------------------------------------------------
#
# Create jumpstart environment
#
#------------------------------------------------------------------------------
sub jumpstart_create {

   my $proto_name  = build_node_name_for_install($NODE_ID);
   my $server_name= COMMON::build_server_name();
   my $proto_ip   = COMMON::get_external_ip($NODE_ID);
   my $ether      = $NODE_LIST[COMMON::getnode($NODE_ID)]{eth0};

   my $cmd;

   #
   # Control the host configuration
   #

   #
   # Test the  jumpstart directory tree, create it if it does not exist
   #
   COMMON::control_dir_rxw_or_create ( "$JUMPSTART" );
   COMMON::control_dir_rxw_or_create ( "$JUMPSTART/$CLUSTER" );
   COMMON::control_dir_rxw_or_create ( "$JUMPSTART/$CLUSTER/$NODE_ID" );

   $finish = "$JUMPSTART/$CLUSTER/$NODE_ID/finish.sh";
   #
   # Create Jumpstart config files
   #
   &create_sysidcfg ();
   &create_profile ();
   &create_finish();
   &create_and_test_rules();   
   
   # 
   # Control and modify /etc/hosts
   #   
   add_host( $proto_ip, $proto_name  );
   
   # 
   # Control end modify /etc/ethers
   #
   &add_ether ( $ether, $proto_name );
    
   #
   # Purge preexistant boot client, ignore errors silently
   #
   COMMON::exec_cmd_ignore ("$SOLARIS_DIST/Tools/rm_install_client $proto_name > /dev/null 2>&1") ;
   
   #
   # Share: 
   #        Jumpstart environment
   COMMON::share("$JUMPSTART" );

   #
   # Add boot client
   #
   $cmd="$SOLARIS_DIST/Tools/add_install_client";
   $cmd .= " -i \"$proto_ip\"";
   $cmd .= " -e \"$ether\"";
   $cmd .= " -s \"$SERVER_IP:$SOLARIS_DIR\"";
   $cmd .= " -c \"$SERVER_IP:${JUMPSTART}/${CLUSTER}/${NODE_ID}\"";
   $cmd .= " -p \"$SERVER_IP:${JUMPSTART}/${CLUSTER}/${NODE_ID}\"";
   $cmd .= " -n :none";
   $cmd .= " $proto_name $ARCH";   
   COMMON::exec_cmd ($cmd) ||
     COMMON::error ("Execution of \"$cmd\" failed"); 
   
   #
   # Remplace install server name by server IP address in /etc/bootparams
   #
   $cmd="/usr/bin/perl -p -i.bak";
   $cmd .= " -e 'if ( /^$proto_name/ ) {";
   $cmd .= " s/^$proto_name\\s+[^:]+:/$proto_name root=$SERVER_IP:/;";
   $cmd .= " }'";
   $cmd .= " /etc/bootparams";
   COMMON::exec_cmd ($cmd) ||
     COMMON::error("Can't modify \"/etc/bootparams\" file");
      
}


#------------------------------------------------------------------------------
#
# Management of /etc/hosts
#
#------------------------------------------------------------------------------

sub add_host {
   my ( $address, $name ) = @_ ;
   my $count=0;
   my $ip;
   my $host;
   my $garbage;
 
   $count = 0;   
     
   open (HOSTS, "/etc/hosts" ) || &error("Unable to open /etc/hosts");
   while ( <HOSTS> ) {
      
      chop();
      s/#.*//;
      ($ip, $host, $garbage) = split (/[\s\t]+/, $_) ;
      next unless (defined($ip));
      next unless (defined($host));
            
      if ( "$ip" eq "$address" ) {
	 COMMON::error("Ip \"$address\" does not match \"$name\" as first hostname in /etc/hosts") 
	 unless ( $host eq $name );
         $count++;
	 last;
      }
       	        
   }
   close (HOSTS);
   
   unless ( $count ) {
      open (HOSTS, ">>/etc/hosts" ) || COMMON::error("Unable to update /etc/hosts");
      print HOSTS "$address $name\n";
      close (HOSTS);
   }
   
}

#------------------------------------------------------------------------------
#
# Management of /etc/ethers files
#
#------------------------------------------------------------------------------
sub add_ether {
   
   my ( $address, $name ) = @_ ;
   my $count=0;
   my $ether;
   my $host;
      
   if ( -f "/etc/ethers" ) {
      open (ETHERS, "/etc/ethers" ) || COMMON::error("Unable to open /etc/ethers");
      while ( <ETHERS> ) {
      
         chop();
         s/#.*//;
         ($ether, $host) = split (/[\s\t]+/, $_) ;
         next unless (defined($ether));
         next unless (defined($host));
      
         if ( ethermatch ("$ether","$address") ) {  
	    COMMON::error("MAC \"$address\" does not match \"$name\" as hostname in /etc/ethers")
	    unless ( $host eq $name );
            $count++;
	    last;
         }
       	        
      }
      close (ETHERS);
   }
   
   unless ( $count ) {
      open (ETHERS, ">>/etc/ethers" ) || COMMON::error("Unable to update /etc/ethers");
      print ETHERS "$address $name\n";
      close (ETHERS);

      COMMON::exec_cmd("$PKILL in.rarpd ; /usr/sbin/in.rarpd -a") ||
   	COMMON::error("Unable to kill and restart rarpd daemon file");

   }

}


sub duplicated_ether {
   
   my ( $address ) = @_ ;
   my $count=0;
   my $ether;
   my $host;
         
   if ( -f "/etc/ethers" ) {
      open (ETHERS, "/etc/ethers" ) || COMMON::error("Unable to open /etc/ethers");
      while ( <ETHERS> ) {      
         chop();
         s/#.*//;
         ($ether, $host) = split (/[\s\t]+/, $_) ;
         next unless (defined($ether));
         next unless (defined($host));      
         $count++ if ( ethermatch($ether,$address) );         	        
      }
      close (ETHERS);
   }

   return ( $count > 1 );
      
}

sub ethermatch {

   my ( $addr1, $addr2 ) = @_;
   
   return 0 unless (defined($addr1));
   return 0 unless (defined($addr2));
   
   @a = split ( /:/, $addr1 );
   @b = split ( /:/, $addr2 );
   
   for ( $i=0; $i < 6; $i++ ) {
      return 0 unless (hex($a[$i]) == hex($b[$i])); 
   }
   
   return 1;
      
}

#------------------------------------------------------------------------------
#
# Create Sysidcfg file
#
#------------------------------------------------------------------------------
sub create_sysidcfg {

   my $node_ip   = COMMON::get_external_ip($NODE_ID);
   my $node_name = build_node_name_for_install($NODE_ID);

   my $timezone = SEQUENCER::get_data("TIMEZONE");
    
   open (SYSIDCFG, ">$JUMPSTART/$CLUSTER/$NODE_ID/sysidcfg") || 
     COMMON::error("Unable to create \"$JUMPSTART/$CLUSTER/$NODE_ID/sysidcfg\" file");
   print SYSIDCFG <<"FEO";
name_service=NONE
system_locale=$LOCALE
timezone=$timezone
timeserver=$SERVER_IP
security_policy=NONE
terminal=$TERMINAL
network_interface=primary {protocol_ipv6=no
                           hostname=$node_name
                           ip_address=$node_ip
		      	   default_route=$SERVER_IP
                           netmask=$DOTTED_NETMASK}
root_password=$ENCRYPTED_PASSWORD
FEO

   close(SYSIDCFG);

}

#------------------------------------------------------------------------------
#
# Create jumpstart profile file
#
#------------------------------------------------------------------------------
sub create_profile {

  my $profile = "$JUMPSTART/$CLUSTER/$NODE_ID/node.prof" ;

  my $slice_root ;
  my $idx;

  COMMON::exec_cmd( "$CP $PROFILE $profile") ||
      COMMON::error("Unable to create $profile file");

  CONF::slice_search(mounting_point, $SLICE_ROOT, \$idx ) ;
  $slice_root= $SLICE_LIST[$idx]{name};

  open(FPROFILE, ">>$profile") ;

  print FPROFILE "boot_device $slice_root update\n" ;
  print FPROFILE "root_device $slice_root\n" ;

  for $idx (0..$#SLICE_LIST)
    {
      print FPROFILE "filesys $SLICE_LIST[$idx]{name} $SLICE_LIST[$idx]{size} $SLICE_LIST[$idx]{mounting_point} $SLICE_LIST[$idx]{option}\n"
    }
  
  #
  # generate a "usedisk" directive for each disk present in the configuration file
  #
  my %disk_array;
  for my $i (0..$#SLICE_LIST) {
    my $disk = substr($SLICE_LIST[$i]{name}, 0, 6);
    if (! exists $disk_array{$disk}) {
      print FPROFILE "usedisk $disk\n" ;
      $disk_array{$disk} = "";
    }
  }

  close FPROFILE ;

}

#----------------------------------------------------------------------------- 
#
# Create jumpstart rules file
#
#------------------------------------------------------------------------------
sub create_and_test_rules {
  
   my $output = "";

   open (RULES, ">$JUMPSTART/$CLUSTER/$NODE_ID/rules") || 
     COMMON::error("Unable to create \"$JUMPSTART/$CLUSTER/$NODE_ID/rules\" file");
   my $node_ip = COMMON::get_external_ip($NODE_ID);
   print RULES "hostaddress $node_ip - node.prof finish.sh\n";
   close (RULES);

   open (CHECK,"cd $JUMPSTART/$CLUSTER/$NODE_ID; $SOLARIS_DIST/Misc/jumpstart_sample/check |") || 
     COMMON::error ("Unable to check \"rules\" file"); 
   while ( <CHECK> ) {
     chop();
     COMMON::print_debug(DEBUG_FILE, $_);
     $output= "$output $_\n";
   }
   if (! close (CHECK)) {
     COMMON::print_log($output);
     COMMON::error("Error found while checking \"Rules\" file");
   }
}

#------------------------------------------------------------------------------
#
# Create jumpstart finish.sh file
#
#------------------------------------------------------------------------------
sub create_finish {

  my $men_nic0;
  my $men_nic1;
  my $men_cgtp;
  my $other_id;
  
  if ($NODE_ID eq $MEN1_ID) {
    $other_id = $MEN2_ID ;
  } else {
    $other_id = $MEN1_ID ;
  }
  $men_nic0 = COMMON::build_node_name($other_id, "NIC0");
  if ($USE_CGTP eq "YES") {
    $men_nic1 = COMMON::build_node_name($other_id, "NIC1");
    $men_cgtp = COMMON::build_node_name($other_id, "CGTP");
  }

  open (FINISH, ">$finish") || 
    COMMON::error("Unable to create $finish file");
  print FINISH "#!/bin/sh\n\n";
  
  print FINISH <<"FEO";
#
# create /etc/notrouter
#
if [ ! -f /a/etc/notrouter ] ; then
/usr/bin/touch /a/etc/notrouter
fi

#
# modify /etc/default/login
#
/usr/bin/mv /a/etc/default/login /a/etc/default/login.orig
/usr/bin/chmod 644 /a/etc/default/login.orig
/usr/bin/sed '1,\$s/^CONSOLE/#CONSOLE/' /a/etc/default/login.orig > /a/etc/default/login
/usr/bin/chmod 444 /a/etc/default/login

#
# disable power management
#
if [ ! -f /a/noautoshutdown ] ; then
/usr/bin/touch /a/noautoshutdown
fi


#
# set boot PROM params
#
/usr/sbin/eeprom local-mac-address?=true
/usr/sbin/eeprom auto-boot?=true

FEO

  if ($RESTRICT_RHOSTS eq "YES") {

    print FINISH <<"FEO";
#
# modify /.rhosts
#
if [ -f /a/.rhosts ] ; then
/usr/bin/cp /a/.rhosts /a/.rhosts.orig
fi
echo "$SERVER_IP root" >> /a/.rhosts
/usr/bin/chmod 444 /a/.rhosts

FEO

  } else {

    print FINISH <<"FEO";
#
# modify /.rhosts
#
if [ -f /a/.rhosts ] ; then
/usr/bin/cp /a/.rhosts /a/.rhosts.orig
fi

FEO

    if ($USE_CGTP eq "YES") {

    print FINISH <<"FEO";
echo "$men_nic0 root" >> /a/.rhosts
echo "$men_nic1 root" >> /a/.rhosts
echo "$men_cgtp root" >> /a/.rhosts
echo "$SERVER_IP root" >> /a/.rhosts
/usr/bin/chmod 444 /a/.rhosts

FEO

    } else {

    print FINISH <<"FEO";
echo "$men_nic0 root" >> /a/.rhosts
echo "$SERVER_IP root" >> /a/.rhosts
/usr/bin/chmod 444 /a/.rhosts

FEO

    }
 }
 close (FINISH);
}



#------------------------------------------------------------------------------
#
#  Solaris installation
#
#------------------------------------------------------------------------------

sub men_jumpstart {

  ($NODE_ID) = @_;

  if ($SOLARIS_INSTALL ne "YES") {
    return ;
  }
  
  COMMON::init_and_check([ JUMPSTART, SOLARIS_DIR ]) ;

  COMMON::print_stage_node("Solaris installation");

  # Test Solaris distribution directory
  
  COMMON::control_dir_is_readable ("$SOLARIS_DIR");
  $SOLARIS_DIST=$SOLARIS_DIR . "/$TARGET_OS" if ( -d "$SOLARIS_DIR/$TARGET_OS" );
  COMMON::error("Unable to find $TARGET_OS distribution on $SOLARIS_DIR") 
    unless (defined($SOLARIS_DIST));

  COMMON::control_dir_is_readable ("$SOLARIS_DIST");
  COMMON::control_dir_is_readable ("$SOLARIS_DIST/Tools");
  COMMON::control_dir_is_readable ("$SOLARIS_DIST/Tools/Boot");
  COMMON::control_dir_is_readable ("$SOLARIS_DIST/Misc");
  COMMON::control_dir_is_readable ("$SOLARIS_DIST/Misc/jumpstart_sample");
  
  COMMON::control_file_is_readable ("$SOLARIS_DIST/Misc/jumpstart_sample/check");
  
  COMMON::control_file_is_readable ( $PROFILE );
  
  COMMON::control_file_is_executable("$SOLARIS_DIST/Tools/add_install_client");
  COMMON::control_file_is_executable("$SOLARIS_DIST/Tools/rm_install_client");
  
  COMMON::control_dir_is_readable ("$SOLARIS_DIST/Tools/Boot/sbin");
  COMMON::control_file_is_executable ("$SOLARIS_DIST/Tools/Boot/sbin/bpgetfile");
    
  # Prepare a jumpstart environment
  COMMON::print_action("Preparing the Jumpstart environment");
  jumpstart_create ();
  if (($USE_SVM eq "YES") && ($TARGET_OS eq "Solaris_8")) {
    COMMON::print_action("Configuring finish.sh for Solaris Volume Manager (SVM) installation");
    svm_install();
  }

  # install additional packages or patches during the Solaris installation
  # thru the finish.sh file
  addon_install();
}

{
}






