#************************************************************ 
#
# Component       CNF  
#
# Synopsis        Cluster Membership Monitor
#
# Copyright 2001 Sun Microsystems, Inc. All rights reserved.
#
#
#************************************************************
#
# #ident "@(#)CONF.pm 1.9 02/10/15 SMI"
#
#************************************************************

#=head1 Foundation Services Configuration File
#
#=over 4
#
#=cut

package CONF ;

use VAR;
use LOG;

$G_prop_name               = 0;
$G_prop_mandatory_men      = 1;
$G_prop_mandatory_diskless = 2;
$G_prop_mandatory_dataless = 3;
$G_prop_feature            = 4;
$G_prop_multiple           = 5;
$G_prop_default            = 6;
$G_prop_type               = 7;
$G_prop_scope              = 8;
$G_prop_field              = 9;
$G_prop_status             = 10;

# 0: name
# 1: mandatory on MEN (YES or NO)
# 2: mandatory on diskless (YES or NO)
# 3: mandatory on dataless (YES or NO)
# 4: if mandatory, mandatory only when the named feature is present
#    (blank: always mandatory whatever the installed features)
#    ignored if the mandatory flag is not set
# 5: mutiple (YES or NO)
# 6: default value
# 7: type: TRUE_FALSE, STRING
# 8: scope: public | private
# 9: field name
# 10: defined or not (updated at run time)

# rank of the Node.Type: needed because need to be used soon

$G_node_type_property = 0;

@G_properties = (

		 # Node

		 [ "Node.Type",
		   YES, YES, YES,
		   "",
		   NO, "", STRING,
		   "public",
		   "NODE_TYPE", "undefined"
		 ],

		 [ "Node.DomainId",
		   YES, YES, YES,
		   "",
		   NO, "", STRING,
		   "public",
		   "DOMAIN_ID", "undefined"
		 ],
		 [ "Node.Nic0",
		   NO, NO, NO,
		   "",
		   NO,"hme0", STRING,
		   "public",
		   "NIC0", "undefined" 
		 ],
		 [ "Node.Nic1",    
		   NO, NO, NO,
		   "CGTP",
		   NO, "hme1", STRING,
		   "public",
		   "NIC1", "undefined" 
		 ],
		 [ "Node.NicCGTP", 
		   NO, NO, NO,
		   "CGTP",
		   NO, "cgtp0", STRING,
		   "public",
		   "NIC_CGTP", "undefined"
		 ],
		 [ "Node.UseCGTP",
		   NO, NO, NO,
		   "",
		   NO, "TRUE", TRUE_FALSE,
		   "public",
		   "USE_CGTP", "undefined" 
		 ],
		 [ "Node.Rnfs.Installed",
		   YES, NO, NO,
		   "",
		   NO, "", TRUE_FALSE,
		   "public",
		   "RNFS_INSTALLED", "undefined"
		 ],
		 [ "Node.NodeId",
		   YES, YES,YES,
		   "",
		   NO, "", STRING,
		   "public",
		   "NODE_ID", "undefined"
		 ],
		 [ "Node.NodesGroup",
		   YES, YES, YES,
		   "SMCT",
		   NO, "", STRING,
		   "public",
		   "SMCT_NODE_GROUP", "undefined"
		 ],

		 # Cluster

		 [ "Cluster.Master.Id",
		   YES, YES, YES,
		   "",
		   NO, "", STRING,
		   "public",
		   "MASTER_ID", "undefined"
		 ],

		 # Cmm

		 [ "Cmm.IsEligible",
		   NO, NO, NO,
		   "CMM",
		   NO, "FALSE", TRUE_FALSE,
		   "public",
		   "IS_ELIGIBLE", "undefined"
		 ],
		 [ "Cmm.LocalConfig.Dir",
		   YES, NO, NO,
		   "CMM",
		   NO, "/etc/opt/SUNWcgha", STRING,
		   "public",
		   "LOCAL_CONFIG_DIR", "undefined"
		 ],
		 [ "Cmm.MiniConfig.Dir",
		   NO, NO, NO,
		   "CMM",
		   NO, "/etc/opt/SUNWcgha", STRING,
		   "public",
		   "MINI_CONFIG_DIR", "undefined"
		 ],
		 [ "Cmm.MiniConfig.File",
		   NO, NO, NO,
		   "CMM",
		   NO, "target.conf", STRING,
		   "public",
		   "MINI_CONFIG_FILE", "undefined"
		 ],
		 [ "Cmm.CurrentNodeName",
		   NO, NO, NO,
		   "CMM",
		   NO, "", STRING,
		   "public",
		   "CURRENT_NODE_NAME", "undefined"
		 ],
		 [ "Cmm.Daemonize",
		   NO, NO, NO,
		   "CMM",
		   NO, "TRUE", TRUE_FALSE,
		   "private",
		   "CMM_DAEMONIZE", "undefined"
		 ],
		 [ "Cmm.UseCgtp",
		   NO, NO, NO,
		   "CMM",
		   NO, "TRUE", TRUE_FALSE,
		   "private",
		   "CMM_USE_CGTP", "undefined"
		 ],
		 [ "Cmm.UseProbe",
		   NO, NO, NO,
		   "CMM",
		   NO, "TRUE", TRUE_FALSE,
		   "private",
		   "USE_PROBE", "undefined"
		 ],
		 [ "Cmm.UseIFCheckMode",
		   NO, NO, NO,
		   "CMM",
		   NO, "TRUE", TRUE_FALSE,
		   "private",
		   "NO_IF_CHECK_MODE", "undefined"
		 ],
		 [ "Cmm.Election.MaxEligible",
		   NO, NO, NO,
		   "CMM",
		   NO, "", STRING,
		   "private",
		   "MAX_ELIGIBLE", "undefined",
		 ],
		 [ "Cmm.Election.Duration",
		   NO, NO, NO,
		   "CMM",
		   NO, 100, STRING,
		   "private",
		   "ELECTION_DURATION", "undefined"
		 ],
		 [ "Cmm.Probe.DetectionDelay",
		   NO, NO, NO,
		   "CMM",
		   NO, 900, STRING,
		   "private",
		   "PROBE_DETECTION_DELAY", "undefined"
		 ],
		 [ "Cmm.Probe.HeartBeatNumber",
		   NO, NO, NO,
		   "CMM",
		   NO, 3, STRING,
		   "private",
		   "PROBE_HEARTBEAT_NUMBER", "undefined"
		 ],
		 [ "Cmm.DebugLevel",
		   NO, NO, NO,
		   "CMM",
		   NO, "-1", STRING,
		   "private",
		   "CMM_DEBUG_LEVEL", "undefined"
		 ],
		 [ "Cmm.Nic0",
		   NO, NO, NO,
		   "CMM",
		   NO, "hme0", STRING,
		   "private",
		   "CMM_NIC0", "undefined"
		 ],
		 [ "Cmm.Nic1",
		   NO, NO, NO,
		   "CMM",
		   NO, "hme1", STRING,
		   "private",
		   "CMM_NIC1", "undefined"
		 ],
		 [ "Cmm.NicCGTP",
		   NO, NO, NO,
		   "CMM",
		   NO, "cgtp0", STRING,
		   "private",
		   "CMM_NIC_CGTP", "undefined"
		 ],


		 # Probe

		 [ "Probe.SelfCheck",
		   NO, NO, NO,
		   "",
		   NO, "TRUE", TRUE_FALSE,
		   "private",
		   "PROBE_SELF_CHECK", "undefined"
		 ],
		 [ "Probe.FirstCheck",
		   NO, NO, NO,
		   "",
		   NO, "", STRING,
		   "private",
		   "PROBE_FIRST_CHECK", "undefined"
		 ],
		 [ "Probe.Daemonize",
		   NO, NO, NO,
		   "",
		   NO, "TRUE", TRUE_FALSE,
		   "private",
		   "PROBE_DAEMONIZE", "undefined"
		 ],
		 [ "Probe.UseCGTP",
		   NO, NO, NO,
		   "",
		   NO, "TRUE", TRUE_FALSE,
		   "private",
		   "PROBE_USE_CGTP", "undefined"
		 ],
		 [ "Probe.Nic0",
		   NO, NO, NO,
		   "",
		   NO, "hme0", STRING,
		   "private",
		   "PROBE_NIC0", "undefined"
		 ],
		 [ "Probe.Nic1",
		   NO, NO, NO,
		   "",
		   NO, "hme1", STRING,
		   "private",
		   "PROBE_NIC1", "undefined"
		 ],


		 # RNFS

		 [ "Rnfs.DebugLevel",
		   NO, NO, NO,
		   "RNFS",
		   NO, 0, STRING,
		   "private",
		   "RNFS_DEBUG_LEVEL", "undefined"
		 ],
		 [ "Rnfs.StatdAlternatePath",
		   YES, NO, NO,
		   "RNFS",
		   NO, "", STRING,
		   "public",
		   "STATD_ALTERNATE_PATH", "undefined"
		 ],
		 [ "Rnfs.Slice",
		   YES, NO, NO,
		   "RNFS",
		   YES, "", STRING,
		   "public",
		   "E_slice_string", "undefined"
		 ],
		 [ "Rnfs.Share",
		   YES, NO, NO,
		   "RNFS",
		   YES, "", STRING,
		   "public",
		   "E_share_string", "undefined"
		 ],
		 [ "Rnfs.UsePmd",
		   NO, NO, NO,
		   "RNFS",
		   YES, "TRUE", TRUE_FALSE,
		   "private",
		   "E_share_string", "undefined"
		 ],

		 # NSM

		 [ "Nsm.Exec.Masterdir",
		   YES, NO, NO,
		   "NSM",
		   NO, "", STRING,
		   "public",
		   "NSM_MASTER_DIR", "undefined"
		 ],
		 [ "Nsm.Exec.ViceMasterdir",
		   YES, NO, NO,
		   "NSM",
		   NO, "", STRING,
		   "public",
		   "NSM_VICEMASTER_DIR", "undefined"
		 ],
		 [ "Nsm.Log.Masterdir",
		   YES, NO, NO,
		   "NSM",
		   NO, "", STRING,
		   "public",
		   "NSM_LOG_MASTER_DIR", "undefined"
		 ],
		 [ "Nsm.Log.ViceMasterdir",
		   YES, NO, NO,
		   "NSM",
		   NO, "", STRING,
		   "public",
		   "NSM_LOG_VICEMASTER_DIR", "undefined"
		 ],

		 # NSM external address

		 [ "Nsm.External.Master.Address",
		   YES, NO, NO,
		   "NSM",
		   NO, "", STRING,
		   "public",
		   "NSM_EXTERNAL_MASTER_ADDRESS", "undefined"
		 ],
		 [ "Nsm.External.Master.Nic",
		   YES, NO, NO,
		   "NSM",
		   NO, "", STRING,
		   "public",
		   "NSM_EXTERNAL_MASTER_NIC", "undefined"
		 ],
		 [ "Nsm.External.Master.Broadcast",
		   NO, NO, NO,
		   "NSM",
		   NO, "", STRING,
		   "public",
		   "NSM_EXTERNAL_MASTER_BROADCAST", "undefined"
		 ],
		 [ "Nsm.External.Master.RouteAdd",
		   NO, NO, NO,
		   "NSM",
		   NO, "", STRING,
		   "public",
		   "NSM_EXTERNAL_MASTER_ROUTEADD", "undefined"
		 ],
		 [ "Nsm.External.Master.RouteDelete",
		   NO, NO, NO,
		   "NSM",
		   NO, "", STRING,
		   "public",
		   "NSM_EXTERNAL_MASTER_ROUTEDELETE", "undefined"
		 ],

		 [ "Nsm.Option.Fifo",
		   NO, NO, NO,
		   "NSM",
		   NO, "", STRING,
		   "private",
		   "NSM_OPTION_FIFO", "undefined"
		 ],
		 [ "Nsm.Option.Trace",
		   NO, NO, NO,
		   "NSM",
		   NO, "FALSE", TRUE_FALSE,
		   "private",
		   "NSM_OPTION_TRACE", "undefined"
		 ],
		 [ "Nsm.Option.Debug",
		   NO, NO, NO,
		   "NSM",
		   NO, "FALSE", TRUE_FALSE,
		   "private",
		   "NSM_OPTION_DEBUG", "undefined"
		 ],
		 [ "Nsm.Option.Print",
		   NO, NO, NO,
		   "NSM",
		   NO, "FALSE", TRUE_FALSE,
		   "private",
		   "NSM_OPTION_PRINT", "undefined"
		 ],
		 [ "Nsm.Option.Heap",
		   NO, NO, NO,
		   "NSM",
		   NO, "FALSE", TRUE_FALSE,
		   "private",
		   "NSM_OPTION_HEAP", "undefined"
		 ],
		 [ "Nsm.Option.Rt",
		   NO, NO, NO,
		   "NSM",
		   NO, "FALSE", TRUE_FALSE,
		   "private",
		   "NSM_OPTION_RT", "undefined"
		 ],
		 [ "Nsm.Option.Log",
		   NO, NO, NO,
		   "NSM",
		   NO, "FALSE", TRUE_FALSE,
		   "private",
		   "NSM_OPTION_LOG", "undefined"
		 ],
		 [ "Nsm.Option.NoCgha",
		   NO, NO, NO,
		   "NSM",
		   NO, "FALSE", TRUE_FALSE,
		   "private",
		   "NSM_OPTION_NOCGHA", "undefined"
		 ],
		 
		 ) ;

#--------------------------------------------------------------
#
# process one parameter
#
#--------------------------------------------------------------

sub process_one_parameter {

  my ($parameter, $value) = @_;
  my $idx;

  my $upparameter = $parameter;
  $upparameter =~ tr/a-z/A-Z/;

  my $found = FALSE;
  for my $i (0..$#G_properties) {
    my $property = $G_properties[$i][$G_prop_name];
    $property =~ tr/a-z/A-Z/;
    if ($G_properties[$i][$G_prop_multiple] eq "YES") {
      # we remove the rank before comparing (no rank means no need to compare)
      if ($upparameter =~ m/(.*)\.([0-9]+)/) {
	if ($1 eq $property) {
	  $found = "TRUE";
	  $idx = $i;
	  last
	}
      }
    } else {
      if ($upparameter eq $property) {
	$found = "TRUE";
	$idx = $i;
	last ;
      }
    }
  }

  if ($found eq "FALSE") {
    LOG::printWarning("%s: unknown property", $parameter);
    return;
  }

  # check the value type
  if ($G_properties[$idx][$G_prop_type] eq "TRUE_FALSE") {
    $value =~ tr/a-z/A-Z/;
    if (($value ne "TRUE") && ($value ne "FALSE")) {
      LOG::printWarning("%s: value must be TRUE or FALSE", $parameter);
      return;
    }
  }

  # check that the parameter is not yet defined
  if (($G_properties[$idx][$G_prop_status] eq "defined") &&
      ($G_properties[$idx][$G_prop_multiple] ne "YES")) {
    LOG::printWarning("%s: multiple defined", $parameter);
    return;
  }

  if ($G_properties[$idx][$G_prop_multiple] eq "NO") {
    # eliminated useless spaces
    $value =~ m/[\s\t]*([^\s\t]*)/;
    $E_variables{$G_properties[$idx][$G_prop_field]} = $1;
  } else {
    my $array = $G_properties[$idx][$G_prop_field];
    push @$array, $value;
  }
  $G_properties[$idx][$G_prop_status] = "defined";
}

#--------------------------------------------------------------
#
# process when all variables have been loaded
#
# . check mandatory properties
# . manage default values
#
#--------------------------------------------------------------

sub process_end {

  my $L_status = OK;
  my $mandatory;

  # process the default value : to be sure that Cmm.isEligible is set
  # required to check mandatory properties (depend on eligibility)
  for my $i (0..$#G_properties) {
    # for simple property not defined, set the default value
    if (($G_properties[$i][$G_prop_multiple] eq "NO") &&
	($G_properties[$i][$G_prop_status] eq "undefined")) {
      $E_variables{$G_properties[$i][$G_prop_field]} = $G_properties[$i][$G_prop_default];
    }
  }

  # retrieve the node type to be able to perform the right checks later
  if ($G_properties[$G_node_type_property][$G_prop_status] eq "defined") {
    $E_variables{NODE_TYPE} =~ tr/a-z/A-Z/;
    if (($E_variables{NODE_TYPE} ne "DISKFULL") &&
	($E_variables{NODE_TYPE} ne "DISKLESS") &&
	($E_variables{NODE_TYPE} ne "DATALESS")) {
      printError("Incorrect value for Node.Type in %s", 
		 $E_fs_configuration_file);
      exit 1;
    }
  } else {
    printError("Node.Type definition missing in %s", 
	       $E_fs_configuration_file);
    exit 1;
  } 

  # check mandatory properties
  if ($E_variables{NODE_TYPE} eq "DISKFULL") {
    $mandatory = $G_prop_mandatory_men;
  } elsif ($E_variables{NODE_TYPE} eq "DISKLESS") {
    $mandatory = $G_prop_mandatory_diskless;
  } else {
     $mandatory = $G_prop_mandatory_dataless;
   
  }

  for my $i (0..$#G_properties) {
    if (($G_properties[$i][$mandatory] eq "YES") &&
	($G_properties[$i][$G_prop_status] eq "undefined")) {

      # check if it depends on a feature
      if ($G_properties[$i][$G_prop_feature] eq "") {

	# mandatory without feature dependencies
	LOG::printWarning("%s definition required",
			  $G_properties[$i][$G_prop_name]);
	$L_status = FAILED;

      } else {

	# mandatory when a specific feature is installed

	my $return = OS::is_feature_installed($G_properties[$i][$G_prop_feature]);
	if (($return eq "TRUE") &&
	    ($G_properties[$i][$G_prop_status] eq "undefined")) {
	  LOG::printWarning("%s definition required when the %s feature is installed",
			    $G_properties[$i][$G_prop_name],$G_properties[$i][$G_prop_feature]);
	  $L_status = FAILED;

	}
      }
    }
  }

  LOG::printResult($L_status, "Configuration file checking");
  if ($L_status eq "FAILED") {
  LOG::printMsg(0, "FATAL: All others tests are skipped");
    exit 1;
  }
}

#--------------------------------------------------------------
#
# loading the Foundation Services configuration file
#
#--------------------------------------------------------------

sub load_fs_conf {

  my $parameter;
  my $value;
  my $upvalue;
  
  LOG::printMsg(0, "Loading FS configuration file %s ...", 
		$E_fs_configuration_file) ;
  
  if (OS::check_file($E_fs_configuration_file) eq FALSE) {
    exit ;
  }
  
  open(FH, "<$E_fs_configuration_file") ;
  while (<FH>) {
    chomp($line =$_) ;
    $initial = $line ;
    # remove comments
    $line =~ /([^\#]*)/;
    $line=$1 ;
    if ($line eq "") {
      next ;
    }
    
    # retrieve parameter and its value
    if ($line =~ /[\s\t]*([^=\s\t]*)[\s\t]*=(.*)/) {
      process_one_parameter($1, $2);  
    }  
  }

  close(FH) ;

  process_end;
}

#--------------------------------------------------------------
#
# display the Foundation Services configuration data
#
#--------------------------------------------------------------

sub display {

  printLine("");
  printLine("Foundation Services configuration data");
  printLine("");;
  for my $i (0..$#G_properties) {
    if (($G_properties[$i][$G_prop_scope] eq "public") 
	&& ($G_properties[$i][$G_prop_multiple] eq "NO")) {
      my $property = $G_properties[$i][$G_prop_name];
      my $field = $G_properties[$i][$G_prop_field];
      my $value = $E_variables{$field};
      printf "    %-30s = %s\n", $property , $value ;
    }
  }
}

#=back
#
#=cut

{
}
