/*
 * Portions Copyright(c) 2001 by Sun Microsystems, Inc.
 * All Rights Reserved
 */

#ifndef __gl_h_
#define __gl_h_

#pragma ident "@(#)gl.h	1.131 04/11/07 SMI"

#ifdef __cplusplus
extern "C" {
#endif

/*
** Copyright 1996,1997,1998 Silicon Graphics, Inc.
** All Rights Reserved.
** 
** This is UNPUBLISHED PROPRIETARY SOURCE CODE of Silicon Graphics, Inc.;
** the contents of this file may not be disclosed to third parties, copied or
** duplicated in any form, in whole or in part, without the prior written
** permission of Silicon Graphics, Inc.
** 
** RESTRICTED RIGHTS LEGEND:
** Use, duplication or disclosure by the Government is subject to restrictions
** as set forth in subdivision(c)(1)(ii) of the Rights in Technical Data
** and Computer Software clause at DFARS 252.227-7013, and/or in similar or
** successor clauses in the FAR, DOD or NASA FAR Supplement. Unpublished -
** rights reserved under the Copyright Laws of the United States.
*/

typedef unsigned int GLenum;
typedef unsigned char GLboolean;
typedef unsigned int GLbitfield;
typedef signed char GLbyte;
typedef short GLshort;
typedef int GLint;
typedef int GLsizei;
typedef unsigned char GLubyte;
typedef unsigned short GLushort;
typedef unsigned int GLuint;
typedef float GLfloat;
typedef float GLclampf;
typedef double GLdouble;
typedef double GLclampd;
typedef void GLvoid;
typedef int GLhandleARB;
typedef unsigned char GLcharARB;

#if defined(_LP64)
typedef long GLintptrARB;
typedef long GLsizeiptrARB;
#else
typedef int  GLintptrARB;
typedef int  GLsizeiptrARB;
#endif


/* Version */
#define GL_VERSION_1_1                          1
#define GL_VERSION_1_2                          1
#define GL_VERSION_1_3                          1

/****************************************************************/
/*                                                              */
/*  List of Suppported OpenGL Extensions                        */
/*  NOTE: Some framebuffers may support only a subset of these. */
/*                                                              */
/****************************************************************/

#define GL_ARB_depth_texture                    1
#define GL_ARB_imaging                          1
#define GL_ARB_multisample                      1
#define GL_ARB_multitexture                     1
#define GL_ARB_point_parameters                 1
#define GL_ARB_shadow                           1
#define GL_ARB_shadow_ambient                   1
#define GL_ARB_texture_border_clamp             1
#define GL_ARB_texture_compression              1
#define GL_ARB_texture_cube_map                 1
#define GL_ARB_texture_env_combine              1
#define GL_ARB_texture_env_dot3                 1
#define GL_ARB_texture_env_add                  1
#define GL_ARB_texture_mirrored_repeat    	1
#define GL_ARB_transpose_matrix                 1

#define GL_EXT_abgr                             1
#define GL_EXT_bgra                             1
#define GL_EXT_blend_color                      1
#define GL_EXT_blend_func_separate        	1
#define GL_EXT_blend_logic_op                   1
#define GL_EXT_blend_minmax                     1
#define GL_EXT_blend_subtract                   1
#define GL_EXT_compiled_vertex_array            1 
#define GL_EXT_convolution                      1
#define GL_EXT_gradient_clear                   1
#define GL_EXT_histogram                        1
#define GL_EXT_multi_draw_arrays                1
#define GL_EXT_pixel_transform                  1
#define GL_EXT_polygon_offset                   1
#define GL_EXT_rescale_normal                   1
#define GL_EXT_shadow_funcs                     1
#define GL_EXT_stencil_wrap                     1
#define GL_EXT_secondary_color                  1
#define GL_EXT_texture3D                        1
#define GL_EXT_texture_env_combine              1
#define GL_EXT_texture_filter_anisotropic       1
#define GL_EXT_texture_lod_bias                 1

#define GL_HP_convolution_border_modes          1
#define GL_HP_occlusion_test                    1

#define GL_SGI_color_table                      1
#define GL_SGI_texture_color_table              1
#define GL_SGIS_detail_texture                  1
#define GL_SGIS_generate_mipmap			1
#define GL_SGIS_sharpen_texture                 1
#define GL_SGIS_texture_border_clamp            1
#define GL_SGIS_texture_filter4                 1
#define GL_SGIX_depth_texture                   1
#define GL_SGIX_shadow                          1
#define GL_SGIX_shadow_ambient                  1
#define GL_SGIX_texture_lod_bias                1
#define GL_SGIX_texture_scale_bias              1

#define GL_NV_texture_rectangle                 1

#define GL_SUN_blend_src_mult_dst_alpha   	1
#define GL_SUN_convolution_border_modes         1
#define GL_SUN_get_texture_memory_size    	1
#define GL_SUN_global_alpha                     1
#define GL_SUN_mesh_array                       1
#define GL_SUN_multi_draw_arrays                1
#define GL_SUN_multisample_pbuffer              1
#define GL_SUN_phong_shading                    1
#define GL_SUN_read_video_pixels          	1
#define GL_SUN_read_write_samples         	1
#define GL_SUN_slice_accum                      1
#define GL_SUN_targeted_texture           	1
#define GL_SUN_triangle_list                    1
#define GL_SUN_vertex                           1
#define GL_SUN_video_resize_compensation  	1
#define GL_SUNX_constant_data                   1
#define GL_SUNX_geometry_compression            1
#define GL_SUNX_surface_hint                    1


/*************************************************************/
/*                                                           */
/*     Enumerates for OpenGL 1.3 Core API                    */
/*                                                           */
/*************************************************************/

/* AccumOp */
#define GL_ACCUM                          0x0100
#define GL_LOAD                           0x0101
#define GL_RETURN                         0x0102
#define GL_MULT                           0x0103
#define GL_ADD                            0x0104
#define GL_SLICE_ACCUM_SUN                0x85CC 

/* AlphaFunction */
#define GL_NEVER                                0x0200
#define GL_LESS                                 0x0201
#define GL_EQUAL                                0x0202
#define GL_LEQUAL                               0x0203
#define GL_GREATER                              0x0204
#define GL_NOTEQUAL                             0x0205
#define GL_GEQUAL                               0x0206
#define GL_ALWAYS                               0x0207

/* AttribMask */
#define GL_CURRENT_BIT                          0x00000001
#define GL_POINT_BIT                            0x00000002
#define GL_LINE_BIT                             0x00000004
#define GL_POLYGON_BIT                          0x00000008
#define GL_POLYGON_STIPPLE_BIT                  0x00000010
#define GL_PIXEL_MODE_BIT                       0x00000020
#define GL_LIGHTING_BIT                         0x00000040
#define GL_FOG_BIT                              0x00000080
#define GL_DEPTH_BUFFER_BIT                     0x00000100
#define GL_ACCUM_BUFFER_BIT                     0x00000200
#define GL_STENCIL_BUFFER_BIT                   0x00000400
#define GL_VIEWPORT_BIT                         0x00000800
#define GL_TRANSFORM_BIT                        0x00001000
#define GL_ENABLE_BIT                           0x00002000
#define GL_COLOR_BUFFER_BIT                     0x00004000
#define GL_HINT_BIT                             0x00008000
#define GL_EVAL_BIT                             0x00010000
#define GL_LIST_BIT                             0x00020000
#define GL_TEXTURE_BIT                          0x00040000
#define GL_SCISSOR_BIT                          0x00080000
#define GL_ALL_ATTRIB_BITS                      0x000fffff

/* BeginMode */
#define GL_POINTS                               0x0000
#define GL_LINES                                0x0001
#define GL_LINE_LOOP                            0x0002
#define GL_LINE_STRIP                           0x0003
#define GL_TRIANGLES                            0x0004
#define GL_TRIANGLE_STRIP                       0x0005
#define GL_TRIANGLE_FAN                         0x0006
#define GL_QUADS                                0x0007
#define GL_QUAD_STRIP                           0x0008
#define GL_POLYGON                              0x0009

/* BlendEquationMode */
/*      GL_LOGIC_OP */
/*      GL_FUNC_ADD */
/*      GL_MIN */
/*      GL_MAX */
/*      GL_FUNC_SUBTRACT */
/*      GL_FUNC_REVERSE_SUBTRACT */

/* BlendingFactorDest */
#define GL_ZERO                                 0
#define GL_ONE                                  1
#define GL_SRC_COLOR                            0x0300
#define GL_ONE_MINUS_SRC_COLOR                  0x0301
#define GL_SRC_ALPHA                            0x0302
#define GL_ONE_MINUS_SRC_ALPHA                  0x0303
#define GL_DST_ALPHA                            0x0304
#define GL_ONE_MINUS_DST_ALPHA                  0x0305

/*      GL_CONSTANT_COLOR */
/*      GL_ONE_MINUS_CONSTANT_COLOR */
/*      GL_CONSTANT_ALPHA */
/*      GL_ONE_MINUS_CONSTANT_ALPHA */

/* BlendingFactorSrc */
/*      GL_ZERO */
/*      GL_ONE */
#define GL_DST_COLOR                            0x0306
#define GL_ONE_MINUS_DST_COLOR                  0x0307
#define GL_SRC_ALPHA_SATURATE                   0x0308
/*      GL_SRC_ALPHA */
/*      GL_ONE_MINUS_SRC_ALPHA */
/*      GL_DST_ALPHA */
/*      GL_ONE_MINUS_DST_ALPHA */
/*      GL_CONSTANT_COLOR */
/*      GL_ONE_MINUS_CONSTANT_COLOR */
/*      GL_CONSTANT_ALPHA */
/*      GL_ONE_MINUS_CONSTANT_ALPHA */

/* Boolean */
#define GL_TRUE                                 1
#define GL_FALSE                                0

/* ClearBufferMask */
/*      GL_COLOR_BUFFER_BIT */
/*      GL_ACCUM_BUFFER_BIT */
/*      GL_STENCIL_BUFFER_BIT */
/*      GL_DEPTH_BUFFER_BIT */

/* ClientArrayType */
/*      GL_VERTEX_ARRAY */
/*      GL_NORMAL_ARRAY */
/*      GL_COLOR_ARRAY */
/*      GL_INDEX_ARRAY */
/*      GL_TEXTURE_COORD_ARRAY */
/*      GL_EDGE_FLAG_ARRAY */

/* ClipPlaneName */
#define GL_CLIP_PLANE0                          0x3000
#define GL_CLIP_PLANE1                          0x3001
#define GL_CLIP_PLANE2                          0x3002
#define GL_CLIP_PLANE3                          0x3003
#define GL_CLIP_PLANE4                          0x3004
#define GL_CLIP_PLANE5                          0x3005

/* ColorMaterialFace */
/*      GL_FRONT */
/*      GL_BACK */
/*      GL_FRONT_AND_BACK */

/* ColorMaterialParameter */
/*      GL_AMBIENT */
/*      GL_DIFFUSE */
/*      GL_SPECULAR */
/*      GL_EMISSION */
/*      GL_AMBIENT_AND_DIFFUSE */

/* ColorPointerType */
/*      GL_BYTE */
/*      GL_UNSIGNED_BYTE */
/*      GL_SHORT */
/*      GL_UNSIGNED_SHORT */
/*      GL_INT */
/*      GL_UNSIGNED_INT */
/*      GL_FLOAT */
/*      GL_DOUBLE */

/* ColorTableParameterPName */
/*      GL_COLOR_TABLE_SCALE */
/*      GL_COLOR_TABLE_BIAS */

/* ColorTableTarget */
/*      GL_COLOR_TABLE */
/*      GL_POST_CONVOLUTION_COLOR_TABLE */
/*      GL_POST_COLOR_MATRIX_COLOR_TABLE */
/*      GL_PROXY_COLOR_TABLE */
/*      GL_PROXY_POST_CONVOLUTION_COLOR_TABLE */
/*      GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE */

/* ConvolutionBorderMode */
/*      GL_REDUCE */
/*      GL_IGNORE_BORDER */
/*      GL_CONSTANT_BORDER */

/* ConvolutionParameter */
/*      GL_CONVOLUTION_BORDER_MODE */
/*      GL_CONVOLUTION_FILTER_SCALE */
/*      GL_CONVOLUTION_FILTER_BIAS */

/* ConvolutionTarget */
/*      GL_CONVOLUTION_1D */
/*      GL_CONVOLUTION_2D */

/* CullFaceMode */
/*      GL_FRONT */
/*      GL_BACK */
/*      GL_FRONT_AND_BACK */

/* DataType */
#define GL_BYTE                                 0x1400
#define GL_UNSIGNED_BYTE                        0x1401
#define GL_SHORT                                0x1402
#define GL_UNSIGNED_SHORT                       0x1403
#define GL_INT                                  0x1404
#define GL_UNSIGNED_INT                         0x1405
#define GL_FLOAT                                0x1406
#define GL_2_BYTES                              0x1407
#define GL_3_BYTES                              0x1408
#define GL_4_BYTES                              0x1409
#define GL_DOUBLE                               0x140A

/* DepthFunction */
/*      GL_NEVER */
/*      GL_LESS */
/*      GL_EQUAL */
/*      GL_LEQUAL */
/*      GL_GREATER */
/*      GL_NOTEQUAL */
/*      GL_GEQUAL */
/*      GL_ALWAYS */

/* DrawBufferMode */
#define GL_NONE                                 0
#define GL_FRONT_LEFT                           0x0400
#define GL_FRONT_RIGHT                          0x0401
#define GL_BACK_LEFT                            0x0402
#define GL_BACK_RIGHT                           0x0403
#define GL_FRONT                                0x0404
#define GL_BACK                                 0x0405
#define GL_LEFT                                 0x0406
#define GL_RIGHT                                0x0407
#define GL_FRONT_AND_BACK                       0x0408
#define GL_AUX0                                 0x0409
#define GL_AUX1                                 0x040A
#define GL_AUX2                                 0x040B
#define GL_AUX3                                 0x040C

/* Enable */
/*      GL_FOG */
/*      GL_LIGHTING */
/*      GL_TEXTURE_1D */
/*      GL_TEXTURE_2D */
/*      GL_LINE_STIPPLE */
/*      GL_POLYGON_STIPPLE */
/*      GL_CULL_FACE */
/*      GL_ALPHA_TEST */
/*      GL_BLEND */
/*      GL_INDEX_LOGIC_OP */
/*      GL_COLOR_LOGIC_OP */
/*      GL_DITHER */
/*      GL_STENCIL_TEST */
/*      GL_DEPTH_TEST */
/*      GL_CLIP_PLANE0 */
/*      GL_CLIP_PLANE1 */
/*      GL_CLIP_PLANE2 */
/*      GL_CLIP_PLANE3 */
/*      GL_CLIP_PLANE4 */
/*      GL_CLIP_PLANE5 */
/*      GL_LIGHT0 */
/*      GL_LIGHT1 */
/*      GL_LIGHT2 */
/*      GL_LIGHT3 */
/*      GL_LIGHT4 */
/*      GL_LIGHT5 */
/*      GL_LIGHT6 */
/*      GL_LIGHT7 */
/*      GL_TEXTURE_GEN_S */
/*      GL_TEXTURE_GEN_T */
/*      GL_TEXTURE_GEN_R */
/*      GL_TEXTURE_GEN_Q */
/*      GL_MAP1_VERTEX_3 */
/*      GL_MAP1_VERTEX_4 */
/*      GL_MAP1_COLOR_4 */
/*      GL_MAP1_INDEX */
/*      GL_MAP1_NORMAL */
/*      GL_MAP1_TEXTURE_COORD_1 */
/*      GL_MAP1_TEXTURE_COORD_2 */
/*      GL_MAP1_TEXTURE_COORD_3 */
/*      GL_MAP1_TEXTURE_COORD_4 */
/*      GL_MAP2_VERTEX_3 */
/*      GL_MAP2_VERTEX_4 */
/*      GL_MAP2_COLOR_4 */
/*      GL_MAP2_INDEX */
/*      GL_MAP2_NORMAL */
/*      GL_MAP2_TEXTURE_COORD_1 */
/*      GL_MAP2_TEXTURE_COORD_2 */
/*      GL_MAP2_TEXTURE_COORD_3 */
/*      GL_MAP2_TEXTURE_COORD_4 */
/*      GL_POINT_SMOOTH */
/*      GL_LINE_SMOOTH */
/*      GL_POLYGON_SMOOTH */
/*      GL_SCISSOR_TEST */
/*      GL_COLOR_MATERIAL */
/*      GL_NORMALIZE */
/*      GL_AUTO_NORMAL */
/*      GL_VERTEX_ARRAY */
/*      GL_NORMAL_ARRAY */
/*      GL_COLOR_ARRAY */
/*      GL_INDEX_ARRAY */
/*      GL_TEXTURE_COORD_ARRAY */
/*      GL_EDGE_FLAG_ARRAY */
/*      GL_POLYGON_OFFSET_POINT */
/*      GL_POLYGON_OFFSET_LINE */
/*      GL_POLYGON_OFFSET_FILL */
/*      GL_POLYGON_OFFSET_EXT */
/*      GL_COLOR_TABLE */
/*      GL_POST_CONVOLUTION_COLOR_TABLE */
/*      GL_POST_COLOR_MATRIX_COLOR_TABLE */
/*      GL_CONVOLUTION_1D */
/*      GL_CONVOLUTION_2D */
/*      GL_SEPARABLE_2D */
/*      GL_HISTOGRAM */
/*      GL_MINMAX */
/*      GL_RESCALE_NORMAL */
/*      GL_TEXTURE_3D */
/*      GL_OCCLUSION_TEST_HP */

/* ErrorCode */
#define GL_NO_ERROR                             0
#define GL_INVALID_ENUM                         0x0500
#define GL_INVALID_VALUE                        0x0501
#define GL_INVALID_OPERATION                    0x0502
#define GL_STACK_OVERFLOW                       0x0503
#define GL_STACK_UNDERFLOW                      0x0504
#define GL_OUT_OF_MEMORY                        0x0505
/*      GL_TABLE_TOO_LARGE */

/* FeedBackMode */
#define GL_2D                                   0x0600
#define GL_3D                                   0x0601
#define GL_3D_COLOR                             0x0602
#define GL_3D_COLOR_TEXTURE                     0x0603
#define GL_4D_COLOR_TEXTURE                     0x0604

/* FeedBackToken */
#define GL_PASS_THROUGH_TOKEN                   0x0700
#define GL_POINT_TOKEN                          0x0701
#define GL_LINE_TOKEN                           0x0702
#define GL_POLYGON_TOKEN                        0x0703
#define GL_BITMAP_TOKEN                         0x0704
#define GL_DRAW_PIXEL_TOKEN                     0x0705
#define GL_COPY_PIXEL_TOKEN                     0x0706
#define GL_LINE_RESET_TOKEN                     0x0707

/* FogMode */
/*      GL_LINEAR */
#define GL_EXP                                  0x0800
#define GL_EXP2                                 0x0801

/* FogParameter */
/*      GL_FOG_COLOR */
/*      GL_FOG_DENSITY */
/*      GL_FOG_END */
/*      GL_FOG_INDEX */
/*      GL_FOG_MODE */
/*      GL_FOG_START */

/* FrontFaceDirection */
#define GL_CW                                   0x0900
#define GL_CCW                                  0x0901

/* GetColorTableParameterPName */
/*      GL_COLOR_TABLE_SCALE */
/*      GL_COLOR_TABLE_BIAS */
/*      GL_COLOR_TABLE_FORMAT */
/*      GL_COLOR_TABLE_WIDTH */
/*      GL_COLOR_TABLE_RED_SIZE */
/*      GL_COLOR_TABLE_GREEN_SIZE */
/*      GL_COLOR_TABLE_BLUE_SIZE */
/*      GL_COLOR_TABLE_ALPHA_SIZE */
/*      GL_COLOR_TABLE_LUMINANCE_SIZE */
/*      GL_COLOR_TABLE_INTENSITY_SIZE */

/* GetConvolutionParameter */
/*      GL_CONVOLUTION_BORDER_COLOR */
/*      GL_CONVOLUTION_BORDER_MODE */
/*      GL_CONVOLUTION_FILTER_SCALE */
/*      GL_CONVOLUTION_FILTER_BIAS */
/*      GL_CONVOLUTION_FORMAT */
/*      GL_CONVOLUTION_WIDTH */
/*      GL_CONVOLUTION_HEIGHT */
/*      GL_MAX_CONVOLUTION_WIDTH */
/*      GL_MAX_CONVOLUTION_HEIGHT */

/* GetHistogramParameterPName */
/*      GL_HISTOGRAM_WIDTH */
/*      GL_HISTOGRAM_FORMAT */
/*      GL_HISTOGRAM_RED_SIZE */
/*      GL_HISTOGRAM_GREEN_SIZE */
/*      GL_HISTOGRAM_BLUE_SIZE */
/*      GL_HISTOGRAM_ALPHA_SIZE */
/*      GL_HISTOGRAM_LUMINANCE_SIZE */
/*      GL_HISTOGRAM_SINK */

/* GetMapTarget */
#define GL_COEFF                                0x0A00
#define GL_ORDER                                0x0A01
#define GL_DOMAIN                               0x0A02

/* GetMinmaxParameterPName */
/*      GL_MINMAX_FORMAT */
/*      GL_MINMAX_SINK */

/* GetPixelMap */
/*      GL_PIXEL_MAP_I_TO_I */
/*      GL_PIXEL_MAP_S_TO_S */
/*      GL_PIXEL_MAP_I_TO_R */
/*      GL_PIXEL_MAP_I_TO_G */
/*      GL_PIXEL_MAP_I_TO_B */
/*      GL_PIXEL_MAP_I_TO_A */
/*      GL_PIXEL_MAP_R_TO_R */
/*      GL_PIXEL_MAP_G_TO_G */
/*      GL_PIXEL_MAP_B_TO_B */
/*      GL_PIXEL_MAP_A_TO_A */

/* GetPointerTarget */
/*      GL_VERTEX_ARRAY_POINTER */
/*      GL_NORMAL_ARRAY_POINTER */
/*      GL_COLOR_ARRAY_POINTER */
/*      GL_INDEX_ARRAY_POINTER */
/*      GL_TEXTURE_COORD_ARRAY_POINTER */
/*      GL_EDGE_FLAG_ARRAY_POINTER */

/* GetTarget */
#define GL_CURRENT_COLOR                        0x0B00
#define GL_CURRENT_INDEX                        0x0B01
#define GL_CURRENT_NORMAL                       0x0B02
#define GL_CURRENT_TEXTURE_COORDS               0x0B03
#define GL_CURRENT_RASTER_COLOR                 0x0B04
#define GL_CURRENT_RASTER_INDEX                 0x0B05
#define GL_CURRENT_RASTER_TEXTURE_COORDS        0x0B06
#define GL_CURRENT_RASTER_POSITION              0x0B07
#define GL_CURRENT_RASTER_POSITION_VALID        0x0B08
#define GL_CURRENT_RASTER_DISTANCE              0x0B09
#define GL_POINT_SMOOTH                         0x0B10
#define GL_POINT_SIZE                           0x0B11
#define GL_POINT_SIZE_RANGE                     0x0B12
#define GL_POINT_SIZE_GRANULARITY               0x0B13
#define GL_LINE_SMOOTH                          0x0B20
#define GL_LINE_WIDTH                           0x0B21
#define GL_LINE_WIDTH_RANGE                     0x0B22
#define GL_LINE_WIDTH_GRANULARITY               0x0B23
#define GL_LINE_STIPPLE                         0x0B24
#define GL_LINE_STIPPLE_PATTERN                 0x0B25
#define GL_LINE_STIPPLE_REPEAT                  0x0B26
#define GL_LIST_MODE                            0x0B30
#define GL_MAX_LIST_NESTING                     0x0B31
#define GL_LIST_BASE                            0x0B32
#define GL_LIST_INDEX                           0x0B33
#define GL_POLYGON_MODE                         0x0B40
#define GL_POLYGON_SMOOTH                       0x0B41
#define GL_POLYGON_STIPPLE                      0x0B42
#define GL_EDGE_FLAG                            0x0B43
#define GL_CULL_FACE                            0x0B44
#define GL_CULL_FACE_MODE                       0x0B45
#define GL_FRONT_FACE                           0x0B46
#define GL_LIGHTING                             0x0B50
#define GL_LIGHT_MODEL_LOCAL_VIEWER             0x0B51
#define GL_LIGHT_MODEL_TWO_SIDE                 0x0B52
#define GL_LIGHT_MODEL_AMBIENT                  0x0B53
#define GL_SHADE_MODEL                          0x0B54
#define GL_COLOR_MATERIAL_FACE                  0x0B55
#define GL_COLOR_MATERIAL_PARAMETER             0x0B56
#define GL_COLOR_MATERIAL                       0x0B57
#define GL_FOG                                  0x0B60
#define GL_FOG_INDEX                            0x0B61
#define GL_FOG_DENSITY                          0x0B62
#define GL_FOG_START                            0x0B63
#define GL_FOG_END                              0x0B64
#define GL_FOG_MODE                             0x0B65
#define GL_FOG_COLOR                            0x0B66
#define GL_DEPTH_RANGE                          0x0B70
#define GL_DEPTH_TEST                           0x0B71
#define GL_DEPTH_WRITEMASK                      0x0B72
#define GL_DEPTH_CLEAR_VALUE                    0x0B73
#define GL_DEPTH_FUNC                           0x0B74
#define GL_ACCUM_CLEAR_VALUE                    0x0B80
#define GL_STENCIL_TEST                         0x0B90
#define GL_STENCIL_CLEAR_VALUE                  0x0B91
#define GL_STENCIL_FUNC                         0x0B92
#define GL_STENCIL_VALUE_MASK                   0x0B93
#define GL_STENCIL_FAIL                         0x0B94
#define GL_STENCIL_PASS_DEPTH_FAIL              0x0B95
#define GL_STENCIL_PASS_DEPTH_PASS              0x0B96
#define GL_STENCIL_REF                          0x0B97
#define GL_STENCIL_WRITEMASK                    0x0B98
#define GL_MATRIX_MODE                          0x0BA0
#define GL_NORMALIZE                            0x0BA1
#define GL_VIEWPORT                             0x0BA2
#define GL_MODELVIEW_STACK_DEPTH                0x0BA3
#define GL_PROJECTION_STACK_DEPTH               0x0BA4
#define GL_TEXTURE_STACK_DEPTH                  0x0BA5
#define GL_MODELVIEW_MATRIX                     0x0BA6
#define GL_PROJECTION_MATRIX                    0x0BA7
#define GL_TEXTURE_MATRIX                       0x0BA8
#define GL_ATTRIB_STACK_DEPTH                   0x0BB0
#define GL_CLIENT_ATTRIB_STACK_DEPTH            0x0BB1
#define GL_ALPHA_TEST                           0x0BC0
#define GL_ALPHA_TEST_FUNC                      0x0BC1
#define GL_ALPHA_TEST_REF                       0x0BC2
#define GL_DITHER                               0x0BD0
#define GL_BLEND_DST                            0x0BE0
#define GL_BLEND_SRC                            0x0BE1
#define GL_BLEND                                0x0BE2
#define GL_LOGIC_OP_MODE                        0x0BF0
#define GL_INDEX_LOGIC_OP                       0x0BF1
#define GL_COLOR_LOGIC_OP                       0x0BF2
#define GL_AUX_BUFFERS                          0x0C00
#define GL_DRAW_BUFFER                          0x0C01
#define GL_READ_BUFFER                          0x0C02
#define GL_SCISSOR_BOX                          0x0C10
#define GL_SCISSOR_TEST                         0x0C11
#define GL_INDEX_CLEAR_VALUE                    0x0C20
#define GL_INDEX_WRITEMASK                      0x0C21
#define GL_COLOR_CLEAR_VALUE                    0x0C22
#define GL_COLOR_WRITEMASK                      0x0C23
#define GL_INDEX_MODE                           0x0C30
#define GL_RGBA_MODE                            0x0C31
#define GL_DOUBLEBUFFER                         0x0C32
#define GL_STEREO                               0x0C33
#define GL_RENDER_MODE                          0x0C40
#define GL_PERSPECTIVE_CORRECTION_HINT          0x0C50
#define GL_POINT_SMOOTH_HINT                    0x0C51
#define GL_LINE_SMOOTH_HINT                     0x0C52
#define GL_POLYGON_SMOOTH_HINT                  0x0C53
#define GL_FOG_HINT                             0x0C54
#define GL_TEXTURE_GEN_S                        0x0C60
#define GL_TEXTURE_GEN_T                        0x0C61
#define GL_TEXTURE_GEN_R                        0x0C62
#define GL_TEXTURE_GEN_Q                        0x0C63
#define GL_PIXEL_MAP_I_TO_I                     0x0C70
#define GL_PIXEL_MAP_S_TO_S                     0x0C71
#define GL_PIXEL_MAP_I_TO_R                     0x0C72
#define GL_PIXEL_MAP_I_TO_G                     0x0C73
#define GL_PIXEL_MAP_I_TO_B                     0x0C74
#define GL_PIXEL_MAP_I_TO_A                     0x0C75
#define GL_PIXEL_MAP_R_TO_R                     0x0C76
#define GL_PIXEL_MAP_G_TO_G                     0x0C77
#define GL_PIXEL_MAP_B_TO_B                     0x0C78
#define GL_PIXEL_MAP_A_TO_A                     0x0C79
#define GL_PIXEL_MAP_I_TO_I_SIZE                0x0CB0
#define GL_PIXEL_MAP_S_TO_S_SIZE                0x0CB1
#define GL_PIXEL_MAP_I_TO_R_SIZE                0x0CB2
#define GL_PIXEL_MAP_I_TO_G_SIZE                0x0CB3
#define GL_PIXEL_MAP_I_TO_B_SIZE                0x0CB4
#define GL_PIXEL_MAP_I_TO_A_SIZE                0x0CB5
#define GL_PIXEL_MAP_R_TO_R_SIZE                0x0CB6
#define GL_PIXEL_MAP_G_TO_G_SIZE                0x0CB7
#define GL_PIXEL_MAP_B_TO_B_SIZE                0x0CB8
#define GL_PIXEL_MAP_A_TO_A_SIZE                0x0CB9
#define GL_UNPACK_SWAP_BYTES                    0x0CF0
#define GL_UNPACK_LSB_FIRST                     0x0CF1
#define GL_UNPACK_ROW_LENGTH                    0x0CF2
#define GL_UNPACK_SKIP_ROWS                     0x0CF3
#define GL_UNPACK_SKIP_PIXELS                   0x0CF4
#define GL_UNPACK_ALIGNMENT                     0x0CF5
#define GL_PACK_SWAP_BYTES                      0x0D00
#define GL_PACK_LSB_FIRST                       0x0D01
#define GL_PACK_ROW_LENGTH                      0x0D02
#define GL_PACK_SKIP_ROWS                       0x0D03
#define GL_PACK_SKIP_PIXELS                     0x0D04
#define GL_PACK_ALIGNMENT                       0x0D05
#define GL_MAP_COLOR                            0x0D10
#define GL_MAP_STENCIL                          0x0D11
#define GL_INDEX_SHIFT                          0x0D12
#define GL_INDEX_OFFSET                         0x0D13
#define GL_RED_SCALE                            0x0D14
#define GL_RED_BIAS                             0x0D15
#define GL_ZOOM_X                               0x0D16
#define GL_ZOOM_Y                               0x0D17
#define GL_GREEN_SCALE                          0x0D18
#define GL_GREEN_BIAS                           0x0D19
#define GL_BLUE_SCALE                           0x0D1A
#define GL_BLUE_BIAS                            0x0D1B
#define GL_ALPHA_SCALE                          0x0D1C
#define GL_ALPHA_BIAS                           0x0D1D
#define GL_DEPTH_SCALE                          0x0D1E
#define GL_DEPTH_BIAS                           0x0D1F
#define GL_MAX_EVAL_ORDER                       0x0D30
#define GL_MAX_LIGHTS                           0x0D31
#define GL_MAX_CLIP_PLANES                      0x0D32
#define GL_MAX_TEXTURE_SIZE                     0x0D33
#define GL_MAX_PIXEL_MAP_TABLE                  0x0D34
#define GL_MAX_ATTRIB_STACK_DEPTH               0x0D35
#define GL_MAX_MODELVIEW_STACK_DEPTH            0x0D36
#define GL_MAX_NAME_STACK_DEPTH                 0x0D37
#define GL_MAX_PROJECTION_STACK_DEPTH           0x0D38
#define GL_MAX_TEXTURE_STACK_DEPTH              0x0D39
#define GL_MAX_VIEWPORT_DIMS                    0x0D3A
#define GL_MAX_CLIENT_ATTRIB_STACK_DEPTH        0x0D3B
#define GL_SUBPIXEL_BITS                        0x0D50
#define GL_INDEX_BITS                           0x0D51
#define GL_RED_BITS                             0x0D52
#define GL_GREEN_BITS                           0x0D53
#define GL_BLUE_BITS                            0x0D54
#define GL_ALPHA_BITS                           0x0D55
#define GL_DEPTH_BITS                           0x0D56
#define GL_STENCIL_BITS                         0x0D57
#define GL_ACCUM_RED_BITS                       0x0D58
#define GL_ACCUM_GREEN_BITS                     0x0D59
#define GL_ACCUM_BLUE_BITS                      0x0D5A
#define GL_ACCUM_ALPHA_BITS                     0x0D5B
#define GL_NAME_STACK_DEPTH                     0x0D70
#define GL_AUTO_NORMAL                          0x0D80
#define GL_MAP1_COLOR_4                         0x0D90
#define GL_MAP1_INDEX                           0x0D91
#define GL_MAP1_NORMAL                          0x0D92
#define GL_MAP1_TEXTURE_COORD_1                 0x0D93
#define GL_MAP1_TEXTURE_COORD_2                 0x0D94
#define GL_MAP1_TEXTURE_COORD_3                 0x0D95
#define GL_MAP1_TEXTURE_COORD_4                 0x0D96
#define GL_MAP1_VERTEX_3                        0x0D97
#define GL_MAP1_VERTEX_4                        0x0D98
#define GL_MAP2_COLOR_4                         0x0DB0
#define GL_MAP2_INDEX                           0x0DB1
#define GL_MAP2_NORMAL                          0x0DB2
#define GL_MAP2_TEXTURE_COORD_1                 0x0DB3
#define GL_MAP2_TEXTURE_COORD_2                 0x0DB4
#define GL_MAP2_TEXTURE_COORD_3                 0x0DB5
#define GL_MAP2_TEXTURE_COORD_4                 0x0DB6
#define GL_MAP2_VERTEX_3                        0x0DB7
#define GL_MAP2_VERTEX_4                        0x0DB8
#define GL_MAP1_GRID_DOMAIN                     0x0DD0
#define GL_MAP1_GRID_SEGMENTS                   0x0DD1
#define GL_MAP2_GRID_DOMAIN                     0x0DD2
#define GL_MAP2_GRID_SEGMENTS                   0x0DD3
#define GL_TEXTURE_1D                           0x0DE0
#define GL_TEXTURE_2D                           0x0DE1
#define GL_FEEDBACK_BUFFER_POINTER              0x0DF0
#define GL_FEEDBACK_BUFFER_SIZE                 0x0DF1
#define GL_FEEDBACK_BUFFER_TYPE                 0x0DF2
#define GL_SELECTION_BUFFER_POINTER             0x0DF3
#define GL_SELECTION_BUFFER_SIZE                0x0DF4

/* GetTextureParameter */
#define GL_TEXTURE_WIDTH                        0x1000
#define GL_TEXTURE_HEIGHT                       0x1001
#define GL_TEXTURE_INTERNAL_FORMAT              0x1003
#define GL_TEXTURE_BORDER_COLOR                 0x1004
#define GL_TEXTURE_BORDER                       0x1005

/* HintMode */
#define GL_DONT_CARE                            0x1100
#define GL_FASTEST                              0x1101
#define GL_NICEST                               0x1102

/* LightName */
#define GL_LIGHT0                               0x4000
#define GL_LIGHT1                               0x4001
#define GL_LIGHT2                               0x4002
#define GL_LIGHT3                               0x4003
#define GL_LIGHT4                               0x4004
#define GL_LIGHT5                               0x4005
#define GL_LIGHT6                               0x4006
#define GL_LIGHT7                               0x4007

/* LightParameter */
#define GL_AMBIENT                              0x1200
#define GL_DIFFUSE                              0x1201
#define GL_SPECULAR                             0x1202
#define GL_POSITION                             0x1203
#define GL_SPOT_DIRECTION                       0x1204
#define GL_SPOT_EXPONENT                        0x1205
#define GL_SPOT_CUTOFF                          0x1206
#define GL_CONSTANT_ATTENUATION                 0x1207
#define GL_LINEAR_ATTENUATION                   0x1208
#define GL_QUADRATIC_ATTENUATION                0x1209

/* ListMode */
#define GL_COMPILE                              0x1300
#define GL_COMPILE_AND_EXECUTE                  0x1301

/* LogicOp */
#define GL_CLEAR                                0x1500
#define GL_AND                                  0x1501
#define GL_AND_REVERSE                          0x1502
#define GL_COPY                                 0x1503
#define GL_AND_INVERTED                         0x1504
#define GL_NOOP                                 0x1505
#define GL_XOR                                  0x1506
#define GL_OR                                   0x1507
#define GL_NOR                                  0x1508
#define GL_EQUIV                                0x1509
#define GL_INVERT                               0x150A
#define GL_OR_REVERSE                           0x150B
#define GL_COPY_INVERTED                        0x150C
#define GL_OR_INVERTED                          0x150D
#define GL_NAND                                 0x150E
#define GL_SET                                  0x150F

/* MaterialParameter */
#define GL_EMISSION                             0x1600
#define GL_SHININESS                            0x1601
#define GL_AMBIENT_AND_DIFFUSE                  0x1602
#define GL_COLOR_INDEXES                        0x1603
/*      GL_AMBIENT */
/*      GL_DIFFUSE */
/*      GL_SPECULAR */

/* MatrixMode */
#define GL_MODELVIEW                            0x1700
#define GL_PROJECTION                           0x1701
#define GL_TEXTURE                              0x1702

/* PixelCopyType */
#define GL_COLOR                                0x1800
#define GL_DEPTH                                0x1801
#define GL_STENCIL                              0x1802

/* PixelFormat */
#define GL_COLOR_INDEX                          0x1900
#define GL_STENCIL_INDEX                        0x1901
#define GL_DEPTH_COMPONENT                      0x1902
#define GL_RED                                  0x1903
#define GL_GREEN                                0x1904
#define GL_BLUE                                 0x1905
#define GL_ALPHA                                0x1906
#define GL_RGB                                  0x1907
#define GL_RGBA                                 0x1908
#define GL_LUMINANCE                            0x1909
#define GL_LUMINANCE_ALPHA                      0x190A

/* PixelType */
#define GL_BITMAP                               0x1A00

/* PolygonMode */
#define GL_POINT                                0x1B00
#define GL_LINE                                 0x1B01
#define GL_FILL                                 0x1B02

/* RenderingMode */
#define GL_RENDER                               0x1C00
#define GL_FEEDBACK                             0x1C01
#define GL_SELECT                               0x1C02

/* ShadingModel */
#define GL_FLAT                                 0x1D00
#define GL_SMOOTH                               0x1D01

/* StencilOp */
#define GL_KEEP                                 0x1E00
#define GL_REPLACE                              0x1E01
#define GL_INCR                                 0x1E02
#define GL_DECR                                 0x1E03
#define GL_INCR_WRAP                            0x8507
#define GL_DECR_WRAP                            0x8508

/* StringName */
#define GL_VENDOR                               0x1F00
#define GL_RENDERER                             0x1F01
#define GL_VERSION                              0x1F02
#define GL_EXTENSIONS                           0x1F03

/* TextureCoordName */
#define GL_S                                    0x2000
#define GL_T                                    0x2001
#define GL_R                                    0x2002
#define GL_Q                                    0x2003

/* TextureEnvMode */
#define GL_MODULATE                             0x2100
#define GL_DECAL                                0x2101

/* TextureEnvParameter */
#define GL_TEXTURE_ENV_MODE                     0x2200
#define GL_TEXTURE_ENV_COLOR                    0x2201

/* TextureEnvTarget */
#define GL_TEXTURE_ENV                          0x2300

/* TextureGenMode */
#define GL_EYE_LINEAR                           0x2400
#define GL_OBJECT_LINEAR                        0x2401
#define GL_SPHERE_MAP                           0x2402

/* TextureGenParameter */
#define GL_TEXTURE_GEN_MODE                     0x2500
#define GL_OBJECT_PLANE                         0x2501
#define GL_EYE_PLANE                            0x2502

/* TextureMagFilter */
#define GL_NEAREST                              0x2600
#define GL_LINEAR                               0x2601

/* TextureMinFilter */
#define GL_NEAREST_MIPMAP_NEAREST               0x2700
#define GL_LINEAR_MIPMAP_NEAREST                0x2701
#define GL_NEAREST_MIPMAP_LINEAR                0x2702
#define GL_LINEAR_MIPMAP_LINEAR                 0x2703

/* TextureParameterName */
#define GL_TEXTURE_MAG_FILTER                   0x2800
#define GL_TEXTURE_MIN_FILTER                   0x2801
#define GL_TEXTURE_WRAP_S                       0x2802
#define GL_TEXTURE_WRAP_T                       0x2803

/* TextureWrapMode */
#define GL_CLAMP                                0x2900
#define GL_REPEAT                               0x2901
#define GL_CLAMP_TO_BORDER                      0x812D
#define GL_CLAMP_TO_EDGE                        0x812F
#define GL_MIRRORED_REPEAT    			0x8370

#ifdef GL_ARB_texture_border_clamp
#define GL_CLAMP_TO_BORDER_ARB                  GL_CLAMP_TO_BORDER
#endif

#ifdef GL_ARB_texture_mirrored_repeat
#define GL_MIRRORED_REPEAT_ARB			GL_MIRRORED_REPEAT
#endif

#ifdef GL_SGIS_texture_border_clamp
#define GL_CLAMP_TO_BORDER_SGIS                 GL_CLAMP_TO_BORDER
#endif

/* ClientAttribMask */
#define GL_CLIENT_PIXEL_STORE_BIT               0x00000001
#define GL_CLIENT_VERTEX_ARRAY_BIT              0x00000002
#define GL_CLIENT_ALL_ATTRIB_BITS               0xffffffff

/* polygon_offset */
#define GL_POLYGON_OFFSET_FACTOR                0x8038
#define GL_POLYGON_OFFSET_UNITS                 0x2A00
#define GL_POLYGON_OFFSET_POINT                 0x2A01
#define GL_POLYGON_OFFSET_LINE                  0x2A02
#define GL_POLYGON_OFFSET_FILL                  0x8037

/* texture */
#define GL_ALPHA4                               0x803B
#define GL_ALPHA8                               0x803C
#define GL_ALPHA12                              0x803D
#define GL_ALPHA16                              0x803E
#define GL_LUMINANCE4                           0x803F
#define GL_LUMINANCE8                           0x8040
#define GL_LUMINANCE12                          0x8041
#define GL_LUMINANCE16                          0x8042
#define GL_LUMINANCE4_ALPHA4                    0x8043
#define GL_LUMINANCE6_ALPHA2                    0x8044
#define GL_LUMINANCE8_ALPHA8                    0x8045
#define GL_LUMINANCE12_ALPHA4                   0x8046
#define GL_LUMINANCE12_ALPHA12                  0x8047
#define GL_LUMINANCE16_ALPHA16                  0x8048
#define GL_INTENSITY                            0x8049
#define GL_INTENSITY4                           0x804A
#define GL_INTENSITY8                           0x804B
#define GL_INTENSITY12                          0x804C
#define GL_INTENSITY16                          0x804D
#define GL_R3_G3_B2                             0x2A10
#define GL_RGB4                                 0x804F
#define GL_RGB5                                 0x8050
#define GL_RGB8                                 0x8051
#define GL_RGB10                                0x8052
#define GL_RGB12                                0x8053
#define GL_RGB16                                0x8054
#define GL_RGBA2                                0x8055
#define GL_RGBA4                                0x8056
#define GL_RGB5_A1                              0x8057
#define GL_RGBA8                                0x8058
#define GL_RGB10_A2                             0x8059
#define GL_RGBA12                               0x805A
#define GL_RGBA16                               0x805B
#define GL_TEXTURE_RED_SIZE                     0x805C
#define GL_TEXTURE_GREEN_SIZE                   0x805D
#define GL_TEXTURE_BLUE_SIZE                    0x805E
#define GL_TEXTURE_ALPHA_SIZE                   0x805F
#define GL_TEXTURE_LUMINANCE_SIZE               0x8060
#define GL_TEXTURE_INTENSITY_SIZE               0x8061
#define GL_PROXY_TEXTURE_1D                     0x8063
#define GL_PROXY_TEXTURE_2D                     0x8064

/* texture_object */
#define GL_TEXTURE_PRIORITY                     0x8066
#define GL_TEXTURE_RESIDENT                     0x8067
#define GL_TEXTURE_BINDING_1D                   0x8068
#define GL_TEXTURE_BINDING_2D                   0x8069

/* multitexture */
#define GL_TEXTURE0                             0x84C0
#define GL_TEXTURE1                             0x84C1
#define GL_TEXTURE2                             0x84C2
#define GL_TEXTURE3                             0x84C3
#define GL_TEXTURE4                             0x84C4
#define GL_TEXTURE5                             0x84C5
#define GL_TEXTURE6                             0x84C6
#define GL_TEXTURE7                             0x84C7
#define GL_TEXTURE8                             0x84C8
#define GL_TEXTURE9                             0x84C9
#define GL_TEXTURE10                            0x84CA
#define GL_TEXTURE11                            0x84CB
#define GL_TEXTURE12                            0x84CC
#define GL_TEXTURE13                            0x84CD
#define GL_TEXTURE14                            0x84CE
#define GL_TEXTURE15                            0x84CF
#define GL_TEXTURE16                            0x84D0
#define GL_TEXTURE17                            0x84D1
#define GL_TEXTURE18                            0x84D2
#define GL_TEXTURE19                            0x84D3
#define GL_TEXTURE20                            0x84D4
#define GL_TEXTURE21                            0x84D5
#define GL_TEXTURE22                            0x84D6
#define GL_TEXTURE23                            0x84D7
#define GL_TEXTURE24                            0x84D8
#define GL_TEXTURE25                            0x84D9
#define GL_TEXTURE26                            0x84DA
#define GL_TEXTURE27                            0x84DB
#define GL_TEXTURE28                            0x84DC
#define GL_TEXTURE29                            0x84DD
#define GL_TEXTURE30                            0x84DE
#define GL_TEXTURE31                            0x84DF
#define GL_ACTIVE_TEXTURE                       0x84E0
#define GL_CLIENT_ACTIVE_TEXTURE                0x84E1
#define GL_MAX_TEXTURE_UNITS                    0x84E2

/* texture_compression */
#define GL_COMPRESSED_ALPHA                     0x84E9
#define GL_COMPRESSED_LUMINANCE                 0x84EA
#define GL_COMPRESSED_LUMINANCE_ALPHA           0x84EB
#define GL_COMPRESSED_INTENSITY                 0x84EC
#define GL_COMPRESSED_RGB                       0x84ED
#define GL_COMPRESSED_RGBA                      0x84EE
#define GL_TEXTURE_COMPRESSION_HINT             0x84EF
#define GL_TEXTURE_COMPRESSED_IMAGE_SIZE        0x86A0
#define GL_TEXTURE_COMPRESSED                   0x86A1
#define GL_NUM_COMPRESSED_TEXTURE_FORMATS       0x86A2
#define GL_COMPRESSED_TEXTURE_FORMATS           0x86A3

/* texture_cube_map */
#define GL_NORMAL_MAP                           0x8511
#define GL_REFLECTION_MAP                       0x8512
#define GL_TEXTURE_CUBE_MAP                     0x8513
#define GL_TEXTURE_BINDING_CUBE_MAP             0x8514
#define GL_TEXTURE_CUBE_MAP_POSITIVE_X          0x8515
#define GL_TEXTURE_CUBE_MAP_NEGATIVE_X          0x8516
#define GL_TEXTURE_CUBE_MAP_POSITIVE_Y          0x8517
#define GL_TEXTURE_CUBE_MAP_NEGATIVE_Y          0x8518
#define GL_TEXTURE_CUBE_MAP_POSITIVE_Z          0x8519
#define GL_TEXTURE_CUBE_MAP_NEGATIVE_Z          0x851A
#define GL_PROXY_TEXTURE_CUBE_MAP               0x851B
#define GL_MAX_CUBE_MAP_TEXTURE_SIZE            0x851C


/* texture_env_dot3 */
#define GL_DOT3_RGB                             0x86AE
#define GL_DOT3_RGBA                            0x86AF

/* texture_env_combine */
#define GL_COMBINE                              0x8570
#define GL_COMBINE_RGB                          0x8571
#define GL_COMBINE_ALPHA                        0x8572
#define GL_SOURCE0_RGB                          0x8580
#define GL_SRC0_RGB                          	0x8580
#define GL_SOURCE1_RGB                          0x8581
#define GL_SRC1_RGB                             0x8581
#define GL_SOURCE2_RGB                          0x8582
#define GL_SRC2_RGB                             0x8582
#define GL_SOURCE0_ALPHA                        0x8588
#define GL_SRC0_ALPHA                           0x8588
#define GL_SOURCE1_ALPHA                        0x8589
#define GL_SRC1_ALPHA                           0x8589
#define GL_SOURCE2_ALPHA                        0x858A
#define GL_SRC2_ALPHA                           0x858A
#define GL_OPERAND0_RGB                         0x8590
#define GL_OPERAND1_RGB                         0x8591
#define GL_OPERAND2_RGB                         0x8592
#define GL_OPERAND0_ALPHA                       0x8598
#define GL_OPERAND1_ALPHA                       0x8599
#define GL_OPERAND2_ALPHA                       0x859A
#define GL_RGB_SCALE                            0x8573
#define GL_ADD_SIGNED                           0x8574
#define GL_INTERPOLATE                          0x8575
#define GL_SUBTRACT                             0x84E7
#define GL_CONSTANT                             0x8576
#define GL_PRIMARY_COLOR                        0x8577
#define GL_PREVIOUS                             0x8578

/* transpose_matrix */
#define GL_TRANSPOSE_MODELVIEW_MATRIX           0x84E3
#define GL_TRANSPOSE_PROJECTION_MATRIX          0x84E4
#define GL_TRANSPOSE_TEXTURE_MATRIX             0x84E5
#define GL_TRANSPOSE_COLOR_MATRIX               0x84E6

/* vertex_array */
#define GL_VERTEX_ARRAY                         0x8074
#define GL_NORMAL_ARRAY                         0x8075
#define GL_COLOR_ARRAY                          0x8076
#define GL_INDEX_ARRAY                          0x8077
#define GL_TEXTURE_COORD_ARRAY                  0x8078
#define GL_EDGE_FLAG_ARRAY                      0x8079
#define GL_VERTEX_ARRAY_SIZE                    0x807A
#define GL_VERTEX_ARRAY_TYPE                    0x807B
#define GL_VERTEX_ARRAY_STRIDE                  0x807C
#define GL_NORMAL_ARRAY_TYPE                    0x807E
#define GL_NORMAL_ARRAY_STRIDE                  0x807F
#define GL_COLOR_ARRAY_SIZE                     0x8081
#define GL_COLOR_ARRAY_TYPE                     0x8082
#define GL_COLOR_ARRAY_STRIDE                   0x8083
#define GL_INDEX_ARRAY_TYPE                     0x8085
#define GL_INDEX_ARRAY_STRIDE                   0x8086
#define GL_TEXTURE_COORD_ARRAY_SIZE             0x8088
#define GL_TEXTURE_COORD_ARRAY_TYPE             0x8089
#define GL_TEXTURE_COORD_ARRAY_STRIDE           0x808A
#define GL_EDGE_FLAG_ARRAY_STRIDE               0x808C
#define GL_VERTEX_ARRAY_POINTER                 0x808E
#define GL_NORMAL_ARRAY_POINTER                 0x808F
#define GL_COLOR_ARRAY_POINTER                  0x8090
#define GL_INDEX_ARRAY_POINTER                  0x8091
#define GL_TEXTURE_COORD_ARRAY_POINTER          0x8092
#define GL_EDGE_FLAG_ARRAY_POINTER              0x8093

#define GL_FOG_COORD_SRC			0x8450
#define GL_FOG_COORD_SOURCE_EXT			0x8450
#define GL_FOG_COORD    			0x8451	
#define GL_FOG_COORDINATE_EXT			0x8451	
#define GL_FRAGMENT_DEPTH			0x8452
#define GL_FRAGMENT_DEPTH_EXT			0x8452
#define GL_CURRENT_FOG_COORD			0x8453
#define GL_CURRENT_FOG_COORDINATE_EXT		0x8453
#define GL_FOG_COORD_ARRAY_TYPE			0x8454
#define GL_FOG_COORDINATE_ARRAY_TYPE_EXT	0x8454
#define GL_FOG_COORD_ARRAY_STRIDE		0x8455
#define GL_FOG_COORDINATE_ARRAY_STRIDE_EXT	0x8455
#define GL_FOG_COORD_ARRAY_POINTER		0x8456
#define GL_FOG_COORDINATE_ARRAY_POINTER_EXT	0x8456
#define GL_FOG_COORD_ARRAY			0x8457
#define GL_FOG_COORDINATE_ARRAY_EXT		0x8457

#define GL_COLOR_SUM_EXT              		0x8458
#define GL_CURRENT_SECONDARY_COLOR              0x8459
#define GL_SECONDARY_COLOR_ARRAY_SIZE           0x845A
#define GL_SECONDARY_COLOR_ARRAY_TYPE           0x845B
#define GL_SECONDARY_COLOR_ARRAY_STRIDE         0x845C
#define GL_SECONDARY_COLOR_ARRAY_POINTER        0x845D
#define GL_SECONDARY_COLOR_ARRAY                0x845E
#define GL_CURRENT_SECONDARY_COLOR_EXT          GL_CURRENT_SECONDARY_COLOR
#define GL_SECONDARY_COLOR_ARRAY_SIZE_EXT       GL_SECONDARY_COLOR_ARRAY_SIZE
#define GL_SECONDARY_COLOR_ARRAY_TYPE_EXT       GL_SECONDARY_COLOR_ARRAY_TYPE
#define GL_SECONDARY_COLOR_ARRAY_STRIDE_EXT     GL_SECONDARY_COLOR_ARRAY_STRIDE
#define GL_SECONDARY_COLOR_ARRAY_POINTER_EXT    GL_SECONDARY_COLOR_ARRAY_POINTER
#define GL_SECONDARY_COLOR_ARRAY_EXT		GL_SECONDARY_COLOR_ARRAY

#define GL_V2F                                  0x2A20
#define GL_V3F                                  0x2A21
#define GL_C4UB_V2F                             0x2A22
#define GL_C4UB_V3F                             0x2A23
#define GL_C3F_V3F                              0x2A24
#define GL_N3F_V3F                              0x2A25
#define GL_C4F_N3F_V3F                          0x2A26
#define GL_T2F_V3F                              0x2A27
#define GL_T4F_V4F                              0x2A28
#define GL_T2F_C4UB_V3F                         0x2A29
#define GL_T2F_C3F_V3F                          0x2A2A
#define GL_T2F_N3F_V3F                          0x2A2B
#define GL_T2F_C4F_N3F_V3F                      0x2A2C
#define GL_T4F_C4F_N3F_V4F                      0x2A2D

/* bgra */
#define GL_BGR                                  0x80E0
#define GL_BGRA                                 0x80E1
#ifdef GL_EXT_bgra
#define GL_BGR_EXT                              GL_BGR 
#define GL_BGRA_EXT                             GL_BGRA 
#endif

/* blend_color */
#define GL_CONSTANT_COLOR                       0x8001
#define GL_ONE_MINUS_CONSTANT_COLOR             0x8002
#define GL_CONSTANT_ALPHA                       0x8003
#define GL_ONE_MINUS_CONSTANT_ALPHA             0x8004
#define GL_BLEND_COLOR                          0x8005

/* blend_minmax */
#define GL_FUNC_ADD                             0x8006
#define GL_MIN                                  0x8007
#define GL_MAX                                  0x8008
#define GL_BLEND_EQUATION                       0x8009

/* blend_subtract */
#define GL_FUNC_SUBTRACT                        0x800A
#define GL_FUNC_REVERSE_SUBTRACT                0x800B

/* color_matrix */
#define GL_COLOR_MATRIX                         0x80B1
#define GL_COLOR_MATRIX_STACK_DEPTH             0x80B2
#define GL_MAX_COLOR_MATRIX_STACK_DEPTH         0x80B3
#define GL_POST_COLOR_MATRIX_RED_SCALE          0x80B4
#define GL_POST_COLOR_MATRIX_GREEN_SCALE        0x80B5
#define GL_POST_COLOR_MATRIX_BLUE_SCALE         0x80B6
#define GL_POST_COLOR_MATRIX_ALPHA_SCALE        0x80B7
#define GL_POST_COLOR_MATRIX_RED_BIAS           0x80B8
#define GL_POST_COLOR_MATRIX_GREEN_BIAS         0x80B9
#define GL_POST_COLOR_MATRIX_BLUE_BIAS          0x80BA
#define GL_POST_COLOR_MATRIX_ALPHA_BIAS         0x80BB

/* color_table */
#define GL_COLOR_TABLE                          0x80D0
#define GL_POST_CONVOLUTION_COLOR_TABLE         0x80D1
#define GL_POST_COLOR_MATRIX_COLOR_TABLE        0x80D2
#define GL_PROXY_COLOR_TABLE                    0x80D3
#define GL_PROXY_POST_CONVOLUTION_COLOR_TABLE   0x80D4
#define GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE  0x80D5
#define GL_COLOR_TABLE_SCALE                    0x80D6
#define GL_COLOR_TABLE_BIAS                     0x80D7
#define GL_COLOR_TABLE_FORMAT                   0x80D8
#define GL_COLOR_TABLE_WIDTH                    0x80D9
#define GL_COLOR_TABLE_RED_SIZE                 0x80DA
#define GL_COLOR_TABLE_GREEN_SIZE               0x80DB
#define GL_COLOR_TABLE_BLUE_SIZE                0x80DC
#define GL_COLOR_TABLE_ALPHA_SIZE               0x80DD
#define GL_COLOR_TABLE_LUMINANCE_SIZE           0x80DE
#define GL_COLOR_TABLE_INTENSITY_SIZE           0x80DF

/* convolution */
#define GL_CONVOLUTION_1D                       0x8010
#define GL_CONVOLUTION_2D                       0x8011
#define GL_SEPARABLE_2D                         0x8012
#define GL_CONVOLUTION_BORDER_MODE              0x8013
#define GL_CONVOLUTION_FILTER_SCALE             0x8014
#define GL_CONVOLUTION_FILTER_BIAS              0x8015
#define GL_REDUCE                               0x8016
#define GL_CONVOLUTION_FORMAT                   0x8017
#define GL_CONVOLUTION_WIDTH                    0x8018
#define GL_CONVOLUTION_HEIGHT                   0x8019
#define GL_MAX_CONVOLUTION_WIDTH                0x801A
#define GL_MAX_CONVOLUTION_HEIGHT               0x801B
#define GL_POST_CONVOLUTION_RED_SCALE           0x801C
#define GL_POST_CONVOLUTION_GREEN_SCALE         0x801D
#define GL_POST_CONVOLUTION_BLUE_SCALE          0x801E
#define GL_POST_CONVOLUTION_ALPHA_SCALE         0x801F
#define GL_POST_CONVOLUTION_RED_BIAS            0x8020
#define GL_POST_CONVOLUTION_GREEN_BIAS          0x8021
#define GL_POST_CONVOLUTION_BLUE_BIAS           0x8022
#define GL_POST_CONVOLUTION_ALPHA_BIAS          0x8023
#define GL_IGNORE_BORDER                        0x8150
#define GL_CONSTANT_BORDER                      0x8151
#define GL_REPLICATE_BORDER                     0x8153
#define GL_CONVOLUTION_BORDER_COLOR             0x8154

/* draw_range_elements */
#define GL_MAX_ELEMENTS_VERTICES                0x80E8
#define GL_MAX_ELEMENTS_INDICES                 0x80E9

/* histogram */
#define GL_HISTOGRAM                            0x8024
#define GL_PROXY_HISTOGRAM                      0x8025
#define GL_HISTOGRAM_WIDTH                      0x8026
#define GL_HISTOGRAM_FORMAT                     0x8027
#define GL_HISTOGRAM_RED_SIZE                   0x8028
#define GL_HISTOGRAM_GREEN_SIZE                 0x8029
#define GL_HISTOGRAM_BLUE_SIZE                  0x802A
#define GL_HISTOGRAM_ALPHA_SIZE                 0x802B
#define GL_HISTOGRAM_LUMINANCE_SIZE             0x802C
#define GL_HISTOGRAM_SINK                       0x802D
#define GL_MINMAX                               0x802E
#define GL_MINMAX_FORMAT                        0x802F
#define GL_MINMAX_SINK                          0x8030
#define GL_TABLE_TOO_LARGE                      0x8031

/* packed_pixels */
#define GL_UNSIGNED_BYTE_3_3_2                  0x8032
#define GL_UNSIGNED_SHORT_4_4_4_4               0x8033
#define GL_UNSIGNED_SHORT_5_5_5_1               0x8034
#define GL_UNSIGNED_INT_8_8_8_8                 0x8035
#define GL_UNSIGNED_INT_10_10_10_2              0x8036
#define GL_UNSIGNED_BYTE_2_3_3_REV              0x8362
#define GL_UNSIGNED_SHORT_5_6_5                 0x8363
#define GL_UNSIGNED_SHORT_5_6_5_REV             0x8364
#define GL_UNSIGNED_SHORT_4_4_4_4_REV           0x8365
#define GL_UNSIGNED_SHORT_1_5_5_5_REV           0x8366
#define GL_UNSIGNED_INT_8_8_8_8_REV             0x8367
#define GL_UNSIGNED_INT_2_10_10_10_REV          0x8368

/* rescale_normal */
#define GL_RESCALE_NORMAL                       0x803A

/* separate_specular_color */
#define GL_LIGHT_MODEL_COLOR_CONTROL            0x81F8
#define GL_SINGLE_COLOR                         0x81F9
#define GL_SEPARATE_SPECULAR_COLOR              0x81FA

/* texture3D */
#define GL_PACK_SKIP_IMAGES                     0x806B
#define GL_PACK_IMAGE_HEIGHT                    0x806C
#define GL_UNPACK_SKIP_IMAGES                   0x806D
#define GL_UNPACK_IMAGE_HEIGHT                  0x806E
#define GL_TEXTURE_3D                           0x806F
#define GL_PROXY_TEXTURE_3D                     0x8070
#define GL_TEXTURE_DEPTH                        0x8071
#define GL_TEXTURE_WRAP_R                       0x8072
#define GL_MAX_3D_TEXTURE_SIZE                  0x8073

/* point parameters */
#define GL_POINT_SIZE_MIN                       0x8126
#define GL_POINT_SIZE_MAX                       0x8127
#define GL_POINT_FADE_THRESHOLD_SIZE            0x8128
#define GL_POINT_DISTANCE_ATTENUATION           0x8129

/* Depth textures */
#define GL_DEPTH_COMPONENT16                    0x81A5
#define GL_DEPTH_COMPONENT24                    0x81A6
#define GL_DEPTH_COMPONENT32                    0x81A7
#define GL_TEXTURE_DEPTH_SIZE                   0x884A
#define GL_DEPTH_TEXTURE_MODE                   0x884B

/* Shadow */
#define GL_TEXTURE_COMPARE_MODE                 0x884C
#define GL_TEXTURE_COMPARE_FUNC                 0x884D
#define GL_COMPARE_R_TO_TEXTURE                 0x884E

/* texture_lod */
#define GL_TEXTURE_MIN_LOD                      0x813A
#define GL_TEXTURE_MAX_LOD                      0x813B
#define GL_TEXTURE_BASE_LEVEL                   0x813C
#define GL_TEXTURE_MAX_LEVEL                    0x813D

/* GetTarget1_2 */
#define GL_SMOOTH_POINT_SIZE_RANGE              0x0B12
#define GL_SMOOTH_POINT_SIZE_GRANULARITY        0x0B13
#define GL_SMOOTH_LINE_WIDTH_RANGE              0x0B22
#define GL_SMOOTH_LINE_WIDTH_GRANULARITY        0x0B23
#define GL_ALIASED_POINT_SIZE_RANGE             0x846D
#define GL_ALIASED_LINE_WIDTH_RANGE             0x846E

/* multisample */
#define GL_MULTISAMPLE_BIT                      0x20000000
#define GL_MULTISAMPLE                          0x809D
#define GL_SAMPLE_ALPHA_TO_COVERAGE             0x809E
#define GL_SAMPLE_ALPHA_TO_ONE                  0x809F
#define GL_SAMPLE_COVERAGE                      0x80A0
#define GL_SAMPLE_BUFFERS                       0x80A8
#define GL_SAMPLES                              0x80A9
#define GL_SAMPLE_COVERAGE_VALUE                0x80AA
#define GL_SAMPLE_COVERAGE_INVERT               0x80AB

/*************************************************************/
/*                                                           */
/*       Enumerates for Supported Extensions                 */
/*                                                           */
/*************************************************************/

/* For compatibility with OpenGL v1.0 */
#define GL_LOGIC_OP                             GL_INDEX_LOGIC_OP
#define GL_TEXTURE_COMPONENTS                   GL_TEXTURE_INTERNAL_FORMAT

#ifdef GL_ARB_multitexture
#define GL_TEXTURE0_ARB                         GL_TEXTURE0
#define GL_TEXTURE1_ARB                         GL_TEXTURE1
#define GL_TEXTURE2_ARB                         GL_TEXTURE2
#define GL_TEXTURE3_ARB                         GL_TEXTURE3
#define GL_TEXTURE4_ARB                         GL_TEXTURE4
#define GL_TEXTURE5_ARB                         GL_TEXTURE5
#define GL_TEXTURE6_ARB                         GL_TEXTURE6
#define GL_TEXTURE7_ARB                         GL_TEXTURE7
#define GL_TEXTURE8_ARB                         GL_TEXTURE8
#define GL_TEXTURE9_ARB                         GL_TEXTURE9
#define GL_TEXTURE10_ARB                        GL_TEXTURE10
#define GL_TEXTURE11_ARB                        GL_TEXTURE11
#define GL_TEXTURE12_ARB                        GL_TEXTURE12
#define GL_TEXTURE13_ARB                        GL_TEXTURE13
#define GL_TEXTURE14_ARB                        GL_TEXTURE14
#define GL_TEXTURE15_ARB                        GL_TEXTURE15
#define GL_TEXTURE16_ARB                        GL_TEXTURE16
#define GL_TEXTURE17_ARB                        GL_TEXTURE17
#define GL_TEXTURE18_ARB                        GL_TEXTURE18
#define GL_TEXTURE19_ARB                        GL_TEXTURE19
#define GL_TEXTURE20_ARB                        GL_TEXTURE20
#define GL_TEXTURE21_ARB                        GL_TEXTURE21
#define GL_TEXTURE22_ARB                        GL_TEXTURE22
#define GL_TEXTURE23_ARB                        GL_TEXTURE23
#define GL_TEXTURE24_ARB                        GL_TEXTURE24
#define GL_TEXTURE25_ARB                        GL_TEXTURE25
#define GL_TEXTURE26_ARB                        GL_TEXTURE26
#define GL_TEXTURE27_ARB                        GL_TEXTURE27
#define GL_TEXTURE28_ARB                        GL_TEXTURE28
#define GL_TEXTURE29_ARB                        GL_TEXTURE29
#define GL_TEXTURE30_ARB                        GL_TEXTURE30
#define GL_TEXTURE31_ARB                        GL_TEXTURE31
#define GL_ACTIVE_TEXTURE_ARB                   GL_ACTIVE_TEXTURE
#define GL_CLIENT_ACTIVE_TEXTURE_ARB            GL_CLIENT_ACTIVE_TEXTURE
#define GL_MAX_TEXTURE_UNITS_ARB                GL_MAX_TEXTURE_UNITS
#endif

#ifdef GL_ARB_texture_compression
#define GL_COMPRESSED_ALPHA_ARB                 GL_COMPRESSED_ALPHA
#define GL_COMPRESSED_LUMINANCE_ARB             GL_COMPRESSED_LUMINANCE
#define GL_COMPRESSED_LUMINANCE_ALPHA_ARB       GL_COMPRESSED_LUMINANCE_ALPHA
#define GL_COMPRESSED_INTENSITY_ARB             GL_COMPRESSED_INTENSITY
#define GL_COMPRESSED_RGB_ARB                   GL_COMPRESSED_RGB
#define GL_COMPRESSED_RGBA_ARB                  GL_COMPRESSED_RGBA
#define GL_TEXTURE_COMPRESSION_HINT_ARB         GL_TEXTURE_COMPRESSION_HINT
#define GL_TEXTURE_COMPRESSED_IMAGE_SIZE_ARB    GL_TEXTURE_COMPRESSED_IMAGE_SIZE
#define GL_TEXTURE_COMPRESSED_ARB               GL_TEXTURE_COMPRESSED
#define GL_NUM_COMPRESSED_TEXTURE_FORMATS_ARB   GL_NUM_COMPRESSED_TEXTURE_FORMATS
#define GL_COMPRESSED_TEXTURE_FORMATS_ARB       GL_COMPRESSED_TEXTURE_FORMATS
#endif

#ifdef GL_ARB_texture_cube_map
#define GL_NORMAL_MAP_ARB                       GL_NORMAL_MAP
#define GL_REFLECTION_MAP_ARB                   GL_REFLECTION_MAP
#define GL_TEXTURE_CUBE_MAP_ARB                 GL_TEXTURE_CUBE_MAP
#define GL_TEXTURE_BINDING_CUBE_MAP_ARB         GL_TEXTURE_BINDING_CUBE_MAP
#define GL_TEXTURE_CUBE_MAP_POSITIVE_X_ARB      GL_TEXTURE_CUBE_MAP_POSITIVE_X
#define GL_TEXTURE_CUBE_MAP_NEGATIVE_X_ARB      GL_TEXTURE_CUBE_MAP_NEGATIVE_X
#define GL_TEXTURE_CUBE_MAP_POSITIVE_Y_ARB      GL_TEXTURE_CUBE_MAP_POSITIVE_Y
#define GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_ARB      GL_TEXTURE_CUBE_MAP_NEGATIVE_Y
#define GL_TEXTURE_CUBE_MAP_POSITIVE_Z_ARB      GL_TEXTURE_CUBE_MAP_POSITIVE_Z
#define GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_ARB      GL_TEXTURE_CUBE_MAP_NEGATIVE_Z
#define GL_PROXY_TEXTURE_CUBE_MAP_ARB           GL_PROXY_TEXTURE_CUBE_MAP
#define GL_MAX_CUBE_MAP_TEXTURE_SIZE_ARB        GL_MAX_CUBE_MAP_TEXTURE_SIZE
#endif

#ifdef GL_ARB_texture_env_combine
#define GL_COMBINE_ARB                          GL_COMBINE
#define GL_COMBINE_RGB_ARB                      GL_COMBINE_RGB
#define GL_COMBINE_ALPHA_ARB                    GL_COMBINE_ALPHA
#define GL_SOURCE0_RGB_ARB                      GL_SOURCE0_RGB
#define GL_SOURCE1_RGB_ARB                      GL_SOURCE1_RGB
#define GL_SOURCE2_RGB_ARB                      GL_SOURCE2_RGB
#define GL_SOURCE0_ALPHA_ARB                    GL_SOURCE0_ALPHA
#define GL_SOURCE1_ALPHA_ARB                    GL_SOURCE1_ALPHA
#define GL_SOURCE2_ALPHA_ARB                    GL_SOURCE2_ALPHA 
#define GL_OPERAND0_RGB_ARB                     GL_OPERAND0_RGB
#define GL_OPERAND1_RGB_ARB                     GL_OPERAND1_RGB  
#define GL_OPERAND2_RGB_ARB                     GL_OPERAND2_RGB
#define GL_OPERAND0_ALPHA_ARB                   GL_OPERAND0_ALPHA
#define GL_OPERAND1_ALPHA_ARB                   GL_OPERAND1_ALPHA
#define GL_OPERAND2_ALPHA_ARB                   GL_OPERAND2_ALPHA 
#define GL_RGB_SCALE_ARB                        GL_RGB_SCALE
#define GL_ADD_SIGNED_ARB                       GL_ADD_SIGNED
#define GL_INTERPOLATE_ARB                      GL_INTERPOLATE
#define GL_SUBTRACT_ARB                         GL_SUBTRACT
#define GL_CONSTANT_ARB                         GL_CONSTANT
#define GL_PRIMARY_COLOR_ARB                    GL_PRIMARY_COLOR
#define GL_PREVIOUS_ARB                         GL_PREVIOUS
#endif

#ifdef GL_ARB_texture_env_dot3
#define GL_DOT3_RGB_ARB                         GL_DOT3_RGB
#define GL_DOT3_RGBA_ARB                        GL_DOT3_RGBA
#endif

#ifdef GL_ARB_transpose_matrix
#define GL_TRANSPOSE_MODELVIEW_MATRIX_ARB       GL_TRANSPOSE_MODELVIEW_MATRIX
#define GL_TRANSPOSE_PROJECTION_MATRIX_ARB      GL_TRANSPOSE_PROJECTION_MATRIX
#define GL_TRANSPOSE_TEXTURE_MATRIX_ARB         GL_TRANSPOSE_TEXTURE_MATRIX
#define GL_TRANSPOSE_COLOR_MATRIX_ARB           GL_TRANSPOSE_COLOR_MATRIX
#endif

#ifdef GL_ARB_multisample
#define GL_MULTISAMPLE_BIT_ARB                  GL_MULTISAMPLE_BIT
#define GL_MULTISAMPLE_ARB                      GL_MULTISAMPLE
#define GL_SAMPLE_ALPHA_TO_COVERAGE_ARB         GL_SAMPLE_ALPHA_TO_COVERAGE
#define GL_SAMPLE_ALPHA_TO_ONE_ARB              GL_SAMPLE_ALPHA_TO_ONE
#define GL_SAMPLE_COVERAGE_ARB                  GL_SAMPLE_COVERAGE
#define GL_SAMPLE_BUFFERS_ARB                   GL_SAMPLE_BUFFERS
#define GL_SAMPLES_ARB                          GL_SAMPLES
#define GL_SAMPLE_COVERAGE_VALUE_ARB            GL_SAMPLE_COVERAGE_VALUE
#define GL_SAMPLE_COVERAGE_INVERT_ARB           GL_SAMPLE_COVERAGE_INVERT
#endif

#ifdef GL_ARB_depth_texture
#define GL_DEPTH_COMPONENT16_ARB                GL_DEPTH_COMPONENT16
#define GL_DEPTH_COMPONENT24_ARB                GL_DEPTH_COMPONENT24
#define GL_DEPTH_COMPONENT32_ARB                GL_DEPTH_COMPONENT32
#define GL_TEXTURE_DEPTH_SIZE_ARB               GL_TEXTURE_DEPTH_SIZE
#define GL_DEPTH_TEXTURE_MODE_ARB               GL_DEPTH_TEXTURE_MODE
#endif

#ifdef GL_ARB_shadow
#define GL_TEXTURE_COMPARE_MODE_ARB             GL_TEXTURE_COMPARE_MODE
#define GL_TEXTURE_COMPARE_FUNC_ARB             GL_TEXTURE_COMPARE_FUNC
#define GL_COMPARE_R_TO_TEXTURE_ARB             GL_COMPARE_R_TO_TEXTURE
#endif

#ifdef GL_ARB_shadow_ambient
#define GL_TEXTURE_COMPARE_FAIL_VALUE_ARB       GL_SHADOW_AMBIENT_SGIX
#endif

#ifdef GL_ARB_point_parameters
#define GL_POINT_SIZE_MIN_ARB                   GL_POINT_SIZE_MIN
#define GL_POINT_SIZE_MAX_ARB                   GL_POINT_SIZE_MAX
#define GL_POINT_FADE_THRESHOLD_SIZE_ARB        GL_POINT_FADE_THRESHOLD_SIZE
#define GL_POINT_DISTANCE_ATTENUATION_ARB       GL_POINT_DISTANCE_ATTENUATION
#endif

#ifdef GL_EXT_abgr
#define GL_ABGR_EXT                             0x8000
#endif

#define GL_ABGR                                 GL_ABGR_EXT

#ifdef GL_EXT_texture3D
#define GL_TEXTURE_3D_EXT                       GL_TEXTURE_3D
#define GL_PROXY_TEXTURE_3D_EXT                 GL_PROXY_TEXTURE_3D  
#define GL_TEXTURE_DEPTH_EXT                    GL_TEXTURE_DEPTH
#define GL_TEXTURE_WRAP_R_EXT                   GL_TEXTURE_WRAP_R
#define GL_MAX_3D_TEXTURE_SIZE_EXT              GL_MAX_3D_TEXTURE_SIZE
#define GL_PACK_SKIP_IMAGES_EXT                 GL_PACK_SKIP_IMAGES
#define GL_PACK_IMAGE_HEIGHT_EXT                GL_PACK_IMAGE_HEIGHT
#define GL_UNPACK_SKIP_IMAGES_EXT               GL_UNPACK_SKIP_IMAGES
#define GL_UNPACK_IMAGE_HEIGHT_EXT              GL_UNPACK_IMAGE_HEIGHT
#endif

#ifdef GL_EXT_rescale_normal
#define GL_RESCALE_NORMAL_EXT		        GL_RESCALE_NORMAL
#endif

#ifdef GL_EXT_compiled_vertex_array
#define GL_ARRAY_ELEMENT_LOCK_FIRST_EXT         0x81A8
#define GL_ARRAY_ELEMENT_LOCK_COUNT_EXT         0x81A9
#endif

#ifdef GL_EXT_blend_func_separate
#define GL_BLEND_DST_RGB_EXT                    0x80C8
#define GL_BLEND_SRC_RGB_EXT                    0x80C9
#define GL_BLEND_DST_ALPHA_EXT                  0x80CA
#define GL_BLEND_SRC_ALPHA_EXT                  0x80CB
#endif

#ifdef GL_EXT_blend_color
#define GL_CONSTANT_COLOR_EXT                   GL_CONSTANT_COLOR
#define GL_ONE_MINUS_CONSTANT_COLOR_EXT         GL_ONE_MINUS_CONSTANT_COLOR
#define GL_CONSTANT_ALPHA_EXT                   GL_CONSTANT_ALPHA
#define GL_ONE_MINUS_CONSTANT_ALPHA_EXT         GL_ONE_MINUS_CONSTANT_ALPHA
#define GL_BLEND_COLOR_EXT                      GL_BLEND_COLOR
#endif

#ifdef GL_EXT_blend_minmax
#define GL_FUNC_ADD_EXT                         GL_FUNC_ADD
#define GL_MIN_EXT                              GL_MIN
#define GL_MAX_EXT                              GL_MAX
#define GL_BLEND_EQUATION_EXT                   GL_BLEND_EQUATION
#endif

#ifdef GL_EXT_blend_subtract
#define GL_FUNC_SUBTRACT_EXT                    GL_FUNC_SUBTRACT
#define GL_FUNC_REVERSE_SUBTRACT_EXT            GL_FUNC_REVERSE_SUBTRACT
#endif

#ifdef GL_EXT_histogram
#define GL_HISTOGRAM_EXT                        GL_HISTOGRAM
#define GL_PROXY_HISTOGRAM_EXT                  GL_PROXY_HISTOGRAM
#define GL_HISTOGRAM_WIDTH_EXT                  GL_HISTOGRAM_WIDTH
#define GL_HISTOGRAM_FORMAT_EXT                 GL_HISTOGRAM_FORMAT
#define GL_HISTOGRAM_RED_SIZE_EXT               GL_HISTOGRAM_RED_SIZE
#define GL_HISTOGRAM_GREEN_SIZE_EXT             GL_HISTOGRAM_GREEN_SIZE
#define GL_HISTOGRAM_BLUE_SIZE_EXT              GL_HISTOGRAM_BLUE_SIZE
#define GL_HISTOGRAM_ALPHA_SIZE_EXT             GL_HISTOGRAM_ALPHA_SIZE
#define GL_HISTOGRAM_LUMINANCE_SIZE_EXT         GL_HISTOGRAM_LUMINANCE_SIZE
#define GL_HISTOGRAM_SINK_EXT                   GL_HISTOGRAM_SINK
#define GL_MINMAX_EXT                           GL_MINMAX
#define GL_MINMAX_FORMAT_EXT                    GL_MINMAX_FORMAT
#define GL_MINMAX_SINK_EXT                      GL_MINMAX_SINK
#define GL_TABLE_TOO_LARGE_EXT                  GL_TABLE_TOO_LARGE
#endif

#ifdef GL_EXT_convolution
#define GL_CONVOLUTION_1D_EXT			GL_CONVOLUTION_1D
#define GL_CONVOLUTION_2D_EXT			GL_CONVOLUTION_2D
#define GL_SEPARABLE_2D_EXT                 	GL_SEPARABLE_2D
#define GL_CONVOLUTION_BORDER_MODE_EXT      	GL_CONVOLUTION_BORDER_MODE
#define GL_CONVOLUTION_FILTER_SCALE_EXT     	GL_CONVOLUTION_FILTER_SCALE
#define GL_CONVOLUTION_FILTER_BIAS_EXT      	GL_CONVOLUTION_FILTER_BIAS
#define GL_REDUCE_EXT                       	GL_REDUCE
#define GL_CONVOLUTION_FORMAT_EXT           	GL_CONVOLUTION_FORMAT
#define GL_CONVOLUTION_WIDTH_EXT            	GL_CONVOLUTION_WIDTH
#define GL_CONVOLUTION_HEIGHT_EXT           	GL_CONVOLUTION_HEIGHT
#define GL_MAX_CONVOLUTION_WIDTH_EXT        	GL_MAX_CONVOLUTION_WIDTH
#define GL_MAX_CONVOLUTION_HEIGHT_EXT       	GL_MAX_CONVOLUTION_HEIGHT
#define GL_POST_CONVOLUTION_RED_SCALE_EXT   	GL_POST_CONVOLUTION_RED_SCALE
#define GL_POST_CONVOLUTION_GREEN_SCALE_EXT 	GL_POST_CONVOLUTION_GREEN_SCALE
#define GL_POST_CONVOLUTION_BLUE_SCALE_EXT  	GL_POST_CONVOLUTION_BLUE_SCALE
#define GL_POST_CONVOLUTION_ALPHA_SCALE_EXT 	GL_POST_CONVOLUTION_ALPHA_SCALE
#define GL_POST_CONVOLUTION_RED_BIAS_EXT    	GL_POST_CONVOLUTION_RED_BIAS
#define GL_POST_CONVOLUTION_GREEN_BIAS_EXT  	GL_POST_CONVOLUTION_GREEN_BIAS
#define GL_POST_CONVOLUTION_BLUE_BIAS_EXT   	GL_POST_CONVOLUTION_BLUE_BIAS
#define GL_POST_CONVOLUTION_ALPHA_BIAS_EXT      GL_POST_CONVOLUTION_ALPHA_BIAS
#endif

#ifdef GL_EXT_polygon_offset
#define GL_POLYGON_OFFSET_EXT                   GL_POLYGON_OFFSET_FILL
#define GL_POLYGON_OFFSET_FACTOR_EXT            GL_POLYGON_OFFSET_FACTOR
#define GL_POLYGON_OFFSET_BIAS_EXT              0x8039
#endif

#ifdef GL_EXT_texture_filter_anisotropic
#define GL_TEXTURE_MAX_ANISOTROPY_EXT           0x84FE
#define GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT       0x84FF 
#endif

#ifdef GL_EXT_texture_env_combine
#define GL_COMBINE_EXT                          GL_COMBINE
#define GL_COMBINE_RGB_EXT                      GL_COMBINE_RGB
#define GL_COMBINE_ALPHA_EXT                    GL_COMBINE_ALPHA
#define GL_SOURCE0_RGB_EXT                      GL_SOURCE0_RGB
#define GL_SOURCE1_RGB_EXT                      GL_SOURCE1_RGB
#define GL_SOURCE2_RGB_EXT                      GL_SOURCE2_RGB
#define GL_SOURCE0_ALPHA_EXT                    GL_SOURCE0_ALPHA
#define GL_SOURCE1_ALPHA_EXT                    GL_SOURCE1_ALPHA
#define GL_SOURCE2_ALPHA_EXT                    GL_SOURCE2_ALPHA 
#define GL_OPERAND0_RGB_EXT                     GL_OPERAND0_RGB
#define GL_OPERAND1_RGB_EXT                     GL_OPERAND1_RGB  
#define GL_OPERAND2_RGB_EXT                     GL_OPERAND2_RGB
#define GL_OPERAND0_ALPHA_EXT                   GL_OPERAND0_ALPHA
#define GL_OPERAND1_ALPHA_EXT                   GL_OPERAND1_ALPHA
#define GL_OPERAND2_ALPHA_EXT                   GL_OPERAND2_ALPHA 
#define GL_RGB_SCALE_EXT                        GL_RGB_SCALE
#define GL_ADD_SIGNED_EXT                       GL_ADD_SIGNED
#define GL_INTERPOLATE_EXT                      GL_INTERPOLATE
#define GL_SUBTRACT_EXT                         GL_SUBTRACT
#define GL_CONSTANT_EXT                         GL_CONSTANT
#define GL_PRIMARY_COLOR_EXT                    GL_PRIMARY_COLOR
#define GL_PREVIOUS_EXT                         GL_PREVIOUS
#endif

#ifdef GL_EXT_pixel_transform
#define GL_PIXEL_TRANSFORM_2D_EXT               0x8330
#define GL_PIXEL_MAG_FILTER_EXT                 0x8331
#define GL_PIXEL_MIN_FILTER_EXT                 0x8332
#define	GL_PIXEL_CUBIC_WEIGHT_EXT               0x8333
#define GL_CUBIC_EXT                            0x8334
#define GL_AVERAGE_EXT                          0x8335
#define GL_PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT   0x8336
#define GL_MAX_PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT 0x8337
#define GL_PIXEL_TRANSFORM_2D_MATRIX_EXT        0x8338
#endif

/* Tokens for EXT_pixel_transform_color_table    */
/* Not implemented yet so commented out for now. */
/* #define GL_EXT_pixel_transform_color_table 1  */
#ifdef GL_EXT_pixel_transform_color_table
#define GL_PIXEL_TRANSFORM_COLOR_TABLE_EXT       0x8339
#define GL_PROXY_PIXEL_TRANSFORM_COLOR_TABLE_EXT 0x833A
#endif

#ifdef GL_SGI_color_table
#define GL_COLOR_TABLE_SGI                      GL_COLOR_TABLE
#define GL_PROXY_COLOR_TABLE_SGI                GL_PROXY_COLOR_TABLE
#define GL_COLOR_TABLE_SCALE_SGI                GL_COLOR_TABLE_SCALE
#define GL_COLOR_TABLE_BIAS_SGI                 GL_COLOR_TABLE_BIAS
#define GL_COLOR_TABLE_FORMAT_SGI               GL_COLOR_TABLE_FORMAT
#define GL_COLOR_TABLE_WIDTH_SGI                GL_COLOR_TABLE_WIDTH
#define GL_COLOR_TABLE_RED_SIZE_SGI             GL_COLOR_TABLE_RED_SIZE
#define GL_COLOR_TABLE_GREEN_SIZE_SGI           GL_COLOR_TABLE_GREEN_SIZE
#define GL_COLOR_TABLE_BLUE_SIZE_SGI            GL_COLOR_TABLE_BLUE_SIZE
#define GL_COLOR_TABLE_ALPHA_SIZE_SGI           GL_COLOR_TABLE_ALPHA_SIZE
#define GL_COLOR_TABLE_LUMINANCE_SIZE_SGI       GL_COLOR_TABLE_LUMINANCE_SIZE
#define GL_COLOR_TABLE_INTENSITY_SIZE_SGI       GL_COLOR_TABLE_INTENSITY_SIZE
#define GL_POST_CONVOLUTION_COLOR_TABLE_SGI     GL_POST_CONVOLUTION_COLOR_TABLE
#define GL_PROXY_POST_CONVOLUTION_COLOR_TABLE_SGI GL_PROXY_POST_CONVOLUTION_COLOR_TABLE
#endif

#ifdef GL_SGI_texture_color_table
#define GL_TEXTURE_COLOR_TABLE_SGI              0x80BC
#define GL_PROXY_TEXTURE_COLOR_TABLE_SGI        0x80BD
#endif

#ifdef GL_SGIS_sharpen_texture
#define GL_LINEAR_SHARPEN_SGIS                  0x80AD
#define GL_LINEAR_SHARPEN_ALPHA_SGIS            0x80AE
#define GL_LINEAR_SHARPEN_COLOR_SGIS            0x80AF
#define GL_SHARPEN_TEXTURE_FUNC_POINTS_SGIS     0x80B0
#endif

#ifdef GL_SGIS_detail_texture
#define GL_DETAIL_TEXTURE_2D_SGIS               0x8095
#define GL_DETAIL_TEXTURE_2D_BINDING_SGIS       0x8096
#define GL_LINEAR_DETAIL_SGIS                   0x8097
#define GL_LINEAR_DETAIL_ALPHA_SGIS             0x8098
#define GL_LINEAR_DETAIL_COLOR_SGIS             0x8099
#define GL_DETAIL_TEXTURE_LEVEL_SGIS            0x809A
#define GL_DETAIL_TEXTURE_MODE_SGIS             0x809B
#define GL_DETAIL_TEXTURE_FUNC_POINTS_SGIS      0x809C
#endif

#ifdef GL_SGIS_texture_filter4
#define GL_FILTER4_SGIS                         0x8146
#define GL_TEXTURE_FILTER4_SIZE_SGIS            0x8147
#endif

#ifdef GL_SGIX_texture_scale_bias
#define GL_POST_TEXTURE_FILTER_BIAS_SGIX        0x8179
#define GL_POST_TEXTURE_FILTER_SCALE_SGIX       0x817A
#define GL_POST_TEXTURE_FILTER_BIAS_RANGE_SGIX  0x817B
#define GL_POST_TEXTURE_FILTER_SCALE_RANGE_SGIX 0x817C
#endif


#ifdef GL_SGIX_texture_lod_bias
#define GL_TEXTURE_LOD_BIAS_S_SGIX              0x818E
#define GL_TEXTURE_LOD_BIAS_T_SGIX              0x818F
#define GL_TEXTURE_LOD_BIAS_R_SGIX              0x8190
#endif

#ifdef GL_SGIS_generate_mipmap
#define GL_GENERATE_MIPMAP     			0x8191
#define GL_GENERATE_MIPMAP_SGIS			GL_GENERATE_MIPMAP
#define GL_GENERATE_MIPMAP_HINT     		0x8192
#define GL_GENERATE_MIPMAP_HINT_SGIS		GL_GENERATE_MIPMAP_HINT
#endif

#ifdef GL_SGIX_depth_texture
#define GL_DEPTH_COMPONENT16_SGIX               GL_DEPTH_COMPONENT16
#define GL_DEPTH_COMPONENT24_SGIX               GL_DEPTH_COMPONENT24
#define GL_DEPTH_COMPONENT32_SGIX               GL_DEPTH_COMPONENT32
#endif

#ifdef GL_SGIX_shadow
#define GL_TEXTURE_COMPARE_SGIX                 0x819A
#define GL_TEXTURE_COMPARE_OPERATOR_SGIX        0x819B
#define GL_TEXTURE_LEQUAL_R_SGIX                0x819C
#define GL_TEXTURE_GEQUAL_R_SGIX                0x819D
#endif

#ifdef GL_NV_texture_rectangle
#define GL_TEXTURE_RECTANGLE_NV                 0x84F5                 
#define GL_TEXTURE_BINDING_RECTANGLE_NV         0x84F6
#define GL_PROXY_TEXTURE_RECTANGLE_NV           0x84F7                
#define GL_MAX_RECTANGLE_TEXTURE_SIZE_NV        0x84F8              
#endif

#ifdef GL_SGIX_shadow_ambient
#define GL_SHADOW_AMBIENT_SGIX                  0x80BF
#endif

#ifdef GL_HP_occlusion_test
#define GL_OCCLUSION_TEST_HP                    0x8165
#define GL_OCCLUSION_TEST_RESULT_HP             0x8166
/* The next enum define is needed for compatibility due to typo in earlier release */
#define GL_OCCLUSION_RESULT_HP                  GL_OCCLUSION_TEST_RESULT_HP
#endif

#ifdef GL_HP_convolution_border_modes
#define GL_IGNORE_BORDER_HP			GL_IGNORE_BORDER
#define GL_CONSTANT_BORDER_HP			GL_CONSTANT_BORDER
#define GL_REPLICATE_BORDER_HP			GL_REPLICATE_BORDER
#define GL_CONVOLUTION_BORDER_COLOR_HP  	GL_CONVOLUTION_BORDER_COLOR
#endif


#ifdef GL_SUN_convolution_border_modes
#define GL_WRAP_BORDER_SUN			0x81D4
#endif

#ifdef GL_SUNX_geometry_compression
#define GL_COMPRESSED_GEOM_ACCELERATED_SUNX     0x81D0
#define GL_COMPRESSED_GEOM_VERSION_SUNX	        0x81D1
#endif

#ifdef GL_SUNX_surface_hint
#define GL_SURFACE_SIZE_HINT_SUNX	        0x81D2
#define GL_LARGE_SUNX			        0x81D3
#endif

#ifdef GL_SUNX_constant_data
#define GL_UNPACK_CONSTANT_DATA_SUNX            0x81D5
#define GL_TEXTURE_CONSTANT_DATA_SUNX           0x81D6
#endif

#ifdef GL_SUN_global_alpha
#define GL_GLOBAL_ALPHA_SUN                     0x81D9
#define GL_GLOBAL_ALPHA_FACTOR_SUN              0x81DA
#endif

#ifdef GL_SUN_read_video_pixels
#define GL_RGB_DEGAMMA_SUN                      0x81DB
#define GL_BGR_DEGAMMA_SUN                      0x81DC
#define GL_BGRA_DEGAMMA_SUN                     0x81DD
#define GL_ABGR_DEGAMMA_SUN                     0x833B
#define GL_RGBA_DEGAMMA_SUN                     0x833C
#define GL_RED_DEGAMMA_SUN                      0x833D
#define GL_GREEN_DEGAMMA_SUN                    0x833E
#define GL_BLUE_DEGAMMA_SUN                     0x833F
#endif

#ifdef GL_SUN_triangle_list
#define GL_RESTART_SUN                          0x01
#define GL_REPLACE_MIDDLE_SUN                   0x02
#define GL_REPLACE_OLDEST_SUN                   0x03
#define GL_TRIANGLE_LIST_SUN                    0x81D7
#define GL_REPLACEMENT_CODE_SUN                 0x81D8
#define GL_REPLACEMENT_CODE_ARRAY_SUN           0x85C0
#define GL_REPLACEMENT_CODE_ARRAY_TYPE_SUN      0x85C1
#define GL_REPLACEMENT_CODE_ARRAY_STRIDE_SUN    0x85C2
#define GL_REPLACEMENT_CODE_ARRAY_POINTER_SUN   0x85C3
#define GL_R1UI_V3F_SUN                         0x85C4
#define GL_R1UI_C4UB_V3F_SUN                    0x85C5
#define GL_R1UI_C3F_V3F_SUN                     0x85C6
#define GL_R1UI_N3F_V3F_SUN                     0x85C7
#define GL_R1UI_C4F_N3F_V3F_SUN                 0x85C8
#define GL_R1UI_T2F_V3F_SUN                     0x85C9
#define GL_R1UI_T2F_N3F_V3F_SUN                 0x85CA
#define GL_R1UI_T2F_C4F_N3F_V3F_SUN             0x85CB
#endif

#ifdef GL_SUN_slice_accum
#define GL_SLICE_ACCUM_SUN                      0x85CC
#endif

#ifdef GL_SUN_video_resize_compensation
#define GL_VIDEO_RESIZE_COMPENSATION_SUN        0x85CD
#endif

#ifdef GL_SUN_phong_shading
#define GL_PHONG_SUN                   	        0x85CE
#define GL_PHONG_HINT_SUN             	        0x85CF
#endif

#ifdef GL_SUN_blend_src_mult_dst_alpha
#define GL_SRC_ALPHA_MULT_DST_ALPHA_SUN             0x8610
#define GL_SRC_ALPHA_MULT_ONE_MINUS_DST_ALPHA_SUN   0x8611
#endif

#ifdef GL_SUN_mesh_array
#define GL_QUAD_MESH_SUN                        0x8614
#define GL_TRIANGLE_MESH_SUN                    0x8615
#endif

#define GL_SPHERE_SUN                           0x8616
#define GL_VOXEL_SUN                            0x8617

#ifdef GL_SUN_targeted_texture
#define GL_TEXTURE_TARGET_NUM_PIPES_SUN         0x8618
#define GL_TEXTURE_TARGET_PIPE_MASK_SUN         0x8619
#define GL_TEXTURE_TARGET_AUTO_SUN              0x861A
#define GL_TEXTURE_TARGET_SUN                   0x861B
#define GL_TEXTURE_TARGET_MAX_PIPES_SUN         0x861C
#define GL_TEXTURE_TARGET_MODE_SUN              0x861D
#endif


#ifdef GL_EXT_gradient_clear
#define GL_GRADIENT_CLEAR_MODE_EXT               0x85D0 
#define GL_GRADIENT_CLEAR_SOLID_EXT              0x85D1
#define GL_GRADIENT_CLEAR_LINEAR_Y_EXT           0x85D2
#define GL_GRADIENT_CLEAR_X_EXT                  0x85D3
#define GL_GRADIENT_CLEAR_Y_EXT                  0x85D4
#define GL_GRADIENT_CLEAR_WIDTH_EXT              0x85D5
#define GL_GRADIENT_CLEAR_HEIGHT_EXT             0x85D6
#define GL_GRADIENT_CLEAR_COLOR_TOP_EXT          0x85D7
#define GL_GRADIENT_CLEAR_COLOR_BOTTOM_EXT       0x85D8
#endif

#ifdef GL_EXT_texture_lod_bias
#define GL_TEXTURE_FILTER_CONTROL_EXT            0x8500
#define GL_TEXTURE_LOD_BIAS_EXT                  0x8501
#define GL_MAX_TEXTURE_LOD_BIAS_EXT              0x84FD
#endif


#ifdef GL_EXT_stencil_wrap
#define GL_INCR_WRAP_EXT                         GL_INCR_WRAP
#define GL_DECR_WRAP_EXT                         GL_DECR_WRAP
#endif

#ifdef GL_SUN_get_texture_memory_size
#define GL_TEXTURE_CAPACITY_SIZE_SUN                0x861E
#define GL_TEXTURE_MEMORY_SIZE_SUN                  0x861F
#endif


/*************************************************************/
/*                                                           */
/*     OpenGL 1.3 Core API Functions                         */
/*                                                           */
/*************************************************************/

extern void glAccum (GLenum op, GLfloat value);
extern void glActiveTexture (GLenum texture);
extern void glAlphaFunc (GLenum func, GLclampf ref);
extern void glArrayElement (GLint i);
extern void glBegin (GLenum mode);
extern void glBitmap (GLsizei width, GLsizei height, GLfloat xorig, GLfloat yorig, GLfloat xmove, GLfloat ymove, const GLubyte *bitmap);
extern void glBlendColor (GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha);
extern void glBlendEquation (GLenum mode);
extern void glBlendFunc (GLenum sfactor, GLenum dfactor);
extern void glCallList (GLuint list);
extern void glCallLists (GLsizei n, GLenum type, const GLvoid *lists);
extern void glClear (GLbitfield mask);
extern void glClearAccum (GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha);
extern void glClearColor (GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha);
extern void glClearDepth (GLclampd depth);
extern void glClearIndex (GLfloat c);
extern void glClearStencil (GLint s);
extern void glClientActiveTexture (GLenum texture);
extern void glClipPlane (GLenum plane, const GLdouble *equation);
extern void glColor3b (GLbyte red, GLbyte green, GLbyte blue);
extern void glColor3bv (const GLbyte *v);
extern void glColor3d (GLdouble red, GLdouble green, GLdouble blue);
extern void glColor3dv (const GLdouble *v);
extern void glColor3f (GLfloat red, GLfloat green, GLfloat blue);
extern void glColor3fv (const GLfloat *v);
extern void glColor3i (GLint red, GLint green, GLint blue);
extern void glColor3iv (const GLint *v);
extern void glColor3s (GLshort red, GLshort green, GLshort blue);
extern void glColor3sv (const GLshort *v);
extern void glColor3ub (GLubyte red, GLubyte green, GLubyte blue);
extern void glColor3ubv (const GLubyte *v);
extern void glColor3ui (GLuint red, GLuint green, GLuint blue);
extern void glColor3uiv (const GLuint *v);
extern void glColor3us (GLushort red, GLushort green, GLushort blue);
extern void glColor3usv (const GLushort *v);

/* EXT_secondary_color extension, becomes part 1.4 core */
extern void glSecondaryColor3d (GLdouble red, GLdouble green, GLdouble blue);
extern void glSecondaryColor3dv (const GLdouble *v);
extern void glSecondaryColor3f (GLfloat red, GLfloat green, GLfloat blue);
extern void glSecondaryColor3fv (const GLfloat *v);
extern void glSecondaryColor3i (GLint red, GLint green, GLint blue);
extern void glSecondaryColor3iv (const GLint *v);
extern void glSecondaryColor3s (GLshort red, GLshort green, GLshort blue);
extern void glSecondaryColor3sv (const GLshort *v);
extern void glSecondaryColor3dEXT (GLdouble red, GLdouble green, GLdouble blue);
extern void glSecondaryColor3dvEXT (const GLdouble *v);
extern void glSecondaryColor3fEXT (GLfloat red, GLfloat green, GLfloat blue);
extern void glSecondaryColor3fvEXT (const GLfloat *v);
extern void glSecondaryColor3iEXT (GLint red, GLint green, GLint blue);
extern void glSecondaryColor3ivEXT (const GLint *v);
extern void glSecondaryColor3sEXT (GLshort red, GLshort green, GLshort blue);
extern void glSecondaryColor3svEXT (const GLshort *v);

extern void glColor4b (GLbyte red, GLbyte green, GLbyte blue, GLbyte alpha);
extern void glColor4bv (const GLbyte *v);
extern void glColor4d (GLdouble red, GLdouble green, GLdouble blue, GLdouble alpha);
extern void glColor4dv (const GLdouble *v);
extern void glColor4f (GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha);
extern void glColor4fv (const GLfloat *v);
extern void glColor4i (GLint red, GLint green, GLint blue, GLint alpha);
extern void glColor4iv (const GLint *v);
extern void glColor4s (GLshort red, GLshort green, GLshort blue, GLshort alpha);
extern void glColor4sv (const GLshort *v);
extern void glColor4ub (GLubyte red, GLubyte green, GLubyte blue, GLubyte alpha);
extern void glColor4ubv (const GLubyte *v);
extern void glColor4ui (GLuint red, GLuint green, GLuint blue, GLuint alpha);
extern void glColor4uiv (const GLuint *v);
extern void glColor4us (GLushort red, GLushort green, GLushort blue, GLushort alpha);
extern void glColor4usv (const GLushort *v);
extern void glColorMask (GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha);
extern void glColorMaterial (GLenum face, GLenum mode);
extern void glColorPointer (GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
extern void glSecondaryColorPointer (GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
extern void glSecondaryColorPointerEXT (GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
extern void glColorSubTable (GLenum target, GLsizei start, GLsizei count, GLenum format, GLenum type, const GLvoid *data);
extern void glColorTable (GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const GLvoid *table);
extern void glColorTableParameterfv (GLenum target, GLenum pname, const GLfloat *params);
extern void glColorTableParameteriv (GLenum target, GLenum pname, const GLint *params);
extern void glCompressedTexImage1D (GLenum target, int GLlevel, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const void *data);
extern void glCompressedTexImage2D (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const void *data);
extern void glCompressedTexImage3D (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const void *data);
extern void glCompressedTexSubImage1D (GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const void *data);
extern void glCompressedTexSubImage2D (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const void *data);
extern void glCompressedTexSubImage3D (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const void *data);
extern void glConvolutionFilter1D (GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const GLvoid *image);
extern void glConvolutionFilter2D (GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *image);
extern void glConvolutionParameterf (GLenum target, GLenum pname, GLfloat params);
extern void glConvolutionParameterfv (GLenum target, GLenum pname, const GLfloat *params);
extern void glConvolutionParameteri (GLenum target, GLenum pname, GLint params);
extern void glConvolutionParameteriv (GLenum target, GLenum pname, const GLint *params);
extern void glCopyColorSubTable (GLenum target, GLsizei start, GLint x, GLint y, GLsizei width);
extern void glCopyColorTable (GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width);
extern void glCopyConvolutionFilter1D (GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width);
extern void glCopyConvolutionFilter2D (GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height);
extern void glCopyPixels (GLint x, GLint y, GLsizei width, GLsizei height, GLenum type);
extern void glCopyTexImage1D (GLenum target, GLint level, GLenum internalFormat, GLint x, GLint y, GLsizei width, GLint border);
extern void glCopyTexImage2D (GLenum target, GLint level, GLenum internalFormat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border);
extern void glCopyTexSubImage1D (GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width);
extern void glCopyTexSubImage2D (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height);
extern void glCopyTexSubImage3D (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height);
extern void glCullFace (GLenum mode);
extern void glDeleteLists (GLuint list, GLsizei range);
extern void glDepthFunc (GLenum func);
extern void glDepthMask (GLboolean flag);
extern void glDepthRange (GLclampd zNear, GLclampd zFar);
extern void glDisable (GLenum cap);
extern void glDisableClientState (GLenum cap);
extern void glDrawArrays (GLenum mode, GLint first, GLsizei count);
extern void glDrawBuffer (GLenum mode);
extern void glDrawElements (GLenum mode, GLsizei count, GLenum type, const GLvoid *indices);
extern void glDrawRangeElements (GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const GLvoid *indices);
extern void glDrawPixels (GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels);
extern void glEdgeFlag (GLboolean flag);
extern void glEdgeFlagPointer (GLsizei stride, const GLvoid *pointer);
extern void glEdgeFlagv (const GLboolean *flag);
extern void glEnable (GLenum cap);
extern void glEnableClientState (GLenum cap);
extern void glEnd (void);
extern void glEndList (void);
extern void glEvalCoord1d (GLdouble u);
extern void glEvalCoord1dv (const GLdouble *u);
extern void glEvalCoord1f (GLfloat u);
extern void glEvalCoord1fv (const GLfloat *u);
extern void glEvalCoord2d (GLdouble u, GLdouble v);
extern void glEvalCoord2dv (const GLdouble *u);
extern void glEvalCoord2f (GLfloat u, GLfloat v);
extern void glEvalCoord2fv (const GLfloat *u);
extern void glEvalMesh1 (GLenum mode, GLint i1, GLint i2);
extern void glEvalMesh2 (GLenum mode, GLint i1, GLint i2, GLint j1, GLint j2);
extern void glEvalPoint1 (GLint i);
extern void glEvalPoint2 (GLint i, GLint j);
extern void glFeedbackBuffer (GLsizei size, GLenum type, GLfloat *buffer);
extern void glFinish (void);
extern void glFlush (void);
extern void glFogf (GLenum pname, GLfloat param);
extern void glFogfv (GLenum pname, const GLfloat *params);
extern void glFogi (GLenum pname, GLint param);
extern void glFogiv (GLenum pname, const GLint *params);
extern void glFrontFace (GLenum mode);
extern void glFrustum (GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar);
extern GLuint glGenLists (GLsizei range);
extern void glGetBooleanv (GLenum pname, GLboolean *params);
extern void glGetClipPlane (GLenum plane, GLdouble *equation);
extern void glGetColorTable (GLenum target, GLenum format, GLenum type, GLvoid *table);
extern void glGetColorTableParameterfv (GLenum target, GLenum pname, GLfloat *params);
extern void glGetColorTableParameteriv (GLenum target, GLenum pname, GLint *params);
extern void glGetConvolutionFilter (GLenum target, GLenum format, GLenum type, GLvoid *image);
extern void glGetConvolutionParameterfv (GLenum target, GLenum pname, GLfloat *params);
extern void glGetConvolutionParameteriv (GLenum target, GLenum pname, GLint *params);
extern void glGetDoublev (GLenum pname, GLdouble *params);
extern GLenum glGetError (void);
extern void glGetFloatv (GLenum pname, GLfloat *params);
extern void glGetHistogram (GLenum target, GLboolean reset, GLenum format, GLenum type, GLvoid *values);
extern void glGetHistogramParameterfv (GLenum target, GLenum pname, GLfloat *params);
extern void glGetHistogramParameteriv (GLenum target, GLenum pname, GLint *params);
extern void glGetIntegerv (GLenum pname, GLint *params);
extern void glGetLightfv (GLenum light, GLenum pname, GLfloat *params);
extern void glGetLightiv (GLenum light, GLenum pname, GLint *params);
extern void glGetMapdv (GLenum target, GLenum query, GLdouble *v);
extern void glGetMapfv (GLenum target, GLenum query, GLfloat *v);
extern void glGetMapiv (GLenum target, GLenum query, GLint *v);
extern void glGetMaterialfv (GLenum face, GLenum pname, GLfloat *params);
extern void glGetMaterialiv (GLenum face, GLenum pname, GLint *params);
extern void glGetMinmax (GLenum target, GLboolean reset, GLenum format, GLenum type, GLvoid *values);
extern void glGetMinmaxParameterfv (GLenum target, GLenum pname, GLfloat *params);
extern void glGetMinmaxParameteriv (GLenum target, GLenum pname, GLint *params);
extern void glGetPixelMapfv (GLenum map, GLfloat *values);
extern void glGetPixelMapuiv (GLenum map, GLuint *values);
extern void glGetPixelMapusv (GLenum map, GLushort *values);
extern void glGetPointerv (GLenum pname, GLvoid* *params);
extern void glGetPolygonStipple (GLubyte *mask);
extern void glGetSeparableFilter (GLenum target, GLenum format, GLenum type, GLvoid *row, GLvoid *column, GLvoid *span);
extern const GLubyte * glGetString (GLenum name);
extern void glGetTexEnvfv (GLenum target, GLenum pname, GLfloat *params);
extern void glGetTexEnviv (GLenum target, GLenum pname, GLint *params);
extern void glGetTexGendv (GLenum coord, GLenum pname, GLdouble *params);
extern void glGetTexGenfv (GLenum coord, GLenum pname, GLfloat *params);
extern void glGetTexGeniv (GLenum coord, GLenum pname, GLint *params);
extern void glGetTexImage (GLenum target, GLint level, GLenum format, GLenum type, GLvoid *pixels);
extern void glGetCompressedTexImage (GLenum target, GLint lod, GLvoid *img);
extern void glGetTexLevelParameterfv (GLenum target, GLint level, GLenum pname, GLfloat *params);
extern void glGetTexLevelParameteriv (GLenum target, GLint level, GLenum pname, GLint *params);
extern void glGetTexParameterfv (GLenum target, GLenum pname, GLfloat *params);
extern void glGetTexParameteriv (GLenum target, GLenum pname, GLint *params);
extern void glHint (GLenum target, GLenum mode);
extern void glHistogram (GLenum target, GLsizei width, GLenum internalformat, GLboolean sink);
extern void glIndexMask (GLuint mask);
extern void glIndexPointer (GLenum type, GLsizei stride, const GLvoid *pointer);
extern void glIndexd (GLdouble c);
extern void glIndexdv (const GLdouble *c);
extern void glIndexf (GLfloat c);
extern void glIndexfv (const GLfloat *c);
extern void glIndexi (GLint c);
extern void glIndexiv (const GLint *c);
extern void glIndexs (GLshort c);
extern void glIndexsv (const GLshort *c);
extern void glIndexub (GLubyte c);
extern void glIndexubv (const GLubyte *c);
extern void glInitNames (void);
extern void glInterleavedArrays (GLenum format, GLsizei stride, const GLvoid *pointer);
extern GLboolean glIsEnabled (GLenum cap);
extern GLboolean glIsList (GLuint list);
extern GLboolean glIsTexture (GLuint texture);
extern void glLightModelf (GLenum pname, GLfloat param);
extern void glLightModelfv (GLenum pname, const GLfloat *params);
extern void glLightModeli (GLenum pname, GLint param);
extern void glLightModeliv (GLenum pname, const GLint *params);
extern void glLightf (GLenum light, GLenum pname, GLfloat param);
extern void glLightfv (GLenum light, GLenum pname, const GLfloat *params);
extern void glLighti (GLenum light, GLenum pname, GLint param);
extern void glLightiv (GLenum light, GLenum pname, const GLint *params);
extern void glLineStipple (GLint factor, GLushort pattern);
extern void glLineWidth (GLfloat width);
extern void glListBase (GLuint base);
extern void glLoadIdentity (void);
extern void glLoadMatrixd (const GLdouble *m);
extern void glLoadMatrixf (const GLfloat *m);
extern void glLoadTransposeMatrixd (const GLdouble *m);
extern void glLoadTransposeMatrixf (const GLfloat *m);
extern void glLoadName (GLuint name);
extern void glLogicOp (GLenum opcode);
extern void glMap1d (GLenum target, GLdouble u1, GLdouble u2, GLint stride, GLint order, const GLdouble *points);
extern void glMap1f (GLenum target, GLfloat u1, GLfloat u2, GLint stride, GLint order, const GLfloat *points);
extern void glMap2d (GLenum target, GLdouble u1, GLdouble u2, GLint ustride, GLint uorder, GLdouble v1, GLdouble v2, GLint vstride, GLint vorder, const GLdouble *points);
extern void glMap2f (GLenum target, GLfloat u1, GLfloat u2, GLint ustride, GLint uorder, GLfloat v1, GLfloat v2, GLint vstride, GLint vorder, const GLfloat *points);
extern void glMapGrid1d (GLint un, GLdouble u1, GLdouble u2);
extern void glMapGrid1f (GLint un, GLfloat u1, GLfloat u2);
extern void glMapGrid2d (GLint un, GLdouble u1, GLdouble u2, GLint vn, GLdouble v1, GLdouble v2);
extern void glMapGrid2f (GLint un, GLfloat u1, GLfloat u2, GLint vn, GLfloat v1, GLfloat v2);
extern void glMaterialf (GLenum face, GLenum pname, GLfloat param);
extern void glMaterialfv (GLenum face, GLenum pname, const GLfloat *params);
extern void glMateriali (GLenum face, GLenum pname, GLint param);
extern void glMaterialiv (GLenum face, GLenum pname, const GLint *params);
extern void glMatrixMode (GLenum mode);
extern void glMinmax (GLenum target, GLenum internalformat, GLboolean sink);
extern void glMultiTexCoord1d (GLenum texture, GLdouble s);
extern void glMultiTexCoord1dv (GLenum texture, const GLdouble *v);
extern void glMultiTexCoord1f (GLenum texture, GLfloat s);
extern void glMultiTexCoord1fv (GLenum texture, const GLfloat *v);
extern void glMultiTexCoord1i (GLenum texture, GLint s);
extern void glMultiTexCoord1iv (GLenum texture, const GLint *v);
extern void glMultiTexCoord1s (GLenum texture, GLshort s);
extern void glMultiTexCoord1sv (GLenum texture, const GLshort *v);
extern void glMultiTexCoord2d (GLenum texture, GLdouble s, GLdouble t);
extern void glMultiTexCoord2dv (GLenum texture, const GLdouble *v);
extern void glMultiTexCoord2f (GLenum texture, GLfloat s, GLfloat t);
extern void glMultiTexCoord2fv (GLenum texture, const GLfloat *v);
extern void glMultiTexCoord2i (GLenum texture, GLint s, GLint t);
extern void glMultiTexCoord2iv (GLenum texture, const GLint *v);
extern void glMultiTexCoord2s (GLenum texture, GLshort s, GLshort t);
extern void glMultiTexCoord2sv (GLenum texture, const GLshort *v);
extern void glMultiTexCoord3d (GLenum texture, GLdouble s, GLdouble t, GLdouble r);
extern void glMultiTexCoord3dv (GLenum texture, const GLdouble *v);
extern void glMultiTexCoord3f (GLenum texture, GLfloat s, GLfloat t, GLfloat r);
extern void glMultiTexCoord3fv (GLenum texture, const GLfloat *v);
extern void glMultiTexCoord3i (GLenum texture, GLint s, GLint t, GLint r);
extern void glMultiTexCoord3iv (GLenum texture, const GLint *v);
extern void glMultiTexCoord3s (GLenum texture, GLshort s, GLshort t, GLshort r);
extern void glMultiTexCoord3sv (GLenum texture, const GLshort *v);
extern void glMultiTexCoord4d (GLenum texture, GLdouble s, GLdouble t, GLdouble r, GLdouble q);
extern void glMultiTexCoord4dv (GLenum texture, const GLdouble *v);
extern void glMultiTexCoord4f (GLenum texture, GLfloat s, GLfloat t, GLfloat r, GLfloat q);
extern void glMultiTexCoord4fv (GLenum texture, const GLfloat *v);
extern void glMultiTexCoord4i (GLenum texture, GLint s, GLint t, GLint r, GLint q);
extern void glMultiTexCoord4iv (GLenum texture, const GLint *v);
extern void glMultiTexCoord4s (GLenum texture, GLshort s, GLshort t, GLshort r, GLshort q);
extern void glMultiTexCoord4sv (GLenum texture, const GLshort *v);
extern void glMultMatrixd (const GLdouble *m);
extern void glMultMatrixf (const GLfloat *m);
extern void glMultTransposeMatrixd (const GLdouble *m);
extern void glMultTransposeMatrixf (const GLfloat *m);
extern void glNewList (GLuint list, GLenum mode);
extern void glNormal3b (GLbyte nx, GLbyte ny, GLbyte nz);
extern void glNormal3bv (const GLbyte *v);
extern void glNormal3d (GLdouble nx, GLdouble ny, GLdouble nz);
extern void glNormal3dv (const GLdouble *v);
extern void glNormal3f (GLfloat nx, GLfloat ny, GLfloat nz);
extern void glNormal3fv (const GLfloat *v);
extern void glNormal3i (GLint nx, GLint ny, GLint nz);
extern void glNormal3iv (const GLint *v);
extern void glNormal3s (GLshort nx, GLshort ny, GLshort nz);
extern void glNormal3sv (const GLshort *v);
extern void glNormalPointer (GLenum type, GLsizei stride, const GLvoid *pointer);
extern void glOrtho (GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar);
extern void glPassThrough (GLfloat token);
extern void glPixelMapfv (GLenum map, GLsizei mapsize, const GLfloat *values);
extern void glPixelMapuiv (GLenum map, GLsizei mapsize, const GLuint *values);
extern void glPixelMapusv (GLenum map, GLsizei mapsize, const GLushort *values);
extern void glPixelStoref (GLenum pname, GLfloat param);
extern void glPixelStorei (GLenum pname, GLint param);
extern void glPixelTransferf (GLenum pname, GLfloat param);
extern void glPixelTransferi (GLenum pname, GLint param);
extern void glPixelZoom (GLfloat xfactor, GLfloat yfactor);
extern void glPointSize (GLfloat size);
extern void glPolygonMode (GLenum face, GLenum mode);
extern void glPolygonOffset (GLfloat factor, GLfloat units);
extern void glPolygonStipple (const GLubyte *mask);
extern void glPopAttrib (void);
extern void glPopClientAttrib (void);
extern void glPopMatrix (void);
extern void glPopName (void);
extern void glBindTexture (GLenum target, GLuint texture);
extern void glDeleteTextures (GLsizei n, const GLuint *textures);
extern void glPrioritizeTextures (GLsizei n, const GLuint *textures, const GLclampf *priorities);
extern void glGenTextures (GLsizei n, GLuint *textures);
extern GLboolean glAreTexturesResident (GLsizei n, const GLuint *textures, GLboolean *residences);
extern void glPushAttrib (GLbitfield mask);
extern void glPushClientAttrib (GLbitfield mask);
extern void glPushMatrix (void);
extern void glPushName (GLuint name);
extern void glRasterPos2d (GLdouble x, GLdouble y);
extern void glRasterPos2dv (const GLdouble *v);
extern void glRasterPos2f (GLfloat x, GLfloat y);
extern void glRasterPos2fv (const GLfloat *v);
extern void glRasterPos2i (GLint x, GLint y);
extern void glRasterPos2iv (const GLint *v);
extern void glRasterPos2s (GLshort x, GLshort y);
extern void glRasterPos2sv (const GLshort *v);
extern void glRasterPos3d (GLdouble x, GLdouble y, GLdouble z);
extern void glRasterPos3dv (const GLdouble *v);
extern void glRasterPos3f (GLfloat x, GLfloat y, GLfloat z);
extern void glRasterPos3fv (const GLfloat *v);
extern void glRasterPos3i (GLint x, GLint y, GLint z);
extern void glRasterPos3iv (const GLint *v);
extern void glRasterPos3s (GLshort x, GLshort y, GLshort z);
extern void glRasterPos3sv (const GLshort *v);
extern void glRasterPos4d (GLdouble x, GLdouble y, GLdouble z, GLdouble w);
extern void glRasterPos4dv (const GLdouble *v);
extern void glRasterPos4f (GLfloat x, GLfloat y, GLfloat z, GLfloat w);
extern void glRasterPos4fv (const GLfloat *v);
extern void glRasterPos4i (GLint x, GLint y, GLint z, GLint w);
extern void glRasterPos4iv (const GLint *v);
extern void glRasterPos4s (GLshort x, GLshort y, GLshort z, GLshort w);
extern void glRasterPos4sv (const GLshort *v);
extern void glReadBuffer (GLenum mode);
extern void glReadPixels (GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid *pixels);
extern void glRectd (GLdouble x1, GLdouble y1, GLdouble x2, GLdouble y2);
extern void glRectdv (const GLdouble *v1, const GLdouble *v2);
extern void glRectf (GLfloat x1, GLfloat y1, GLfloat x2, GLfloat y2);
extern void glRectfv (const GLfloat *v1, const GLfloat *v2);
extern void glRecti (GLint x1, GLint y1, GLint x2, GLint y2);
extern void glRectiv (const GLint *v1, const GLint *v2);
extern void glRects (GLshort x1, GLshort y1, GLshort x2, GLshort y2);
extern void glRectsv (const GLshort *v1, const GLshort *v2);
extern GLint glRenderMode (GLenum mode);
extern void glResetHistogram (GLenum target);
extern void glResetMinmax (GLenum target);
extern void glRotated (GLdouble angle, GLdouble x, GLdouble y, GLdouble z);
extern void glRotatef (GLfloat angle, GLfloat x, GLfloat y, GLfloat z);
extern void glSampleCoverage (GLclampf value, GLboolean invert);
extern void glScaled (GLdouble x, GLdouble y, GLdouble z);
extern void glScalef (GLfloat x, GLfloat y, GLfloat z);
extern void glScissor (GLint x, GLint y, GLsizei width, GLsizei height);
extern void glSelectBuffer (GLsizei size, GLuint *buffer);
extern void glSeparableFilter2D (GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *row, const GLvoid *column);
extern void glShadeModel (GLenum mode);
extern void glStencilFunc (GLenum func, GLint ref, GLuint mask);
extern void glStencilMask (GLuint mask);
extern void glStencilOp (GLenum fail, GLenum zfail, GLenum zpass);
extern void glTexCoord1d (GLdouble s);
extern void glTexCoord1dv (const GLdouble *v);
extern void glTexCoord1f (GLfloat s);
extern void glTexCoord1fv (const GLfloat *v);
extern void glTexCoord1i (GLint s);
extern void glTexCoord1iv (const GLint *v);
extern void glTexCoord1s (GLshort s);
extern void glTexCoord1sv (const GLshort *v);
extern void glTexCoord2d (GLdouble s, GLdouble t);
extern void glTexCoord2dv (const GLdouble *v);
extern void glTexCoord2f (GLfloat s, GLfloat t);
extern void glTexCoord2fv (const GLfloat *v);
extern void glTexCoord2i (GLint s, GLint t);
extern void glTexCoord2iv (const GLint *v);
extern void glTexCoord2s (GLshort s, GLshort t);
extern void glTexCoord2sv (const GLshort *v);
extern void glTexCoord3d (GLdouble s, GLdouble t, GLdouble r);
extern void glTexCoord3dv (const GLdouble *v);
extern void glTexCoord3f (GLfloat s, GLfloat t, GLfloat r);
extern void glTexCoord3fv (const GLfloat *v);
extern void glTexCoord3i (GLint s, GLint t, GLint r);
extern void glTexCoord3iv (const GLint *v);
extern void glTexCoord3s (GLshort s, GLshort t, GLshort r);
extern void glTexCoord3sv (const GLshort *v);
extern void glTexCoord4d (GLdouble s, GLdouble t, GLdouble r, GLdouble q);
extern void glTexCoord4dv (const GLdouble *v);
extern void glTexCoord4f (GLfloat s, GLfloat t, GLfloat r, GLfloat q);
extern void glTexCoord4fv (const GLfloat *v);
extern void glTexCoord4i (GLint s, GLint t, GLint r, GLint q);
extern void glTexCoord4iv (const GLint *v);
extern void glTexCoord4s (GLshort s, GLshort t, GLshort r, GLshort q);
extern void glTexCoord4sv (const GLshort *v);
extern void glTexCoordPointer (GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
extern void glTexEnvf (GLenum target, GLenum pname, GLfloat param);
extern void glTexEnvfv (GLenum target, GLenum pname, const GLfloat *params);
extern void glTexEnvi (GLenum target, GLenum pname, GLint param);
extern void glTexEnviv (GLenum target, GLenum pname, const GLint *params);
extern void glTexGend (GLenum coord, GLenum pname, GLdouble param);
extern void glTexGendv (GLenum coord, GLenum pname, const GLdouble *params);
extern void glTexGenf (GLenum coord, GLenum pname, GLfloat param);
extern void glTexGenfv (GLenum coord, GLenum pname, const GLfloat *params);
extern void glTexGeni (GLenum coord, GLenum pname, GLint param);
extern void glTexGeniv (GLenum coord, GLenum pname, const GLint *params);
extern void glTexImage1D (GLenum target, GLint level, GLint internalformat, GLsizei width, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
extern void glTexImage2D (GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
extern void glTexImage3D (GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
extern void glTexParameterf (GLenum target, GLenum pname, GLfloat param);
extern void glTexParameterfv (GLenum target, GLenum pname, const GLfloat *params);
extern void glTexParameteri (GLenum target, GLenum pname, GLint param);
extern void glTexParameteriv (GLenum target, GLenum pname, const GLint *params);
extern void glTexSubImage1D (GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid *pixels);
extern void glTexSubImage2D (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels);
extern void glTexSubImage3D (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid *pixels);
extern void glTranslated (GLdouble x, GLdouble y, GLdouble z);
extern void glTranslatef (GLfloat x, GLfloat y, GLfloat z);
extern void glVertex2d (GLdouble x, GLdouble y);
extern void glVertex2dv (const GLdouble *v);
extern void glVertex2f (GLfloat x, GLfloat y);
extern void glVertex2fv (const GLfloat *v);
extern void glVertex2i (GLint x, GLint y);
extern void glVertex2iv (const GLint *v);
extern void glVertex2s (GLshort x, GLshort y);
extern void glVertex2sv (const GLshort *v);
extern void glVertex3d (GLdouble x, GLdouble y, GLdouble z);
extern void glVertex3dv (const GLdouble *v);
extern void glVertex3f (GLfloat x, GLfloat y, GLfloat z);
extern void glVertex3fv (const GLfloat *v);
extern void glVertex3i (GLint x, GLint y, GLint z);
extern void glVertex3iv (const GLint *v);
extern void glVertex3s (GLshort x, GLshort y, GLshort z);
extern void glVertex3sv (const GLshort *v);
extern void glVertex4d (GLdouble x, GLdouble y, GLdouble z, GLdouble w);
extern void glVertex4dv (const GLdouble *v);
extern void glVertex4f (GLfloat x, GLfloat y, GLfloat z, GLfloat w);
extern void glVertex4fv (const GLfloat *v);
extern void glVertex4i (GLint x, GLint y, GLint z, GLint w);
extern void glVertex4iv (const GLint *v);
extern void glVertex4s (GLshort x, GLshort y, GLshort z, GLshort w);
extern void glVertex4sv (const GLshort *v);
extern void glVertexPointer (GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
extern void glViewport (GLint x, GLint y, GLsizei width, GLsizei height);

/*************************************************************/
/*                                                           */
/* Supported OpenGL Extension APIs                           */
/*                                                           */
/*************************************************************/

#ifdef GL_ARB_multitexture
extern void glMultiTexCoord1dARB (GLenum texture, GLdouble s);
extern void glMultiTexCoord1dvARB (GLenum texture, const GLdouble *v);
extern void glMultiTexCoord1fARB (GLenum texture, GLfloat s);
extern void glMultiTexCoord1fvARB (GLenum texture, const GLfloat *v);
extern void glMultiTexCoord1iARB (GLenum texture, GLint s);
extern void glMultiTexCoord1ivARB (GLenum texture, const GLint *v);
extern void glMultiTexCoord1sARB (GLenum texture, GLshort s);
extern void glMultiTexCoord1svARB (GLenum texture, const GLshort *v);
extern void glMultiTexCoord2dARB (GLenum texture, GLdouble s, GLdouble t);
extern void glMultiTexCoord2dvARB (GLenum texture, const GLdouble *v);
extern void glMultiTexCoord2fARB (GLenum texture, GLfloat s, GLfloat t);
extern void glMultiTexCoord2fvARB (GLenum texture, const GLfloat *v);
extern void glMultiTexCoord2iARB (GLenum texture, GLint s, GLint t);
extern void glMultiTexCoord2ivARB (GLenum texture, const GLint *v);
extern void glMultiTexCoord2sARB (GLenum texture, GLshort s, GLshort t);
extern void glMultiTexCoord2svARB (GLenum texture, const GLshort *v);
extern void glMultiTexCoord3dARB (GLenum texture, GLdouble s, GLdouble t, GLdouble r);
extern void glMultiTexCoord3dvARB (GLenum texture, const GLdouble *v);
extern void glMultiTexCoord3fARB (GLenum texture, GLfloat s, GLfloat t, GLfloat r);
extern void glMultiTexCoord3fvARB (GLenum texture, const GLfloat *v);
extern void glMultiTexCoord3iARB (GLenum texture, GLint s, GLint t, GLint r);
extern void glMultiTexCoord3ivARB (GLenum texture, const GLint *v);
extern void glMultiTexCoord3sARB (GLenum texture, GLshort s, GLshort t, GLshort r);
extern void glMultiTexCoord3svARB (GLenum texture, const GLshort *v);
extern void glMultiTexCoord4dARB (GLenum texture, GLdouble s, GLdouble t, GLdouble r, GLdouble q);
extern void glMultiTexCoord4dvARB (GLenum texture, const GLdouble *v);
extern void glMultiTexCoord4fARB (GLenum texture, GLfloat s, GLfloat t, GLfloat r, GLfloat q);
extern void glMultiTexCoord4fvARB (GLenum texture, const GLfloat *v);
extern void glMultiTexCoord4iARB (GLenum texture, GLint s, GLint t, GLint r, GLint q);
extern void glMultiTexCoord4ivARB (GLenum texture, const GLint *v);
extern void glMultiTexCoord4sARB (GLenum texture, GLshort s, GLshort t, GLshort r, GLshort q);
extern void glMultiTexCoord4svARB (GLenum texture, const GLshort *v);
extern void glClientActiveTextureARB (GLenum texture);
extern void glActiveTextureARB (GLenum texture);
#endif

#ifdef GL_ARB_texture_compression
extern void glCompressedTexImage1DARB (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const void *data);
extern void glCompressedTexImage2DARB (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const void *data);
extern void glCompressedTexImage3DARB (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const void *data);
extern void glCompressedTexSubImage1DARB (GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const void *data);
extern void glCompressedTexSubImage2DARB (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const void *data);
extern void glCompressedTexSubImage3DARB (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const void *data);
extern void glGetCompressedTexImageARB (GLenum target, GLint lod, GLvoid *img);
#endif

#ifdef GL_ARB_transpose_matrix
extern void glLoadTransposeMatrixdARB (const GLdouble *m);
extern void glLoadTransposeMatrixfARB (const GLfloat *m);
extern void glMultTransposeMatrixdARB (const GLdouble *m);
extern void glMultTransposeMatrixfARB (const GLfloat *m);
#endif

#ifdef GL_ARB_multisample
extern void glSampleCoverageARB (GLclampf value, GLboolean invert);
#endif

#ifdef GL_ARB_point_parameters
extern void glPointParameterfARB (GLenum pname, GLfloat param);
extern void glPointParameterfvARB (GLenum pname, const GLfloat *param);
#endif

#ifdef GL_EXT_polygon_offset
extern void glPolygonOffsetEXT (GLfloat factor, GLfloat bias);
#endif

#ifdef GL_EXT_texture3D
extern void glTexImage3DEXT (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
extern void glTexSubImage3DEXT (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid *pixels);
extern void glCopyTexSubImage3DEXT (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height);
#endif

#ifdef GL_EXT_histogram
extern void glHistogramEXT (GLenum target, GLsizei width, GLenum internalformat, GLboolean sink);
extern void glResetHistogramEXT (GLenum target);
extern void glGetHistogramEXT (GLenum target, GLboolean reset, GLenum format, GLenum type, GLvoid *values);
extern void glGetHistogramParameterfvEXT (GLenum target, GLenum pname, GLfloat *params);
extern void glGetHistogramParameterivEXT (GLenum target, GLenum pname, GLint *params);
extern void glMinmaxEXT (GLenum target, GLenum internalformat, GLboolean sink);
extern void glResetMinmaxEXT (GLenum target);
extern void glGetMinmaxEXT (GLenum target, GLboolean reset, GLenum format, GLenum type, GLvoid *values);
extern void glGetMinmaxParameterfvEXT (GLenum target, GLenum pname, GLfloat *params);
extern void glGetMinmaxParameterivEXT (GLenum target, GLenum pname, GLint *params);
#endif

#ifdef GL_EXT_blend_func_separate
extern void glBlendFuncSeparateEXT (GLenum sfactorRGB, GLenum dfactorRGB, GLenum sfactorAlpha, GLenum dfactorAlpha);
#endif

#ifdef GL_EXT_blend_color
extern void glBlendColorEXT (GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha);
#endif

#ifdef GL_EXT_blend_minmax
extern void glBlendEquationEXT (GLenum mode);
#endif

#ifdef GL_EXT_convolution
extern void glConvolutionParameterfEXT (GLenum target, GLenum pname, GLfloat params);
extern void glConvolutionParameterfvEXT (GLenum target, GLenum pname, const GLfloat *params);
extern void glConvolutionParameteriEXT (GLenum target, GLenum pname, GLint params);
extern void glConvolutionParameterivEXT (GLenum target, GLenum pname, const GLint *params);
extern void glConvolutionFilter1DEXT (GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const GLvoid *image);
extern void glConvolutionFilter2DEXT (GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *image);
extern void glCopyConvolutionFilter1DEXT (GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width);
extern void glCopyConvolutionFilter2DEXT (GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height);
extern void glSeparableFilter2DEXT (GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *row, const GLvoid *column);
extern void glGetConvolutionParameterfvEXT (GLenum target, GLenum pname, GLfloat *params);
extern void glGetConvolutionParameterivEXT (GLenum target, GLenum pname, GLint *params);
extern void glGetConvolutionFilterEXT (GLenum target, GLenum format, GLenum type, GLvoid *image);
extern void glGetSeparableFilterEXT (GLenum target, GLenum format, GLenum type, GLvoid *row, GLvoid *column, GLvoid *span);
#endif

#ifdef GL_EXT_pixel_transform
extern void glPixelTransformParameteriEXT (GLenum target, GLenum pname, const int param);
extern void glPixelTransformParameterfEXT (GLenum target, GLenum pname, const float param);
extern void glPixelTransformParameterivEXT (GLenum target, GLenum pname, const int *param);
extern void glPixelTransformParameterfvEXT (GLenum target, GLenum pname, const float *param);
extern void glGetPixelTransformParameterivEXT (GLenum target, GLenum pname, GLint *param);
extern void glGetPixelTransformParameterfvEXT (GLenum target, GLenum pname, GLfloat *param);
#endif

#ifdef GL_EXT_compiled_vertex_array
extern void glLockArraysEXT (GLint first, GLsizei count);
extern void glUnlockArraysEXT (void);
#endif

#ifdef GL_EXT_multi_draw_arrays
extern void glMultiDrawArraysEXT (GLenum mode, GLint* first, GLsizei* count, GLsizei primcount);
extern void glMultiDrawElementsEXT (GLenum mode, GLsizei *count, GLenum type, const GLvoid **indices, GLsizei primcount);
#endif

#ifdef GL_EXT_gradient_clear
extern void glClearColorModeEXT(GLenum pname); 
extern void glClearParameterfvEXT(GLenum pname, const GLfloat *params);
extern void glClearParameterivEXT(GLenum pname, const GLint *params);
extern void glClearParameterfEXT(GLenum pname, const GLfloat param);
extern void glClearParameteriEXT(GLenum pname, const GLint param);
#endif

#ifdef GL_SGI_color_table
extern void glColorTableSGI (GLenum target, GLenum internalFormat, GLsizei width, GLenum format, GLenum type, const GLvoid* table);
extern void glCopyColorTableSGI (GLenum target, GLenum internalFormat, GLint x, GLint y, GLsizei width);
extern void glColorTableParameterfvSGI (GLenum target, GLenum pname, const GLfloat *params);
extern void glColorTableParameterivSGI (GLenum target, GLenum pname, const GLint *params);
extern void glGetColorTableSGI (GLenum target, GLenum format, GLenum type, GLvoid *table);
extern void glGetColorTableParameterfvSGI (GLenum target, GLenum pname, GLfloat *params);
extern void glGetColorTableParameterivSGI (GLenum target, GLenum pname, GLint *params);
#endif

#ifdef GL_SGIS_sharpen_texture
extern void glSharpenTexFuncSGIS (GLenum target, GLsizei n, const GLfloat* points);
extern void glGetSharpenTexFuncSGIS (GLenum target, GLfloat* points);
#endif

#ifdef GL_SGIS_detail_texture
extern void glDetailTexFuncSGIS (GLenum target, GLsizei n, const GLfloat* points);
extern void glGetDetailTexFuncSGIS (GLenum target, GLfloat* points);
#endif

#ifdef GL_SGIS_texture_filter4
extern void glTexFilterFuncSGIS (GLenum target, GLenum filter, GLsizei n, const GLfloat* points);
extern void glGetTexFilterFuncSGIS (GLenum target, GLenum filter, GLfloat* points);
#endif

#ifdef GL_SUN_multi_draw_arrays
extern void glMultiDrawArraysSUN (GLenum mode, GLint* first, GLsizei* count, GLsizei primcount);
extern void glMultiDrawElementsSUN (GLenum mode, GLsizei *count, GLenum type, const GLvoid **indices, GLsizei primcount);
#endif

#ifdef GL_SUNX_geometry_compression
extern void glDrawCompressedGeomSUNX (GLint size, GLubyte *data);
#endif

#ifdef GL_SUN_triangle_list
extern void glReplacementCodeuiSUN (GLuint);
extern void glReplacementCodeusSUN (GLushort);
extern void glReplacementCodeubSUN (GLubyte);
extern void glReplacementCodeuivSUN (GLuint *);
extern void glReplacementCodeusvSUN (GLushort *);
extern void glReplacementCodeubvSUN (GLubyte *);
extern void glReplacementCodePointerSUN (GLenum, GLsizei, const void *);
#endif

#ifdef GL_SUN_mesh_array
extern void glDrawMeshArraysSUN (GLenum, GLint, GLsizei, GLsizei);
#endif

#ifdef GL_SUN_global_alpha
extern void glGlobalAlphaFactorbSUN (GLbyte factor);
extern void glGlobalAlphaFactorsSUN (GLshort factor);
extern void glGlobalAlphaFactoriSUN (GLint factor);
extern void glGlobalAlphaFactorfSUN (GLfloat factor);
extern void glGlobalAlphaFactordSUN (GLdouble factor);
extern void glGlobalAlphaFactorubSUN (GLubyte factor);
extern void glGlobalAlphaFactorusSUN (GLushort factor);
extern void glGlobalAlphaFactoruiSUN (GLuint factor);
#endif

#ifdef GL_SUNX_constant_data
extern void glFinishTextureSUNX (void);
#endif

#ifdef GL_SUN_vertex
extern void glColor4ubVertex2fSUN (GLubyte, GLubyte, GLubyte, GLubyte,
					GLfloat, GLfloat);
extern void glColor4ubVertex2fvSUN (const GLubyte *, const GLfloat *);
extern void glColor4ubVertex3fSUN (GLubyte, GLubyte, GLubyte, GLubyte,
					GLfloat, GLfloat, GLfloat);
extern void glColor4ubVertex3fvSUN (const GLubyte *, const GLfloat *);
extern void glColor3fVertex3fSUN (GLfloat, GLfloat, GLfloat,
					GLfloat, GLfloat, GLfloat);
extern void glColor3fVertex3fvSUN (const GLfloat *, const GLfloat *);
extern void glNormal3fVertex3fSUN (GLfloat, GLfloat, GLfloat,
					GLfloat, GLfloat, GLfloat);
extern void glNormal3fVertex3fvSUN (const GLfloat *, const GLfloat *);
extern void glColor4fNormal3fVertex3fSUN (GLfloat, GLfloat, GLfloat, GLfloat,
					GLfloat, GLfloat, GLfloat,
					GLfloat, GLfloat, GLfloat);
extern void glColor4fNormal3fVertex3fvSUN (const GLfloat *, const GLfloat *, 
					const GLfloat *);
extern void glTexCoord2fVertex3fSUN (GLfloat, GLfloat, 
					GLfloat, GLfloat, GLfloat);
extern void glTexCoord2fVertex3fvSUN (const GLfloat *, const GLfloat *);
extern void glTexCoord4fVertex4fSUN (GLfloat, GLfloat, GLfloat, GLfloat,
					GLfloat, GLfloat, GLfloat, GLfloat);
extern void glTexCoord4fVertex4fvSUN (const GLfloat *, const GLfloat *);
extern void glTexCoord2fColor4ubVertex3fSUN (GLfloat, GLfloat, 
					GLubyte, GLubyte, GLubyte, GLubyte,
					GLfloat, GLfloat, GLfloat);
extern void glTexCoord2fColor4ubVertex3fvSUN (const GLfloat *, 
					const GLubyte *, const GLfloat *);
extern void glTexCoord2fColor3fVertex3fSUN (GLfloat, GLfloat, 
					GLfloat, GLfloat, GLfloat,
					GLfloat, GLfloat, GLfloat);
extern void glTexCoord2fColor3fVertex3fvSUN (const GLfloat *, 
					const GLfloat *, const GLfloat *);
extern void glTexCoord2fNormal3fVertex3fSUN (GLfloat, GLfloat, 
					GLfloat, GLfloat, GLfloat,
					GLfloat, GLfloat, GLfloat);
extern void glTexCoord2fNormal3fVertex3fvSUN (const GLfloat *, 
					const GLfloat *, const GLfloat *);
extern void glTexCoord2fColor4fNormal3fVertex3fSUN (
					GLfloat, GLfloat, 
					GLfloat, GLfloat, GLfloat, GLfloat,
					GLfloat, GLfloat, GLfloat,
					GLfloat, GLfloat, GLfloat);
extern void glTexCoord2fColor4fNormal3fVertex3fvSUN (
					const GLfloat *, const GLfloat *, 
					const GLfloat *, const GLfloat *);
extern void glTexCoord4fColor4fNormal3fVertex4fSUN (
					GLfloat, GLfloat, GLfloat, GLfloat,
					GLfloat, GLfloat, GLfloat, GLfloat,
					GLfloat, GLfloat, GLfloat,
					GLfloat, GLfloat, GLfloat, GLfloat);
extern void glTexCoord4fColor4fNormal3fVertex4fvSUN (
					const GLfloat *, const GLfloat *, 
					const GLfloat *, const GLfloat *);
extern void glReplacementCodeuiVertex3fSUN (GLuint,
					GLfloat, GLfloat, GLfloat);
extern void glReplacementCodeuiVertex3fvSUN (const GLuint *, const GLfloat *);
extern void glReplacementCodeuiColor4ubVertex3fSUN (GLuint,
					GLubyte, GLubyte, GLubyte, GLubyte,
					GLfloat, GLfloat, GLfloat);
extern void glReplacementCodeuiColor4ubVertex3fvSUN (const GLuint *, 
					const GLubyte *, const GLfloat *);
extern void glReplacementCodeuiColor3fVertex3fSUN (GLuint,
					GLfloat, GLfloat, GLfloat, 
					GLfloat, GLfloat, GLfloat);
extern void glReplacementCodeuiColor3fVertex3fvSUN (const GLuint *, 
					const GLfloat *, const GLfloat *);
extern void glReplacementCodeuiNormal3fVertex3fSUN (GLuint,
					GLfloat, GLfloat, GLfloat, 
					GLfloat, GLfloat, GLfloat);
extern void glReplacementCodeuiNormal3fVertex3fvSUN (const GLuint *, 
					const GLfloat *, const GLfloat *);
extern void glReplacementCodeuiColor4fNormal3fVertex3fSUN (GLuint,
					GLfloat, GLfloat, GLfloat, GLfloat,
					GLfloat, GLfloat, GLfloat, 
					GLfloat, GLfloat, GLfloat);
extern void glReplacementCodeuiColor4fNormal3fVertex3fvSUN (const GLuint *, 
					const GLfloat *, const GLfloat *,
					const GLfloat *);
extern void glReplacementCodeuiTexCoord2fVertex3fSUN (GLuint,
					GLfloat, GLfloat, 
					GLfloat, GLfloat, GLfloat);
extern void glReplacementCodeuiTexCoord2fVertex3fvSUN (const GLuint *, 
					const GLfloat *, const GLfloat *);
extern void glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN (GLuint,
					GLfloat, GLfloat, 
					GLfloat, GLfloat, GLfloat,
					GLfloat, GLfloat, GLfloat);
extern void glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN (const GLuint *, 
					const GLfloat *, const GLfloat *,
					const GLfloat *);
extern void glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN (GLuint,
					GLfloat, GLfloat, 
					GLfloat, GLfloat, GLfloat, GLfloat,
					GLfloat, GLfloat, GLfloat,
					GLfloat, GLfloat, GLfloat);
extern void glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN (const GLuint *, 
					const GLfloat *, const GLfloat *,
					const GLfloat *, const GLfloat *);
#endif

#ifdef GL_SUN_read_video_pixels
extern void glReadVideoPixelsSUN (GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid *pixels);
#endif

#ifdef GL_SUN_read_write_samples
extern void glReadSamplesSUN (GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid *pixels);
extern void glWriteSamplesSUN (GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *samples);
#endif

#ifdef GL_SUN_targeted_texture
extern void glSetTextureTargetiSUN(GLenum mode, GLuint param);
extern void glSetTextureTargetModeSUN(GLenum mode);
#endif


#ifndef SUN_OGL_NO_VERTEX_MACROS
#ifndef LINUX 
#include <GL/glmacros.h>
#endif /* LINUX */
#endif /* SUN_OGL_NO_VERTEX_MACROS */


#ifdef __cplusplus
}
#endif

#endif /* __gl_h_ */
